/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.util;

import java.util.HashMap;
import kd.hr.hbp.business.service.complexobj.util.BigDecimalConvert;
import kd.hr.hbp.business.service.complexobj.util.BooleanConvert;
import kd.hr.hbp.business.service.complexobj.util.DataTypeConvert;
import kd.hr.hbp.business.service.complexobj.util.DateSplitConvert;
import kd.hr.hbp.business.service.complexobj.util.DatetimeConvert;
import kd.hr.hbp.business.service.complexobj.util.IntegerConvert;
import kd.hr.hbp.business.service.complexobj.util.LongConvert;
import kd.hr.hbp.business.service.complexobj.util.StringConvert;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;

public class DataTypeConvertUtil {
    private static final HashMap<DataTypeEnum, DataTypeConvert> convertMap = new HashMap(16);
    private static final HashMap<DataTypeEnum, DataTypeConvert> dbStoreCnovertMap = new HashMap(16);

    public static Object toConvert(DataTypeEnum dataType, Object value) {
        DataTypeConvert dataTypeConvert = convertMap.get(dataType);
        if (dataTypeConvert == null) {
            return value;
        }
        return dataTypeConvert.convert(value);
    }

    public static Object toConvertDbStore(DataTypeEnum dataType, Object value) {
        DataTypeConvert dataTypeConvert = dbStoreCnovertMap.get(dataType);
        if (dataTypeConvert == null) {
            return value;
        }
        return dataTypeConvert.convert(value);
    }

    static {
        convertMap.put(DataTypeEnum.INTEGER, new IntegerConvert());
        convertMap.put(DataTypeEnum.STRING, new StringConvert());
        convertMap.put(DataTypeEnum.LONG, new LongConvert());
        convertMap.put(DataTypeEnum.BOOLEAN, new BooleanConvert());
        convertMap.put(DataTypeEnum.BIGDECIMAL, new BigDecimalConvert());
        convertMap.put(DataTypeEnum.DATETIME, new DatetimeConvert());
        dbStoreCnovertMap.put(DataTypeEnum.INTEGER, new IntegerConvert());
        dbStoreCnovertMap.put(DataTypeEnum.STRING, new StringConvert());
        dbStoreCnovertMap.put(DataTypeEnum.LONG, new LongConvert());
        dbStoreCnovertMap.put(DataTypeEnum.BOOLEAN, new StringConvert());
        dbStoreCnovertMap.put(DataTypeEnum.BIGDECIMAL, new BigDecimalConvert());
        dbStoreCnovertMap.put(DataTypeEnum.DATETIME, new DateSplitConvert());
    }
}

