/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.util;

import java.util.Map;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import org.apache.commons.lang3.StringUtils;

public class EntityPropParseUtil {
    private static final Log LOGGER = LogFactory.getLog(EntityPropParseUtil.class);
    private final MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();

    public DynamicProperty getDynamicProperty(String mainEntityNumber, Map<String, String> relEntityMap, String fullFieldName) {
        String entityNumber = mainEntityNumber;
        String[] fieldNameArr = fullFieldName.split("\\.");
        if (StringUtils.isNotEmpty((CharSequence)fieldNameArr[0]) && fieldNameArr.length > 1 && StringUtils.isNotEmpty((CharSequence)relEntityMap.get(fieldNameArr[0]))) {
            String entityNumberTmp = fieldNameArr[0] + ".";
            fullFieldName = fullFieldName.substring(fullFieldName.indexOf(entityNumberTmp) + entityNumberTmp.length());
            entityNumber = fieldNameArr[0];
        }
        DynamicProperty property = this.convertFullFieldName(entityNumber, fullFieldName);
        return property;
    }

    public DynamicProperty getVirtDynamicProperty(String fullFieldName) {
        String[] fieldNameArr = fullFieldName.split("\\.");
        if (StringUtils.isNotEmpty((CharSequence)fieldNameArr[0]) && fieldNameArr.length > 1) {
            String entityNumberTmp = fieldNameArr[0] + ".";
            fullFieldName = fullFieldName.substring(fullFieldName.indexOf(entityNumberTmp) + entityNumberTmp.length());
        }
        DynamicProperty property = this.convertFullFieldName(fieldNameArr[0], fullFieldName);
        return property;
    }

    public DynamicProperty convertFullFieldName(String entityNumber, String fullFieldName) {
        if (StringUtils.isEmpty((CharSequence)fullFieldName)) {
            return null;
        }
        String[] fieldNameArr = fullFieldName.split("\\.");
        if (entityNumber == null) {
            entityNumber = fieldNameArr[0];
        }
        if (StringUtils.isNotEmpty((CharSequence)fieldNameArr[0]) && fieldNameArr[0].equalsIgnoreCase(entityNumber)) {
            String[] fieldNameArrDest = new String[fieldNameArr.length - 1];
            System.arraycopy(fieldNameArr, 1, fieldNameArrDest, 0, fieldNameArr.length - 1);
            fieldNameArr = fieldNameArrDest;
        } else {
            entityNumber = StringUtils.isNotEmpty((CharSequence)entityNumber) ? entityNumber : fieldNameArr[0];
        }
        DynamicProperty property = null;
        try {
            MainEntityType mainEntityType = this.mainEntityTypeUtil.getMainEntityType(entityNumber);
            if (mainEntityType == null) {
                return null;
            }
            if (fieldNameArr.length == 1) {
                property = mainEntityType.getProperty(fieldNameArr[0]);
            } else if (fieldNameArr.length > 1) {
                property = mainEntityType.getProperty(fieldNameArr[0]);
                String baseEntityId = this.getBaseEntityID(property);
                String preProperty = null;
                if (null == baseEntityId && property instanceof EntryProp) {
                    property = ((EntityType)mainEntityType.getAllEntities().get(fieldNameArr[0])).getProperty(fieldNameArr[1]);
                    baseEntityId = this.getBaseEntityID(property);
                    preProperty = fieldNameArr[0] + "." + fieldNameArr[1] + ".";
                } else {
                    preProperty = fieldNameArr[0] + ".";
                }
                if (StringUtils.isNotEmpty((CharSequence)baseEntityId)) {
                    property = this.convertFullFieldName(baseEntityId, fullFieldName.substring(fullFieldName.indexOf(preProperty) + preProperty.length()));
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
        }
        return property;
    }

    private String getBaseEntityID(DynamicProperty property) {
        String baseEntityId = null;
        if (property instanceof BasedataProp) {
            baseEntityId = ((BasedataProp)property).getBaseEntityId();
        } else if (property instanceof MulBasedataProp) {
            baseEntityId = ((MulBasedataProp)property).getBaseEntityId();
        }
        return baseEntityId;
    }
}

