/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.util;

import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;

public class FieldFullPathParseUtil {
    public static String getFieldEntityNumber(HRComplexObjContext context, String fieldAlias) {
        Map<String, String> relEntityMap = context.getJoinRelationList().stream().collect(Collectors.toMap(HRComplexObjJoinRelation::getRelEntityAlias, HRComplexObjJoinRelation::getRelEntityNumber));
        String entityNumber = FieldFullPathParseUtil.getFieldEntityNumber(relEntityMap, fieldAlias);
        if (entityNumber != null) {
            return entityNumber;
        }
        return context.getEntityNumber();
    }

    public static String getFieldEntityNumber(Map<String, String> relEntityMap, String fieldAlias) {
        String[] fieldAliasArr = fieldAlias.split("\\.");
        String firstField = fieldAliasArr[0];
        if (relEntityMap.containsKey(firstField)) {
            return relEntityMap.get(firstField);
        }
        return null;
    }

    public static String getFieldEntityAlias(HRComplexObjContext context, String fieldAlias) {
        Map<String, String> relEntityMap = context.getJoinRelationList().stream().collect(Collectors.toMap(HRComplexObjJoinRelation::getRelEntityAlias, HRComplexObjJoinRelation::getRelEntityNumber));
        String entityAliasPrex = FieldFullPathParseUtil.getFieldEntityAlias(relEntityMap, fieldAlias);
        if (entityAliasPrex != null) {
            return entityAliasPrex;
        }
        return context.getEntityNumber();
    }

    public static boolean fieldIsMultiBdProp(String fieldAlias, Map<String, String> relEntityMap, String mainEntityNumber, MainEntityTypeUtil mainEntityTypeUtil) {
        String curEntityNumber;
        String[] split = fieldAlias.split("\\.");
        String relEntityNumber = relEntityMap.get(split[0]);
        if (relEntityNumber == null) {
            curEntityNumber = mainEntityNumber;
        } else {
            curEntityNumber = FieldFullPathParseUtil.getFieldEntityNumber(relEntityMap, fieldAlias);
            String[] fieldAliasArr = fieldAlias.split("\\.");
            String curEntityAlias = fieldAliasArr[0];
            fieldAlias = fieldAlias.replaceFirst(curEntityAlias + "\\.", "");
        }
        MainEntityType entityType = mainEntityTypeUtil.getMainEntityType(curEntityNumber);
        String[] fieldAliasArr = fieldAlias.split("\\.");
        DynamicProperty property = entityType.getProperty(fieldAliasArr[0]);
        if (!(property instanceof DynamicComplexProperty)) {
            return false;
        }
        return fieldAliasArr.length != 2 || !fieldAliasArr[1].equals("id");
    }

    public static String getFieldEntityAlias(Map<String, String> relEntityMap, String fieldAlias) {
        String[] fieldAliasArr = fieldAlias.split("\\.");
        String firstField = fieldAliasArr[0];
        if (relEntityMap.containsKey(firstField)) {
            return firstField;
        }
        return null;
    }

    public static String getFullFieldName(String entityAlias, String fieldAlias) {
        String fieldEntityAlias = entityAlias + ".";
        if (fieldAlias.indexOf(fieldEntityAlias) > -1) {
            return fieldAlias.substring(fieldAlias.indexOf(fieldEntityAlias) + fieldEntityAlias.length());
        }
        return fieldAlias;
    }
}

