/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.util;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class MulTableAliasUtil {
    public static final String MULI_LANG_TABLE_SUFFIX = "_L";
    public static final String MULI_LANG_TABLE_ALIAS = "L";
    private static final String[] ALIAS_LIB = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static final int MAX_VALUE = 225;

    public static String genMuliLangAlias(String mainTableAlias) {
        return mainTableAlias + MULI_LANG_TABLE_ALIAS;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Map<String, String>> genTableAlias(Map<String, Set<String>> aliasTableSet) {
        void var4_7;
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>(aliasTableSet.size());
        TreeMap sortTableMap = new TreeMap(Comparator.naturalOrder());
        for (Map.Entry<String, Set<String>> entry : aliasTableSet.entrySet()) {
            TreeSet treeSet = new TreeSet(Comparator.naturalOrder());
            treeSet.addAll((Collection)entry.getValue());
            sortTableMap.put(entry.getKey(), treeSet);
        }
        HashMap mulTbMap = new HashMap();
        for (Map.Entry entry : sortTableMap.entrySet()) {
            TreeSet tbSet = (TreeSet)entry.getValue();
            HashSet<String> muliLangTableSet = new HashSet<String>();
            Iterator iterator = tbSet.iterator();
            while (iterator.hasNext()) {
                String mainTable;
                String tb = (String)iterator.next();
                if (!tb.endsWith(MULI_LANG_TABLE_SUFFIX) && !tb.endsWith(MULI_LANG_TABLE_SUFFIX.toLowerCase(Locale.ROOT)) || !tbSet.contains(mainTable = tb.substring(0, tb.length() - 2))) continue;
                muliLangTableSet.add(tb);
                iterator.remove();
            }
            if (muliLangTableSet.isEmpty()) continue;
            mulTbMap.put(entry.getKey(), muliLangTableSet);
        }
        boolean bl = false;
        for (Set value : sortTableMap.values()) {
            var4_7 += value.size();
        }
        String[] stringArray = MulTableAliasUtil.genAlias((int)var4_7);
        int index = 0;
        for (Map.Entry entry : sortTableMap.entrySet()) {
            HashMap tableAlias = Maps.newHashMapWithExpectedSize((int)16);
            for (String tb : (TreeSet)entry.getValue()) {
                tableAlias.put(tb, stringArray[index++]);
            }
            resultMap.put((String)entry.getKey(), tableAlias);
        }
        for (Map.Entry entry : mulTbMap.entrySet()) {
            Map map = (Map)resultMap.get(entry.getKey());
            for (String mulTb : (Set)entry.getValue()) {
                String mainTable = mulTb.substring(0, mulTb.length() - 2);
                String mainTbAlias = (String)map.get(mainTable);
                String mulTbAlias = MulTableAliasUtil.genMuliLangAlias(mainTbAlias);
                map.put(mulTb, mulTbAlias);
            }
        }
        return resultMap;
    }

    public static String[] genAlias(int number) {
        if (number > 225) {
            return new String[0];
        }
        int sigAliasLen = ALIAS_LIB.length;
        String[] retAliasArr = Arrays.copyOf(ALIAS_LIB, number);
        if (number <= sigAliasLen) {
            return retAliasArr;
        }
        int index = sigAliasLen;
        block0: for (int i = 1; i < 10; ++i) {
            String suffix = String.valueOf(i);
            for (String str : ALIAS_LIB) {
                if (index == number) continue block0;
                String alias = str + suffix;
                retAliasArr[index++] = alias;
            }
        }
        return retAliasArr;
    }

    private static int calRepeatTime(int number) {
        int sigAliasLen = ALIAS_LIB.length;
        return number / sigAliasLen + (number % sigAliasLen > 0 ? 0 : -1) + 1;
    }
}

