/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.complexobj.util;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ILocaleProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DBRoute;
import kd.bos.db.pktemptable.PKTempTable;
import kd.bos.db.pktemptable.config.PKTempTableConfig;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.config.ORMConfig;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.bos.xdb.XDBConfig;
import kd.hr.hbp.business.service.complexobj.ksql.KSqlParser;
import kd.hr.hbp.business.service.complexobj.util.KSqlFuncUtil;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.query.util.QFilterUtilHR;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.HRComplexObjJoinRelation;
import kd.hr.hbp.common.model.query.vo.NestedBasicDataPropertyVO;
import kd.hr.hbp.common.model.report.SplitDateTypeEnum;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class QFilterUtil {
    public static String hrEmptyDecimal = "hrEmptyDecimal";
    public static String hrEmptyText = "hrEmptyText";
    public static String hrEmptyFieldText = "hrEmptyFieldText";
    public static String hrEmptyOther = "hrEmptyOther";
    public static Long NOT_EXTID = -9999L;

    @ExcludeFromJacocoGeneratedReport
    public static QFilter changeBasicDataToSubEntityFilterEx(QFilter qFilter, HRComplexObjContext context, MainEntityTypeUtil mainEntityTypeUtil) {
        String fullPropertyName = qFilter.getProperty();
        String subEntityName = QFilterUtil.getSubEntityNameByBasicData(fullPropertyName, context, mainEntityTypeUtil);
        if (subEntityName != null) {
            String[] nameKeys = fullPropertyName.split("\\.");
            if (QFilterUtil.isMainEntityPropery(fullPropertyName, context).booleanValue()) {
                if (nameKeys.length == 2) {
                    String basicDataName = nameKeys[0];
                    String newPropertyName = fullPropertyName.replace(basicDataName, subEntityName);
                    qFilter.__setProperty(newPropertyName);
                }
            } else if (nameKeys.length == 3) {
                String attributeString = fullPropertyName.substring(fullPropertyName.lastIndexOf(46) + 1);
                StringBuilder newPropertyNameBuilder = new StringBuilder();
                newPropertyNameBuilder.append(subEntityName).append('.').append(attributeString);
                String newPropertyName = newPropertyNameBuilder.toString();
                qFilter.__setProperty(newPropertyName);
            }
        }
        return qFilter;
    }

    public static Boolean isMainEntityPropery(String fullPropertyName, HRComplexObjContext context) {
        String subEntityName = QFilterUtil.getSubEntityName(fullPropertyName, context);
        if (subEntityName != null) {
            return false;
        }
        return true;
    }

    @ExcludeFromJacocoGeneratedReport
    public static String getSubEntityNameByBasicData(String fullPropertyName, HRComplexObjContext context, MainEntityTypeUtil mainEntityTypeUtil) {
        String subEntityNumber = QFilterUtil.getSubEntityName(fullPropertyName, context);
        if (subEntityNumber != null) {
            String[] nameKeys = fullPropertyName.split("\\.");
            if (nameKeys.length != 3) {
                return null;
            }
            return QFilterUtil.getSubEntityNameBySameBasicData(subEntityNumber, nameKeys[1], context, mainEntityTypeUtil);
        }
        String[] nameKeys = fullPropertyName.split("\\.");
        if (nameKeys.length != 2) {
            return null;
        }
        return QFilterUtil.getSubEntityNameBySameBasicData(context.getEntityNumber(), nameKeys[0], context, mainEntityTypeUtil);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QFilter convertPermQFilterEx(QFilter filter, HRComplexObjContext context, MainEntityTypeUtil mainEntityTypeUtil) {
        Boolean bSubEntity = true;
        String entityName = QFilterUtil.getSubEntityName(filter.getProperty(), context);
        if (entityName == null) {
            entityName = context.getEntityNumber();
            bSubEntity = false;
        }
        String propertyName = filter.getProperty();
        String[] nameKeys = propertyName.split("\\.");
        String attributeName = null;
        if (bSubEntity.booleanValue()) {
            if (nameKeys.length != 2) return filter;
            attributeName = nameKeys[1];
        } else {
            if (nameKeys.length != 1) return filter;
            attributeName = nameKeys[0];
        }
        MainEntityType dataEntityType = mainEntityTypeUtil.getMainEntityType(entityName);
        DynamicProperty dynamicProperty = dataEntityType.getProperty(attributeName);
        if (!(dynamicProperty instanceof DynamicComplexProperty)) return filter;
        StringBuilder builder = new StringBuilder();
        builder.append(propertyName).append(".id");
        filter.__setProperty(builder.toString());
        return filter;
    }

    public static String getSubEntityName(String fullPropertyName, HRComplexObjContext context) {
        String[] nameKeys = fullPropertyName.split("\\.");
        String subEntityAlias = fullPropertyName;
        if (nameKeys.length > 0) {
            subEntityAlias = nameKeys[0];
        }
        Map<String, String> relEntityMap = context.getJoinRelationList().stream().collect(Collectors.toMap(HRComplexObjJoinRelation::getRelEntityAlias, HRComplexObjJoinRelation::getRelEntityNumber));
        return relEntityMap.get(subEntityAlias);
    }

    public static String getFieldEntityAlias(String fullPropertyName, HRComplexObjContext context) {
        String[] nameKeys = fullPropertyName.split("\\.");
        String subEntityAlias = fullPropertyName;
        if (nameKeys.length > 0) {
            subEntityAlias = nameKeys[0];
        }
        Set relEntityAlias = context.getJoinRelationList().stream().map(HRComplexObjJoinRelation::getRelEntityAlias).collect(Collectors.toSet());
        String entityAlias = context.getEntityNumber();
        if (relEntityAlias.contains(subEntityAlias)) {
            entityAlias = subEntityAlias;
        }
        return entityAlias;
    }

    @ExcludeFromJacocoGeneratedReport
    public static String getSubEntityNameBySameBasicData(String entityName, String basicDataName, HRComplexObjContext context, MainEntityTypeUtil mainEntityTypeUtil) {
        MainEntityType dataEntityType = mainEntityTypeUtil.getMainEntityType(entityName);
        DynamicProperty dynamicProperty = dataEntityType.getProperty(basicDataName);
        if (dynamicProperty instanceof DynamicComplexProperty) {
            DynamicComplexProperty dynamicComplexProperty = (DynamicComplexProperty)dynamicProperty;
            BasedataProp firstdataProp1 = (BasedataProp)dynamicComplexProperty;
            String basicDataEntityName = firstdataProp1.getBaseEntityId();
            List joinRelationList = context.getJoinRelationList();
            for (HRComplexObjJoinRelation joinRelation : joinRelationList) {
                if (!basicDataEntityName.equalsIgnoreCase(joinRelation.getRelEntityNumber())) continue;
                return basicDataEntityName;
            }
        }
        return null;
    }

    public static List<QFilter> copyQFilters(List<QFilter> qFilterList) {
        ArrayList<QFilter> copyQFilterList = new ArrayList<QFilter>(qFilterList.size());
        for (QFilter qFilter : qFilterList) {
            copyQFilterList.add(qFilter.copy());
        }
        return copyQFilterList;
    }

    public static QFilter[] copyQFilters(QFilter[] filterArray) {
        QFilter[] filterArrayCopy = new QFilter[filterArray.length];
        for (int j = 0; j < filterArray.length; ++j) {
            if (filterArray[j] == null) continue;
            filterArrayCopy[j] = filterArray[j].copy();
        }
        return filterArrayCopy;
    }

    @ExcludeFromJacocoGeneratedReport
    public static NestedBasicDataPropertyVO changeSecondLvBDToFirstLvBDByFilterEx(String fullPropertyName, QFilter filter, HRComplexObjContext context, MainEntityTypeUtil mainEntityTypeUtil) {
        if (QFilterUtil.isNestedBasicData(fullPropertyName, context).booleanValue()) {
            String subEntityNumber = QFilterUtil.getSubEntityName(fullPropertyName, context);
            if (subEntityNumber != null) {
                String[] nameKeys = fullPropertyName.split("\\.");
                return QFilterUtil.changeFirstLvBDFromSecondLvBDEx(nameKeys[1], nameKeys[2], subEntityNumber, filter, context, mainEntityTypeUtil);
            }
            String[] nameKeys = fullPropertyName.split("\\.");
            String firstBDName = null;
            String secondBDName = null;
            String mainEntityName = context.getEntityNumber();
            if (nameKeys[0].equalsIgnoreCase(mainEntityName)) {
                firstBDName = nameKeys[1];
                secondBDName = nameKeys[2];
            } else {
                firstBDName = nameKeys[0];
                secondBDName = nameKeys[1];
            }
            return QFilterUtil.changeFirstLvBDFromSecondLvBDEx(firstBDName, secondBDName, context.getEntityNumber(), filter, context, mainEntityTypeUtil);
        }
        if (QFilterUtil.isNormalBasicData(fullPropertyName, context).booleanValue()) {
            String subEntityNumber = QFilterUtil.getSubEntityName(fullPropertyName, context);
            if (subEntityNumber != null) {
                String[] nameKeys = fullPropertyName.split("\\.");
                return QFilterUtil.changeNoramlBDEx(nameKeys[1], subEntityNumber, filter, context, mainEntityTypeUtil);
            }
            String[] nameKeys = fullPropertyName.split("\\.");
            String basicDataName = null;
            String mainEntityName = context.getEntityNumber();
            basicDataName = nameKeys[0].equalsIgnoreCase(mainEntityName) ? nameKeys[1] : nameKeys[0];
            return QFilterUtil.changeNoramlBDEx(basicDataName, context.getEntityNumber(), filter, context, mainEntityTypeUtil);
        }
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    public static NestedBasicDataPropertyVO getNestedBasicDataPropertyVO(QFilter filter, String entityName, Boolean isMainEntity, HRComplexObjContext context, MainEntityTypeUtil mainEntityTypeUtil) {
        MainEntityType dataEntityType;
        NestedBasicDataPropertyVO vo = new NestedBasicDataPropertyVO();
        vo.mainEntityType = dataEntityType = mainEntityTypeUtil.getMainEntityType(entityName);
        String propertyname = null;
        String propAlias = filter.getProperty();
        if (propAlias.contains("!")) {
            String[] propAliaSplit = propAlias.split("!");
            propAlias = propAliaSplit[0];
        }
        String[] nameKeys = propAlias.split("\\.");
        if (isMainEntity.booleanValue()) {
            String mainEntityName = context.getEntityNumber();
            propertyname = nameKeys[0].equalsIgnoreCase(mainEntityName) ? nameKeys[1] : nameKeys[0];
        } else if (nameKeys.length < 2 && filter.getCP().equals("=") && filter.getValue() instanceof QEmptyValue) {
            propertyname = "id";
            filter.__setProperty(propAlias + ".id");
        } else {
            propertyname = nameKeys[1];
        }
        DynamicProperty dynamicProperty = dataEntityType.getProperty(propertyname);
        if (dynamicProperty == null) {
            throw new KDBizException(context.getEntityNumber() + " not exists property:" + propertyname);
        }
        if (dynamicProperty instanceof ILocaleProperty) {
            vo.mutileLang = true;
        }
        if (ORMConfig.PRIVACY_ENABLE.getBoolean() && PrivacyCenterServiceHelper.isEncryptField((IDataEntityProperty)dynamicProperty)) {
            QFilterUtil.handlePrivacyProperty(dynamicProperty, filter, context);
            return QFilterUtil.getNestedBasicDataPropertyVO(filter, entityName, isMainEntity, context, mainEntityTypeUtil);
        }
        vo.dataEntityProperty = dynamicProperty;
        vo.filter = filter;
        return vo;
    }

    public static Boolean isNormalBasicData(String fullPropertyName, HRComplexObjContext context) {
        if (QFilterUtil.isMainEntityPropery(fullPropertyName, context).booleanValue()) {
            String[] nameKeys = fullPropertyName.split("\\.");
            String mainEntityName = context.getEntityNumber();
            int nLevel = 2;
            if (nameKeys[0].equalsIgnoreCase(mainEntityName)) {
                nLevel = 3;
            }
            if (nameKeys.length == nLevel) {
                return true;
            }
            return false;
        }
        if (QFilterUtil.getSubEntityName(fullPropertyName, context) != null) {
            String[] nameKeys = fullPropertyName.split("\\.");
            if (nameKeys.length == 3) {
                return true;
            }
            return false;
        }
        return false;
    }

    public static Boolean isNestedBasicData(String fullPropertyName, HRComplexObjContext context) {
        if (QFilterUtil.isMainEntityPropery(fullPropertyName, context).booleanValue()) {
            String[] nameKeys = fullPropertyName.split("\\.");
            String mainEntityName = context.getEntityNumber();
            int nLevel = 3;
            if (nameKeys[0].equalsIgnoreCase(mainEntityName)) {
                nLevel = 4;
            }
            if (nameKeys.length == nLevel) {
                return true;
            }
            return false;
        }
        if (QFilterUtil.getSubEntityName(fullPropertyName, context) != null) {
            String[] nameKeys = fullPropertyName.split("\\.");
            if (nameKeys.length == 4) {
                return true;
            }
            return false;
        }
        return false;
    }

    @ExcludeFromJacocoGeneratedReport
    private static NestedBasicDataPropertyVO changeFirstLvBDFromSecondLvBDEx(String firstBDName, String secondBDName, String entityName, QFilter filter, HRComplexObjContext context, MainEntityTypeUtil mainEntityTypeUtil) {
        QFilter filterNew;
        String fullPropertyName = filter.getProperty();
        NestedBasicDataPropertyVO netstedBDVo = QFilterUtil.convertNestedBasicDataName(firstBDName, secondBDName, entityName, mainEntityTypeUtil);
        String attributeName = fullPropertyName.substring(fullPropertyName.lastIndexOf(46) + 1);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(netstedBDVo.secondBDEntityName);
        QFilter qFilter = new QFilter(attributeName, filter.getCP(), filter.getValue());
        HashSet secondIDSets = Sets.newHashSetWithExpectedSize((int)16);
        DynamicObjectCollection baseDataList = serviceHelper.queryOriginalCollection("id", new QFilter[]{qFilter});
        for (DynamicObject row : baseDataList) {
            secondIDSets.add(row.get("id"));
        }
        if (netstedBDVo.getDataEntityProperty() instanceof EntryProp) {
            netstedBDVo.filter = new QFilter(secondBDName, "in", (Object)secondIDSets);
            netstedBDVo.mainEntityType = mainEntityTypeUtil.getMainEntityType(entityName);
            return netstedBDVo;
        }
        netstedBDVo.filter = filterNew = QFilterUtil.changeFirstLvBDFromSecondLvBDSub(firstBDName, secondBDName, entityName, secondIDSets, netstedBDVo.firstBDEntityName, netstedBDVo.secondBDEntityName, context);
        if (filterNew != null) {
            MainEntityType dataEntityType;
            netstedBDVo.mainEntityType = dataEntityType = mainEntityTypeUtil.getMainEntityType(entityName);
            DynamicProperty dynamicProperty = dataEntityType.getProperty(firstBDName);
            netstedBDVo.dataEntityProperty = dynamicProperty;
        }
        return netstedBDVo;
    }

    @ExcludeFromJacocoGeneratedReport
    public static NestedBasicDataPropertyVO convertNestedBasicDataName(String firstBDName, String secondBDName, String entityName, MainEntityTypeUtil mainEntityTypeUtil) {
        MainEntityType dataEntityType = mainEntityTypeUtil.getMainEntityType(entityName);
        DynamicProperty dynamicProperty = dataEntityType.getProperty(firstBDName);
        NestedBasicDataPropertyVO vo = new NestedBasicDataPropertyVO();
        if (dynamicProperty instanceof DynamicComplexProperty) {
            String firstBDEntityName;
            DynamicComplexProperty dynamicComplexProperty = (DynamicComplexProperty)dynamicProperty;
            MainEntityType subEntityType = (MainEntityType)((DynamicComplexProperty)dynamicProperty).getComplexType();
            BasedataProp firstdataProp1 = (BasedataProp)dynamicComplexProperty;
            vo.firstBDEntityName = firstBDEntityName = firstdataProp1.getBaseEntityId();
            DynamicProperty dynamicProperty2 = subEntityType.getProperty(secondBDName);
            if (dynamicProperty2 instanceof DynamicComplexProperty) {
                String secondBDEntityName;
                DynamicComplexProperty dynamicComplexProperty2 = (DynamicComplexProperty)dynamicProperty2;
                BasedataProp basedataProp2 = (BasedataProp)dynamicComplexProperty2;
                vo.secondBDEntityName = secondBDEntityName = basedataProp2.getBaseEntityId();
            }
        } else if (dynamicProperty instanceof EntryProp) {
            EntryProp entryProp = (EntryProp)dynamicProperty;
            vo.firstBDEntityName = entryProp.getName();
            DynamicProperty property2 = entryProp.getDynamicCollectionItemPropertyType().getProperty(secondBDName);
            if (property2 instanceof DynamicComplexProperty) {
                String secondBDEntityName;
                DynamicComplexProperty dynamicComplexProperty2 = (DynamicComplexProperty)property2;
                BasedataProp basedataProp2 = (BasedataProp)dynamicComplexProperty2;
                vo.secondBDEntityName = secondBDEntityName = basedataProp2.getBaseEntityId();
            }
            vo.dataEntityProperty = dynamicProperty;
        }
        vo.entityName = entityName;
        vo.firstBDName = firstBDName;
        vo.secondBDName = secondBDName;
        return vo;
    }

    @ExcludeFromJacocoGeneratedReport
    public static QFilter changeFirstLvBDFromSecondLvBDSub(String firstBDName, String secondBDName, String entityName, Set<Object> secondIDSets, String firstBDEntityName, String secondBDEntityName, HRComplexObjContext context) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(firstBDEntityName);
        QFilter qFilter = new QFilter(secondBDName, "in", secondIDSets);
        HashSet firstIDSets = Sets.newHashSetWithExpectedSize((int)16);
        DynamicObjectCollection baseDataList = serviceHelper.queryOriginalCollection("id", new QFilter[]{qFilter});
        for (DynamicObject row : baseDataList) {
            firstIDSets.add(row.get("id"));
        }
        StringBuilder fullFilterName = new StringBuilder();
        if (QFilterUtil.getSubEntityName(entityName, context) != null) {
            fullFilterName.append(entityName).append(".");
        }
        fullFilterName.append(firstBDName).append(".id");
        QFilter firstBDFilter = null;
        firstBDFilter = firstIDSets.size() > 0 ? new QFilter(fullFilterName.toString(), "in", (Object)firstIDSets) : new QFilter(fullFilterName.toString(), "=", (Object)NOT_EXTID);
        return firstBDFilter;
    }

    public static NestedBasicDataPropertyVO changeNoramlBDEx(String BasicDataName, String entityName, QFilter filter, HRComplexObjContext context, MainEntityTypeUtil mainEntityTypeUtil) {
        String fullPropertyName = filter.getProperty();
        NestedBasicDataPropertyVO vo = null;
        String attributeName = fullPropertyName.substring(fullPropertyName.lastIndexOf(46) + 1);
        MainEntityType dataEntityType = mainEntityTypeUtil.getMainEntityType(entityName);
        DynamicProperty dynamicProperty = dataEntityType.getProperty(BasicDataName);
        if (dynamicProperty instanceof DynamicComplexProperty) {
            vo = new NestedBasicDataPropertyVO();
            if (attributeName.equalsIgnoreCase("id")) {
                vo.filter = filter;
                vo.mainEntityType = dataEntityType;
                vo.dataEntityProperty = dynamicProperty;
                return vo;
            }
            BasedataProp firstdataProp = (BasedataProp)dynamicProperty;
            String BasicDataEntityName = firstdataProp.getBaseEntityId();
            ISimpleProperty primaryKey = mainEntityTypeUtil.getMainEntityType(BasicDataEntityName).getPrimaryKey();
            String pkType = "bigint";
            if (primaryKey.getPropertyType() == String.class) {
                pkType = "string";
            }
            QFilter qFilter = new QFilter(attributeName, filter.getCP(), filter.getValue());
            HashSet basicDataIDSets = Sets.newHashSetWithExpectedSize((int)16);
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(BasicDataEntityName);
            DynamicObjectCollection baseDataList = serviceHelper.queryOriginalCollection("id", new QFilter[]{qFilter});
            for (DynamicObject row : baseDataList) {
                if (HRStringUtils.equals((String)pkType, (String)"string")) {
                    basicDataIDSets.add(row.getString("id"));
                    continue;
                }
                basicDataIDSets.add(row.getLong("id"));
            }
            if (filter.getCP().equalsIgnoreCase("<>")) {
                if (HRStringUtils.equals((String)pkType, (String)"string")) {
                    basicDataIDSets.add(" ");
                } else {
                    basicDataIDSets.add(0L);
                }
            }
            StringBuilder fullFilterName = new StringBuilder();
            if (QFilterUtil.getSubEntityName(entityName, context) != null) {
                fullFilterName.append(entityName).append(".");
            }
            fullFilterName.append(BasicDataName).append(".id");
            QFilter firstBDFilter = null;
            if (basicDataIDSets.size() > 0) {
                firstBDFilter = new QFilter(fullFilterName.toString(), "in", (Object)basicDataIDSets);
            } else {
                Object value = HRStringUtils.equals((String)pkType, (String)"string") ? "'-1'" : Long.valueOf(-1L);
                if (filter.getCP().equalsIgnoreCase("is null")) {
                    value = HRStringUtils.equals((String)pkType, (String)"string") ? "" : Long.valueOf(0L);
                }
                firstBDFilter = new QFilter(fullFilterName.toString(), "=", value);
            }
            vo.filter = firstBDFilter;
            vo.mainEntityType = dataEntityType;
            vo.dataEntityProperty = dynamicProperty;
        }
        return vo;
    }

    @ExcludeFromJacocoGeneratedReport
    public static void handlePrivacyProperty(DynamicProperty prop, QFilter filter, HRComplexObjContext context) {
        String property;
        int dotIndex;
        BasedataEntityType parent = (BasedataEntityType)prop.getParent();
        if (parent == null) {
            return;
        }
        String privacyEntityName = parent.getName();
        QFilter privacyQfilter = new QFilter(filter.getProperty(), filter.getCP(), filter.getValue());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(privacyEntityName);
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray("id", privacyQfilter.toArray());
        Set ids = Arrays.stream(dynamicObjects).map(dyo -> dyo.get("id")).collect(Collectors.toSet());
        boolean isMainEntity = false;
        String entityName = QFilterUtil.getSubEntityName(filter.getProperty(), context);
        if (entityName == null) {
            isMainEntity = true;
        }
        String idProperty = (dotIndex = (property = filter.getProperty()).lastIndexOf(".")) == -1 ? "id" : property.substring(0, dotIndex);
        if (dotIndex >= 0 && !isMainEntity) {
            idProperty = idProperty + ".id";
        }
        filter.__setProperty(idProperty);
        if (filter.getCP().equalsIgnoreCase("=") || filter.getCP().equalsIgnoreCase("in")) {
            filter.__setCP("in");
        } else if (filter.getCP().equalsIgnoreCase("!=") || filter.getCP().equalsIgnoreCase("not in")) {
            filter.__setCP("not in");
        } else {
            filter.__setCP("in");
        }
        filter.__setValue(ids);
    }

    @ExcludeFromJacocoGeneratedReport
    public static String toQFilterString(QFilter qFilter, boolean recursive, boolean bTmpTable, Map<String, PKTempTable> tmpTableMap, KSqlParser kSqlParser, int tmpTableThresh) {
        StringBuilder s = new StringBuilder(128);
        String property = qFilter.getProperty();
        Object value = qFilter.getValue();
        String cp = qFilter.getCP();
        if (property.contains("!")) {
            String[] propAliaSplit = property.split("!");
            property = KSqlFuncUtil.substitutionFunc(propAliaSplit[0], SplitDateTypeEnum.getEnum((String)propAliaSplit[1]));
        }
        List nests = qFilter.getNests(false);
        if (cp.equalsIgnoreCase(hrEmptyDecimal)) {
            s.append("(");
            s.append(property).append(' ').append("is null").append(" or ").append(property).append(' ').append("= 0");
            s.append(")");
        } else if (cp.equalsIgnoreCase(hrEmptyText)) {
            s.append("(");
            s.append(property).append(' ').append("is null").append(" or ").append(property).append(' ').append("=' '");
            if (!XDBConfig.get().isSpaceAsEmptyString()) {
                s.append(" or ").append(property).append(' ').append("=''");
            }
            s.append(")");
        } else if (cp.equalsIgnoreCase("is null") || cp.equalsIgnoreCase("is not null")) {
            s.append(property).append(' ').append(cp);
        } else if (cp.equalsIgnoreCase("in") || cp.equalsIgnoreCase("not in")) {
            StringBuilder inSql = new StringBuilder();
            DBRoute route = kSqlParser.getDBRoute();
            Object[] params = QFilterUtilHR.getWithoutDuplicateInValues(value);
            if (params != null && bTmpTable && params.length >= tmpTableThresh && (params[0] instanceof String || params[0] instanceof Integer || params[0] instanceof Long)) {
                Object param1 = params[0];
                if (param1 instanceof String) {
                    Date date = null;
                    try {
                        date = HRDateTimeUtils.parseDate((String)param1.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    int bigStringLength = PKTempTableConfig.getBigStringLength();
                    Set tooLongValSet = Arrays.stream(params).filter(Objects::nonNull).map(param -> (String)param).filter(param -> param.length() > bigStringLength).collect(Collectors.toSet());
                    if (tooLongValSet.size() > 0) {
                        inSql.append(" ( ").append(property).append(' ').append(cp);
                        inSql.append(" (").append(QFilterUtilHR.parametertoString(tooLongValSet)).append(")");
                        Object[] otherVals = Arrays.stream(params).filter(param -> !tooLongValSet.contains(param)).toArray();
                        if (otherVals.length > 0) {
                            inSql.append(" OR ").append(property).append(' ').append(cp);
                            String tmpTableName = QFilterUtilHR.createTmpTableAndSQL(route, otherVals, tmpTableMap, date != null);
                            inSql.append(tmpTableName);
                        }
                        inSql.append(" ) ");
                    } else {
                        String tmpTableName = QFilterUtilHR.createTmpTableAndSQL(route, params, tmpTableMap, date != null);
                        inSql.append(property).append(' ').append(cp);
                        inSql.append(tmpTableName);
                    }
                } else {
                    String tmpTableName = QFilterUtilHR.createTmpTableAndSQL(route, params, tmpTableMap);
                    inSql.append(property).append(' ').append(cp);
                    inSql.append(tmpTableName);
                }
            } else {
                inSql.append(property).append(' ').append(cp);
                inSql.append(" (").append(QFilterUtilHR.parametertoString(value)).append(')');
            }
            s.append((CharSequence)inSql);
        } else {
            s.append(property).append(' ').append(cp);
            s.append(' ').append(QFilterUtilHR.parametertoString(value));
        }
        if (recursive) {
            for (QFilter.QFilterNest nest : nests) {
                s.insert(0, '(');
                if (nest.isAnd()) {
                    s.append(' ').append("and").append(' ');
                } else {
                    s.append(' ').append("or").append(' ');
                }
                s.append(QFilterUtil.toQFilterString(nest.getFilter(), true, bTmpTable, tmpTableMap, kSqlParser, tmpTableThresh));
                s.append(')');
            }
        }
        return s.toString();
    }
}

