/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.diff;

import java.util.List;
import java.util.Locale;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import kd.bos.service.bootstrap.embedjetty.EmbedJettyServer;
import kd.hr.hbp.business.service.diff.AOPContainer;
import kd.hr.hbp.business.service.diff.annotaion.KDOpenAopAPI;
import kd.hr.hbp.business.service.diff.annotaion.KDOpenAopAPIScope;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;

public class AOPListener {
    private static final Logger logger = Logger.getLogger(AOPListener.class);

    public synchronized void start() throws Exception {
        long beginTime = System.currentTimeMillis();
        logger.info((Object)"AOPListener.start() begin.");
        StringBuilder aopStateBuffer = new StringBuilder();
        ClassPool pool = ClassPool.getDefault();
        pool.appendClassPath((ClassPath)new LoaderClassPath(EmbedJettyServer.class.getClassLoader()));
        List<AOPContainer.AOPItem> list = AOPContainer.getInstance().init().getData();
        for (AOPContainer.AOPItem it : list) {
            CtClass ctClass = pool.getOrNull(it.getSourceClassName());
            if (null == ctClass) {
                String errorMsg = "AOPListener.start() error, " + String.format(Locale.ROOT, "Class[%s] not found.", it.getSourceClassName());
                logger.error((Object)errorMsg);
                throw new ClassNotFoundException(errorMsg);
            }
            String key = it.getSourceClassName() + "#" + it.getSourceMethodName();
            CtMethod ctMethod = null;
            try {
                ctMethod = ctClass.getDeclaredMethod(it.getSourceMethodName());
            }
            catch (NotFoundException e) {
                String errorMsg = "AOPListener.start() error, " + e.getMessage();
                logger.error((Object)errorMsg, (Throwable)e);
                throw new ClassNotFoundException(errorMsg, e);
            }
            if (!it.isExtend() && !ctMethod.hasAnnotation(KDOpenAopAPI.class)) {
                String errorMsg = "AOPListener.start() error, " + String.format(Locale.ROOT, "Class[%s] method[%s] do not has a annotation[@KDOpenAopAPI].", it.getSourceClassName(), it.getSourceMethodName());
                logger.error((Object)errorMsg);
                throw new IllegalStateException(errorMsg);
            }
            KDOpenAopAPI openAPI = (KDOpenAopAPI)ctMethod.getAnnotation(KDOpenAopAPI.class);
            for (Pair<String, AOPContainer.AOPItemScope> pair : it.getTargets()) {
                if (0 == AOPContainer.AOPItemScope.BEFORE.compareTo((Enum)pair.getValue()) && (it.isExtend() || 0 == openAPI.scope().compareTo(KDOpenAopAPIScope.ALL) || 0 == openAPI.scope().compareTo(KDOpenAopAPIScope.BEFORE))) {
                    ctMethod.insertBefore((String)pair.getKey() + "(\"" + key + "\",$0,$args);");
                    continue;
                }
                if (0 == AOPContainer.AOPItemScope.AFTER.compareTo((Enum)pair.getValue()) && (it.isExtend() || 0 == openAPI.scope().compareTo(KDOpenAopAPIScope.ALL) || 0 == openAPI.scope().compareTo(KDOpenAopAPIScope.AFTER))) {
                    ctMethod.insertAfter((String)pair.getKey() + "(\"" + key + "\",$0,$_,$args);");
                    continue;
                }
                String errorMsg = "AOPListener.start() error, " + String.format(Locale.ROOT, "Class[%s] method[%s] [@KDOpenAopAPI] scope error.", it.getSourceClassName(), it.getSourceMethodName());
                logger.error((Object)errorMsg);
                throw new IllegalArgumentException(errorMsg);
            }
            ctClass.toClass();
            aopStateBuffer.append(key).append(";");
            logger.info((Object)String.format(Locale.ROOT, "AOPListener.start() ,call javassit to compile class ,className: %s,methodName:%s", it.getSourceClassName(), it.getSourceMethodName()));
            System.setProperty("AOPListenerFinishClasses", aopStateBuffer.toString());
        }
        logger.info((Object)"AOPListener.start() end.");
        long endTime = System.currentTimeMillis();
        logger.info((Object)String.format(Locale.ROOT, "AOPListener.start(),total cost : %s", String.valueOf(endTime - beginTime)));
    }
}

