/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.diff;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.diff.cache.DiffCache;
import org.apache.commons.lang3.tuple.Pair;

public class DiffProxy {
    private static final Log logger = LogFactory.getLog(DiffProxy.class);
    private static final Object CLASS_LOCK = new Object();
    private static final Object METHOD_LOCK = new Object();
    private static volatile Map<String, Class> classMap = new LinkedHashMap<String, Class>(16, 0.75f, true);
    private static volatile Map<String, Method> methodMap = new LinkedHashMap<String, Method>(16, 0.75f, true);
    public static final String CACHE_TYPE = "DIFF_PROXY_TYPE";
    public static final String CACHE_KEY = "DIFF_PROXY_KEY";
    private static final String LOCATION_BEFORE = "BEFORE";
    private static final String LOCATION_AFTER = "AFTER";

    public static void before(String key, Object origin, Object[] parameters) {
        Pair<String, String> pair = DiffProxy.getTarget(key, LOCATION_BEFORE);
        if (null == pair) {
            return;
        }
        String className = (String)pair.getKey();
        String methodName = (String)pair.getValue();
        long beginTime = System.currentTimeMillis();
        DiffProxy.doInvoke(className, methodName, origin, parameters);
        long endTime = System.currentTimeMillis();
        String callMsg = "complete call customer Class (before AOP): className:{},methodName:{},total cost:{}";
        logger.info(callMsg, new Object[]{className, methodName, String.valueOf(endTime - beginTime)});
    }

    public static Object after(String key, Object origin, Object returnValue, Object[] parameters) {
        Pair<String, String> pair = DiffProxy.getTarget(key, LOCATION_AFTER);
        if (null == pair) {
            return null;
        }
        String className = (String)pair.getKey();
        String methodName = (String)pair.getValue();
        long beginTime = System.currentTimeMillis();
        Object obj = DiffProxy.doInvoke(className, methodName, origin, returnValue, parameters);
        long endTime = System.currentTimeMillis();
        String callMsg = "complete call customer Class (after AOP): className:{},methodName:{},total cost:{}";
        logger.info(callMsg, new Object[]{className, methodName, String.valueOf(endTime - beginTime)});
        return obj;
    }

    private static Pair<String, String> getTarget(String key, String location) {
        Map<String, Map<String, String>> allMap = DiffCache.listEnabledDiffApiAop();
        if (null == allMap) {
            return null;
        }
        String newKey = key + "#" + location;
        Map<String, String> newValue = allMap.get(newKey);
        if (null != newValue) {
            Map.Entry<String, String> entry = newValue.entrySet().iterator().next();
            return Pair.of((Object)entry.getKey(), (Object)entry.getValue());
        }
        return null;
    }

    private static Object doInvoke(String className, String methodName, Object origin, Object[] parameters) {
        try {
            Class<?> clazz = DiffProxy.getClass(className);
            Object object = clazz.newInstance();
            Optional<Method> method = DiffProxy.getMethod(clazz, methodName, parameters);
            if (!method.isPresent()) {
                throw new KDException(new ErrorCode("kd.hr.hbp.business.service.diff.DiffProxy.doInvoke.before", ResManager.loadKDString((String)"\u6267\u884c\u5dee\u5f02\u5316\u65b9\u6cd5\u5931\u8d25\uff0c\u7c7b%1$s\u7684\u65b9\u6cd5%2$s\u4e0d\u5b58\u5728\u3002", (String)"DiffProxy_0", (String)"hrmp-hbp-business", (Object[])new Object[]{className, methodName})), new Object[0]);
            }
            return method.get().invoke(object, origin, parameters);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new KDException(new ErrorCode("kd.hr.hbp.business.service.diff.DiffProxy.doInvoke.before", ResManager.loadKDString((String)"\u6267\u884c\u5dee\u5f02\u5316\u65b9\u6cd5\u5931\u8d25\u3002", (String)"DiffProxy_1", (String)"hrmp-hbp-business", (Object[])new Object[0])), new Object[]{e});
        }
    }

    private static Object doInvoke(String className, String methodName, Object origin, Object returnValue, Object[] parameters) {
        try {
            Class<?> clazz = DiffProxy.getClass(className);
            Object object = clazz.newInstance();
            Optional<Method> method = DiffProxy.getMethod(clazz, methodName, parameters);
            if (!method.isPresent()) {
                throw new KDException(new ErrorCode("kd.hr.hbp.business.service.diff.DiffProxy.doInvoke.after", ResManager.loadKDString((String)"\u6267\u884c\u5dee\u5f02\u5316\u65b9\u6cd5\u5931\u8d25\uff0c\u7c7b%1$s\u7684\u65b9\u6cd5%2$s\u4e0d\u5b58\u5728\u3002", (String)"DiffProxy_0", (String)"hrmp-hbp-business", (Object[])new Object[]{className, methodName})), new Object[0]);
            }
            return method.get().invoke(object, origin, returnValue, parameters);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new KDException(new ErrorCode("kd.hr.hbp.business.service.diff.DiffProxy.doInvoke.after", ResManager.loadKDString((String)"\u6267\u884c\u5dee\u5f02\u5316\u65b9\u6cd5\u5931\u8d25\u3002", (String)"DiffProxy_1", (String)"hrmp-hbp-business", (Object[])new Object[0])), new Object[]{e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> getClass(String className) throws ClassNotFoundException {
        Object object = CLASS_LOCK;
        synchronized (object) {
            Class clazz = classMap.get(className);
            if (null == clazz) {
                clazz = TypesContainer.getOrRegister((String)className);
                classMap.put(className, clazz);
            }
            return clazz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Optional<Method> getMethod(Class<?> clazz, String methodName, Object[] parameters) throws KDException {
        String key = clazz.getName() + "#" + methodName;
        int methodNameCount = 0;
        Object object = METHOD_LOCK;
        synchronized (object) {
            Optional<Method> m = Optional.ofNullable(methodMap.get(key));
            if (!m.isPresent()) {
                Method[] methods;
                for (Method method : methods = clazz.getMethods()) {
                    if (!method.getName().equals(methodName)) continue;
                    m = Optional.of(method);
                    methodMap.put(key, m.get());
                    ++methodNameCount;
                }
                if (methodNameCount >= 2) {
                    methodMap.remove(key);
                    throw new KDException(new ErrorCode("kd.hr.hbp.business.service.diff.DiffProxy.getMethod", ResManager.loadKDString((String)"\u6267\u884c\u5dee\u5f02\u5316\u65b9\u6cd5\u5931\u8d25\uff0c\u7c7b%1$s\u7684\u65b9\u6cd5%2$s\u4e0d\u80fd\u91cd\u547d\uff0c\u4e0d\u652f\u6301\u91cd\u8f7d\uff0c\u8bf7\u4e3a\u65b9\u6cd5\u91cd\u65b0\u547d\u540d\u3002", (String)"DiffProxy_2", (String)"hrmp-hbp-business", (Object[])new Object[]{clazz.getName(), methodName})), new Object[0]);
                }
            }
            return m;
        }
    }
}

