/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.diff;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class DiffServiceHelper {
    public static final String DIFF_CUSCONFIG = "hbss_diffcusconfig";
    public static final String DIFF_HANDLER = "hbss_diffhandler";
    public static final String DIFF_IMPLEMENT = "hbss_diffimplement";
    public static final String DIFF_CUSIMPLEMENT = "hbss_diffcusimpl";
    public static final String DIFF_CUSAOPCONFIG = "hbss_diffcusaopconfig";
    public static final String DIFF_CUSIMPLCONFIG = "hbss_diffcusimpl";
    private static final String HANDLER_FIELDS = "id,targetclassname,targetmethodname,isv,diffhandler.sourceclassname,diffhandler.sourcemethodname,diffhandler.sourcemethodsign,diffhandler.isoverride,diffhandler.app";
    private static final String IMPLEMENT_FIELDS = "id,isv,number,name,description,serviceimpl,diffimpl.number";
    private static final String AOP_FIELDS = "sourceclassname, sourcemethodname, targetlocation, targetclassname, targetmethodname";
    public static final String TYPE_HANDLER = "HANDLER";
    public static final String TYPE_APIAOP = "APIAOP";
    public static Function<DynamicObject, Map<String, String>> handlerResult = dynamicObject -> new HashMap<String, String>(){
        private static final long serialVersionUID = -5046911205254499304L;
        {
            this.put("id", dynamicObject.getString("id"));
            this.put("app", dynamicObject.getDynamicObject("diffhandler.app").getString("id"));
            this.put("sourceclassname", dynamicObject.getString("diffhandler.sourceclassname"));
            this.put("sourcemethodname", dynamicObject.getString("diffhandler.sourcemethodname"));
            this.put("sourcemethodsign", dynamicObject.getString("diffhandler.sourcemethodsign"));
            this.put("isoverride", dynamicObject.getString("diffhandler.isoverride"));
            this.put("isv", dynamicObject.getString("isv"));
            this.put("targetclassname", dynamicObject.getString("targetclassname"));
            this.put("targetmethodname", dynamicObject.getString("targetmethodname"));
        }
    };
    public static Function<DynamicObject, Map<String, Object>> implementResult = dynamicObject -> new HashMap<String, Object>(){
        private static final long serialVersionUID = -4207839316486903559L;
        {
            this.put("id", dynamicObject.getString("id"));
            this.put("isv", dynamicObject.getString("isv"));
            this.put("number", dynamicObject.getString("diffimpl.number"));
            this.put("name", dynamicObject.getString("name"));
            this.put("description", dynamicObject.getString("description"));
            this.put("serviceimpl", dynamicObject.getString("serviceimpl"));
        }
    };

    public static List<Map<String, String>> listEnabledHandler() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(DIFF_CUSCONFIG);
        return Arrays.stream(serviceHelper.query(HANDLER_FIELDS, new QFilter[]{new QFilter("enable", "=", (Object)Character.valueOf('1')), new QFilter("diffhandler.type", "=", (Object)TYPE_HANDLER)})).map(handlerResult).collect(Collectors.toList());
    }

    public static List<Map<String, String>> listById(List<Long> handlerIdList) {
        HRBaseServiceHelper handlerHelper = new HRBaseServiceHelper(DIFF_CUSCONFIG);
        return Arrays.stream(handlerHelper.query(HANDLER_FIELDS, new QFilter[]{new QFilter("id", "in", handlerIdList), new QFilter("diffhandler.type", "=", (Object)TYPE_HANDLER)})).map(handlerResult).collect(Collectors.toList());
    }

    public static void batchEnableHandler(List<Long> handlerIdList) {
        DynamicObject[] items;
        HRBaseServiceHelper handlerHelper = new HRBaseServiceHelper(DIFF_CUSCONFIG);
        for (DynamicObject item : items = handlerHelper.query("enable", new QFilter[]{new QFilter("id", "in", handlerIdList), new QFilter("diffhandler.type", "=", (Object)TYPE_HANDLER)})) {
            item.set("enable", (Object)1);
        }
        SaveServiceHelper.save((DynamicObject[])items);
    }

    public static void batchDisableHandler(List<Long> handlerIdList) {
        DynamicObject[] items;
        HRBaseServiceHelper handlerHelper = new HRBaseServiceHelper(DIFF_CUSCONFIG);
        for (DynamicObject item : items = handlerHelper.query("enable", new QFilter[]{new QFilter("id", "in", handlerIdList), new QFilter("diffhandler.type", "=", (Object)TYPE_HANDLER)})) {
            item.set("enable", (Object)0);
        }
        SaveServiceHelper.save((DynamicObject[])items);
    }

    public static List<Map<String, Object>> listEnabledImplement() {
        HRBaseServiceHelper implementHelper = new HRBaseServiceHelper("hbss_diffcusimpl");
        return Arrays.stream(implementHelper.query(IMPLEMENT_FIELDS, new QFilter[]{new QFilter("enable", "=", (Object)Character.valueOf('1'))})).map(implementResult).collect(Collectors.toList());
    }

    public static List<Map<String, Object>> listImplementById(List<Long> implementIdList) {
        HRBaseServiceHelper implementHelper = new HRBaseServiceHelper(DIFF_IMPLEMENT);
        return Arrays.stream(implementHelper.query(IMPLEMENT_FIELDS, new QFilter[]{new QFilter("id", "in", implementIdList)})).map(implementResult).collect(Collectors.toList());
    }

    public static void batchEnableImplement(List<Long> implementIdList) {
        DynamicObject[] items;
        HRBaseServiceHelper implementHelper = new HRBaseServiceHelper("hbss_diffcusimpl");
        for (DynamicObject item : items = implementHelper.query("enable", new QFilter[]{new QFilter("id", "in", implementIdList)})) {
            item.set("enable", (Object)"1");
        }
        SaveServiceHelper.save((DynamicObject[])items);
    }

    public static void batchDisableImplement(List<Long> implementIdList) {
        DynamicObject[] items;
        HRBaseServiceHelper implementHelper = new HRBaseServiceHelper("hbss_diffcusimpl");
        for (DynamicObject item : items = implementHelper.query("enable", new QFilter[]{new QFilter("id", "in", implementIdList)})) {
            item.set("enable", (Object)"0");
        }
        SaveServiceHelper.save((DynamicObject[])items);
    }

    public static Map<String, Map<String, String>> listApiAop() {
        HRBaseServiceHelper implementHelper = new HRBaseServiceHelper(DIFF_CUSAOPCONFIG);
        return Arrays.stream(implementHelper.query(AOP_FIELDS, new QFilter[]{new QFilter("enable", "=", (Object)Character.valueOf('1'))})).collect(DiffServiceHelper.getApiAopCollector());
    }

    public static Map<String, Map<String, String>> listApiAopWithByAppId(String appId) {
        HRBaseServiceHelper implementHelper = new HRBaseServiceHelper(DIFF_CUSAOPCONFIG);
        return Arrays.stream(implementHelper.query(AOP_FIELDS, new QFilter[]{new QFilter("enable", "=", (Object)Character.valueOf('1')), new QFilter("app", "=", (Object)appId)})).collect(DiffServiceHelper.getApiAopCollector());
    }

    public static Map<String, Map<String, String>> listApiAopByIds(List<Long> ids) {
        HRBaseServiceHelper implementHelper = new HRBaseServiceHelper(DIFF_CUSAOPCONFIG);
        return Arrays.stream(implementHelper.query(AOP_FIELDS, new QFilter[]{new QFilter("enable", "=", (Object)Character.valueOf('1')), new QFilter("id", "in", ids)})).collect(DiffServiceHelper.getApiAopCollector());
    }

    public static void batchEnableApiAop(List<Long> apiAopIdList) {
        DynamicObject[] items;
        HRBaseServiceHelper implementHelper = new HRBaseServiceHelper(DIFF_CUSAOPCONFIG);
        for (DynamicObject item : items = implementHelper.query("enable", new QFilter[]{new QFilter("id", "in", apiAopIdList)})) {
            item.set("enable", (Object)1);
        }
        SaveServiceHelper.save((DynamicObject[])items);
    }

    public static void batchDisableApiAop(List<Long> apiAopIdList) {
        DynamicObject[] items;
        HRBaseServiceHelper implementHelper = new HRBaseServiceHelper(DIFF_CUSAOPCONFIG);
        for (DynamicObject item : items = implementHelper.query("enable", new QFilter[]{new QFilter("id", "in", apiAopIdList)})) {
            item.set("enable", (Object)0);
        }
        SaveServiceHelper.save((DynamicObject[])items);
    }

    public static Collector<DynamicObject, ?, Map<String, Map<String, String>>> getApiAopCollector() {
        return Collectors.toMap(it -> it.getString("sourceclassname") + "#" + it.getString("sourcemethodname") + "#" + it.getString("targetlocation"), it -> new HashMap<String, String>(){
            private static final long serialVersionUID = 2510275137756638952L;
            {
                this.put(it.getString("targetclassname"), it.getString("targetmethodname"));
            }
        }, (oldValue, newValue) -> oldValue);
    }

    public static boolean checkClassContainDuplicateMethod(String className, String methodName) {
        Method[] methods;
        Class clazz = TypesContainer.getOrRegister((String)className);
        int methodNameCount = 0;
        for (Method m : methods = clazz.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            ++methodNameCount;
        }
        return methodNameCount >= 2;
    }
}

