/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.diff;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.hr.hbp.business.service.diff.cache.DiffCache;
import org.apache.commons.math3.util.Pair;

public class HRExecuteCustomPluginTool {
    private static final Log logger = LogFactory.getLog(HRExecuteCustomPluginTool.class);
    private static final Object LOCK = new Object();
    private static final Map<String, Pair<Method, Class<?>>> handlerMethodMap = new LinkedHashMap(16, 0.75f, true);

    public static Object executePluginMethod(Optional<String> formNum, String invokeSign, Object ... objects) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement element = stackTraceElements[1];
        String invokeClassName = element.getClassName();
        String invokeMethodName = element.getMethodName();
        String isv = ISVServiceHelper.getISVInfo().getId();
        Optional<String> formId = formNum.map(it -> MetadataDao.getIdByNumber((String)it, (MetaCategory)MetaCategory.Form));
        List list = DiffCache.listEnabledHandler(isv).stream().filter(map -> {
            String recordFormId = (String)map.get("form");
            return (!formId.isPresent() || null == recordFormId || ((String)formId.get()).equals(recordFormId)) && ((String)map.get("sourceclassname")).equalsIgnoreCase(invokeClassName) && ((String)map.get("sourcemethodname")).equalsIgnoreCase(invokeMethodName) && ((String)map.get("sourcemethodsign")).equalsIgnoreCase(invokeSign);
        }).collect(Collectors.toList());
        if (list.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u5dee\u5f02\u5316\u65b9\u6cd5\u5931\u8d25\uff0c\u8be5\u57cb\u70b9\u6709\u591a\u6761\u8bb0\u5f55\uff0c\u8bf7\u5408\u5e76\u3002", (String)"HRExecuteCustomPluginTool_1", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        if (1 == list.size()) {
            Map diffTarget = (Map)list.get(0);
            long beginTime = System.currentTimeMillis();
            Object resultObj = HRExecuteCustomPluginTool.invokeClassMethod((String)diffTarget.get("targetclassname"), (String)diffTarget.get("targetmethodname"), objects);
            long endTime = System.currentTimeMillis();
            String callMsg = "complete call customer Class : className:{},methodName:{},total cost:{},in the Class:className:{},methodName:{},singFlag:{}";
            logger.info(callMsg, new Object[]{diffTarget.get("targetclassname"), diffTarget.get("targetmethodname"), String.valueOf(endTime - beginTime), invokeClassName, invokeMethodName, invokeSign});
            return resultObj;
        }
        return null;
    }

    public static boolean existOverrideMethod(Optional<String> formNum, String invokeSign, Object ... objects) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement element = stackTraceElements[1];
        String invokeClassName = element.getClassName();
        String invokeMethodName = element.getMethodName();
        String isv = ISVServiceHelper.getISVInfo().getId();
        Optional<String> formId = formNum.map(it -> MetadataDao.getIdByNumber((String)it, (MetaCategory)MetaCategory.Form));
        List list = DiffCache.listEnabledHandler(isv).stream().filter(map -> {
            String recordFormId = (String)map.get("form");
            return (!formId.isPresent() || null == recordFormId || ((String)formId.get()).equals(recordFormId)) && ((String)map.get("sourceclassname")).equalsIgnoreCase(invokeClassName) && ((String)map.get("sourcemethodname")).equalsIgnoreCase(invokeMethodName) && ((String)map.get("sourcemethodsign")).equalsIgnoreCase(invokeSign) && ((String)map.get("isoverride")).equalsIgnoreCase("true");
        }).collect(Collectors.toList());
        if (list.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u5dee\u5f02\u5316\u65b9\u6cd5\u5931\u8d25\uff0c\u8be5\u57cb\u70b9\u6709\u591a\u6761\u8bb0\u5f55\uff0c\u8bf7\u5408\u5e76\u3002", (String)"HRExecuteCustomPluginTool_1", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        return 1 == list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object invokeClassMethod(String className, String methodName, Object ... objects) {
        try {
            Class clazz;
            Method method;
            int parameterLength = objects.length;
            String cacheKey = HRExecuteCustomPluginTool.getKey(className, methodName, parameterLength);
            int methodNameCount = 0;
            Object object = LOCK;
            synchronized (object) {
                Pair pair = handlerMethodMap.getOrDefault(cacheKey, new Pair(null, null));
                method = (Method)pair.getKey();
                clazz = (Class)pair.getValue();
                if (null == method) {
                    Method[] methods;
                    clazz = TypesContainer.getOrRegister((String)className);
                    for (Method m : methods = clazz.getMethods()) {
                        if (!m.getName().equals(methodName)) continue;
                        method = m;
                        handlerMethodMap.put(cacheKey, new Pair((Object)m, (Object)clazz));
                        ++methodNameCount;
                    }
                }
            }
            if (methodNameCount >= 2) {
                handlerMethodMap.remove(cacheKey);
                throw new KDException(new ErrorCode("kd.hr.hbp.business.service.diff.HRExecuteCustomPluginTool.invokeClassMethod", ResManager.loadKDString((String)"\u6267\u884c\u5dee\u5f02\u5316\u65b9\u6cd5\u5931\u8d25\uff0c\u7c7b%1$s\u7684\u65b9\u6cd5%2$s\u4e0d\u80fd\u91cd\u547d\uff0c\u4e0d\u652f\u6301\u91cd\u8f7d\uff0c\u8bf7\u4e3a\u65b9\u6cd5\u91cd\u65b0\u547d\u540d\u3002", (String)"HRExecuteCustomPluginTool_2", (String)"hrmp-hbp-business", (Object[])new Object[]{className, methodName})), new Object[0]);
            }
            if (null == method) {
                throw new KDException(new ErrorCode("kd.hr.hbp.business.service.diff.HRExecuteCustomPluginTool.invokeClassMethod", ResManager.loadKDString((String)"\u6267\u884c\u5dee\u5f02\u5316\u65b9\u6cd5\u5931\u8d25\uff0c\u7c7b%1$s\u7684\u65b9\u6cd5%2$s\u4e0d\u5b58\u5728\u3002", (String)"HRExecuteCustomPluginTool_3", (String)"hrmp-hbp-business", (Object[])new Object[]{className, methodName})), new Object[0]);
            }
            if (null != method && null != clazz) {
                return method.invoke(clazz.newInstance(), Arrays.copyOfRange(objects, 0, method.getParameterCount()));
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            if (e instanceof InvocationTargetException && e.getCause() instanceof RuntimeException) {
                throw new RuntimeException(e.getCause());
            }
            throw new KDException(new ErrorCode("kd.hr.hbp.business.service.diff.HRExecuteCustomPluginTool.invokeClassMethod", ResManager.loadKDString((String)"\u6267\u884c\u5dee\u5f02\u5316\u65b9\u6cd5\u5931\u8d25\u3002", (String)"HRExecuteCustomPluginTool_4", (String)"hrmp-hbp-business", (Object[])new Object[0])), new Object[]{e});
        }
        return null;
    }

    private static String getKey(String className, String methodName, int parametersLength) {
        return className + "#" + methodName + "#" + parametersLength;
    }
}

