/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.diff.cache;

import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class CacheMgr {
    private static Log logger = LogFactory.getLog(CacheMgr.class);
    private static CacheConfigInfo cacheConfig = new CacheConfigInfo(){
        {
            this.setTimeout(Integer.parseInt(System.getProperty("diff.handler.timeout", "7200")));
            this.setMaxMemSize(Integer.parseInt(System.getProperty("diff.handler.max-mem-size", "100")));
            this.setMaxItemSize(Integer.parseInt(System.getProperty("diff.handler.max-item-size", "100000")));
            this.setTimeToLive(true);
        }
    };
    private static CacheFactory cacheFactory = CacheFactory.getCommonCacheFactory();
    private static final String DIFF_HANDLER = "HBP_DIFF_HANDLER";
    private static final String DIFF_HANDLER_TARGET = "HBP_DIFF_HANDLER_TARGET";
    private static final String DIFF_IMPLEMENT = "HBP_DIFF_IMPLEMENT";
    private static final String DIFF_API_AOP = "HBP_DIFF_API_AOP";

    public static String getType4DiffHandler() {
        return DIFF_HANDLER;
    }

    public static String getType4DiffHandlerTarget() {
        return DIFF_HANDLER_TARGET;
    }

    public static String getType4DiffImplement() {
        return DIFF_IMPLEMENT;
    }

    public static String getType4DiffApiAop() {
        return DIFF_API_AOP;
    }

    public static String getAcctId() {
        String acctId = CacheKeyUtil.getAcctId();
        if (acctId != null && acctId.length() != 0) {
            return acctId;
        }
        throw new RuntimeException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u4e3a\u7a7a\u3002", (String)"CacheMrg_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
    }

    public static String getCache(String type, String key) {
        LocalMemoryCache cache = cacheFactory.$getOrCreateLocalMemoryCache(CacheMgr.getAcctId(), type, cacheConfig);
        return (String)cache.get(key);
    }

    public static void putCache(String type, String key, String value) {
        LocalMemoryCache cache = cacheFactory.$getOrCreateLocalMemoryCache(CacheMgr.getAcctId(), type, cacheConfig);
        cache.put(key, (Object)value);
    }

    public static void removeCache(String type, String key) {
        LocalMemoryCache cache = cacheFactory.$getOrCreateLocalMemoryCache(CacheMgr.getAcctId(), type, cacheConfig);
        cache.remove(new String[]{key});
    }
}

