/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.entity.operate.imp;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.service.entity.operate.IHRMPEntityOperateService;
import kd.hr.hbp.business.service.entity.operate.imp.HRMPOperationServiceImpl;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class HRMPAdminOrgOpInnerService
implements IHRMPEntityOperateService {
    private String adminOrgBillEntityNumber;
    private String eventEntityNumber;
    private String entityType;
    private String appId;
    private String fromService;

    public HRMPAdminOrgOpInnerService(String adminOrgBillEntityNumber, String eventEntityNumber, String entityType) {
        this.adminOrgBillEntityNumber = adminOrgBillEntityNumber;
        this.eventEntityNumber = eventEntityNumber;
        this.entityType = entityType;
        this.fromService = "yes";
    }

    @Override
    public OperationResult addNew(DynamicObject[] dys) {
        HRMPOperationServiceImpl serviceImpl = new HRMPOperationServiceImpl("hbos_adminorgbill");
        return serviceImpl.localInvokeOperation("save", dys, this.getOperateOption(this.fromService));
    }

    @Override
    public OperationResult modify(DynamicObject[] dys) {
        HRMPOperationServiceImpl serviceImpl = new HRMPOperationServiceImpl("hbos_orgchangebill");
        return serviceImpl.localInvokeOperation("submitandchange", dys, this.getOperateOption(this.fromService));
    }

    @Override
    public OperationResult enable(DynamicObject[] dys) {
        return this.invokeOperation(dys, "enable");
    }

    @Override
    public OperationResult disable(DynamicObject[] dys) {
        return this.invokeOperation(dys, "disable");
    }

    @Override
    public OperationResult audit(DynamicObject[] dys) {
        return this.invokeOperation(dys, "audit");
    }

    @Override
    public OperationResult unAudit(DynamicObject[] dys) {
        return this.invokeOperation(dys, "unaudit");
    }

    @Override
    public OperationResult submit(DynamicObject[] dys) {
        return this.invokeOperation(dys, "submit");
    }

    @Override
    public OperationResult unSubmit(DynamicObject[] dys) {
        return this.invokeOperation(dys, "unsubmit");
    }

    @Override
    public OperationResult edit(DynamicObject[] dys) {
        HRMPOperationServiceImpl serviceImpl = new HRMPOperationServiceImpl("hbos_adminorgbill");
        return serviceImpl.localInvokeOperation("save", dys, this.getOperateOption(this.fromService));
    }

    @Override
    public OperationResult delete(DynamicObject[] dys) {
        return this.invokeOperation(dys, "delete");
    }

    public void syncBaseOrg() {
    }

    public void setFromService(String fromService) {
        this.fromService = fromService;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    private OperationResult invokeOperation(DynamicObject[] dys, String operateKey) {
        HRMPOperationServiceImpl serviceImpl = new HRMPOperationServiceImpl("haos_adminorghr");
        DynamicObject[] entityDys = this.generateDynamicObjectByEntityNumber("haos_adminorghr", dys);
        return serviceImpl.localInvokeOperation(operateKey, entityDys, this.getOperateOption("yes"));
    }

    private DynamicObject[] generateDynamicObjectByEntityNumber(String entityNumber, DynamicObject[] dynArr) {
        ArrayList dynamicList = Lists.newArrayListWithExpectedSize((int)dynArr.length);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        List<String> fieldNameList = HistoryEntityUtils.getFieldsNameList((MainEntityType)dynArr[0].getDataEntityType());
        boolean include = fieldNameList.contains("adminorg");
        Arrays.stream(dynArr).forEach(dyn -> {
            DynamicObject entityDynamic = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dyn, (DynamicObject)entityDynamic);
            if (include) {
                entityDynamic.set("id", (Object)HistoryEntityUtils.getDynamicObjectFieldId(dyn, "adminorg"));
            } else {
                entityDynamic.set("id", dyn.get("id"));
            }
            dynamicList.add(entityDynamic);
        });
        return dynamicList.toArray(new DynamicObject[0]);
    }

    private OperateOption getOperateOption(String fromService) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("billentitynumber", this.adminOrgBillEntityNumber);
        option.setVariableValue("eventEntityNumber", this.eventEntityNumber);
        option.setVariableValue("entitytype", this.entityType);
        option.setVariableValue("fromservice", fromService);
        option.setVariableValue("appnumber", this.getAppId());
        return option;
    }
}

