/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.entity.operate.imp;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.service.entity.operate.IHRMPEntityOperateService;
import kd.hr.hbp.business.service.entity.operate.imp.HRMPOperationServiceImpl;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class HRMPProjectTeamOpInnerService
implements IHRMPEntityOperateService {
    private static final String HAOS_PROJECTTEAM = "haos_projectteam";
    private String adminOrgBillEntityNumber;
    private String eventEntityNumber;
    private String entityType;
    private String fromService;

    public HRMPProjectTeamOpInnerService(String adminOrgBillEntityNumber, String eventEntityNumber, String entityType) {
        this.adminOrgBillEntityNumber = adminOrgBillEntityNumber;
        this.eventEntityNumber = eventEntityNumber;
        this.entityType = entityType;
        this.fromService = "yes";
    }

    @Override
    public OperationResult addNew(DynamicObject[] dys) {
        HRMPOperationServiceImpl serviceImpl = new HRMPOperationServiceImpl(HAOS_PROJECTTEAM);
        return serviceImpl.localInvokeOperation("save", dys, this.getOperateOption(this.fromService));
    }

    @Override
    public OperationResult modify(DynamicObject[] dys) {
        HRMPOperationServiceImpl serviceImpl = new HRMPOperationServiceImpl("haos_projteammod");
        return serviceImpl.localInvokeOperation("submitandchange", dys, this.getOperateOption(this.fromService));
    }

    @Override
    public OperationResult enable(DynamicObject[] dys) {
        return this.invokeOperation(dys, "enable");
    }

    @Override
    public OperationResult disable(DynamicObject[] dys) {
        return null;
    }

    @Override
    public OperationResult audit(DynamicObject[] dys) {
        return null;
    }

    @Override
    public OperationResult unAudit(DynamicObject[] dys) {
        return null;
    }

    @Override
    public OperationResult submit(DynamicObject[] dys) {
        return null;
    }

    @Override
    public OperationResult unSubmit(DynamicObject[] dys) {
        return null;
    }

    @Override
    public OperationResult edit(DynamicObject[] dys) {
        return null;
    }

    @Override
    public OperationResult delete(DynamicObject[] dys) {
        return null;
    }

    private OperateOption getOperateOption(String fromService) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("billentitynumber", this.adminOrgBillEntityNumber);
        option.setVariableValue("eventEntityNumber", this.eventEntityNumber);
        option.setVariableValue("entitytype", this.entityType);
        option.setVariableValue("fromservice", fromService);
        return option;
    }

    private OperationResult invokeOperation(DynamicObject[] dys, String operateKey) {
        HRMPOperationServiceImpl serviceImpl = new HRMPOperationServiceImpl(HAOS_PROJECTTEAM);
        DynamicObject[] entityDys = this.generateDynamicObjectByEntityNumber(HAOS_PROJECTTEAM, dys);
        return serviceImpl.localInvokeOperation(operateKey, entityDys, this.getOperateOption("yes"));
    }

    private DynamicObject[] generateDynamicObjectByEntityNumber(String entityNumber, DynamicObject[] dynamics) {
        ArrayList dynLsit = Lists.newArrayListWithExpectedSize((int)dynamics.length);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        List<String> fieldNameList = HistoryEntityUtils.getFieldsNameList((MainEntityType)dynamics[0].getDataEntityType());
        boolean include = fieldNameList.contains("id");
        Arrays.stream(dynamics).forEach(dynamic -> {
            DynamicObject entityDyn = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dynamic, (DynamicObject)entityDyn);
            if (include) {
                entityDyn.set("id", (Object)HistoryEntityUtils.getDynamicObjectFieldId(dynamic, "adminorg"));
            } else {
                entityDyn.set("id", dynamic.get("id"));
            }
            dynLsit.add(entityDyn);
        });
        return dynLsit.toArray(new DynamicObject[0]);
    }
}

