/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.hr.hbp.business.service.formula.entity.FormulaInfo;
import kd.hr.hbp.business.service.formula.entity.item.CalItem;
import kd.hr.hbp.business.service.formula.entity.item.DataGradeItem;
import kd.hr.hbp.business.service.formula.entity.item.FunctionItem;
import kd.hr.hbp.business.service.formula.entity.item.ResultItem;
import kd.hr.hbp.business.service.formula.entity.node.OriginalNode;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.business.service.formula.enums.FormulaKeyEnum;
import kd.hr.hbp.business.service.formula.enums.OperatorEnum;
import kd.hr.hbp.business.service.formula.helper.FormulaSplitHelper;
import kd.hr.hbp.business.service.formula.utils.FormulaCacheUtils;
import kd.hr.hbp.business.service.formula.utils.FormulaUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class FormulaFormatService {
    private static FormulaInfo getFormulaInfo(IFormView view) {
        FormulaInfo formulaInfo = new FormulaInfo();
        formulaInfo.setFcMap(FormulaCacheUtils.getMapCustValueFromFormulaPageCache(view, "formula_fuc_map_cache_key", FunctionItem.class));
        formulaInfo.setDataGradeMap(FormulaCacheUtils.getMapCustValueFromFormulaPageCache(view, "formula_data_grade_map_cache_key", DataGradeItem.class));
        formulaInfo.setCalItemMap(FormulaCacheUtils.getMapCustValueFromFormulaPageCache(view, "formula_cal_item_map_cache_key", CalItem.class));
        formulaInfo.setResultItemMap(FormulaCacheUtils.getMapCustValueFromFormulaPageCache(view, "formula_result_item_map_cache_key", ResultItem.class));
        formulaInfo.setItemCategorySet(new HashSet<String>(FormulaCacheUtils.getListBaseValueFromFormulaPageCache(view, "formula_item_category_set_cache_key", String.class)));
        return formulaInfo;
    }

    public static String formatFormulaExp(String formatText, IFormView view) throws KDBizException {
        return FormulaFormatService.formatFormulaExp(formatText, FormulaFormatService.getFormulaInfo(view));
    }

    public static String formatFormulaExp(String formatText, FormulaInfo formulaInfo) throws KDBizException {
        if (HRStringUtils.isEmpty((String)formatText) || formulaInfo == null) {
            return formatText;
        }
        FormulaSplitHelper splitHelper = new FormulaSplitHelper();
        List<OriginalNode> nodes = splitHelper.getOriginalNodes(formatText, formulaInfo.getItemCategorySet());
        int complex = 0;
        OriginalNode lastNode = null;
        StringBuilder formatExp = new StringBuilder();
        for (int index = 0; index < nodes.size(); ++index) {
            OriginalNode node = nodes.get(index);
            FormulaKeyEnum keyEnum = FormulaKeyEnum.getByAlias(node.getNodeText());
            FormulaKeyEnum lastKeyEnum = null;
            DataTypeEnum lastDataTypeEnum = null;
            if (lastNode != null) {
                lastKeyEnum = FormulaKeyEnum.getByAlias(lastNode.getNodeText());
                lastDataTypeEnum = DataTypeEnum.getByAlias(lastNode.getNodeText());
            }
            DataTypeEnum dataTypeEnum = DataTypeEnum.getByAlias(node.getNodeText());
            if (Objects.nonNull((Object)keyEnum)) {
                int tabIndex = complex++;
                switch (keyEnum) {
                    case IF: 
                    case WHILE: {
                        break;
                    }
                    case ENDIF: 
                    case ENDWHILE: {
                        --tabIndex;
                        --complex;
                        break;
                    }
                    case THEN: 
                    case ELSEIF: 
                    case ELSE: {
                        --tabIndex;
                        break;
                    }
                }
                switch (keyEnum) {
                    case IF: 
                    case WHILE: 
                    case ENDIF: 
                    case ENDWHILE: 
                    case THEN: 
                    case ELSEIF: 
                    case ELSE: 
                    case RESULT: 
                    case EXPORT: 
                    case EXIT: {
                        FormulaFormatService.attachEnterAndTab(formatExp, tabIndex);
                        break;
                    }
                    default: {
                        if (lastNode != null && lastNode.isAnnotation()) {
                            FormulaFormatService.attachEnterAndTab(formatExp, complex);
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else if (node.isAnnotation() || Objects.nonNull((Object)dataTypeEnum)) {
                FormulaFormatService.attachEnterAndTab(formatExp, complex);
            } else if (FormulaUtils.isAssignmentMeaning(formulaInfo, nodes, index) && FormulaFormatService.checkAssignAddTabAfterKeyEnum(lastKeyEnum, lastDataTypeEnum, lastNode)) {
                FormulaFormatService.attachEnterAndTab(formatExp, complex);
            } else if (lastNode != null && lastNode.isAnnotation()) {
                FormulaFormatService.attachEnterAndTab(formatExp, complex);
            }
            if (Objects.nonNull((Object)dataTypeEnum) && DataTypeEnum.NULL != dataTypeEnum) {
                FormulaFormatService.addTempVariableDefine(formulaInfo, nodes, index);
            }
            if (OperatorEnum.LPARENTHESES.getAlias().equals(node.getNodeText()) || OperatorEnum.RPARENTHESES.getAlias().equals(node.getNodeText()) || OperatorEnum.SPOT.getAlias().equals(node.getNodeText()) || OperatorEnum.COMMA.getAlias().equals(node.getNodeText())) {
                formatExp.deleteCharAt(formatExp.length() - 1);
            }
            formatExp.append(node.getNodeText());
            if (!OperatorEnum.SPOT.getAlias().equals(node.getNodeText())) {
                formatExp.append(' ');
            }
            lastNode = node;
        }
        if (formatExp.charAt(0) == '\n') {
            formatExp.deleteCharAt(0);
        }
        return formatExp.toString();
    }

    private static void attachEnterAndTab(StringBuilder formatExp, int complex) {
        formatExp.append('\n');
        for (int tab = 0; tab < complex; ++tab) {
            formatExp.append("    ");
        }
    }

    private static boolean checkAssignAddTabAfterKeyEnum(FormulaKeyEnum lastKeyEnum, DataTypeEnum lastDataTypeEnum, OriginalNode lastNode) {
        if (Objects.nonNull((Object)lastDataTypeEnum) && DataTypeEnum.NULL != lastDataTypeEnum) {
            return false;
        }
        if (Objects.isNull((Object)lastKeyEnum)) {
            return true;
        }
        if (Objects.nonNull(lastNode) && ",".equals(lastNode.getNodeText())) {
            return false;
        }
        switch (lastKeyEnum) {
            case IF: 
            case WHILE: 
            case EXPORT: {
                return false;
            }
        }
        return true;
    }

    private static void addTempVariableDefine(FormulaInfo formula, List<OriginalNode> nodes, int index) {
        if (index + 1 < nodes.size()) {
            OriginalNode afterNode = nodes.get(index + 1);
            formula.addTempVariable(FormulaUtils.getTempVariableCode(afterNode.getNodeText()), afterNode);
        }
    }
}

