/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.cal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.formula.cal.BonusCalcService;
import kd.hr.hbp.business.service.formula.cal.enums.AddSumTypeEnum;
import kd.hr.hbp.business.service.formula.cal.enums.SubsectionSummaryType;
import kd.hr.hbp.business.service.formula.cal.template.FormulaParse;
import kd.hr.hbp.business.service.formula.cal.vo.AddSumVO;
import kd.hr.hbp.business.service.formula.cal.vo.CalAllParamVO;
import kd.hr.hbp.business.service.formula.cal.vo.CalItemVO;
import kd.hr.hbp.business.service.formula.cal.vo.CalResultDetailVO;
import kd.hr.hbp.business.service.formula.cal.vo.CalResultVO;
import kd.hr.hbp.business.service.formula.cal.vo.FormulaVO;
import kd.hr.hbp.business.service.formula.cal.vo.FunctionVO;
import kd.hr.hbp.business.service.formula.cal.vo.ProportionRuleVO;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class CalcService {
    private static final HRBaseServiceHelper RULE_DEMO_HELPER = new HRBaseServiceHelper("hrcs_calruledemo");
    private static final HRBaseServiceHelper CAL_ITEM_LIST_DEMO_HELPER = new HRBaseServiceHelper("hrcs_calitemlistdemo");
    private static final HRBaseServiceHelper CAL_PROPORTION_DEMO_HELPER = new HRBaseServiceHelper("hrcs_calproportiondemo");
    private static final Log log = LogFactory.getLog(CalcService.class);

    public static void CalByPersonId(List<Long> personIds) throws Exception {
        if (ObjectUtils.isEmpty(personIds)) {
            return;
        }
        DynamicObject ruleDemo = RULE_DEMO_HELPER.loadDynamicObject(new QFilter("number", "=", (Object)"testrule"));
        DynamicObjectCollection calRules = ruleDemo.getDynamicObjectCollection("calruleitementry");
        HashSet calItemIds = Sets.newHashSetWithExpectedSize((int)calRules.size());
        HashMap calUniqueCodeToProportionRule = Maps.newHashMapWithExpectedSize((int)calRules.size());
        ArrayList calFormulaList = Lists.newArrayListWithExpectedSize((int)10);
        HashMap proportionFormulaMap = Maps.newHashMapWithExpectedSize((int)16);
        HashSet functionUniqueCodes = Sets.newHashSetWithExpectedSize((int)16);
        ArrayList functionVOList = Lists.newArrayListWithExpectedSize((int)10);
        Map<Long, DynamicObject> proportionRuleMap = CalcService.getProportionRuleMap(calRules, calItemIds);
        HRBaseServiceHelper personDataHelper = new HRBaseServiceHelper("hrcs_calpeoplevalue");
        DynamicObject[] personItemValues = personDataHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("calitem.id", "in", (Object)calItemIds), new QFilter("person.id", "in", personIds)});
        HashMap uniqueCodeCalItemMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap addSumMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject rule : calRules) {
            CalcService.buildFunctionUniqueCodes(calUniqueCodeToProportionRule, proportionFormulaMap, functionUniqueCodes, proportionRuleMap, rule);
            CalcService.buildExecuteExp(calFormulaList, functionUniqueCodes, rule);
            CalcService.buildUniqueCodeCalItemMap(uniqueCodeCalItemMap, rule);
            CalcService.buildAddSumMap(addSumMap, rule);
        }
        if (ObjectUtils.isNotEmpty((Object)functionUniqueCodes)) {
            DynamicObject[] fucArray;
            HRBaseServiceHelper fucHelper = new HRBaseServiceHelper("hrcs_function");
            QFilter uniqueCodeFilter = new QFilter("uniquecode", "in", (Object)functionUniqueCodes);
            for (DynamicObject fuc : fucArray = fucHelper.query("id,name,funcexp", new QFilter[]{uniqueCodeFilter})) {
                functionVOList.add(new FunctionVO(fuc.getString("name"), fuc.getString("funcexp")));
            }
        }
        CalAllParamVO paramVO = CalcService.getCalAllParamVO(calUniqueCodeToProportionRule, personItemValues, uniqueCodeCalItemMap, addSumMap);
        BonusCalcService SERVICE = BonusCalcService.getService();
        FormulaParse formulaClassImpl = SERVICE.createClassImpl(null, calFormulaList, functionVOList);
        FormulaParse calProportionImpl = SERVICE.createClassImpl(null, new ArrayList<FormulaVO>(proportionFormulaMap.values()), functionVOList);
        Map<String, CalResultDetailVO> cal = SERVICE.calc(formulaClassImpl, calProportionImpl, paramVO, personIds.stream().map(String::valueOf).collect(Collectors.toList()));
        CalcService.saveData(personIds, cal);
    }

    private static Map<Long, DynamicObject> getProportionRuleMap(DynamicObjectCollection calRules, Set<Long> calItemIds) {
        Map<Long, DynamicObject> proportionRuleMap = new HashMap<Long, DynamicObject>();
        HashSet<Long> ruleIdSet = new HashSet<Long>();
        for (DynamicObject rule : calRules) {
            long calItemId = rule.getLong("calitem.id");
            DynamicObject customproportionrule = rule.getDynamicObject("customproportionrule");
            if (Objects.nonNull(customproportionrule)) {
                ruleIdSet.add(customproportionrule.getLong("id"));
            }
            calItemIds.add(calItemId);
        }
        if (!ruleIdSet.isEmpty()) {
            proportionRuleMap = Stream.of(CAL_PROPORTION_DEMO_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", ruleIdSet)})).collect(Collectors.toMap(r -> r.getLong("id"), r -> r));
        }
        return proportionRuleMap;
    }

    private static void buildExecuteExp(List<FormulaVO> calFormulaList, Set<String> functionUniqueCodes, DynamicObject rule) {
        DynamicObject formulaDyObj = rule.getDynamicObject("formula");
        if (Objects.nonNull(formulaDyObj)) {
            String dependentFunc;
            String executeExp = formulaDyObj.getString("executeexp");
            if (HRStringUtils.isNotEmpty((String)executeExp)) {
                String formulaName = formulaDyObj.getString("name");
                FormulaVO formulaVO = new FormulaVO();
                formulaVO.setName(formulaName);
                formulaVO.setExecuteCode(executeExp);
                calFormulaList.add(formulaVO);
            }
            if (HRStringUtils.isNotEmpty((String)(dependentFunc = formulaDyObj.getString("dependentfunc")))) {
                functionUniqueCodes.addAll(Arrays.asList(dependentFunc.split(",")));
            }
        }
    }

    private static void buildFunctionUniqueCodes(Map<String, DynamicObject> calUniqueCodeToProportionRule, Map<Long, FormulaVO> proportionFormulaMap, Set<String> functionUniqueCodes, Map<Long, DynamicObject> proportionRuleMap, DynamicObject rule) {
        String dependentFunc;
        FormulaVO formulaVO;
        DynamicObject customProportionRule = rule.getDynamicObject("customproportionrule");
        if (Objects.isNull(customProportionRule)) {
            return;
        }
        DynamicObject allRuleObj = proportionRuleMap.get(customProportionRule.getLong("id"));
        calUniqueCodeToProportionRule.put(rule.getString("calitem.uniquecode"), allRuleObj);
        long numeratorId = allRuleObj.getLong("numerator.id");
        long denominatorId = allRuleObj.getLong("denominator.id");
        if (!proportionFormulaMap.containsKey(numeratorId)) {
            formulaVO = new FormulaVO();
            formulaVO.setName(allRuleObj.getString("numerator.name"));
            formulaVO.setExecuteCode(allRuleObj.getString("numerator.executeexp"));
            proportionFormulaMap.put(numeratorId, formulaVO);
            dependentFunc = allRuleObj.getString("numerator.dependentfunc");
            if (HRStringUtils.isNotEmpty((String)dependentFunc)) {
                functionUniqueCodes.addAll(Arrays.asList(dependentFunc.split(",")));
            }
        }
        if (!proportionFormulaMap.containsKey(denominatorId)) {
            formulaVO = new FormulaVO();
            formulaVO.setName(allRuleObj.getString("denominator.name"));
            formulaVO.setExecuteCode(allRuleObj.getString("denominator.executeexp"));
            proportionFormulaMap.put(denominatorId, formulaVO);
            dependentFunc = allRuleObj.getString("denominator.dependentfunc");
            if (HRStringUtils.isNotEmpty((String)dependentFunc)) {
                functionUniqueCodes.addAll(Arrays.asList(dependentFunc.split(",")));
            }
        }
    }

    private static void buildAddSumMap(Map<String, AddSumVO> addSumMap, DynamicObject rule) {
        if ("true".equals(rule.getString("calitem.isaddsum"))) {
            addSumMap.computeIfAbsent(rule.getString("calitem.uniquecode"), k -> {
                AddSumVO addSumVO = new AddSumVO();
                addSumVO.setAddSumId(rule.getString("calitem.id"));
                addSumVO.setUniqueCode(rule.getString("calitem.uniquecode"));
                addSumVO.setAddSumItemUniqueCodeSet(new HashSet<String>(Arrays.asList(rule.getString("calitem.addsumitems").split(","))));
                addSumVO.setAddSumType(AddSumTypeEnum.AFTER_CAL_SUM);
                return addSumVO;
            });
        }
    }

    private static void buildUniqueCodeCalItemMap(Map<String, CalItemVO> uniqueCodeCalItemMap, DynamicObject rule) {
        uniqueCodeCalItemMap.computeIfAbsent(rule.getString("calitem.uniquecode"), k -> {
            CalItemVO calItemVO = new CalItemVO();
            calItemVO.setId(rule.getString("calitem.id"));
            calItemVO.setDataType(DataTypeEnum.getDataType(rule.getString("calitem.datatype")));
            calItemVO.setName(rule.getString("calitem.name"));
            calItemVO.setUniqueCode(rule.getString("calitem.uniquecode"));
            calItemVO.setSummaryType(SubsectionSummaryType.SUM);
            calItemVO.setDataLength(rule.getInt("calitem.datalength"));
            calItemVO.setScale(rule.getInt("calitem.scale"));
            calItemVO.setRoundingMode(RoundingMode.HALF_UP);
            return calItemVO;
        });
    }

    private static CalAllParamVO getCalAllParamVO(Map<String, DynamicObject> calUniqueCodeToProportionRule, DynamicObject[] personItemValues, Map<String, CalItemVO> uniqueCodeCalItemMap, Map<String, AddSumVO> addSumMap) {
        CalAllParamVO paramVO = new CalAllParamVO();
        HashMap<String, Map<String, List<String>>> paramIdToConvertSectionMap = new HashMap<String, Map<String, List<String>>>();
        HashMap<String, Map<String, Map<String, ProportionRuleVO>>> itemSectionProportionRuleMap = new HashMap<String, Map<String, Map<String, ProportionRuleVO>>>();
        HashMap<String, Map<String, Map<String, Object>>> paramIdToSectionParamMap = new HashMap<String, Map<String, Map<String, Object>>>();
        HashMap<String, Map<String, Object>> paramIdToParamMap = new HashMap<String, Map<String, Object>>();
        HashMap<String, Map<String, List<String>>> itemSectionMap = new HashMap<String, Map<String, List<String>>>();
        HashMap<String, Map<String, AddSumVO>> paramIdAddSumMap = new HashMap<String, Map<String, AddSumVO>>();
        HashSet personIds = Sets.newHashSetWithExpectedSize((int)personItemValues.length);
        Map<Long, List<DynamicObject>> subTags = Stream.of(personItemValues).filter(dy -> StringUtils.isNotBlank((String)dy.getString("subtag"))).collect(Collectors.groupingBy(dy -> dy.getLong("person.id")));
        for (DynamicObject personItemValue : personItemValues) {
            long personId = personItemValue.getLong("person.id");
            personIds.add(personId);
            itemSectionProportionRuleMap.computeIfAbsent(String.valueOf(personId), k -> new HashMap());
            paramIdToConvertSectionMap.computeIfAbsent(String.valueOf(personId), k -> new LinkedHashMap());
            itemSectionMap.computeIfAbsent(String.valueOf(personId), k -> new HashMap());
            paramIdAddSumMap.computeIfAbsent(String.valueOf(personId), k -> addSumMap);
            CalcService.parseSubTag(calUniqueCodeToProportionRule, paramIdToSectionParamMap, paramIdToParamMap, subTags, personItemValue);
        }
        CalcService.buildProportionRule(calUniqueCodeToProportionRule, paramIdToConvertSectionMap, itemSectionProportionRuleMap, itemSectionMap, personIds, subTags);
        paramVO.setParamIdToConvertSectionMap(paramIdToConvertSectionMap);
        paramVO.setItemSectionProportionRuleMap(itemSectionProportionRuleMap);
        paramVO.setParamIdToSectionParamMap(paramIdToSectionParamMap);
        paramVO.setParamIdToParamMap(paramIdToParamMap);
        paramVO.setItemSectionMap(itemSectionMap);
        paramVO.setUniqueCodeCalItemMap(uniqueCodeCalItemMap);
        paramVO.setParamIdAddSumMap(paramIdAddSumMap);
        return paramVO;
    }

    private static void buildProportionRule(Map<String, DynamicObject> calUniqueCodeToProportionRule, Map<String, Map<String, List<String>>> paramIdToConvertSectionMap, Map<String, Map<String, Map<String, ProportionRuleVO>>> itemSectionProportionRuleMap, Map<String, Map<String, List<String>>> itemSectionMap, Set<Long> personIds, Map<Long, List<DynamicObject>> subTags) {
        for (Map.Entry<String, DynamicObject> entry : calUniqueCodeToProportionRule.entrySet()) {
            for (Long personId : personIds) {
                List<DynamicObject> subTagObjs = subTags.get(personId);
                for (DynamicObject subTagObj : subTagObjs) {
                    Map<String, Map<String, ProportionRuleVO>> itemSectionProportionRule = itemSectionProportionRuleMap.get(String.valueOf(personId));
                    itemSectionProportionRule.computeIfAbsent(entry.getKey(), k -> new LinkedHashMap());
                    itemSectionProportionRule.computeIfPresent(entry.getKey(), (k, value) -> {
                        ProportionRuleVO ruleVO = new ProportionRuleVO();
                        ruleVO.setId(((DynamicObject)entry.getValue()).getString("id"));
                        ruleVO.setNumeratorId(((DynamicObject)entry.getValue()).getLong("numerator.id"));
                        ruleVO.setDenominatorId(((DynamicObject)entry.getValue()).getLong("denominator.id"));
                        ruleVO.setScale(((DynamicObject)entry.getValue()).getInt("scale"));
                        value.put(subTagObj.getString("subtag"), ruleVO);
                        return value;
                    });
                    Map<String, List<String>> convertSectionTagMap = paramIdToConvertSectionMap.get(String.valueOf(personId));
                    convertSectionTagMap.computeIfAbsent(entry.getValue().getString("numerator.id"), k -> new ArrayList());
                    convertSectionTagMap.computeIfPresent(entry.getValue().getString("numerator.id"), (k, value) -> {
                        if (!value.contains(subTagObj.getString("subtag"))) {
                            value.add(subTagObj.getString("subtag"));
                        }
                        return value;
                    });
                    convertSectionTagMap.computeIfAbsent(entry.getValue().getString("denominator.id"), k -> new ArrayList());
                    convertSectionTagMap.computeIfPresent(entry.getValue().getString("denominator.id"), (k, value) -> {
                        if (!value.contains(subTagObj.getString("subtag"))) {
                            value.add(subTagObj.getString("subtag"));
                        }
                        return value;
                    });
                    itemSectionMap.computeIfPresent(String.valueOf(personId), (k, v) -> {
                        v.computeIfAbsent(entry.getKey(), c -> new ArrayList());
                        v.computeIfPresent(entry.getKey(), (c, l) -> {
                            if (!l.contains(subTagObj.getString("subtag"))) {
                                l.add(subTagObj.getString("subtag"));
                            }
                            return l;
                        });
                        return v;
                    });
                }
            }
        }
    }

    private static void parseSubTag(Map<String, DynamicObject> calUniqueCodeToProportionRule, Map<String, Map<String, Map<String, Object>>> paramIdToSectionParamMap, Map<String, Map<String, Object>> paramIdToParamMap, Map<Long, List<DynamicObject>> subTags, DynamicObject personItemValue) {
        long personId = personItemValue.getLong("person.id");
        DynamicObject calItem = personItemValue.getDynamicObject("calitem");
        paramIdToSectionParamMap.computeIfAbsent(String.valueOf(personId), k -> new LinkedHashMap());
        if (CollectionUtils.isEmpty(calUniqueCodeToProportionRule)) {
            return;
        }
        String subTag = personItemValue.getString("subtag");
        if (HRStringUtils.isNotEmpty((String)subTag)) {
            Map<String, Map<String, Object>> sectionParamMap = paramIdToSectionParamMap.get(String.valueOf(personId));
            sectionParamMap.computeIfAbsent(subTag, k -> new HashMap());
            sectionParamMap.computeIfPresent(subTag, (k, value) -> {
                value.put(calItem.getString("uniquecode"), CalcService.convertValueByType(calItem.getString("datatype"), personItemValue.getString("calitemvalue")));
                return value;
            });
        } else {
            List<DynamicObject> subTagObjs = subTags.get(personId);
            for (DynamicObject subTagObj : subTagObjs) {
                Map<String, Map<String, Object>> sectionParamMap = paramIdToSectionParamMap.get(String.valueOf(personId));
                sectionParamMap.computeIfAbsent(subTagObj.getString("subtag"), k -> new HashMap());
                sectionParamMap.computeIfPresent(subTagObj.getString("subtag"), (k, value) -> {
                    value.put(calItem.getString("uniquecode"), CalcService.convertValueByType(calItem.getString("datatype"), personItemValue.getString("calitemvalue")));
                    return value;
                });
            }
            paramIdToParamMap.computeIfAbsent(String.valueOf(personId), k -> new HashMap());
            paramIdToParamMap.computeIfPresent(String.valueOf(personId), (k, value) -> {
                value.put(calItem.getString("uniquecode"), CalcService.convertValueByType(calItem.getString("datatype"), personItemValue.getString("calitemvalue")));
                return value;
            });
        }
    }

    private static void setFormulaInfo(Map<String, Object> calCacheParamMap, List<Long> formulabaseIdList) throws KDBizException {
        ArrayList<String> uniqueCodeList = new ArrayList<String>();
        ArrayList<String> fcUniqueCodeList = new ArrayList<String>();
        ArrayList<String> customUniqueCodeList = new ArrayList<String>();
        LinkedList list = new LinkedList();
        LinkedList<String> needSaveItemList = new LinkedList<String>();
        DynamicObject[] formulaArray = CalcService.getFormulaData(formulabaseIdList);
        ArrayList salaryItemIdList = Lists.newArrayListWithExpectedSize((int)formulaArray.length);
        for (DynamicObject formulaTemp : formulaArray) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("executeCode", formulaTemp.getString("executeexp"));
            map.put("name", formulaTemp.getString("name"));
            list.add(map);
            CalItemVO itemVO = new CalItemVO();
            itemVO.setId(formulaTemp.getString("resultitem.id"));
            itemVO.setUniqueCode("SL" + formulaTemp.getLong("resultitem.id"));
            itemVO.setName(formulaTemp.getString("resultitem.name"));
            itemVO.setScale(5);
            map.put("resultitem", itemVO);
            salaryItemIdList.add(String.valueOf(formulaTemp.getLong("resultitem.id")));
            CalcService.addItemCodeToList(formulaTemp.getString("dependentfunc"), fcUniqueCodeList);
            CalcService.addItemCodeToList(formulaTemp.getString("dependentcalitemforfunc"), uniqueCodeList);
            CalcService.addItemCodeToList(formulaTemp.getString("dependentcalitem"), uniqueCodeList);
            CalcService.addItemCodeToList(formulaTemp.getString("dependentcustitem"), customUniqueCodeList);
            CalcService.addItemCodeToList(formulaTemp.getString("resultitemuniquecode"), needSaveItemList);
        }
        needSaveItemList.addAll(uniqueCodeList);
        Map<String, String> fcMap = CalcService.getFuncMap(fcUniqueCodeList);
        calCacheParamMap.put("fcMapKey", fcMap);
        calCacheParamMap.put("uniqueCodeList", uniqueCodeList);
        calCacheParamMap.put("customUniqueCodeList", customUniqueCodeList);
        calCacheParamMap.put("needSaveItemList", needSaveItemList);
        calCacheParamMap.put("formulaList", list);
        calCacheParamMap.put("calSalaryItemIdList", salaryItemIdList);
    }

    public static void addItemCodeToList(String dependOnItems, List<String> itemUniqueCodeList) {
        if (!HRStringUtils.isEmpty((String)dependOnItems)) {
            for (String uniqueCode : dependOnItems.split(",")) {
                if (itemUniqueCodeList.contains(uniqueCode)) continue;
                itemUniqueCodeList.add(uniqueCode);
            }
        }
    }

    public static Map<String, String> getFuncMap(List<String> uniqueCodeList) {
        HashMap<String, String> fcMap = new HashMap<String, String>(16);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbp_formula_cache_key");
        QFilter qFilter = new QFilter("uniquecode", "in", uniqueCodeList);
        DynamicObjectCollection fcData = helper.queryOriginalCollection("number,name,funcexp", new QFilter[]{qFilter});
        if (null != fcData && fcData.size() != 0) {
            for (DynamicObject fc : fcData) {
                fcMap.put(fc.getString("number"), fc.getString("funcexp"));
            }
        }
        return fcMap;
    }

    private static DynamicObject[] getFormulaData(List<Long> formulabaseIdList) {
        HRBaseServiceHelper formulaHelper = new HRBaseServiceHelper("t_hrcs_formulatestdemo");
        String fields = "id,number,name,executeexp,dependentfunc,dependentcalitem,dependentcalitemforfunc,dependentcustitem,resultitemuniquecode,resultitem";
        DynamicObject[] formulaArray = formulaHelper.query(fields, new QFilter[]{new QFilter("id", "in", formulabaseIdList)});
        return formulaArray;
    }

    private static void handleCustomCalItem(Map<String, Object> calParamMap) {
        List customCalItemList = (List)calParamMap.get("customUniqueCodeList");
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)customCalItemList)) {
            return;
        }
        HRBaseServiceHelper spHelper = new HRBaseServiceHelper("hsas_supportitem");
        QFilter filter = new QFilter("uniquecode", "in", (Object)customCalItemList);
        filter.and(new QFilter("effectivesection", "=", (Object)"2"));
        DynamicObjectCollection spData = spHelper.queryOriginalCollection("id,uniquecode,datatype,defaultvalue", new QFilter[]{filter});
        HashMap<String, Object> customDataMap = new HashMap<String, Object>(3);
        for (DynamicObject spItem : spData) {
            String uniquecode = spItem.getString("uniquecode");
            Object value = spItem.get("defaultvalue");
            customDataMap.put(uniquecode, value);
        }
        calParamMap.put("customMapKey", customDataMap);
    }

    private static DynamicObject[] getSalaryItemCollection(List<String> uniqueCodeList) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hsbs_salaryitem");
        String selectProperties = "id,name,number,uniquecode,datatype.showtype,dataprecision.scale,dataround.id,datalength,proratesummarytype";
        QFilter filter = new QFilter("uniquecode", "in", uniqueCodeList);
        DynamicObject[] collection = helper.query(selectProperties, new QFilter[]{filter});
        return collection;
    }

    private static CalItemVO getSalaryItemObj(DynamicObject item, int amtPrecision) {
        CalItemVO salaryItem = new CalItemVO();
        salaryItem.setUniqueCode(item.getString("uniquecode"));
        salaryItem.setName(item.getString("name"));
        salaryItem.setId(item.getString("id"));
        salaryItem.setDataLength(item.getInt("datalength"));
        salaryItem.setDataType(DataTypeEnum.INT);
        return salaryItem;
    }

    private static int cachePaysubjectData(Map<String, Object> calData) {
        Long paySubjectHisId = (Long)calData.get("paySubjectHisId");
        int amtPrecision = 0;
        if (null == paySubjectHisId || paySubjectHisId <= 0L) {
            return amtPrecision;
        }
        HRBaseServiceHelper paySubjectHelper = new HRBaseServiceHelper("hsbs_paysubjecthis");
        String fields = "id,dataprecision.scale,dataround.id,currency.amtprecision";
        QFilter qFilter = new QFilter("id", "=", (Object)paySubjectHisId);
        DynamicObject paySubject = paySubjectHelper.queryOne(fields, new QFilter[]{qFilter});
        HashMap<String, Number> paySubjectMap = new HashMap<String, Number>(2);
        if (paySubject != null) {
            paySubjectMap.put("scale", paySubject.getInt("dataprecision.scale"));
            paySubjectMap.put("dataroundId", paySubject.getLong("dataround.id"));
            amtPrecision = paySubject.getInt("currency.amtprecision");
        } else {
            paySubjectMap.put("scale", 2);
            amtPrecision = 2;
        }
        calData.put(String.format("cal_paysubject_%s", paySubjectHisId), paySubjectMap);
        return amtPrecision;
    }

    private static void saveData(List<Long> personIds, Map<String, CalResultDetailVO> cal) {
        QFilter personIdFilter = new QFilter("person.id", "in", personIds);
        CAL_ITEM_LIST_DEMO_HELPER.deleteByFilter(new QFilter[]{personIdFilter});
        ArrayList saveData = Lists.newArrayListWithExpectedSize((int)cal.size());
        HashMap<String, DynamicObject> subMap = new HashMap<String, DynamicObject>();
        for (Map.Entry<String, CalResultDetailVO> entry : cal.entrySet()) {
            CalResultDetailVO value = entry.getValue();
            String personIdStr = entry.getKey().split("-")[0];
            DynamicObject sumValue = CAL_ITEM_LIST_DEMO_HELPER.generateEmptyDynamicObject();
            sumValue.set("caltype", (Object)"1");
            sumValue.set("person", (Object)Long.parseLong(personIdStr));
            sumValue.set("status", (Object)"C");
            sumValue.set("enable", (Object)"1");
            for (Map.Entry<String, CalResultVO> sumResult : value.getSumResultMap().entrySet()) {
                CalResultVO resultValue = sumResult.getValue();
                String propertyKey = "";
                switch (sumResult.getKey()) {
                    case "S_yearendbonuspayable": {
                        propertyKey = "yearendbonuspayable";
                        break;
                    }
                    case "S_taxamount": {
                        propertyKey = "taxamount";
                        break;
                    }
                    case "S_actualyearendbonus": {
                        propertyKey = "actualyearendbonus";
                        break;
                    }
                }
                if (StringUtils.isNotBlank((String)propertyKey)) {
                    sumValue.set(propertyKey, resultValue.getCalResultValue());
                }
                CalcService.setSubDy(subMap, personIdStr, propertyKey, resultValue.getItemSubsectionResult());
                CalcService.setSubDy(subMap, personIdStr, propertyKey, resultValue.getTimeSubsectionResult());
            }
            Set<Map.Entry<String, AddSumVO>> entries = value.getAddSumMap().entrySet();
            for (Map.Entry<String, AddSumVO> addSumVO : entries) {
                AddSumVO addSumValue = addSumVO.getValue();
                sumValue.set("originaladdsumresult", addSumValue.getOriginalValue());
                sumValue.set("currentaddsumresult", addSumValue.getCurrentCalValue());
                sumValue.set("totaladdsumresult", (Object)addSumValue.getTotalValue());
            }
            saveData.add(sumValue);
        }
        saveData.addAll(subMap.values());
        if (!CollectionUtils.isEmpty((Collection)saveData)) {
            CAL_ITEM_LIST_DEMO_HELPER.save(saveData.toArray(new DynamicObject[0]));
        }
    }

    private static void setSubDy(Map<String, DynamicObject> subMap, String personIdStr, String propertyKey, List<CalResultVO> subResultList) {
        for (CalResultVO itemResult : subResultList) {
            DynamicObject itemValue = subMap.get(itemResult.getItemProrateDetailId());
            if (Objects.isNull(itemValue)) {
                itemValue = CAL_ITEM_LIST_DEMO_HELPER.generateEmptyDynamicObject();
                subMap.put(itemResult.getItemProrateDetailId(), itemValue);
            }
            itemValue.set("caltype", (Object)"2");
            itemValue.set("person", (Object)Long.parseLong(personIdStr));
            itemValue.set("status", (Object)"C");
            itemValue.set("enable", (Object)"1");
            if (StringUtils.isNotBlank((String)propertyKey)) {
                itemValue.set(propertyKey, itemResult.getCalResultValue());
            }
            if (CollectionUtils.isEmpty(itemResult.getItemSubsectionResult())) continue;
            CalcService.setSubDy(subMap, personIdStr, propertyKey, itemResult.getItemSubsectionResult());
        }
    }

    private static Object convertValueByType(String valueType, String value) {
        if (HRStringUtils.isEmpty((String)value) || HRStringUtils.isEmpty((String)valueType)) {
            return null;
        }
        switch (valueType) {
            case "num": {
                return new BigDecimal(value);
            }
            case "string": {
                return value;
            }
            case "boolean": {
                return Boolean.parseBoolean(value);
            }
            case "int": {
                return Integer.valueOf(value);
            }
            case "date": {
                try {
                    return HRDateTimeUtils.parseDate((String)value);
                }
                catch (ParseException e) {
                    return null;
                }
            }
            case "amount": {
                return new BigDecimal(value);
            }
        }
        return value;
    }
}

