/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.cal;

import com.google.common.collect.Sets;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.formula.excel.UDFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.function.HRBaseFunction;
import kd.hr.hbp.business.service.formula.cal.MyClassLoader;
import kd.hr.hbp.business.service.formula.cal.template.FormulaParse;
import kd.hr.hbp.business.service.formula.cal.vo.FormulaVO;
import kd.hr.hbp.business.service.formula.cal.vo.FunctionVO;
import kd.hr.hbp.business.service.formula.entity.item.FunctionItem;
import kd.hr.hbp.business.service.formula.entity.item.ParamItem;
import kd.hr.hbp.business.service.formula.enums.FunctionErrorCodeEnum;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections4.CollectionUtils;

public class FormulaAnalysis {
    private static final Log log = LogFactory.getLog(FormulaAnalysis.class);
    protected static char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String CLASS_NAME = "kd.hr.hbp.business.service.formula.cal.template.FormulaParse";
    private static final String CLASS_NAME_FUNCTION = "kd.hr.hbp.business.function.HRBaseFunction";
    private static final ClassPool POOL = new ClassPool(true);
    private static final Set<String> FORMULA_IMPORT_PACKAGE = Sets.newHashSetWithExpectedSize((int)16);

    public static synchronized UDFunction getFunctionExecuteInstance(FunctionItem functionItem) throws Exception {
        for (String page : FORMULA_IMPORT_PACKAGE) {
            POOL.importPackage(page.trim());
        }
        if (CollectionUtils.isNotEmpty(functionItem.getImportPackages())) {
            for (String packageName : functionItem.getImportPackages()) {
                POOL.importPackage(packageName.trim());
            }
        }
        POOL.insertClassPath((ClassPath)new ClassClassPath(HRBaseFunction.class));
        MyClassLoader classLoader = new MyClassLoader(FormulaAnalysis.class.getClassLoader());
        String classNameImp = CLASS_NAME_FUNCTION + functionItem.getDefine() + "Impl";
        CtClass ctClass = POOL.makeClass(classNameImp, POOL.get(CLASS_NAME_FUNCTION));
        String executeBodyCode = String.format(" public String getName() { return \"%s\";}", functionItem.getFunkey());
        CtMethod nameMethod = CtNewMethod.make((String)executeBodyCode, (CtClass)ctClass);
        ctClass.addMethod(nameMethod);
        CtMethod newMethod = CtNewMethod.make((String)functionItem.getFuncexp(), (CtClass)ctClass);
        ctClass.addMethod(newMethod);
        StringBuilder params = new StringBuilder();
        String methodBody = FormulaAnalysis.transferParamType(functionItem, params);
        String executeFunCode = String.format("\tpublic Object exec(Object[] objects) {%1s return %2s(%3s);}", methodBody, functionItem.getFunkey(), params);
        CtMethod callMethod = CtNewMethod.make((String)executeFunCode, (CtClass)ctClass);
        ctClass.addMethod(callMethod);
        Class clazz = null;
        try {
            clazz = ctClass.toClass((ClassLoader)classLoader, classLoader.getClass().getProtectionDomain());
            UDFunction uDFunction = (UDFunction)clazz.newInstance();
            return uDFunction;
        }
        catch (VerifyError ex) {
            throw new Exception(MessageFormat.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u7c7b\u201c{0}\u201d\u751f\u6210\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{1}\u3002", (String)"FormulaAnalysis_1", (String)"hrmp-hbp-business", (Object[])new Object[0]), functionItem.getId(), ex.getMessage()), ex);
        }
        finally {
            ctClass.detach();
            ctClass.defrost();
        }
    }

    private static String transferParamType(FunctionItem functionItem, StringBuilder params) {
        StringBuilder methodBody = new StringBuilder();
        for (int i = 0; i < functionItem.getParams().size(); ++i) {
            ParamItem paramItem = functionItem.getParams().get(i);
            switch (paramItem.getParamDataType()) {
                case NUM: {
                    params.append(" objects[").append(i);
                    params.append("] instanceof BigDecimal ? (BigDecimal)").append(" objects[").append(i);
                    params.append("]:BigDecimal.valueOf(Double.parseDouble(String.valueOf(objects[");
                    params.append(i);
                    params.append("])))");
                    break;
                }
                case TEXT: {
                    params.append(" objects[").append(i);
                    params.append("] instanceof String ? (String)").append(" objects[").append(i);
                    params.append("]:String.valueOf(objects[");
                    params.append(i);
                    params.append("])");
                    break;
                }
                case BOOLEAN: {
                    params.append(" objects[").append(i);
                    params.append("] instanceof Boolean ? (Boolean)").append(" objects[").append(i);
                    params.append("]:Boolean.valueOf(String.valueOf(objects[");
                    params.append(i);
                    params.append("]))");
                    break;
                }
                case DATE: 
                case DATETIME: {
                    params.append(" objects[").append(i);
                    params.append("] instanceof Date ? (Date)").append(" objects[").append(i);
                    params.append("]:HRDateTimeUtils.parseDateLocal(String.valueOf(objects[");
                    params.append(i);
                    params.append("]))");
                    break;
                }
                case INT: {
                    params.append(" objects[").append(i);
                    params.append("] instanceof Integer ? (Integer)").append(" objects[").append(i);
                    params.append("]:Integer.valueOf(String.valueOf(objects[");
                    params.append(i);
                    params.append("]))");
                    break;
                }
                case OBJECT: {
                    params.append(" objects[");
                    params.append(i);
                    params.append("] ");
                    break;
                }
                case ARRAY_NUM: {
                    methodBody.append(" BigDecimal[] decimalArr = new BigDecimal[objects.length];");
                    methodBody.append("  for (int k = 0; k < objects.length; k++) {");
                    methodBody.append(" decimalArr[k]=BigDecimal.valueOf(Double.parseDouble(String.valueOf(objects[k]))); }");
                    params.append("decimalArr");
                    break;
                }
                case ARRAY_STRING: {
                    methodBody.append(" String[] stringArr = new String[objects.length];");
                    methodBody.append("  for (int k = 0; k < objects.length; k++) {");
                    methodBody.append(" stringArr[k]=String.valueOf(objects[k]); }");
                    params.append("stringArr");
                    break;
                }
                case ARRAY_DATE: {
                    methodBody.append(" Date[] dateArr = new Date[objects.length];");
                    methodBody.append("  for (int k = 0; k < objects.length; k++) {");
                    params.append(" dateArr[k]=objects[k] instanceof Date ? (Date)objects[k]:HRDateTimeUtils.parseDateLocal(String.valueOf(objects[k]));}");
                    params.append("dateArr");
                    break;
                }
                case ARRAY_INT: {
                    methodBody.append(" Integer[] intArr = new Integer[objects.length];");
                    methodBody.append("  for (int k = 0; k < objects.length; k++) {");
                    methodBody.append(" intArr[k]=Integer.valueOf(String.valueOf(objects[k]))); }");
                    params.append("intArr");
                    break;
                }
                case ARRAY_OBJECT: {
                    params.append("objects");
                    break;
                }
            }
            if (i >= functionItem.getParams().size() - 1) continue;
            params.append(" , ");
        }
        return methodBody.toString();
    }

    public static FormulaParse getFormulaExecuteInstance(String formulaCode, List<FormulaVO> formulaInfoList, List<FunctionVO> fcDetailList) throws Exception {
        if (HRStringUtils.isEmpty((String)formulaCode)) {
            return null;
        }
        ClassPool pool = FormulaAnalysis.getInitPool(fcDetailList);
        pool.insertClassPath((ClassPath)new ClassClassPath(FormulaParse.class));
        MyClassLoader classLoader = new MyClassLoader(FormulaAnalysis.class.getClassLoader());
        String classNameImp = CLASS_NAME + formulaCode + "Impl";
        CtClass ctClass = pool.makeClass(classNameImp, pool.get(CLASS_NAME));
        FormulaAnalysis.generateFuncMethods(fcDetailList, ctClass);
        StringBuffer executeFunBody = new StringBuffer();
        FormulaAnalysis.generateFormulaMethods(formulaInfoList, ctClass, executeFunBody);
        String executeFunCode = String.format("\tpublic void calculate(){\n%s\n}", executeFunBody.toString());
        CtMethod newMethod = CtNewMethod.make((String)executeFunCode, (CtClass)ctClass);
        ctClass.addMethod(newMethod);
        Class clazz = null;
        try {
            clazz = ctClass.toClass((ClassLoader)classLoader, classLoader.getClass().getProtectionDomain());
            FormulaParse formulaParse = (FormulaParse)clazz.newInstance();
            return formulaParse;
        }
        catch (VerifyError ex) {
            log.error("\u8ba1\u7b97\u7c7b{}\u751f\u6210\u5931\u8d25", (Object)formulaCode, (Object)ex);
            throw new Exception(MessageFormat.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u7c7b\u201c{0}\u201d\u751f\u6210\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{1}\u3002", (String)"FormulaAnalysis_1", (String)"hrmp-hbp-business", (Object[])new Object[0]), formulaCode, ex.getMessage()), ex);
        }
        finally {
            ctClass.detach();
            ctClass.defrost();
        }
    }

    private static void generateFormulaMethods(List<FormulaVO> formulas, CtClass ctClass, StringBuffer executeFunBody) throws Exception {
        StringBuilder formulaFunCode = new StringBuilder();
        int len = formulas.size();
        for (int i = 0; i < len; ++i) {
            FormulaVO formulaInfo = formulas.get(i);
            if (StringUtils.isEmpty((String)formulaInfo.getExecuteCode())) continue;
            try {
                log.info("create formula method,formula name:{}", (Object)formulaInfo.getName());
                formulaFunCode.append(String.format("\tpublic void formula_%s_%s(){\n%s\n}\n", i, String.valueOf(formulaInfo.getId()), formulaInfo.getExecuteCode()));
                executeFunBody.append(String.format("\n\tformula_%s_%s();", i, String.valueOf(formulaInfo.getId())));
                CtMethod newMehtod = CtNewMethod.make((String)formulaFunCode.toString(), (CtClass)ctClass);
                ctClass.addMethod(newMehtod);
                continue;
            }
            catch (Exception ex) {
                log.error("create formula method{}fail", (Object)formulaInfo.getName(), (Object)ex);
                throw new Exception(MessageFormat.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\u201c{0}\u201d\u751f\u6210\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{1}\u3002", (String)"FormulaAnalysis_2", (String)"hrmp-hbp-business", (Object[])new Object[0]), formulaInfo.getName(), ex.getMessage()), ex);
            }
            finally {
                formulaFunCode.setLength(0);
            }
        }
    }

    private static void generateFuncMethods(List<FunctionVO> fcDetailList, CtClass ctClass) throws Exception {
        if (CollectionUtils.isEmpty(fcDetailList)) {
            return;
        }
        HashSet fcNameSet = Sets.newHashSetWithExpectedSize((int)fcDetailList.size());
        for (FunctionVO functionVo : fcDetailList) {
            try {
                if (fcNameSet.contains(functionVo.getName())) continue;
                CtMethod newMethod = CtNewMethod.make((String)functionVo.getExecuteCode(), (CtClass)ctClass);
                ctClass.addMethod(newMethod);
                fcNameSet.add(functionVo.getName());
            }
            catch (Exception ex) {
                log.error("generateFuncMethods{}fail", (Object)functionVo.getName(), (Object)ex);
                throw new Exception(MessageFormat.format(ResManager.loadKDString((String)"\u51fd\u6570\u201c{0}\u201d\u751f\u6210\u5931\u8d25\u3002\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{1}\u3002", (String)"FormulaAnalysis_3", (String)"hrmp-hbp-business", (Object[])new Object[0]), functionVo.getName(), ex.getMessage()), ex);
            }
        }
    }

    private static ClassPool getInitPool(List<FunctionVO> functionVOList) {
        ClassPool pool = new ClassPool(true);
        HashSet importPackages = Sets.newHashSet(FORMULA_IMPORT_PACKAGE);
        if (Objects.nonNull(functionVOList)) {
            functionVOList.forEach(functionVO -> {
                if (Objects.nonNull(functionVO.getImportPackages())) {
                    importPackages.addAll(functionVO.getImportPackages());
                }
            });
        }
        for (String packageName : importPackages) {
            pool.importPackage(packageName.trim());
        }
        return pool;
    }

    public static synchronized String generateClassNameHash(List<FormulaVO> formulaInfoList, List<FunctionVO> fcDetailList) throws Exception {
        int hashCodeValue = 1;
        hashCodeValue = 31 * hashCodeValue;
        if (CollectionUtils.isNotEmpty(formulaInfoList)) {
            for (FormulaVO formulaVO : formulaInfoList) {
                if (StringUtils.isEmpty((String)formulaVO.getExecuteCode())) continue;
                hashCodeValue = 31 * hashCodeValue + formulaVO.getExecuteCode().hashCode();
            }
        }
        if (CollectionUtils.isNotEmpty(fcDetailList)) {
            for (FunctionVO functionVO : fcDetailList) {
                if (StringUtils.isEmpty((String)functionVO.getExecuteCode())) continue;
                hashCodeValue = 31 * hashCodeValue + functionVO.getExecuteCode().hashCode();
            }
        }
        if (hashCodeValue == 31) {
            log.error("generateClassName_empty");
            return null;
        }
        return String.valueOf(hashCodeValue);
    }

    public static synchronized String generateClassName(List<FormulaVO> formulaInfoList, List<FunctionVO> fcDetailList) throws Exception {
        StringBuilder formulaInfo = new StringBuilder();
        if (CollectionUtils.isNotEmpty(formulaInfoList)) {
            for (FormulaVO formulaVO : formulaInfoList) {
                if (StringUtils.isEmpty((String)formulaVO.getExecuteCode())) continue;
                formulaInfo.append(formulaVO.getExecuteCode());
            }
        }
        if (CollectionUtils.isNotEmpty(fcDetailList)) {
            for (FunctionVO functionVO : fcDetailList) {
                if (StringUtils.isEmpty((String)functionVO.getExecuteCode())) continue;
                formulaInfo.append(functionVO.getExecuteCode());
            }
        }
        if (StringUtils.isEmpty((String)formulaInfo.toString())) {
            log.error("generateClassName_empty");
            return null;
        }
        String classNameKey = FormulaAnalysis.shaStr(formulaInfo.toString());
        formulaInfo.setLength(0);
        return classNameKey;
    }

    public static String shaStr(String sourceStr) throws Exception {
        byte[] bytes;
        StringBuilder result = new StringBuilder();
        MessageDigest sha1 = MessageDigest.getInstance("SHA-256");
        sha1.update(sourceStr.getBytes(StandardCharsets.UTF_8));
        for (byte byte0 : bytes = sha1.digest()) {
            result.append(hex[byte0 >>> 4 & 0xF]);
            result.append(hex[byte0 & 0xF]);
        }
        return result.toString();
    }

    public static Set<String> getFormulaImportPackage() {
        return FORMULA_IMPORT_PACKAGE;
    }

    static {
        FORMULA_IMPORT_PACKAGE.add(FormulaParse.class.getPackage().getName());
        FORMULA_IMPORT_PACKAGE.add(FunctionErrorCodeEnum.class.getPackage().getName());
        FORMULA_IMPORT_PACKAGE.add("java.math");
        FORMULA_IMPORT_PACKAGE.add("java.time");
        FORMULA_IMPORT_PACKAGE.add("java.text.SimpleDateFormat");
        FORMULA_IMPORT_PACKAGE.add("java.util");
        FORMULA_IMPORT_PACKAGE.add("java.lang");
        FORMULA_IMPORT_PACKAGE.add("java.lang.Double");
        FORMULA_IMPORT_PACKAGE.add("java.util.Date");
        FORMULA_IMPORT_PACKAGE.add("java.util.List");
        FORMULA_IMPORT_PACKAGE.add("java.util.Calendar");
        FORMULA_IMPORT_PACKAGE.add("kd.hr.hbp.business.service.formula.cal");
        FORMULA_IMPORT_PACKAGE.add("kd.hr.hbp.business.service.formula.cal.formula.enums.FunctionErrorCodeEnum");
        FORMULA_IMPORT_PACKAGE.add("kd.bos.dataentity.entity.DynamicObject");
        FORMULA_IMPORT_PACKAGE.add("kd.hr.hbp.common.util.HRDateTimeUtils");
        FORMULA_IMPORT_PACKAGE.add("kd.bos.exception.ErrorCode");
        FORMULA_IMPORT_PACKAGE.add("com.alibaba.fastjson.JSONObject");
        FORMULA_IMPORT_PACKAGE.add("kd.bos.dataentity.serialization.SerializationUtils");
        FORMULA_IMPORT_PACKAGE.add("kd.bos.exception.KDBizException");
        FORMULA_IMPORT_PACKAGE.add("kd.hr.hbp.business.service.formula.cal.template.FormulaLog");
        FORMULA_IMPORT_PACKAGE.add(HRBaseFunction.class.getPackage().getName());
        FORMULA_IMPORT_PACKAGE.add("org.joda.time.DateTime");
    }
}

