/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.cal.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.formula.cal.template.FormulaParse;
import kd.hr.hbp.business.service.formula.cal.utils.CalUtils;
import kd.hr.hbp.business.service.formula.cal.vo.AddSumVO;
import kd.hr.hbp.business.service.formula.cal.vo.CalAllParamVO;
import kd.hr.hbp.business.service.formula.cal.vo.CalItemVO;
import kd.hr.hbp.business.service.formula.cal.vo.CalRecordVO;
import kd.hr.hbp.business.service.formula.cal.vo.CalResultDetailVO;
import kd.hr.hbp.business.service.formula.cal.vo.CalResultVO;
import kd.hr.hbp.business.service.formula.cal.vo.DataGradeVO;
import kd.hr.hbp.business.service.formula.cal.vo.ProportionRuleVO;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.business.service.formula.utils.FormulaUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class HRMPCalcServiceHelper {
    private static final Log logger = LogFactory.getLog(HRMPCalcServiceHelper.class);
    private final String traceId;
    private boolean openLog;
    private final Map<String, Map<String, List<String>>> paramIdToConvertSectionMap;
    private final Map<String, Map<String, Map<String, ProportionRuleVO>>> itemSectionProportionRuleMap;
    private final Map<String, List<String>> calParamIdRelationMap;
    private final Map<String, Map<String, Object>> paramIdToParamMap;
    private final Map<String, Map<String, Map<String, Object>>> paramIdToSectionParamMap;
    private final Map<String, Map<String, List<String>>> itemSectionMap;
    private final Map<String, Map<String, Map<String, Object>>> sectionPriorResultMap;
    private final Map<String, Object> customCalItemMap;
    private final Map<String, CalItemVO> uniqueCodeCalItemMap;
    private final Map<String, Map<String, AddSumVO>> paramIdAddSumMap;
    private final Map<String, DataGradeVO> dataGradeVOMap;
    private final Map<String, CalResultDetailVO> resultMap = Maps.newHashMapWithExpectedSize((int)16);
    private int loopLimit = 100;

    public HRMPCalcServiceHelper(CalAllParamVO paramVO) {
        this.traceId = paramVO.getTraceId();
        this.openLog = paramVO.isOpenLog();
        this.paramIdToConvertSectionMap = paramVO.getParamIdToConvertSectionMap();
        this.itemSectionProportionRuleMap = paramVO.getItemSectionProportionRuleMap();
        this.calParamIdRelationMap = paramVO.getCalParamIdRelationMap();
        this.paramIdToParamMap = paramVO.getParamIdToParamMap();
        this.paramIdToSectionParamMap = paramVO.getParamIdToSectionParamMap();
        this.itemSectionMap = paramVO.getItemSectionMap();
        this.sectionPriorResultMap = paramVO.getSectionPriorResultMap();
        this.customCalItemMap = paramVO.getCustomCalItemMap();
        this.uniqueCodeCalItemMap = paramVO.getUniqueCodeCalItemMap();
        this.paramIdAddSumMap = paramVO.getParamIdAddSumMap();
        this.dataGradeVOMap = paramVO.getDataGradeVOMap();
        this.loopLimit = paramVO.getLoopLimit();
    }

    private void addSumResultIntoMap(String paramId, CalResultDetailVO sumResultMap) {
        this.resultMap.put(paramId, sumResultMap);
    }

    public Map<String, CalResultDetailVO> getResultMap() {
        return this.resultMap;
    }

    public void itemCal(FormulaParse formulaCalTemplate, FormulaParse calProportionTemplate, List<String> paramIdList) {
        if (Objects.isNull(formulaCalTemplate) || Objects.isNull(paramIdList) || paramIdList.isEmpty()) {
            return;
        }
        FormulaParse calProportionObj = this.getActualCalClass(calProportionTemplate);
        FormulaParse formulaCalObj = this.getActualCalClass(formulaCalTemplate);
        if (null != calProportionObj) {
            calProportionObj.setOpenLog(this.openLog);
        }
        if (null != formulaCalObj) {
            formulaCalObj.setOpenLog(this.openLog);
        }
        for (String paramId : paramIdList) {
            this.itemCal(formulaCalObj, calProportionObj, paramId);
        }
    }

    private void itemCal(FormulaParse formulaCalImpl, FormulaParse calProportionImpl, String paramId) {
        String tempParamId;
        CalResultDetailVO result = new CalResultDetailVO(paramId);
        CalRecordVO calRecord = new CalRecordVO();
        result.setCalRecord(calRecord);
        calRecord.setParamId(String.valueOf(paramId));
        if (!this.checkParamValidate(calRecord, formulaCalImpl, calProportionImpl)) {
            return;
        }
        boolean isPeriodProportion = true;
        ArrayList tempParamIdList = this.calParamIdRelationMap.get(paramId);
        if (CollectionUtils.isEmpty(tempParamIdList)) {
            tempParamIdList = Lists.newArrayList();
            tempParamIdList.add(paramId);
            isPeriodProportion = false;
        }
        Iterator iterator = tempParamIdList.iterator();
        while (iterator.hasNext() && this.calItemProportion(calProportionImpl, isPeriodProportion, tempParamId = (String)iterator.next(), calRecord)) {
            this.setFormulaCalImplProp(formulaCalImpl, calProportionImpl, isPeriodProportion, tempParamId);
            if (this.calculate(formulaCalImpl, tempParamId, isPeriodProportion, result, calRecord)) continue;
            break;
        }
        this.addSumResultIntoMap(paramId, result);
    }

    private void setFormulaCalImplProp(FormulaParse formulaCalImpl, FormulaParse calProportionImpl, boolean isPeriodProportion, String paramId) {
        formulaCalImpl.setParams(this.paramIdToParamMap.get(paramId));
        formulaCalImpl.setSectionPriorResultMap(this.sectionPriorResultMap.get(paramId));
        formulaCalImpl.setProportionMap(Objects.nonNull(calProportionImpl) ? calProportionImpl.getProportionMap() : new HashMap(16));
        formulaCalImpl.setSectionParamMap(this.paramIdToSectionParamMap.get(paramId));
        formulaCalImpl.setItemSectionMap(this.itemSectionMap.get(paramId));
        formulaCalImpl.setUniqueCodeCalItemMap(this.uniqueCodeCalItemMap);
        formulaCalImpl.setCustomCalItemMap(this.customCalItemMap);
        formulaCalImpl.setItemSectionResultMap(new HashMap<String, LinkedHashMap<String, Object>>(16));
        formulaCalImpl.setResultMap(new HashMap<String, Object>(16));
        formulaCalImpl.setAddSumMap(this.paramIdAddSumMap.get(paramId));
        formulaCalImpl.setDataGradeMap(this.dataGradeVOMap);
        formulaCalImpl.setSection(isPeriodProportion || !CollectionUtils.isEmpty(this.itemSectionMap.get(paramId)));
        formulaCalImpl.setCalProportion(false);
        formulaCalImpl.setLoopLimit(this.loopLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean calItemProportion(FormulaParse calProportionImpl, boolean isPeriodProportion, String paramId, CalRecordVO calRecord) {
        HashMap<String, Map<String, BigDecimal>> proportionMap = new HashMap<String, Map<String, BigDecimal>>(16);
        boolean isSuccess = true;
        String errorMsg = null;
        String errorTraceInfo = null;
        if (null == calProportionImpl || !isPeriodProportion && Objects.isNull(this.paramIdToConvertSectionMap.get(paramId))) {
            if (Objects.nonNull(calProportionImpl)) {
                calProportionImpl.setProportionMap(new HashMap<String, Map<String, BigDecimal>>());
            }
            return true;
        }
        calProportionImpl.setItemSectionMap(this.paramIdToConvertSectionMap.get(paramId));
        calProportionImpl.setParams(this.paramIdToParamMap.get(paramId));
        calProportionImpl.setSectionParamMap(this.paramIdToSectionParamMap.get(paramId));
        calProportionImpl.setSection(true);
        calProportionImpl.setCalProportion(true);
        calProportionImpl.setResultMap(new HashMap<String, Object>(16));
        calProportionImpl.setSectionPriorResultMap(new HashMap<String, Map<String, Object>>(16));
        calProportionImpl.setItemSectionResultMap(new HashMap<String, LinkedHashMap<String, Object>>(16));
        calProportionImpl.setCustomCalItemMap(this.customCalItemMap);
        calProportionImpl.setUniqueCodeCalItemMap(this.uniqueCodeCalItemMap);
        calProportionImpl.setLoopLimit(this.loopLimit);
        try {
            calProportionImpl.calculate();
            Map<String, LinkedHashMap<String, Object>> itemSectionResultMap = calProportionImpl.getItemSectionResultMap();
            Map<String, Map<String, ProportionRuleVO>> sectionProportionRuleMap = this.itemSectionProportionRuleMap.get(paramId);
            this.setCalProportionMap(proportionMap, itemSectionResultMap, sectionProportionRuleMap);
            calProportionImpl.setProportionMap(proportionMap);
            calRecord.setSuccess(isSuccess);
            calRecord.setErrorMsg(errorMsg);
            calRecord.setErrorTraceInfo(errorTraceInfo);
            calRecord.setResultLog(calProportionImpl.getResultLog());
        }
        catch (KDBizException kdBizException) {
            logger.error("cal_error_traceId={},paramId={}", new Object[]{this.traceId, paramId, kdBizException});
            errorMsg = kdBizException.getMessage();
            errorTraceInfo = ExceptionUtils.getStackTrace((Throwable)kdBizException);
            isSuccess = false;
            calRecord.setSuccess(isSuccess);
            calRecord.setErrorMsg(errorMsg);
            calRecord.setErrorTraceInfo(errorTraceInfo);
            calRecord.setResultLog(calProportionImpl.getResultLog());
        }
        catch (Exception e) {
            logger.error("cal_error_traceId={},paramId={}", new Object[]{this.traceId, paramId, e});
            errorMsg = e.getMessage();
            errorTraceInfo = ExceptionUtils.getStackTrace((Throwable)e);
            if (errorMsg == null) {
                errorMsg = ResManager.loadKDString((String)"\u8ba1\u7b97\u9879\u76ee\u5206\u6bb5\u5360\u6bd4\u5931\u8d25\uff0c\u672a\u77e5\u5f02\u5e38\u3002", (String)"HRMPCalcServiceHelper_01", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            }
            isSuccess = false;
            calRecord.setSuccess(isSuccess);
            calRecord.setErrorMsg(errorMsg);
            calRecord.setErrorTraceInfo(errorTraceInfo);
            calRecord.setResultLog(calProportionImpl.getResultLog());
            {
                catch (Throwable throwable) {
                    calRecord.setSuccess(isSuccess);
                    calRecord.setErrorMsg(errorMsg);
                    calRecord.setErrorTraceInfo(errorTraceInfo);
                    calRecord.setResultLog(calProportionImpl.getResultLog());
                    throw throwable;
                }
            }
        }
        return isSuccess;
    }

    private void setCalProportionMap(Map<String, Map<String, BigDecimal>> proportionMap, Map<String, LinkedHashMap<String, Object>> itemSectionResultMap, Map<String, Map<String, ProportionRuleVO>> sectionProportionRuleMap) {
        for (Map.Entry<String, Map<String, ProportionRuleVO>> entry : sectionProportionRuleMap.entrySet()) {
            for (Map.Entry<String, ProportionRuleVO> temp : entry.getValue().entrySet()) {
                ProportionRuleVO tempProportionRule = temp.getValue();
                LinkedHashMap<String, Object> tempMap = itemSectionResultMap.get(tempProportionRule.getNumeratorId().toString());
                if (null == tempMap) continue;
                BigDecimal numerator = (BigDecimal)tempMap.get(temp.getKey());
                if (Objects.isNull(numerator)) {
                    throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8ba1\u7b97\u5206\u6bb5\u5360\u6bd4\u5931\u8d25\u3002\u5206\u5b50\u4e3a\u7a7a\u3002\u8ba1\u7b97\u9879\u76ee\u552f\u4e00\u7f16\u7801\u4e3a\u201c%1$s\u201d\uff0c\u65e5\u671f\u533a\u95f4\u4e3a\u201c%2$s\u201d\u3002", (String)"HRMPCalcServiceHelper_02", (String)"hrmp-hbp-business", (Object[])new Object[0]), entry.getKey(), temp.getKey()));
                }
                tempMap = itemSectionResultMap.get(tempProportionRule.getDenominatorId().toString());
                if (null == tempMap) continue;
                BigDecimal denominator = (BigDecimal)tempMap.get(temp.getKey());
                if (Objects.isNull(denominator) || BigDecimal.ZERO.compareTo(denominator) == 0) {
                    throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8ba1\u7b97\u5206\u6bb5\u5360\u6bd4\u5931\u8d25\u3002\u5206\u6bcd\u4e3a\u7a7a\u6216\u8005\u4e3a\u96f6\u3002\u8ba1\u7b97\u9879\u76ee\u552f\u4e00\u7f16\u7801\u4e3a\u201c%1$s\u201d\uff0c\u65e5\u671f\u533a\u95f4\u4e3a\u201c%2$s\u201d\u3002", (String)"HRMPCalcServiceHelper_03", (String)"hrmp-hbp-business", (Object[])new Object[0]), entry.getKey(), temp.getKey()));
                }
                BigDecimal result = numerator.divide(denominator, (int)tempProportionRule.getScale(), tempProportionRule.getRoundingMode());
                Map dateRangeMap = proportionMap.computeIfAbsent(entry.getKey(), k -> new HashMap());
                dateRangeMap.put(temp.getKey(), result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean calculate(FormulaParse formulaCalImpl, String paramId, boolean isPeriodProportion, CalResultDetailVO result, CalRecordVO calRecord) {
        boolean isSuccess = true;
        String errorMsg = null;
        String errorTraceInfo = null;
        try {
            this.calculateDetail(formulaCalImpl, paramId, isPeriodProportion, result, calRecord);
            calRecord.setErrorMsg(errorMsg);
            calRecord.setErrorTraceInfo(errorTraceInfo);
            calRecord.setSuccess(isSuccess);
            calRecord.setResultLog(formulaCalImpl.getResultLog());
        }
        catch (KDBizException kdBizException) {
            errorTraceInfo = ExceptionUtils.getStackTrace((Throwable)kdBizException);
            logger.error("cal_error_traceDetail{}", (Object)errorTraceInfo);
            logger.error("cal_error_traceId={},paramId={}", new Object[]{this.traceId, paramId, kdBizException});
            isSuccess = false;
            errorMsg = kdBizException.getErrorCode().getMessage();
            String causeMessage = kdBizException.getCause().getMessage();
            if (kdBizException.getCause() instanceof NullPointerException) {
                errorMsg = MessageFormat.format(ResManager.loadKDString((String)"{0} \u7a7a\u6307\u9488\u5f02\u5e38\u3002", (String)"HRMPCalcServiceHelper_10", (String)"hrmp-hbp-business", (Object[])new Object[0]), errorMsg);
            } else if (HRStringUtils.isNotEmpty((String)causeMessage)) {
                errorMsg = errorMsg + " " + causeMessage;
            }
            calRecord.setException(kdBizException);
            calRecord.setErrorMsg(errorMsg);
            calRecord.setErrorTraceInfo(errorTraceInfo);
            calRecord.setSuccess(isSuccess);
            calRecord.setResultLog(formulaCalImpl.getResultLog());
        }
        catch (Exception exception) {
            errorTraceInfo = ExceptionUtils.getStackTrace((Throwable)exception);
            logger.error("cal_error_traceId={},paramId={}", new Object[]{this.traceId, paramId, exception});
            logger.error("cal_error_traceDetail{}", (Object)errorTraceInfo);
            errorMsg = exception.getMessage();
            if (exception instanceof NullPointerException) {
                errorMsg = MessageFormat.format(ResManager.loadKDString((String)"{0} \u7a7a\u6307\u9488\u5f02\u5e38\u3002", (String)"HRMPCalcServiceHelper_10", (String)"hrmp-hbp-business", (Object[])new Object[0]), errorMsg);
            }
            if (Objects.isNull(errorMsg)) {
                errorMsg = ResManager.loadKDString((String)"\u8ba1\u7b97\u5931\u8d25\uff0c\u672a\u77e5\u5f02\u5e38\u3002", (String)"HRMPCalcServiceHelper_04", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            }
            calRecord.setException(exception);
            isSuccess = false;
            calRecord.setErrorMsg(errorMsg);
            calRecord.setErrorTraceInfo(errorTraceInfo);
            calRecord.setSuccess(isSuccess);
            calRecord.setResultLog(formulaCalImpl.getResultLog());
            {
                catch (Throwable throwable) {
                    calRecord.setErrorMsg(errorMsg);
                    calRecord.setErrorTraceInfo(errorTraceInfo);
                    calRecord.setSuccess(isSuccess);
                    calRecord.setResultLog(formulaCalImpl.getResultLog());
                    throw throwable;
                }
            }
        }
        return isSuccess;
    }

    private void calculateDetail(FormulaParse formulaCalImpl, String paramId, boolean isPeriodProportion, CalResultDetailVO result, CalRecordVO calRecord) {
        Map<String, CalResultVO> sumResultMap = result.getSumResultMap();
        formulaCalImpl.calculate();
        formulaCalImpl.calAddSumValueAfterAllCal();
        Map<String, Object> calResultMap = formulaCalImpl.getResultMap();
        Map<String, LinkedHashMap<String, Object>> itemSectionResultMap = formulaCalImpl.getItemSectionResultMap();
        for (Map.Entry<String, Object> entry : calResultMap.entrySet()) {
            LinkedHashMap<String, Object> itemResultMap;
            String itemUniqueCode = entry.getKey();
            CalResultVO calResult = new CalResultVO();
            CalResultVO sumResult = sumResultMap.get(itemUniqueCode);
            if (!isPeriodProportion) {
                sumResult = calResult;
            }
            CalItemVO tempCalItem = this.uniqueCodeCalItemMap.get(itemUniqueCode);
            this.setCalResult(formulaCalImpl, paramId, entry, calResult, tempCalItem);
            if (isPeriodProportion) {
                this.mergeCalResultValue(sumResultMap, calResult, calRecord.getParamId(), tempCalItem);
            }
            if (!CollectionUtils.isEmpty(itemResultMap = itemSectionResultMap.get(itemUniqueCode))) {
                for (Map.Entry<String, Object> itemEntry : itemResultMap.entrySet()) {
                    try {
                        calResult.addItemSubResult(this.getItemSubCalResult(formulaCalImpl, paramId, itemUniqueCode, tempCalItem, itemEntry));
                    }
                    catch (KDBizException kdBizException) {
                        throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u5206\u6bb5\u9879\u76ee\u7ed3\u679c\u83b7\u53d6\u5931\u8d25\uff1a{0}\u3002", (String)"HRMPCalcServiceHelper_05", (String)"hrmp-hbp-business", (Object[])new Object[0]), kdBizException.getMessage()));
                    }
                }
            }
            if (isPeriodProportion) continue;
            sumResultMap.put(itemUniqueCode, sumResult);
        }
        result.getAddSumMap().putAll(formulaCalImpl.getAddSumMap());
        Map<String, Object> outCustomItemResultMap = result.getOutCustomItemResultMap();
        Map<String, Object> outputCustomCalItemValueMap = formulaCalImpl.getOutputCustomCalItemValueMap();
        outCustomItemResultMap.putAll(outputCustomCalItemValueMap);
    }

    private void setCalResult(FormulaParse formulaCalImpl, String paramId, Map.Entry<String, Object> entry, CalResultVO calResult, CalItemVO tempCalItem) {
        String itemUniqueCode = entry.getKey();
        calResult.setItemProrateDetailId(paramId);
        calResult.setParamId(paramId);
        calResult.setUniqueCode(itemUniqueCode);
        if (Objects.isNull(tempCalItem)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u552f\u4e00\u7f16\u7801\u83b7\u53d6\u7684\u8ba1\u7b97\u9879\u76ee\u8be6\u60c5\u4e3a\u7a7a\u3002", (String)"HRMPCalcServiceHelper_06", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        calResult.setItemId(tempCalItem.getId());
        calResult.setDataType(tempCalItem.getDataType());
        this.dealDataAccuracy(tempCalItem, entry.getValue(), calResult);
        this.setProportionValue(this.getPeriodDateRange(formulaCalImpl.getItemSectionMap(), itemUniqueCode), calResult, formulaCalImpl.getProportionMap().get(itemUniqueCode));
    }

    private CalResultVO getItemSubCalResult(FormulaParse formulaCalImpl, String paramId, String itemUniqueCode, CalItemVO tempCalItem, Map.Entry<String, Object> itemEntry) {
        CalResultVO itemSubResult = new CalResultVO();
        itemSubResult.setParamId(paramId);
        itemSubResult.setItemProrateDetailId(itemEntry.getKey());
        itemSubResult.setUniqueCode(itemUniqueCode);
        itemSubResult.setItemId(tempCalItem.getId());
        itemSubResult.setDataType(tempCalItem.getDataType());
        this.dealDataAccuracy(tempCalItem, itemEntry.getValue(), itemSubResult);
        this.setProportionValue(itemEntry.getKey(), itemSubResult, formulaCalImpl.getProportionMap().get(itemUniqueCode));
        return itemSubResult;
    }

    private void dealDataAccuracy(CalItemVO calItem, Object value, CalResultVO calResult) throws KDBizException {
        if (value == null) {
            return;
        }
        this.checkResultValueLength(calItem, value);
        if (DataTypeEnum.NUM == calItem.getDataType() || DataTypeEnum.MONEY == calItem.getDataType()) {
            BigDecimal calAmountValue = new BigDecimal(String.valueOf(value));
            calResult.setCalResultValue(calAmountValue);
        } else if (DataTypeEnum.INT == calItem.getDataType()) {
            if (FormulaUtils.isGtMaxInteger(String.valueOf(value))) {
                String msg = ResManager.loadKDString((String)"\u9879\u76ee\u201c%s\u201d\u7684\u8ba1\u7b97\u7ed3\u679c\u6570\u636e\u8fc7\u5927\uff0c\u8d85\u51fa\u4e86\u6574\u6570\u7684\u6700\u5927\u503c(2147483647)\u3002", (String)"HRMPCalcServiceHelper_07", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                throw new KDBizException(String.format(msg, calItem.getName()));
            }
            if (FormulaUtils.isLtMinInteger(String.valueOf(value))) {
                String msg = ResManager.loadKDString((String)"\u9879\u76ee\u201c%s\u201d\u7684\u8ba1\u7b97\u7ed3\u679c\u6570\u636e\u8fc7\u5c0f\uff0c\u5c0f\u4e8e\u6574\u6570\u7684\u6700\u5c0f\u503c(-2147483648)\u3002", (String)"HRMPCalcServiceHelper_08", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                throw new KDBizException(String.format(msg, calItem.getName()));
            }
            calResult.setCalResultValue(value);
        } else {
            calResult.setCalResultValue(value);
        }
    }

    private void setProportionValue(String dateRange, CalResultVO calResult, Map<String, BigDecimal> itemProportionMap) {
        if (null == itemProportionMap || itemProportionMap.size() == 0) {
            calResult.setProportion(BigDecimal.ZERO);
        } else {
            BigDecimal tempProportionValue = itemProportionMap.get(dateRange);
            if (null == tempProportionValue) {
                calResult.setProportion(BigDecimal.ZERO);
            } else {
                calResult.setProportion(tempProportionValue);
            }
        }
    }

    private String getPeriodDateRange(Map<String, List<String>> itemSectionMap, String uniqueCode) {
        if (null == itemSectionMap || itemSectionMap.size() == 0) {
            return null;
        }
        List<String> dateRangeList = itemSectionMap.get(uniqueCode);
        if (null == dateRangeList || dateRangeList.size() == 0) {
            return null;
        }
        return dateRangeList.get(0);
    }

    private void mergeCalResultValue(Map<String, CalResultVO> sumResultMap, CalResultVO timeSubResult, String mainParamId, CalItemVO tempCalItem) {
        CalResultVO sumResult = sumResultMap.get(timeSubResult.getUniqueCode());
        if (null == sumResult) {
            sumResult = CalUtils.cloneCalResultProp(timeSubResult);
            sumResult.setParamId(mainParamId);
            sumResultMap.put(timeSubResult.getUniqueCode(), sumResult);
        }
        if (DataTypeEnum.NUM == tempCalItem.getDataType() || DataTypeEnum.MONEY == tempCalItem.getDataType()) {
            switch (tempCalItem.getSummaryType()) {
                case FIRST: {
                    this.setFirstOrLastItemValue(mainParamId, timeSubResult, sumResult, true);
                    break;
                }
                case LAST: {
                    this.setFirstOrLastItemValue(mainParamId, timeSubResult, sumResult, false);
                    break;
                }
                default: {
                    this.sumItemValue(timeSubResult, sumResult);
                    break;
                }
            }
        } else {
            sumResult.setCalResultValue(timeSubResult.getCalResultValue());
        }
        sumResult.addTimeSubResult(timeSubResult);
    }

    private void sumItemValue(CalResultVO calResult, CalResultVO resultVO) {
        BigDecimal existCalValue = (BigDecimal)resultVO.getCalResultValue();
        BigDecimal newCalValue = (BigDecimal)calResult.getCalResultValue();
        if (existCalValue == null) {
            existCalValue = BigDecimal.ZERO;
        }
        if (newCalValue == null) {
            newCalValue = BigDecimal.ZERO;
        }
        resultVO.setCalResultValue(existCalValue.add(newCalValue));
    }

    private void setFirstOrLastItemValue(String mainParamId, CalResultVO calResult, CalResultVO resultVO, boolean isFirstFag) {
        List<String> paramSubIdList = this.calParamIdRelationMap.get(mainParamId);
        int index = isFirstFag ? 0 : paramSubIdList.size() - 1;
        String calSubParamId = paramSubIdList.get(index);
        if (!calResult.getParamId().equals(calSubParamId)) {
            return;
        }
        resultVO.setCalResultValue(calResult.getCalResultValue());
    }

    private boolean checkParamValidate(CalRecordVO recordVO, FormulaParse calFormulaImpl, FormulaParse calProportionImpl) {
        boolean isValidate = true;
        StringBuilder msg = new StringBuilder();
        boolean isFirst = true;
        if (Objects.isNull(this.calParamIdRelationMap)) {
            msg.append("calParamIdRelationMap");
            isFirst = false;
            isValidate = false;
        }
        if (Objects.isNull(calFormulaImpl)) {
            if (!isFirst) {
                msg.append(',');
            }
            msg.append("calFormulaImpl");
            isFirst = false;
            isValidate = false;
        }
        if (!isValidate) {
            msg.append("_is_null");
            recordVO.setSuccess(false);
            recordVO.setErrorMsg(msg.toString());
        }
        return isValidate;
    }

    private FormulaParse getActualCalClass(FormulaParse template) {
        if (Objects.isNull(template)) {
            return null;
        }
        return (FormulaParse)template.clone();
    }

    private void checkResultValueLength(CalItemVO calItem, Object value) {
        Integer dataLength = calItem.getDataLength();
        if (Objects.isNull(dataLength)) {
            return;
        }
        String msg = ResManager.loadKDString((String)"\u9879\u76ee\u201c{0}\u201d\u7684\u8ba1\u7b97\u7ed3\u679c\u201c{1}\u201d\u6570\u636e\u957f\u5ea6\u8fc7\u957f\uff0c\u8d85\u51fa\u4e86\u9879\u76ee\u8bbe\u7f6e\u7684\u6570\u636e\u957f\u5ea6\u201c{2}\u201d\u3002", (String)"HRMPCalcServiceHelper_09", (String)"hrmp-hbp-business", (Object[])new Object[0]);
        if (value instanceof String || value instanceof Integer || value instanceof BigDecimal) {
            if (String.valueOf(value).length() > dataLength) {
                throw new KDBizException(MessageFormat.format(msg, calItem.getName(), String.valueOf(value), dataLength));
            }
        } else if (value instanceof String[]) {
            if (((String[])value).length > dataLength) {
                throw new KDBizException(MessageFormat.format(msg, calItem.getName(), ((String[])value).length, dataLength));
            }
        } else if (value instanceof Boolean[]) {
            if (((Boolean[])value).length > dataLength) {
                throw new KDBizException(MessageFormat.format(msg, calItem.getName(), ((Boolean[])value).length, dataLength));
            }
        } else if (value instanceof Date[]) {
            if (((Date[])value).length > dataLength) {
                throw new KDBizException(MessageFormat.format(msg, calItem.getName(), ((Date[])value).length, dataLength));
            }
        } else if (value instanceof Integer[]) {
            if (((Integer[])value).length > dataLength) {
                throw new KDBizException(MessageFormat.format(msg, calItem.getName(), ((Integer[])value).length, dataLength));
            }
        } else if (value instanceof BigDecimal[] && ((BigDecimal[])value).length > dataLength) {
            throw new KDBizException(MessageFormat.format(msg, calItem.getName(), ((BigDecimal[])value).length, dataLength));
        }
    }
}

