/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.cal.service;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.formula.cal.FormulaAnalysis;
import kd.hr.hbp.business.service.formula.cal.helper.HRMPCalcServiceHelper;
import kd.hr.hbp.business.service.formula.cal.service.IHRMPCalcService;
import kd.hr.hbp.business.service.formula.cal.template.FormulaParse;
import kd.hr.hbp.business.service.formula.cal.vo.CalAllParamVO;
import kd.hr.hbp.business.service.formula.cal.vo.CalResultDetailVO;
import kd.hr.hbp.business.service.formula.cal.vo.FormulaVO;
import kd.hr.hbp.business.service.formula.cal.vo.FunctionVO;
import kd.hr.hbp.common.util.HRLockObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.collections.CollectionUtils;

@SdkPublic
public abstract class AbsHRMPCalcService
implements IHRMPCalcService {
    private static final Log LOG = LogFactory.getLog(AbsHRMPCalcService.class);
    private static volatile Map<String, FormulaParse> formulaParseTemplateCache = new ConcurrentHashMap<String, FormulaParse>();

    public Map<String, CalResultDetailVO> calc(CalAllParamVO paramVO, List<String> paramIdList) throws Exception {
        return this.calc(null, null, paramVO, paramIdList);
    }

    @Override
    public Map<String, CalResultDetailVO> calc(FormulaParse formulaParse, FormulaParse calProportionClass, CalAllParamVO paramVO, List<String> paramIdList) throws Exception {
        try {
            if (null == formulaParse) {
                formulaParse = this.createBizClassImpl(null, paramVO);
            }
            if (null == formulaParse) {
                Map<String, CalResultDetailVO> map = null;
                return map;
            }
            if (null == calProportionClass) {
                calProportionClass = this.createBizProportionClassImpl(null, paramVO);
            }
            this.handleCalProportion(paramVO);
            this.getCalItemData(paramVO);
            Map<String, CalResultDetailVO> map = this.handleCal(formulaParse, calProportionClass, paramVO, paramIdList);
            return map;
        }
        catch (Exception ex) {
            LOG.error("deal_calc_error_traceId={}", (Object)paramVO.getTraceId(), (Object)ex);
            throw ex;
        }
        finally {
            if (null != formulaParse) {
                this.clear(formulaParse.getClassNameKey());
            }
            if (null != calProportionClass) {
                this.clear(calProportionClass.getClassNameKey());
            }
        }
    }

    @Override
    public FormulaParse createBizClassImpl(String className, CalAllParamVO paramVO) throws Exception {
        return this.createClassImpl(className, paramVO.getFormulaVOList(), paramVO.getFunctionVOList());
    }

    @Override
    public FormulaParse createBizProportionClassImpl(String className, CalAllParamVO paramVO) throws Exception {
        List<FormulaVO> proportionFormulaVOList = paramVO.getProportionFormulaVOList();
        if (Objects.isNull(proportionFormulaVOList) || proportionFormulaVOList.isEmpty()) {
            return null;
        }
        return this.createClassImpl(className, proportionFormulaVOList, paramVO.getFunctionVOList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FormulaParse createClassImpl(String className, List<FormulaVO> formulaInfoList, List<FunctionVO> fcDetailList) throws Exception {
        Object obj;
        if (CollectionUtils.isEmpty(formulaInfoList)) {
            LOG.error("className_or_formulaInfoList_is_empty");
            return null;
        }
        className = AbsHRMPCalcService.buildClassNameHash(formulaInfoList, fcDetailList);
        Object object = obj = HRLockObjectUtils.getLockObject((String)className);
        synchronized (object) {
            if (Objects.nonNull(formulaParseTemplateCache.get(className))) {
                return formulaParseTemplateCache.get(className);
            }
            LOG.info("formula parse begin,start time is:{}", (Object)System.currentTimeMillis());
            FormulaParse formulaParse = FormulaAnalysis.getFormulaExecuteInstance(className, formulaInfoList, fcDetailList);
            formulaParse.setClassNameKey(className);
            formulaParseTemplateCache.put(className, formulaParse);
            LOG.info("formula parse end,end time is:{}", (Object)System.currentTimeMillis());
            return formulaParse;
        }
    }

    private static String buildClassNameHash(List<FormulaVO> formulaInfoList, List<FunctionVO> fcDetailList) throws Exception {
        return FormulaAnalysis.generateClassNameHash(formulaInfoList, fcDetailList);
    }

    @Override
    public abstract void handleCalProportion(CalAllParamVO var1);

    @Override
    public abstract void getCalItemData(CalAllParamVO var1);

    @Override
    public Map<String, CalResultDetailVO> handleCal(FormulaParse formulaParse, FormulaParse calProportionClass, CalAllParamVO paramVO, List<String> paramIdList) {
        LOG.info("handleCal_CalAllParamVO_{}", (Object)paramVO);
        HRMPCalcServiceHelper calServiceHelper = new HRMPCalcServiceHelper(paramVO);
        if (CollectionUtils.isEmpty(paramIdList)) {
            return null;
        }
        calServiceHelper.itemCal(formulaParse, calProportionClass, paramIdList);
        return calServiceHelper.getResultMap();
    }

    @Override
    public void clear(String formulaCode) {
        if (HRStringUtils.isNotEmpty((String)formulaCode)) {
            formulaParseTemplateCache.remove(formulaCode);
        }
    }
}

