/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.cal.vo;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.formula.cal.enums.ConditionHitOperatorEnum;
import kd.hr.hbp.business.service.formula.cal.enums.DataGradeParamTypeEnum;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.datagrade.CValueVO;
import kd.hr.hbp.common.datagrade.ConditionValueVO;
import kd.hr.hbp.common.datagrade.DataGradeTableVO;
import kd.hr.hbp.common.datagrade.DefValue;
import kd.hr.hbp.common.datagrade.DefaultResult;
import kd.hr.hbp.common.datagrade.EntryVO;
import kd.hr.hbp.common.datagrade.ParamValue;
import kd.hr.hbp.common.datagrade.ResultValue;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class DataGradeVO
implements Serializable {
    private static final long serialVersionUID = -2710621723954809807L;
    private static final Log LOGGER = LogFactory.getLog(DataGradeVO.class);
    private static final String SPLIT_SYMBOL = ",";
    private String uniqueCode;
    private boolean isReturnDefaultResult;
    private ArrayList<EntryVO> conditionHeadList;
    private Map<String, EntryVO> resultHeadMap;
    private Map<String, DefaultResult> defaultResultMap;
    private Map<String, DynamicObject> idToDyMap;
    private ArrayList<ArrayList<ConditionValueVO>> conditionList;
    private ArrayList<Map<String, ResultValue>> resultList;

    public static DataGradeVO getDataGradeVO(String uniqueCode, String dataGradeTableVoStr) {
        DataGradeVO dataGradeVO = new DataGradeVO();
        dataGradeVO.uniqueCode = uniqueCode;
        try {
            DataGradeTableVO dataGradeParam = (DataGradeTableVO)HRJSONUtils.cast((String)dataGradeTableVoStr, DataGradeTableVO.class);
            List paramValues = dataGradeParam.getValue();
            List conditionHead = dataGradeParam.getHead().getCondition();
            List resultHeadList = dataGradeParam.getHead().getResult();
            DefValue defValue = dataGradeParam.getDefValue();
            HashMap metaNumberToIdsMap = Maps.newHashMapWithExpectedSize((int)(conditionHead.size() + resultHeadList.size()));
            DataGradeVO.initProperties(dataGradeVO, paramValues.size(), defValue);
            DataGradeVO.setDataGradeConditionAndResultList(dataGradeVO, paramValues, resultHeadList, metaNumberToIdsMap);
            DataGradeVO.setDataGradeDefaultResult(dataGradeVO, defValue.getDefaultValue(), resultHeadList, metaNumberToIdsMap);
            DataGradeVO.setDataGradeConditionHeadList(dataGradeVO, conditionHead);
            DataGradeVO.setDataGradeResultHeadMap(dataGradeVO, resultHeadList);
            DataGradeVO.initBaseDataMap(dataGradeVO, metaNumberToIdsMap);
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5206\u7ea7\u53c2\u6570\u89e3\u6790\u5931\u8d25\u3002", (String)"DataGradeVO_0", (String)"hrmp-hbp-business", (Object[])new Object[0]));
        }
        return dataGradeVO;
    }

    public Map<String, Object> getDataGradeResultMap(Object ... conditions) {
        int rowIndex;
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)this.resultHeadMap.size());
        if (Objects.isNull(conditions)) {
            return resultMap;
        }
        block0: for (rowIndex = 0; rowIndex < this.conditionList.size(); ++rowIndex) {
            ArrayList<ConditionValueVO> conditionValueVOS = this.conditionList.get(rowIndex);
            int columnSize = conditionValueVOS.size();
            if (conditions.length < columnSize) {
                LOGGER.warn("input_conditions_length_less_than_conditionTable_size");
                break;
            }
            for (int columnIndex = 0; columnIndex < columnSize; ++columnIndex) {
                Object condition = conditions[columnIndex];
                ConditionValueVO conditionValueVO = conditionValueVOS.get(columnIndex);
                EntryVO conditionHead = this.conditionHeadList.get(columnIndex);
                if (Objects.isNull(conditionValueVO) || Objects.isNull(conditionHead)) {
                    LOGGER.warn("conditionValueVO_or_conditionHead_is_null");
                    break block0;
                }
                if (!this.checkConditionWhetherHit(condition = this.dealConditionOrResultValue(condition, conditionHead), conditionValueVO, conditionHead)) continue block0;
            }
        }
        for (Map.Entry<String, EntryVO> resultHeadEntry : this.resultHeadMap.entrySet()) {
            Object resultValue;
            if (rowIndex == this.conditionList.size() || rowIndex >= this.resultList.size()) {
                resultValue = this.getDefaultResult(resultHeadEntry.getKey(), resultHeadEntry.getValue());
            } else {
                Map<String, ResultValue> resultValueMap = this.resultList.get(rowIndex);
                resultValue = this.getResultValue(resultValueMap.get(resultHeadEntry.getKey()), resultHeadEntry.getValue());
            }
            resultMap.put(resultHeadEntry.getKey(), resultValue);
        }
        return resultMap;
    }

    public static DataGradeVO getDataGradeVO(DynamicObject dy) {
        return DataGradeVO.getDataGradeVO(dy.getString("uniquecode"), dy.getString("datagradeparam"));
    }

    public Object getDataGradeResult(String resultKey, Object ... conditions) {
        return this.getDataGradeResultMap(conditions).get(resultKey);
    }

    public Map<String, Object> getDataGradeResultMap(Map<String, Object> params) {
        Object[] paramArray = new Object[this.conditionHeadList.size()];
        for (int index = 0; index < this.conditionHeadList.size(); ++index) {
            EntryVO head = this.conditionHeadList.get(index);
            paramArray[index] = params.get(String.valueOf(head.getId()));
        }
        return this.getDataGradeResultMap(paramArray);
    }

    private static void initProperties(DataGradeVO dataGradeVO, int rowNumber, DefValue defValue) {
        dataGradeVO.conditionList = Lists.newArrayListWithExpectedSize((int)rowNumber);
        dataGradeVO.resultList = Lists.newArrayListWithExpectedSize((int)rowNumber);
        dataGradeVO.isReturnDefaultResult = defValue.isShow();
        dataGradeVO.defaultResultMap = Maps.newHashMapWithExpectedSize((int)(Objects.nonNull(defValue.getDefaultValue()) ? defValue.getDefaultValue().size() : 16));
    }

    private Object dealConditionOrResultValue(Object value, EntryVO head) {
        DataGradeParamTypeEnum typeEnum = DataGradeParamTypeEnum.getTypeEnumByCode(head.getPropsName());
        if (Objects.isNull((Object)typeEnum)) {
            return value;
        }
        switch (typeEnum) {
            case MONEY: 
            case NUMBER: {
                BigDecimal num = this.parseBigDecimal(value);
                if (Objects.isNull(num)) {
                    return value;
                }
                return num.setScale((int)head.getPrecision(), RoundingMode.HALF_UP);
            }
            case BASE: {
                if (value instanceof DynamicObject) {
                    return value;
                }
                DynamicObject resultDy = this.idToDyMap.get(String.valueOf(value));
                return Objects.nonNull(resultDy) ? resultDy : value;
            }
        }
        return value;
    }

    private boolean checkConditionWhetherHit(Object condition, ConditionValueVO dataGradeCondition, EntryVO conditionHead) {
        Stream stream = dataGradeCondition.getValue().stream();
        if ("and".equals(dataGradeCondition.getCompare())) {
            return stream.allMatch(conditionVO -> this.checkHit(condition, (CValueVO)conditionVO, conditionHead));
        }
        return stream.anyMatch(conditionVO -> this.checkHit(condition, (CValueVO)conditionVO, conditionHead));
    }

    private static void setDataGradeConditionHeadList(DataGradeVO dataGradeVO, List<EntryVO> conditionHead) {
        dataGradeVO.conditionHeadList = new ArrayList<EntryVO>(conditionHead);
    }

    private static void setDataGradeResultHeadMap(DataGradeVO dataGradeVO, List<EntryVO> resultHeadList) {
        dataGradeVO.resultHeadMap = resultHeadList.stream().collect(Collectors.toMap(EntryVO::getName, result -> result));
    }

    private static void setDataGradeConditionAndResultList(DataGradeVO dataGradeVO, List<ParamValue> paramValues, List<EntryVO> resultHeadList, Map<String, List<Object>> metaNumberToIdsMap) {
        for (ParamValue paramValue : paramValues) {
            ArrayList conditionValueVOS = Lists.newArrayList((Iterable)paramValue.getCondition());
            dataGradeVO.conditionList.add(conditionValueVOS);
            conditionValueVOS.forEach(conditionValueVO -> DataGradeVO.setBaseDataIds(metaNumberToIdsMap, conditionValueVO));
            List resultValues = paramValue.getResult();
            HashMap resultNameMap = Maps.newHashMapWithExpectedSize((int)resultValues.size());
            for (int colIndex = 0; colIndex < resultValues.size(); ++colIndex) {
                EntryVO resultHead = resultHeadList.get(colIndex);
                ResultValue resultValue = (ResultValue)resultValues.get(colIndex);
                resultNameMap.put(resultHead.getName(), resultValue);
                DataGradeVO.setBaseDataIds(metaNumberToIdsMap, resultValue);
            }
            dataGradeVO.resultList.add(resultNameMap);
        }
    }

    private static void setBaseDataIds(Map<String, List<Object>> metaNumberToIdsMap, ConditionValueVO conditionValueVO) {
        if (Objects.nonNull(conditionValueVO) && StringUtils.isNotBlank((CharSequence)conditionValueVO.getBasedatafield())) {
            List vos;
            List<Object> ids = metaNumberToIdsMap.get(conditionValueVO.getBasedatafield());
            if (Objects.isNull(ids)) {
                ids = new ArrayList<Object>(10);
                metaNumberToIdsMap.put(conditionValueVO.getBasedatafield(), ids);
            }
            if (Objects.nonNull(vos = conditionValueVO.getValue())) {
                for (CValueVO value : vos) {
                    String baseDataId = value.getBasedataId();
                    ConditionHitOperatorEnum hitEnum = ConditionHitOperatorEnum.getHitEnum(value.getKey());
                    if (ConditionHitOperatorEnum.IN == hitEnum || ConditionHitOperatorEnum.NOT_IN == hitEnum) {
                        if (!StringUtils.isNotBlank((CharSequence)baseDataId)) continue;
                        ids.addAll(Stream.of(baseDataId.split(SPLIT_SYMBOL)).map(DataGradeVO::convertIdType).collect(Collectors.toList()));
                        continue;
                    }
                    if (ConditionHitOperatorEnum.IS_NULL == hitEnum || !StringUtils.isNotBlank((CharSequence)baseDataId)) continue;
                    ids.add(DataGradeVO.convertIdType(baseDataId));
                }
            }
        }
    }

    private static void setBaseDataIds(Map<String, List<Object>> metaNumberToIdsMap, ResultValue resultValue) {
        if (Objects.nonNull(resultValue) && StringUtils.isNotBlank((CharSequence)resultValue.getBasedatafield())) {
            String id;
            List<Object> ids = metaNumberToIdsMap.get(resultValue.getBasedatafield());
            if (Objects.isNull(ids)) {
                ids = new ArrayList<Object>(10);
                metaNumberToIdsMap.put(resultValue.getBasedatafield(), ids);
            }
            if (StringUtils.isNotBlank((CharSequence)(id = resultValue.getBasedataId()))) {
                ids.add(DataGradeVO.convertIdType(id));
            }
        }
    }

    private static void setDataGradeDefaultResult(DataGradeVO dataGradeVO, List<DefaultResult> defaultResultList, List<EntryVO> resultHeadList, Map<String, List<Object>> metaNumberToIdsMap) {
        Map<Long, EntryVO> idToResultHeadMap = resultHeadList.stream().collect(Collectors.toMap(EntryVO::getId, resultHead -> resultHead, (oldData, newData) -> newData));
        if (Objects.isNull(defaultResultList)) {
            return;
        }
        for (DefaultResult defaultResult : defaultResultList) {
            EntryVO resultHead2 = idToResultHeadMap.get(defaultResult.getId());
            if (!Objects.nonNull(resultHead2)) continue;
            dataGradeVO.defaultResultMap.put(resultHead2.getName(), defaultResult);
            DataGradeVO.setBaseDataIds(metaNumberToIdsMap, defaultResult);
        }
    }

    private static void setBaseDataIds(Map<String, List<Object>> metaNumberToIdsMap, DefaultResult defaultResult) {
        if (Objects.nonNull(defaultResult) && StringUtils.isNotBlank((CharSequence)defaultResult.getBasedatafield())) {
            String id;
            List<Object> ids = metaNumberToIdsMap.get(defaultResult.getBasedatafield());
            if (Objects.isNull(ids)) {
                ids = new ArrayList<Object>(10);
                metaNumberToIdsMap.put(defaultResult.getBasedatafield(), ids);
            }
            if (StringUtils.isNotBlank((CharSequence)(id = defaultResult.getBasedataId()))) {
                ids.add(DataGradeVO.convertIdType(id));
            }
        }
    }

    private static void initBaseDataMap(DataGradeVO dataGradeVO, Map<String, List<Object>> metaNumberToIdsMap) {
        if (Objects.isNull(metaNumberToIdsMap) || metaNumberToIdsMap.isEmpty()) {
            return;
        }
        dataGradeVO.idToDyMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<String, List<Object>> entry : metaNumberToIdsMap.entrySet()) {
            DynamicObject[] dys;
            List<Object> ids = entry.getValue();
            if (Objects.isNull(ids) || ids.isEmpty()) continue;
            HRBaseServiceHelper helper = new HRBaseServiceHelper(entry.getKey());
            for (DynamicObject dy : dys = helper.loadDynamicObjectArray(ids.toArray())) {
                dataGradeVO.idToDyMap.put(String.valueOf(dy.getPkValue()), dy);
            }
        }
    }

    private Object getResultValue(ResultValue resultValue, EntryVO resultHead) {
        if (Objects.nonNull(resultValue) && Objects.nonNull(resultHead)) {
            DataGradeParamTypeEnum typeEnum = DataGradeParamTypeEnum.getTypeEnumByCode(resultHead.getPropsName());
            switch (typeEnum) {
                case BASE: {
                    return this.dealConditionOrResultValue(resultValue.getBasedataId(), resultHead);
                }
            }
            return this.dealConditionOrResultValue(resultValue.getValue(), resultHead);
        }
        return null;
    }

    private Object getDefaultResult(String resultKey, EntryVO resultHead) {
        if (!this.isReturnDefaultResult || Objects.isNull(resultHead)) {
            return null;
        }
        DefaultResult defaultResult = this.defaultResultMap.get(resultKey);
        if (Objects.nonNull(defaultResult)) {
            DataGradeParamTypeEnum typeEnum = DataGradeParamTypeEnum.getTypeEnumByCode(resultHead.getPropsName());
            switch (typeEnum) {
                case BASE: {
                    return this.dealConditionOrResultValue(defaultResult.getBasedataId(), resultHead);
                }
            }
            return this.dealConditionOrResultValue(defaultResult.getValue(), resultHead);
        }
        return null;
    }

    private boolean checkHit(Object condition, CValueVO valueVO, EntryVO conditionHead) {
        ConditionHitOperatorEnum hitEnum = ConditionHitOperatorEnum.getHitEnum(valueVO.getKey());
        DataGradeParamTypeEnum typeEnum = DataGradeParamTypeEnum.getTypeEnumByCode(conditionHead.getPropsName());
        if (Objects.isNull((Object)hitEnum) || Objects.isNull((Object)typeEnum)) {
            return false;
        }
        switch (hitEnum) {
            case CONTAINS: {
                return Objects.nonNull(condition) && String.valueOf(condition).contains(valueVO.getValue());
            }
            case NOT_CONTAINS: {
                return Objects.isNull(condition) || !String.valueOf(condition).contains(valueVO.getValue());
            }
            case STARTS_WITH: {
                return Objects.nonNull(condition) && String.valueOf(condition).startsWith(valueVO.getValue());
            }
            case ENDS_WITH: {
                return Objects.nonNull(condition) && String.valueOf(condition).endsWith(valueVO.getValue());
            }
            case TODAY: {
                return this.timeCompare(condition, new DateTime().withTimeAtStartOfDay(), new DateTime().millisOfDay().withMaximumValue());
            }
            case YESTERDAY: {
                return this.timeCompare(condition, new DateTime().minusDays(1).withTimeAtStartOfDay(), new DateTime().minusDays(1).millisOfDay().withMaximumValue());
            }
            case TOMORROW: {
                return this.timeCompare(condition, new DateTime().plusDays(1).withTimeAtStartOfDay(), new DateTime().plusDays(1).millisOfDay().withMaximumValue());
            }
            case THIS_WEEK: {
                return this.timeCompare(condition, new DateTime().dayOfWeek().withMinimumValue().withTimeAtStartOfDay(), new DateTime().dayOfWeek().withMaximumValue().millisOfDay().withMaximumValue());
            }
            case LAST_WEEK: {
                return this.timeCompare(condition, new DateTime().minusWeeks(1).dayOfWeek().withMinimumValue().withTimeAtStartOfDay(), new DateTime().minusWeeks(1).dayOfWeek().withMaximumValue().millisOfDay().withMaximumValue());
            }
            case NEXT_WEEK: {
                return this.timeCompare(condition, new DateTime().plusWeeks(1).dayOfWeek().withMinimumValue().withTimeAtStartOfDay(), new DateTime().plusWeeks(1).dayOfWeek().withMaximumValue().millisOfDay().withMaximumValue());
            }
            case THIS_MONTH: {
                return this.timeCompare(condition, new DateTime().dayOfMonth().withMinimumValue().withTimeAtStartOfDay(), new DateTime().dayOfMonth().withMaximumValue().millisOfDay().withMaximumValue());
            }
            case LAST_MONTH: {
                return this.timeCompare(condition, new DateTime().minusMonths(1).dayOfMonth().withMinimumValue().withTimeAtStartOfDay(), new DateTime().minusMonths(1).dayOfMonth().withMaximumValue().millisOfDay().withMaximumValue());
            }
            case NEXT_MONTH: {
                return this.timeCompare(condition, new DateTime().plusMonths(1).dayOfMonth().withMinimumValue().withTimeAtStartOfDay(), new DateTime().plusMonths(1).dayOfMonth().withMaximumValue().millisOfDay().withMaximumValue());
            }
            case LAST_THREE_MONTH: {
                return this.timeCompare(condition, new DateTime().minusMonths(3).dayOfMonth().withMinimumValue().withTimeAtStartOfDay(), new DateTime().minusMonths(1).dayOfMonth().withMaximumValue().millisOfDay().withMaximumValue());
            }
            case NEXT_THREE_MONTH: {
                return this.timeCompare(condition, new DateTime().plusMonths(1).dayOfMonth().withMinimumValue().withTimeAtStartOfDay(), new DateTime().plusMonths(3).dayOfMonth().withMaximumValue().millisOfDay().withMaximumValue());
            }
            case THIS_QUARTER: {
                Quarter thisQuarter = new Quarter();
                return this.timeCompare(condition, ((Quarter)thisQuarter).getThisQuarter().startTime, ((Quarter)thisQuarter).getThisQuarter().endTime);
            }
            case LAST_QUARTER: {
                Quarter thisQuarter = new Quarter();
                return this.timeCompare(condition, ((Quarter)thisQuarter).getLastQuarter().startTime, ((Quarter)thisQuarter).getLastQuarter().endTime);
            }
            case NEXT_QUARTER: {
                Quarter thisQuarter = new Quarter();
                return this.timeCompare(condition, ((Quarter)thisQuarter).getNextQuarter().startTime, ((Quarter)thisQuarter).getNextQuarter().endTime);
            }
            case THIS_YEAR: {
                return this.timeCompare(condition, new DateTime().dayOfYear().withMinimumValue().withTimeAtStartOfDay(), new DateTime().dayOfYear().withMaximumValue().millisOfDay().withMaximumValue());
            }
            case LAST_YEAR: {
                return this.timeCompare(condition, new DateTime().minusYears(1).dayOfYear().withMinimumValue().withTimeAtStartOfDay(), new DateTime().minusYears(1).dayOfYear().withMaximumValue().millisOfDay().withMaximumValue());
            }
            case NEXT_YEAR: {
                return this.timeCompare(condition, new DateTime().plusYears(1).dayOfYear().withMinimumValue().withTimeAtStartOfDay(), new DateTime().plusYears(1).dayOfYear().withMaximumValue().millisOfDay().withMaximumValue());
            }
            case EQUAL: {
                return this.equalsCheck(condition, valueVO, typeEnum, conditionHead);
            }
            case NOT_EQUAL: {
                return !this.equalsCheck(condition, valueVO, typeEnum, conditionHead);
            }
            case LESS_EQUAL: {
                return this.compareTo(condition, valueVO.getValue(), typeEnum, Arrays.asList(-1, 0));
            }
            case MORE_EQUAL: {
                return this.compareTo(condition, valueVO.getValue(), typeEnum, Arrays.asList(1, 0));
            }
            case LESS_THAN: {
                return this.compareTo(condition, valueVO.getValue(), typeEnum, Collections.singletonList(-1));
            }
            case MORE_THAN: {
                return this.compareTo(condition, valueVO.getValue(), typeEnum, Collections.singletonList(1));
            }
            case IN: {
                return this.conditionInCheck(condition, valueVO, typeEnum);
            }
            case NOT_IN: {
                return !this.conditionInCheck(condition, valueVO, typeEnum);
            }
            case IS_NULL: {
                return HRStringUtils.isEmpty((String)String.valueOf(condition)) || Objects.isNull(condition);
            }
            case IS_NOT_NULL: {
                return HRStringUtils.isNotEmpty((String)String.valueOf(condition)) && Objects.nonNull(condition);
            }
        }
        return false;
    }

    private boolean equalsCheck(Object condition, CValueVO valueVO, DataGradeParamTypeEnum typeEnum, EntryVO conditionHead) {
        Object checkValue = this.dealConditionOrResultValue(valueVO.getValue(), conditionHead);
        Object conditionValue = condition;
        if (DataGradeParamTypeEnum.BASE == typeEnum) {
            checkValue = valueVO.getBasedataId();
            if (condition instanceof DynamicObject) {
                conditionValue = ((DynamicObject)condition).getPkValue();
            }
        } else if (DataGradeParamTypeEnum.DATE == typeEnum) {
            DateTime conditionDateTime = this.getDateTime(condition);
            if (Objects.isNull(conditionDateTime)) {
                return false;
            }
            DateTime checkValueDateTime = this.getDateTime(valueVO.getValue());
            if (Objects.isNull(checkValueDateTime)) {
                return true;
            }
            checkValue = checkValueDateTime.getMillis();
            conditionValue = conditionDateTime.getMillis();
        }
        return String.valueOf(checkValue).equals(String.valueOf(conditionValue));
    }

    private boolean conditionInCheck(Object condition, CValueVO valueVO, DataGradeParamTypeEnum typeEnum) {
        String checkValue = valueVO.getValue();
        Object conditionValue = condition;
        if (DataGradeParamTypeEnum.BASE == typeEnum) {
            checkValue = valueVO.getBasedataId();
            if (condition instanceof DynamicObject) {
                conditionValue = ((DynamicObject)condition).getPkValue();
            }
            return this.inCheck(conditionValue, checkValue);
        }
        return this.inCheck(conditionValue, checkValue);
    }

    private boolean inCheck(Object condition, String value) {
        if (HRStringUtils.isEmpty((String)value) || Objects.isNull(condition)) {
            return false;
        }
        HashSet<String> valueSet = new HashSet<String>(Arrays.asList(value.split(SPLIT_SYMBOL)));
        return valueSet.contains(String.valueOf(condition));
    }

    private boolean compareTo(Object condition, String value, DataGradeParamTypeEnum typeEnum, List<Integer> resultList) {
        switch (typeEnum) {
            case MONEY: 
            case NUMBER: {
                return this.numberCompare(condition, value, resultList);
            }
            case DATE: {
                return this.dateCompare(condition, value, resultList);
            }
        }
        return false;
    }

    private boolean dateCompare(Object condition, String value, List<Integer> resultList) {
        DateTime conditionTime = this.getDateTime(condition);
        DateTime compareValue = this.getDateTime(value);
        if (conditionTime == null) {
            return false;
        }
        int result = conditionTime.compareTo((ReadableInstant)compareValue);
        return resultList.contains(result);
    }

    private DateTime getDateTime(Object value) {
        DateTime time;
        if (value instanceof String) {
            try {
                time = new DateTime((Object)HRDateTimeUtils.parseDate((String)String.valueOf(value)));
            }
            catch (ParseException e) {
                throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u65e5\u671f\u89e3\u6790\u5931\u8d25\u3002\u65e5\u671f\u4e3a\u201c%1$s\u201d\u3002", (String)"DataGradeVO_1", (String)"hrmp-hbp-business", (Object[])new Object[0]), value));
            }
        } else if (value instanceof Date) {
            time = new DateTime(value);
        } else {
            return null;
        }
        return time.withTimeAtStartOfDay();
    }

    private boolean numberCompare(Object condition, String value, List<Integer> resultList) {
        BigDecimal conditionValue = this.parseBigDecimal(condition);
        if (Objects.isNull(conditionValue)) {
            return false;
        }
        BigDecimal compareValue = this.parseBigDecimal(value);
        int result = conditionValue.compareTo(compareValue);
        return resultList.contains(result);
    }

    private BigDecimal parseBigDecimal(Object value) {
        try {
            if (Objects.isNull(value) || HRStringUtils.isEmpty((String)String.valueOf(value))) {
                return null;
            }
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            return new BigDecimal(String.valueOf(value));
        }
        catch (NumberFormatException nf) {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6570\u5b57\u89e3\u6790\u5931\u8d25\uff0c\u5931\u8d25\u6570\u5b57\u4e3a%1$s\u3002", (String)"DataGradeVO_2", (String)"hrmp-hbp-business", (Object[])new Object[0]), value));
        }
    }

    private boolean timeCompare(Object condition, DateTime startTime, DateTime endTime) {
        DateTime time = this.getDateTime(condition);
        if (time == null) {
            return false;
        }
        return startTime.minusMillis(1).isBefore((ReadableInstant)time) && endTime.plusMillis(1).isAfter((ReadableInstant)time);
    }

    private static Object convertIdType(Object id) {
        try {
            return Long.parseLong(String.valueOf(id));
        }
        catch (NumberFormatException ne) {
            return id;
        }
    }

    public String getUniqueCode() {
        return this.uniqueCode;
    }

    public void setUniqueCode(String uniqueCode) {
        this.uniqueCode = uniqueCode;
    }

    public boolean isReturnDefaultResult() {
        return this.isReturnDefaultResult;
    }

    public void setReturnDefaultResult(boolean returnDefaultResult) {
        this.isReturnDefaultResult = returnDefaultResult;
    }

    public ArrayList<EntryVO> getConditionHeadList() {
        return this.conditionHeadList;
    }

    public void setConditionHeadList(ArrayList<EntryVO> conditionHeadList) {
        this.conditionHeadList = conditionHeadList;
    }

    public Map<String, EntryVO> getResultHeadMap() {
        return this.resultHeadMap;
    }

    public void setResultHeadMap(Map<String, EntryVO> resultHeadMap) {
        this.resultHeadMap = resultHeadMap;
    }

    public Map<String, DefaultResult> getDefaultResultMap() {
        return this.defaultResultMap;
    }

    public void setDefaultResultMap(Map<String, DefaultResult> defaultResultMap) {
        this.defaultResultMap = defaultResultMap;
    }

    public Map<String, DynamicObject> getIdToDyMap() {
        return this.idToDyMap;
    }

    public void setIdToDyMap(Map<String, DynamicObject> idToDyMap) {
        this.idToDyMap = idToDyMap;
    }

    public ArrayList<ArrayList<ConditionValueVO>> getConditionList() {
        return this.conditionList;
    }

    public void setConditionList(ArrayList<ArrayList<ConditionValueVO>> conditionList) {
        this.conditionList = conditionList;
    }

    public ArrayList<Map<String, ResultValue>> getResultList() {
        return this.resultList;
    }

    public void setResultList(ArrayList<Map<String, ResultValue>> resultList) {
        this.resultList = resultList;
    }

    public String toString() {
        return "DataGradeVO{uniqueCode='" + this.uniqueCode + '\'' + ", isReturnDefaultResult=" + this.isReturnDefaultResult + ", conditionHeadList=" + this.conditionHeadList + ", resultHeadMap=" + this.resultHeadMap + ", defaultResultMap=" + this.defaultResultMap + ", idToDyMap=" + this.idToDyMap + ", conditionList=" + this.conditionList + ", resultList=" + this.resultList + '}';
    }

    private static class DateRange {
        DateTime startTime;
        DateTime endTime;

        DateRange(DateTime startTime, DateTime endTime) {
            this.startTime = startTime.withTimeAtStartOfDay();
            this.endTime = endTime.millisOfDay().withMaximumValue();
        }

        DateRange addYear() {
            return new DateRange(this.startTime.plusYears(1), this.endTime.plusYears(1));
        }

        DateRange minusYear() {
            return new DateRange(this.startTime.minusYears(1), this.endTime.minusYears(1));
        }
    }

    private static class Quarter {
        List<DateRange> quarters = new ArrayList<DateRange>();

        Quarter() {
            this.quarters.add(new DateRange(new DateTime().monthOfYear().setCopy(1).dayOfMonth().setCopy(1), new DateTime().monthOfYear().setCopy(3).dayOfMonth().setCopy(31)));
            this.quarters.add(new DateRange(new DateTime().monthOfYear().setCopy(4).dayOfMonth().setCopy(1), new DateTime().monthOfYear().setCopy(6).dayOfMonth().setCopy(30)));
            this.quarters.add(new DateRange(new DateTime().monthOfYear().setCopy(7).dayOfMonth().setCopy(1), new DateTime().monthOfYear().setCopy(9).dayOfMonth().setCopy(30)));
            this.quarters.add(new DateRange(new DateTime().monthOfYear().setCopy(10).dayOfMonth().setCopy(1), new DateTime().monthOfYear().setCopy(12).dayOfMonth().setCopy(31)));
        }

        private DateRange getThisQuarter() {
            return this.quarters.get(this.getQuarterIndex());
        }

        private int getQuarterIndex() {
            int month = new DateTime().getMonthOfYear();
            int quarterIndex = 1 <= month && month <= 3 ? 0 : (4 <= month && month <= 6 ? 1 : (7 <= month && month <= 9 ? 2 : 3));
            return quarterIndex;
        }

        private DateRange getLastQuarter() {
            int quarterIndex = this.getQuarterIndex();
            if (--quarterIndex < 0) {
                return this.quarters.get(3).minusYear();
            }
            return this.quarters.get(quarterIndex);
        }

        private DateRange getNextQuarter() {
            int quarterIndex = this.getQuarterIndex();
            if (++quarterIndex > 3) {
                return this.quarters.get(0).addYear();
            }
            return this.quarters.get(quarterIndex);
        }
    }
}

