/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.cal.vo;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.hr.hbp.common.util.HRStringUtils;

public class FunctionVO
implements Serializable {
    private static final long serialVersionUID = 3645305105557502263L;
    private String name;
    private String executeCode;
    private Set<String> importPackages;

    public FunctionVO() {
    }

    public FunctionVO(String name, String executeCode) {
        this(name, executeCode, null);
    }

    public FunctionVO(String name, String executeCode, Set<String> importPackages) {
        this.name = name;
        this.executeCode = executeCode;
        this.importPackages = importPackages;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExecuteCode() {
        return this.executeCode;
    }

    public void setExecuteCode(String executeCode) {
        this.executeCode = executeCode;
    }

    public Set<String> getImportPackages() {
        return this.importPackages;
    }

    public void setImportPackages(Set<String> importPackages) {
        this.importPackages = importPackages;
    }

    public static FunctionVO getFunctionVO(DynamicObject functionDy) {
        FunctionVO functionVO = new FunctionVO();
        functionVO.setName(functionDy.getString("name"));
        functionVO.setExecuteCode(functionDy.getString("funcexp"));
        DynamicObjectCollection importEntry = functionDy.getDynamicObjectCollection("importentry");
        if (Objects.nonNull(importEntry) && importEntry.size() > 0) {
            HashSet<String> importPackages = new HashSet<String>(importEntry.size());
            for (DynamicObject dy : importEntry) {
                String packageName = dy.getString("importcode");
                if (!HRStringUtils.isNotEmpty((String)packageName)) continue;
                importPackages.add(packageName.trim());
            }
            functionVO.setImportPackages(importPackages);
        }
        return functionVO;
    }

    public String toString() {
        return "FunctionVO{name='" + this.name + '\'' + ", executeCode='" + this.executeCode + '\'' + ", importPackages=" + this.importPackages + '}';
    }
}

