/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.demo;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.formula.cal.enums.AddSumTypeEnum;
import kd.hr.hbp.business.service.formula.cal.enums.SubsectionSummaryType;
import kd.hr.hbp.business.service.formula.cal.service.DefaultHRMPCalcService;
import kd.hr.hbp.business.service.formula.cal.template.FormulaParse;
import kd.hr.hbp.business.service.formula.cal.vo.AddSumVO;
import kd.hr.hbp.business.service.formula.cal.vo.CalAllParamVO;
import kd.hr.hbp.business.service.formula.cal.vo.CalItemVO;
import kd.hr.hbp.business.service.formula.cal.vo.CalResultDetailVO;
import kd.hr.hbp.business.service.formula.cal.vo.CalResultVO;
import kd.hr.hbp.business.service.formula.cal.vo.DataGradeVO;
import kd.hr.hbp.business.service.formula.cal.vo.FormulaVO;
import kd.hr.hbp.business.service.formula.cal.vo.FunctionVO;
import kd.hr.hbp.business.service.formula.cal.vo.ProportionRuleVO;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang.StringUtils;

public class CalDemoServiceTest {
    private static final HRBaseServiceHelper RULE_DEMO_HELPER = new HRBaseServiceHelper("hrcs_calruledemo");
    private static final HRBaseServiceHelper CAL_ITEM_LIST_DEMO_HELPER = new HRBaseServiceHelper("hrcs_calitemlistdemo");
    private static final HRBaseServiceHelper CAL_PROPORTION_DEMO_HELPER = new HRBaseServiceHelper("hrcs_calproportiondemo");

    public static void CalByPersonId(List<Long> personIds) throws Exception {
        if (CollectionUtils.isEmpty(personIds)) {
            return;
        }
        DynamicObject ruleDemo = RULE_DEMO_HELPER.loadDynamicObject(new QFilter("number", "=", (Object)"testrule"));
        DynamicObjectCollection calRules = ruleDemo.getDynamicObjectCollection("calruleitementry");
        HashSet<Long> calItemIds = new HashSet<Long>(calRules.size());
        HashMap<String, DynamicObject> calUniqueCodeToProportionRule = new HashMap<String, DynamicObject>(calRules.size());
        ArrayList<FormulaVO> calFormulaList = new ArrayList<FormulaVO>();
        HashMap<Long, FormulaVO> proportionFormulaMap = new HashMap<Long, FormulaVO>();
        HashSet<String> functionUniqueCodes = new HashSet<String>();
        ArrayList<FunctionVO> functionVOList = new ArrayList<FunctionVO>();
        HashSet<Long> ruleIdSet = new HashSet<Long>();
        Map<Object, Object> proportionRuleMap = new HashMap();
        for (DynamicObject rule : calRules) {
            long calItemId = rule.getLong("calitem.id");
            DynamicObject customproportionrule = rule.getDynamicObject("customproportionrule");
            if (Objects.nonNull(customproportionrule)) {
                ruleIdSet.add(customproportionrule.getLong("id"));
            }
            calItemIds.add(calItemId);
        }
        if (!ruleIdSet.isEmpty()) {
            proportionRuleMap = Stream.of(CAL_PROPORTION_DEMO_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", ruleIdSet)})).collect(Collectors.toMap(r -> r.getLong("id"), r -> r));
        }
        HRBaseServiceHelper personDataHelper = new HRBaseServiceHelper("hrcs_calpeoplevalue");
        DynamicObject[] personItemValues = personDataHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("calitem.id", "in", calItemIds), new QFilter("person.id", "in", personIds)});
        Map<Long, List<DynamicObject>> subTags = Stream.of(personItemValues).filter(dy -> StringUtils.isNotBlank((String)dy.getString("subtag"))).collect(Collectors.groupingBy(dy -> dy.getLong("person.id")));
        HashMap<String, CalItemVO> uniqueCodeCalItemMap = new HashMap<String, CalItemVO>(16);
        HashMap<String, AddSumVO> addSumMap = new HashMap<String, AddSumVO>();
        for (DynamicObject rule : calRules) {
            DynamicObject[] formulaDyObj;
            DynamicObject customProportionRule = rule.getDynamicObject("customproportionrule");
            if (Objects.nonNull(customProportionRule)) {
                String dependentFunc;
                FormulaVO formulaVO;
                DynamicObject allRuleObj = (DynamicObject)proportionRuleMap.get(customProportionRule.getLong("id"));
                calUniqueCodeToProportionRule.put(rule.getString("calitem.uniquecode"), allRuleObj);
                long numeratorId = allRuleObj.getLong("numerator.id");
                long denominatorId = allRuleObj.getLong("denominator.id");
                if (!proportionFormulaMap.containsKey(numeratorId)) {
                    formulaVO = new FormulaVO();
                    formulaVO.setName(allRuleObj.getString("numerator.name"));
                    formulaVO.setExecuteCode(allRuleObj.getString("numerator.executeexp"));
                    proportionFormulaMap.put(numeratorId, formulaVO);
                    dependentFunc = allRuleObj.getString("numerator.dependentfunc");
                    if (HRStringUtils.isNotEmpty((String)dependentFunc)) {
                        functionUniqueCodes.addAll(Arrays.asList(dependentFunc.split(",")));
                    }
                }
                if (!proportionFormulaMap.containsKey(denominatorId)) {
                    formulaVO = new FormulaVO();
                    formulaVO.setName(allRuleObj.getString("denominator.name"));
                    formulaVO.setExecuteCode(allRuleObj.getString("denominator.executeexp"));
                    proportionFormulaMap.put(denominatorId, formulaVO);
                    dependentFunc = allRuleObj.getString("denominator.dependentfunc");
                    if (HRStringUtils.isNotEmpty((String)dependentFunc)) {
                        functionUniqueCodes.addAll(Arrays.asList(dependentFunc.split(",")));
                    }
                }
            }
            if (Objects.nonNull(formulaDyObj = rule.getDynamicObject("formula"))) {
                String dependentFunc;
                String executeExp = formulaDyObj.getString("executeexp");
                if (HRStringUtils.isNotEmpty((String)executeExp)) {
                    String formulaName = formulaDyObj.getString("name");
                    FormulaVO formulaVO = new FormulaVO();
                    formulaVO.setName(formulaName);
                    formulaVO.setExecuteCode(executeExp);
                    calFormulaList.add(formulaVO);
                }
                if (HRStringUtils.isNotEmpty((String)(dependentFunc = formulaDyObj.getString("dependentfunc")))) {
                    functionUniqueCodes.addAll(Arrays.asList(dependentFunc.split(",")));
                }
            }
            uniqueCodeCalItemMap.computeIfAbsent(rule.getString("calitem.uniquecode"), k -> {
                CalItemVO calItemVO = new CalItemVO();
                calItemVO.setId(rule.getString("calitem.id"));
                calItemVO.setDataType(DataTypeEnum.getDataType(rule.getString("calitem.datatype")));
                calItemVO.setName(rule.getString("calitem.name"));
                calItemVO.setUniqueCode(rule.getString("calitem.uniquecode"));
                calItemVO.setSummaryType(SubsectionSummaryType.SUM);
                calItemVO.setDataLength(rule.getInt("calitem.datalength"));
                calItemVO.setScale(rule.getInt("calitem.scale"));
                calItemVO.setRoundingMode(RoundingMode.HALF_UP);
                return calItemVO;
            });
            if (!"true".equals(rule.getString("calitem.isaddsum"))) continue;
            addSumMap.computeIfAbsent(rule.getString("calitem.uniquecode"), k -> {
                AddSumVO addSumVO = new AddSumVO();
                addSumVO.setAddSumId(rule.getString("calitem.id"));
                addSumVO.setUniqueCode(rule.getString("calitem.uniquecode"));
                addSumVO.setAddSumItemUniqueCodeSet(new HashSet<String>(Arrays.asList(rule.getString("calitem.addsumitems").split(","))));
                addSumVO.setAddSumType(AddSumTypeEnum.AFTER_CAL_SUM);
                return addSumVO;
            });
        }
        if (!CollectionUtils.isEmpty(functionUniqueCodes)) {
            DynamicObject[] fucArray;
            HRBaseServiceHelper fucHelper = new HRBaseServiceHelper("hrcs_funcdefine");
            QFilter uniqueCodeFilter = new QFilter("uniquecode", "in", functionUniqueCodes);
            for (DynamicObject fuc : fucArray = fucHelper.query("id,name,funcexp", new QFilter[]{uniqueCodeFilter})) {
                functionVOList.add(new FunctionVO(fuc.getString("name"), fuc.getString("funcexp")));
            }
        }
        CalAllParamVO paramVO = CalDemoServiceTest.getCalAllParamVO(calUniqueCodeToProportionRule, personItemValues, uniqueCodeCalItemMap, subTags, addSumMap);
        FormulaParse formulaClassImpl = DefaultHRMPCalcService.getInstance().createClassImpl(null, calFormulaList, functionVOList);
        FormulaParse calProportionImpl = DefaultHRMPCalcService.getInstance().createClassImpl(null, new ArrayList<FormulaVO>(proportionFormulaMap.values()), functionVOList);
        Map<String, CalResultDetailVO> cal = DefaultHRMPCalcService.getInstance().calc(formulaClassImpl, calProportionImpl, paramVO, personIds.stream().map(String::valueOf).collect(Collectors.toList()));
        CalDemoServiceTest.saveData(personIds, cal);
    }

    private static void saveData(List<Long> personIds, Map<String, CalResultDetailVO> cal) {
        QFilter personIdFilter = new QFilter("person.id", "in", personIds);
        CAL_ITEM_LIST_DEMO_HELPER.deleteByFilter(new QFilter[]{personIdFilter});
        ArrayList saveData = Lists.newArrayListWithExpectedSize((int)cal.size());
        HashMap<String, DynamicObject> subMap = new HashMap<String, DynamicObject>();
        for (Map.Entry<String, CalResultDetailVO> entry : cal.entrySet()) {
            CalResultDetailVO value = entry.getValue();
            String personIdStr = entry.getKey().split("-")[0];
            DynamicObject sumValue = CAL_ITEM_LIST_DEMO_HELPER.generateEmptyDynamicObject();
            sumValue.set("caltype", (Object)"1");
            sumValue.set("person", (Object)Long.parseLong(personIdStr));
            sumValue.set("status", (Object)"C");
            sumValue.set("enable", (Object)"1");
            for (Map.Entry<String, CalResultVO> sumResult : value.getSumResultMap().entrySet()) {
                CalResultVO resultValue = sumResult.getValue();
                String propertyKey = "";
                switch (sumResult.getKey()) {
                    case "S_yearendbonuspayable": {
                        propertyKey = "yearendbonuspayable";
                        break;
                    }
                    case "S_taxamount": {
                        propertyKey = "taxamount";
                        break;
                    }
                    case "S_actualyearendbonus": {
                        propertyKey = "actualyearendbonus";
                        break;
                    }
                }
                if (StringUtils.isNotBlank((String)propertyKey)) {
                    sumValue.set(propertyKey, resultValue.getCalResultValue());
                }
                CalDemoServiceTest.setSubDy(subMap, personIdStr, propertyKey, resultValue.getItemSubsectionResult());
                CalDemoServiceTest.setSubDy(subMap, personIdStr, propertyKey, resultValue.getTimeSubsectionResult());
            }
            Set<Map.Entry<String, AddSumVO>> entries = value.getAddSumMap().entrySet();
            for (Map.Entry<String, AddSumVO> addSumVO : entries) {
                AddSumVO addSumValue = addSumVO.getValue();
                sumValue.set("originaladdsumresult", addSumValue.getOriginalValue());
                sumValue.set("currentaddsumresult", addSumValue.getCurrentCalValue());
                sumValue.set("totaladdsumresult", (Object)addSumValue.getTotalValue());
            }
            saveData.add(sumValue);
        }
        saveData.addAll(subMap.values());
        if (!CollectionUtils.isEmpty((Collection)saveData)) {
            CAL_ITEM_LIST_DEMO_HELPER.save(saveData.toArray(new DynamicObject[0]));
        }
    }

    private static void setSubDy(Map<String, DynamicObject> subMap, String personIdStr, String propertyKey, List<CalResultVO> subResultList) {
        for (CalResultVO itemResult : subResultList) {
            DynamicObject itemValue = subMap.get(itemResult.getItemProrateDetailId());
            if (Objects.isNull(itemValue)) {
                itemValue = CAL_ITEM_LIST_DEMO_HELPER.generateEmptyDynamicObject();
                subMap.put(itemResult.getItemProrateDetailId(), itemValue);
            }
            itemValue.set("caltype", (Object)"2");
            itemValue.set("person", (Object)Long.parseLong(personIdStr));
            itemValue.set("status", (Object)"C");
            itemValue.set("enable", (Object)"1");
            if (StringUtils.isNotBlank((String)propertyKey)) {
                itemValue.set(propertyKey, itemResult.getCalResultValue());
            }
            if (CollectionUtils.isEmpty(itemResult.getItemSubsectionResult())) continue;
            CalDemoServiceTest.setSubDy(subMap, personIdStr, propertyKey, itemResult.getItemSubsectionResult());
        }
    }

    private static CalAllParamVO getCalAllParamVO(Map<String, DynamicObject> calUniqueCodeToProportionRule, DynamicObject[] personItemValues, Map<String, CalItemVO> uniqueCodeCalItemMap, Map<Long, List<DynamicObject>> subTags, Map<String, AddSumVO> addSumMap) {
        CalAllParamVO paramVO = new CalAllParamVO();
        HashMap<String, Map<String, List<String>>> paramIdToConvertSectionMap = new HashMap<String, Map<String, List<String>>>();
        HashMap<String, Map<String, Map<String, ProportionRuleVO>>> itemSectionProportionRuleMap = new HashMap<String, Map<String, Map<String, ProportionRuleVO>>>();
        HashMap<String, Map<String, Map<String, Object>>> paramIdToSectionParamMap = new HashMap<String, Map<String, Map<String, Object>>>();
        HashMap<String, Map<String, Object>> paramIdToParamMap = new HashMap<String, Map<String, Object>>();
        HashMap<String, Map<String, List<String>>> itemSectionMap = new HashMap<String, Map<String, List<String>>>();
        HashMap<String, Map<String, AddSumVO>> paramIdAddSumMap = new HashMap<String, Map<String, AddSumVO>>();
        HashSet personIds = Sets.newHashSetWithExpectedSize((int)personItemValues.length);
        for (DynamicObject personItemValue : personItemValues) {
            long personId = personItemValue.getLong("person.id");
            personIds.add(personId);
            itemSectionProportionRuleMap.computeIfAbsent(String.valueOf(personId), k -> new HashMap());
            paramIdToConvertSectionMap.computeIfAbsent(String.valueOf(personId), k -> new LinkedHashMap());
            paramIdToSectionParamMap.computeIfAbsent(String.valueOf(personId), k -> new LinkedHashMap());
            itemSectionMap.computeIfAbsent(String.valueOf(personId), k -> new HashMap());
            paramIdAddSumMap.computeIfAbsent(String.valueOf(personId), k -> addSumMap);
            DynamicObject calItem = personItemValue.getDynamicObject("calitem");
            if (CollectionUtils.isEmpty(calUniqueCodeToProportionRule)) continue;
            String subTag = personItemValue.getString("subtag");
            if (HRStringUtils.isNotEmpty((String)subTag)) {
                Map sectionParamMap = (Map)paramIdToSectionParamMap.get(String.valueOf(personId));
                sectionParamMap.computeIfAbsent(subTag, k -> new HashMap());
                sectionParamMap.computeIfPresent(subTag, (k, value) -> {
                    value.put(calItem.getString("uniquecode"), CalDemoServiceTest.convertValueByType(calItem.getString("datatype"), personItemValue.getString("calitemvalue")));
                    return value;
                });
                continue;
            }
            List<DynamicObject> subTagObjs = subTags.get(personId);
            for (DynamicObject subTagObj : subTagObjs) {
                Map sectionParamMap = (Map)paramIdToSectionParamMap.get(String.valueOf(personId));
                sectionParamMap.computeIfAbsent(subTagObj.getString("subtag"), k -> new HashMap());
                sectionParamMap.computeIfPresent(subTagObj.getString("subtag"), (k, value) -> {
                    value.put(calItem.getString("uniquecode"), CalDemoServiceTest.convertValueByType(calItem.getString("datatype"), personItemValue.getString("calitemvalue")));
                    return value;
                });
            }
            paramIdToParamMap.computeIfAbsent(String.valueOf(personId), k -> new HashMap());
            paramIdToParamMap.computeIfPresent(String.valueOf(personId), (k, value) -> {
                value.put(calItem.getString("uniquecode"), CalDemoServiceTest.convertValueByType(calItem.getString("datatype"), personItemValue.getString("calitemvalue")));
                return value;
            });
        }
        for (Map.Entry entry : calUniqueCodeToProportionRule.entrySet()) {
            for (Long personId : personIds) {
                List<DynamicObject> subTagObjs = subTags.get(personId);
                for (DynamicObject subTagObj : subTagObjs) {
                    Map itemSectionProportionRule = (Map)itemSectionProportionRuleMap.get(String.valueOf(personId));
                    itemSectionProportionRule.computeIfAbsent(entry.getKey(), k -> new LinkedHashMap());
                    itemSectionProportionRule.computeIfPresent(entry.getKey(), (k, value) -> {
                        ProportionRuleVO ruleVO = new ProportionRuleVO();
                        ruleVO.setId(((DynamicObject)entry.getValue()).getString("id"));
                        ruleVO.setNumeratorId(((DynamicObject)entry.getValue()).getLong("numerator.id"));
                        ruleVO.setDenominatorId(((DynamicObject)entry.getValue()).getLong("denominator.id"));
                        ruleVO.setScale(((DynamicObject)entry.getValue()).getInt("scale"));
                        value.put(subTagObj.getString("subtag"), ruleVO);
                        return value;
                    });
                    Map convertSectionTagMap = (Map)paramIdToConvertSectionMap.get(String.valueOf(personId));
                    convertSectionTagMap.computeIfAbsent(((DynamicObject)entry.getValue()).getString("numerator.id"), k -> new ArrayList());
                    convertSectionTagMap.computeIfPresent(((DynamicObject)entry.getValue()).getString("numerator.id"), (k, value) -> {
                        if (!value.contains(subTagObj.getString("subtag"))) {
                            value.add(subTagObj.getString("subtag"));
                        }
                        return value;
                    });
                    convertSectionTagMap.computeIfAbsent(((DynamicObject)entry.getValue()).getString("denominator.id"), k -> new ArrayList());
                    convertSectionTagMap.computeIfPresent(((DynamicObject)entry.getValue()).getString("denominator.id"), (k, value) -> {
                        if (!value.contains(subTagObj.getString("subtag"))) {
                            value.add(subTagObj.getString("subtag"));
                        }
                        return value;
                    });
                    itemSectionMap.computeIfPresent(String.valueOf(personId), (k, v) -> {
                        v.computeIfAbsent(entry.getKey(), c -> new ArrayList());
                        v.computeIfPresent(entry.getKey(), (c, l) -> {
                            if (!l.contains(subTagObj.getString("subtag"))) {
                                l.add(subTagObj.getString("subtag"));
                            }
                            return l;
                        });
                        return v;
                    });
                }
            }
        }
        paramVO.setParamIdToConvertSectionMap(paramIdToConvertSectionMap);
        paramVO.setItemSectionProportionRuleMap(itemSectionProportionRuleMap);
        paramVO.setParamIdToSectionParamMap(paramIdToSectionParamMap);
        paramVO.setParamIdToParamMap(paramIdToParamMap);
        paramVO.setItemSectionMap(itemSectionMap);
        paramVO.setUniqueCodeCalItemMap(uniqueCodeCalItemMap);
        paramVO.setParamIdAddSumMap(paramIdAddSumMap);
        return paramVO;
    }

    private static Object convertValueByType(String valueType, String value) {
        if (HRStringUtils.isEmpty((String)value) || HRStringUtils.isEmpty((String)valueType)) {
            return null;
        }
        switch (valueType) {
            case "num": {
                return new BigDecimal(value);
            }
            case "string": {
                return value;
            }
            case "boolean": {
                return Boolean.parseBoolean(value);
            }
            case "int": {
                return Integer.valueOf(value);
            }
            case "date": {
                try {
                    return HRDateTimeUtils.parseDate((String)value);
                }
                catch (ParseException e) {
                    return null;
                }
            }
            case "amount": {
                return new BigDecimal(value);
            }
        }
        return value;
    }

    public static CalResultDetailVO calFormulaTest(DynamicObject formulaObj, Map<String, Object> params, Map<String, CalItemVO> uniqueCodeCalItemMap, Map<String, Object> customParams) throws Exception {
        return CalDemoServiceTest.calFormulaTest(formulaObj, params, uniqueCodeCalItemMap, customParams, null);
    }

    public static CalResultDetailVO calFormulaTest(DynamicObject formulaObj, Map<String, Object> params, Map<String, CalItemVO> uniqueCodeCalItemMap, Map<String, Object> customParams, Map<String, AddSumVO> addSumVOMap) throws Exception {
        String paramId = "test";
        String dependentFunc = formulaObj.getString("dependentfunc");
        ArrayList<FunctionVO> functionVOList = new ArrayList<FunctionVO>(10);
        CalDemoServiceTest.getFunctionVos(dependentFunc, functionVOList);
        String dependentDg = formulaObj.getString("dependentdatagrade");
        Map<String, DataGradeVO> dataGradeVOMap = CalDemoServiceTest.getDataGradeVos(dependentDg);
        ArrayList<FormulaVO> calFormulaList = new ArrayList<FormulaVO>(10);
        String executeExp = formulaObj.getString("executeexp");
        if (HRStringUtils.isNotEmpty((String)executeExp)) {
            String formulaName = formulaObj.getString("name");
            FormulaVO formulaVO = new FormulaVO();
            formulaVO.setName(formulaName);
            formulaVO.setExecuteCode(executeExp);
            calFormulaList.add(formulaVO);
        }
        CalAllParamVO paramVO = new CalAllParamVO();
        HashMap<String, Map<String, Object>> paramIdToParamMap = new HashMap<String, Map<String, Object>>(1);
        paramIdToParamMap.put(paramId, params);
        paramVO.setOpenLog(true);
        paramVO.setParamIdToParamMap(paramIdToParamMap);
        paramVO.setUniqueCodeCalItemMap(uniqueCodeCalItemMap);
        paramVO.setDataGradeVOMap(dataGradeVOMap);
        paramVO.setCustomCalItemMap(customParams);
        if (Objects.nonNull(addSumVOMap) && addSumVOMap.size() > 0) {
            HashMap<String, Map<String, AddSumVO>> paramIdAddSumMap = new HashMap<String, Map<String, AddSumVO>>(1);
            paramIdAddSumMap.put(paramId, addSumVOMap);
            paramVO.setParamIdAddSumMap(paramIdAddSumMap);
        }
        paramVO.setOpenLog(true);
        DefaultHRMPCalcService service = DefaultHRMPCalcService.getInstance();
        FormulaParse formulaClassImpl = service.createClassImpl(null, calFormulaList, functionVOList);
        Map<String, CalResultDetailVO> cal = service.calc(formulaClassImpl, null, paramVO, (List<String>)ImmutableList.of((Object)paramId));
        return cal.get(paramId);
    }

    private static void getFunctionVos(String dependentFunc, List<FunctionVO> functionVOList) {
        HashSet<String> functionUniqueCodes = new HashSet<String>(16);
        if (HRStringUtils.isNotEmpty((String)dependentFunc)) {
            functionUniqueCodes.addAll(Arrays.asList(dependentFunc.split(",")));
        }
        if (!CollectionUtils.isEmpty(functionUniqueCodes)) {
            DynamicObject[] fucArray;
            HRBaseServiceHelper fucHelper = new HRBaseServiceHelper("hrcs_function");
            QFilter uniqueCodeFilter = new QFilter("uniquecode", "in", functionUniqueCodes);
            for (DynamicObject fuc : fucArray = fucHelper.query("id,name,funcexp,importentry.importcode", new QFilter[]{uniqueCodeFilter})) {
                functionVOList.add(FunctionVO.getFunctionVO(fuc));
            }
        }
    }

    private static Map<String, DataGradeVO> getDataGradeVos(String dependentFunc) {
        HashMap<String, DataGradeVO> dataGradeVOs = new HashMap<String, DataGradeVO>(16);
        HashSet<String> dataGradeUniqueCodes = new HashSet<String>(16);
        if (HRStringUtils.isNotEmpty((String)dependentFunc)) {
            dataGradeUniqueCodes.addAll(Arrays.asList(dependentFunc.split(",")));
        }
        if (!CollectionUtils.isEmpty(dataGradeUniqueCodes)) {
            DynamicObject[] fucArray;
            HRBaseServiceHelper fucHelper = new HRBaseServiceHelper("hbp_datagrade_unittest");
            QFilter uniqueCodeFilter = new QFilter("uniquecode", "in", dataGradeUniqueCodes);
            for (DynamicObject fuc : fucArray = fucHelper.query("id,uniquecode,datagradeparam", new QFilter[]{uniqueCodeFilter})) {
                DataGradeVO dataGradeVO = DataGradeVO.getDataGradeVO(fuc);
                dataGradeVOs.put(dataGradeVO.getUniqueCode(), dataGradeVO);
            }
        }
        return dataGradeVOs;
    }
}

