/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.entity.floatcontrol;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ValueMapItem;
import kd.hr.hbp.business.service.formula.entity.item.CalItem;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.business.service.formula.enums.OperatorEnum;

public class SelectItem {
    private String showKey;
    private String uniqueKey;
    private String showUniqueKey;
    private String showValue;
    private DataTypeEnum dataType;
    private String entityNumber;
    private String executeValue;

    public String getShowKey() {
        return this.showKey;
    }

    public void setShowKey(String showKey) {
        this.showKey = showKey;
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public void setUniqueKey(String uniqueKey) {
        this.uniqueKey = uniqueKey;
    }

    public String getShowUniqueKey() {
        return this.showUniqueKey;
    }

    public void setShowUniqueKey(String showUniqueKey) {
        this.showUniqueKey = showUniqueKey;
    }

    public String getShowValue() {
        return this.showValue;
    }

    public void setShowValue(String showValue) {
        this.showValue = showValue;
    }

    public static String getShowKey(String key) {
        return "\"" + key + "\"";
    }

    public static String getUniqueKey(String key) {
        return "[" + key + "]";
    }

    public String getExecuteValue() {
        return this.executeValue;
    }

    public void setExecuteValue(String executeValue) {
        this.executeValue = executeValue;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public DataTypeEnum getDataType() {
        return this.dataType;
    }

    public void setDataType(DataTypeEnum dataType) {
        this.dataType = dataType;
    }

    public static SelectItem getSelectItemByBaseData(CalItem calItem, DynamicObject baseData) {
        String value;
        String entityNumber = calItem.getEntityNumber();
        String propertyField = calItem.getPropertyField();
        String[] fields = propertyField.split(",");
        SelectItem selectItem = new SelectItem();
        StringBuilder valueAppend = new StringBuilder();
        for (String field : fields) {
            valueAppend.append(baseData.getString(field));
            valueAppend.append("_");
        }
        String string = value = valueAppend.length() > 0 ? valueAppend.deleteCharAt(valueAppend.length() - 1).toString() : valueAppend.toString();
        if (DataTypeEnum.BASE == calItem.getDataType()) {
            selectItem.setUniqueKey(SelectItem.getUniqueKey(calItem.getUniqueCode() + OperatorEnum.SPOT.getAlias() + entityNumber + OperatorEnum.SPOT.getAlias() + baseData.getString("id")));
            selectItem.setExecuteValue(baseData.getString("id"));
        } else {
            selectItem.setExecuteValue(value);
        }
        String showKey = SelectItem.getShowKey(value);
        selectItem.setShowKey(showKey);
        selectItem.setShowValue(value);
        selectItem.setEntityNumber(entityNumber);
        selectItem.setDataType(calItem.getDataType());
        selectItem.setShowUniqueKey(showKey + OperatorEnum.SPOT.getAlias() + selectItem.getUniqueKey());
        return selectItem;
    }

    public static SelectItem getSelectItemByValueMapItem(CalItem calItem, ValueMapItem valueMapItem) {
        SelectItem selectItem = new SelectItem();
        selectItem.setShowKey(SelectItem.getShowKey(valueMapItem.getName().getLocaleValue()));
        selectItem.setUniqueKey(SelectItem.getUniqueKey(calItem.getEntityNumber() + OperatorEnum.SPOT.getAlias() + calItem.getPropertyField() + OperatorEnum.SPOT.getAlias() + valueMapItem.getValue()));
        selectItem.setShowValue(valueMapItem.getName().getLocaleValue());
        selectItem.setExecuteValue(valueMapItem.getValue());
        selectItem.setEntityNumber(calItem.getEntityNumber());
        selectItem.setDataType(calItem.getDataType());
        selectItem.setShowUniqueKey(selectItem.getShowKey() + OperatorEnum.SPOT.getAlias() + selectItem.getUniqueKey());
        return selectItem;
    }
}

