/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.entity.item;

import java.io.Serializable;
import java.util.regex.Pattern;
import kd.hr.hbp.common.util.HRStringUtils;

public class Item
implements Serializable {
    private static final long serialVersionUID = -3788362228392690395L;
    private static final String JAVA_VARIABLE_REGULAR = "^[$\\u4e00-\\u9fa5_a-zA-Z0-9]+$";
    private static final Pattern JAVA_VARIABLE_PATTERN = Pattern.compile("^[$\\u4e00-\\u9fa5_a-zA-Z0-9]+$");
    private static final String INVALID_SYMBOL_REGULAR = "[-\"/\\\\+=*()<>\\[\\],]";
    private static final Pattern INVALID_SYMBOL_PATTERN = Pattern.compile("[-\"/\\\\+=*()<>\\[\\],]");
    protected String itemCategory;
    protected String name;
    protected boolean checkUniqueCode = true;
    protected String uniqueCode;
    protected String id;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUniqueCode() {
        return this.uniqueCode;
    }

    public void setUniqueCode(String uniqueCode) {
        this.uniqueCode = uniqueCode;
    }

    public String getItemCategory() {
        return this.itemCategory;
    }

    public void setItemCategory(String itemCategory) {
        this.itemCategory = itemCategory;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isCheckUniqueCode() {
        return this.checkUniqueCode;
    }

    public void setCheckUniqueCode(boolean checkUniqueCode) {
        this.checkUniqueCode = checkUniqueCode;
    }

    public Item() {
    }

    public Item(String itemCategory, String id, String name, String uniqueCode) {
        this.itemCategory = itemCategory;
        this.name = name;
        this.uniqueCode = uniqueCode;
        this.id = id;
    }

    public String toString() {
        return "item [itemCategory=" + this.itemCategory + ", name=" + this.name + ", uniqueCode=" + this.uniqueCode + "]";
    }

    protected boolean checkCodeValidate(String code) {
        if (HRStringUtils.isNotEmpty((String)code) && this.checkUniqueCode) {
            return JAVA_VARIABLE_PATTERN.matcher(code).matches();
        }
        return true;
    }

    protected boolean checkNameValidate(String name) {
        if (HRStringUtils.isNotEmpty((String)name)) {
            return !INVALID_SYMBOL_PATTERN.matcher(name).find();
        }
        return true;
    }
}

