/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.enums;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.hr.hbp.business.service.formula.entity.HBPI18NParam;

public enum FormulaKeyEnum {
    IF("IF", new HBPI18NParam("IF", "FormulaKeyEnum_0", "hrmp-hbp-business")),
    WHILE("WHILE", new HBPI18NParam("WHILE", "FormulaKeyEnum_1", "hrmp-hbp-business")),
    ELSEIF("ELSEIF", new HBPI18NParam("ELSEIF", "FormulaKeyEnum_2", "hrmp-hbp-business")),
    ELSE("ELSE", new HBPI18NParam("ELSE", "FormulaKeyEnum_3", "hrmp-hbp-business")),
    THEN("THEN", new HBPI18NParam("THEN", "FormulaKeyEnum_4", "hrmp-hbp-business")),
    AND("AND", new HBPI18NParam("AND", "FormulaKeyEnum_5", "hrmp-hbp-business")),
    OR("OR", new HBPI18NParam("OR", "FormulaKeyEnum_6", "hrmp-hbp-business")),
    LIKE("LIKE", new HBPI18NParam("LIKE", "FormulaKeyEnum_7", "hrmp-hbp-business")),
    RESULT("RESULT", new HBPI18NParam("RESULT", "FormulaKeyEnum_8", "hrmp-hbp-business")),
    ENDIF("ENDIF", new HBPI18NParam("ENDIF", "FormulaKeyEnum_9", "hrmp-hbp-business")),
    ENDWHILE("ENDWHILE", new HBPI18NParam("ENDWHILE", "FormulaKeyEnum_10", "hrmp-hbp-business")),
    ASSIGN("ASSIGN", new HBPI18NParam("ASSIGN", "FormulaKeyEnum_11", "hrmp-hbp-business")),
    NULL("NULL", new HBPI18NParam("NULL", "FormulaKeyEnum_13", "hrmp-hbp-business")),
    EXIT("EXIT", new HBPI18NParam("EXIT", "FormulaKeyEnum_14", "hrmp-hbp-business")),
    EXPORT("EXPORT", new HBPI18NParam("EXPORT", "FormulaKeyEnum_12", "hrmp-hbp-business"));

    private final String code;
    private final HBPI18NParam alias;
    private static final Map<String, FormulaKeyEnum> CODE_CACHE_MAP;
    private static final Map<String, FormulaKeyEnum> ALIAS_CACHE_MAP;
    private static long LAST_UPDATE_TIME;
    private static final long UPDATE_INTERVAL = 600000L;

    public String getCode() {
        return this.code;
    }

    public String getAlias() {
        return this.alias.loadKDString();
    }

    public HBPI18NParam getLocateParam() {
        return this.alias;
    }

    private FormulaKeyEnum(String code, HBPI18NParam alias) {
        this.code = code;
        this.alias = alias;
    }

    public static FormulaKeyEnum getByAlias(String alias) {
        return FormulaKeyEnum.getAliasCacheMap().get(alias);
    }

    public static Map<String, FormulaKeyEnum> getCodeCacheMap() {
        return CODE_CACHE_MAP;
    }

    public static Map<String, FormulaKeyEnum> getAliasCacheMap() {
        if (System.currentTimeMillis() - LAST_UPDATE_TIME >= 600000L) {
            LAST_UPDATE_TIME = System.currentTimeMillis();
            for (FormulaKeyEnum formulaKeyEnum : FormulaKeyEnum.values()) {
                HBPI18NParam alias = formulaKeyEnum.alias;
                LocaleString localeString = alias.getLocaleString();
                localeString.values().forEach(lang -> ALIAS_CACHE_MAP.put((String)lang, formulaKeyEnum));
            }
        }
        return ALIAS_CACHE_MAP;
    }

    static {
        CODE_CACHE_MAP = Arrays.stream(FormulaKeyEnum.values()).collect(Collectors.toMap(FormulaKeyEnum::getCode, key -> key));
        ALIAS_CACHE_MAP = Maps.newHashMapWithExpectedSize((int)16);
        LAST_UPDATE_TIME = 0L;
    }
}

