/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.helper;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.hr.hbp.business.service.formula.helper.ExprExecutor;

public class ExprExecuteHelper {
    private static Map<String, ExprExecutor> EXPR_EXECUTOR_MAP = Maps.newHashMapWithExpectedSize((int)16);

    public static ExprExecutor getExprExecutor(String funCode) {
        ExprExecutor exprExecutor;
        if (funCode == null) {
            return null;
        }
        if (EXPR_EXECUTOR_MAP.size() == 0) {
            ExprExecuteHelper.initExprExecutorMap();
        }
        if ((exprExecutor = EXPR_EXECUTOR_MAP.get(funCode.toUpperCase(Locale.ROOT))) != null) {
            return exprExecutor;
        }
        return null;
    }

    private static void initExprExecutorMap() {
        EXPR_EXECUTOR_MAP = new HashMap<String, ExprExecutor>(16);
        EXPR_EXECUTOR_MAP.put("ROUND", new ExprExecutor("ROUND", "ROUND(%s, %s)"));
        EXPR_EXECUTOR_MAP.put("GetCurrUserId".toUpperCase(Locale.ROOT), new ExprExecutor("GetCurrUserId", "GetCurrUserId()"));
        EXPR_EXECUTOR_MAP.put("INT", new ExprExecutor("INT", "INT(%s)"));
        EXPR_EXECUTOR_MAP.put("RemoveTailZero".toUpperCase(Locale.ROOT), new ExprExecutor("RemoveTailZero", "RemoveTailZero(%s)"));
        EXPR_EXECUTOR_MAP.put("STRING", new ExprExecutor("STRING", "STRING(%s)"));
        EXPR_EXECUTOR_MAP.put("LEFT", new ExprExecutor("LEFT", "LEFT(%s , %s)"));
        EXPR_EXECUTOR_MAP.put("RIGHT", new ExprExecutor("RIGHT", "RIGHT(%s, %s)"));
        EXPR_EXECUTOR_MAP.put("REPT", new ExprExecutor("REPT", "REPT(%s, %s)"));
        EXPR_EXECUTOR_MAP.put("TRIM", new ExprExecutor("TRIM", "TRIM(%s)"));
        EXPR_EXECUTOR_MAP.put("LOWER", new ExprExecutor("LOWER", "LOWER(%s)"));
        EXPR_EXECUTOR_MAP.put("UPPER", new ExprExecutor("UPPER", "UPPER(%s)"));
        EXPR_EXECUTOR_MAP.put("FIND", new ExprExecutor("FIND", "FIND(%s, %s , %s)"));
        EXPR_EXECUTOR_MAP.put("CONCAT", new ExprExecutor("CONCAT", "CONCAT(%s)"));
        EXPR_EXECUTOR_MAP.put("SUBSTITUTE", new ExprExecutor("SUBSTITUTE", "SUBSTITUTE(%s, %s , %s , %s)"));
        EXPR_EXECUTOR_MAP.put("REPLACE", new ExprExecutor("REPLACE", "REPLACE(%s, %s , %s)"));
        EXPR_EXECUTOR_MAP.put("NOW", new ExprExecutor("NOW", "NOW()"));
        EXPR_EXECUTOR_MAP.put("TO_DATE", new ExprExecutor("TO_DATE", "TO_DATE(%s, %s , %s)"));
        EXPR_EXECUTOR_MAP.put("DATE", new ExprExecutor("DATE", "DATE(%s)"));
        EXPR_EXECUTOR_MAP.put("QUARTER", new ExprExecutor("QUARTER", "QUARTER(%s)"));
        EXPR_EXECUTOR_MAP.put("DATEDIF", new ExprExecutor("DATEDIF", "DATEDIF(%s , %s , %s)"));
        EXPR_EXECUTOR_MAP.put("EMPTY_TO_INT", new ExprExecutor("EMPTY_TO_INT", "EMPTY_TO_INT(%s , %s)"));
        EXPR_EXECUTOR_MAP.put("EMPTY_TO_NUMBER", new ExprExecutor("EMPTY_TO_NUMBER", "EMPTY_TO_NUMBER(%s, %s)"));
        EXPR_EXECUTOR_MAP.put("EMPTY_TO_TEXT", new ExprExecutor("EMPTY_TO_TEXT", "EMPTY_TO_TEXT(%s,%s)"));
        EXPR_EXECUTOR_MAP.put("SUBSTRING", new ExprExecutor("SUBSTRING", "SUBSTRING(%s,%s,%s)"));
        EXPR_EXECUTOR_MAP.put("DATEYMD", new ExprExecutor("DATE", "DATE(%s,%s,%s)"));
        EXPR_EXECUTOR_MAP.put("IF", new ExprExecutor("IF", "IF(%s,%s,%s)"));
        EXPR_EXECUTOR_MAP.put("sum".toUpperCase(Locale.ROOT), new ExprExecutor("sum", "sum(%s)"));
        EXPR_EXECUTOR_MAP.put("min".toUpperCase(Locale.ROOT), new ExprExecutor("min", "min(%s)"));
        EXPR_EXECUTOR_MAP.put("max".toUpperCase(Locale.ROOT), new ExprExecutor("max", "max(%s)"));
        EXPR_EXECUTOR_MAP.put("count".toUpperCase(Locale.ROOT), new ExprExecutor("count", "count(%s)"));
        EXPR_EXECUTOR_MAP.put("avg".toUpperCase(Locale.ROOT), new ExprExecutor("avg", "avg(%s)"));
    }

    public static BigDecimal convert2BigDecimal(Object value) {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Integer || value instanceof Long) {
            BigDecimal result = new BigDecimal(String.valueOf(value));
            return result.setScale(0);
        }
        return new BigDecimal(String.valueOf(value));
    }

    public static String convert2String(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        return String.valueOf(value);
    }

    public static Integer convert2Integer(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return Integer.valueOf(String.valueOf(value));
    }

    public static Date convert2Date(Object value) {
        if (value instanceof Date) {
            return (Date)value;
        }
        return null;
    }
}

