/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.helper;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.business.service.formula.FormulaParseService;
import kd.hr.hbp.business.service.formula.entity.FormulaInfo;
import kd.hr.hbp.business.service.formula.entity.expression.ArrayIndexExpression;
import kd.hr.hbp.business.service.formula.entity.expression.AssExpression;
import kd.hr.hbp.business.service.formula.entity.expression.BooleanExpression;
import kd.hr.hbp.business.service.formula.entity.expression.CalExpression;
import kd.hr.hbp.business.service.formula.entity.expression.DataGradeExpression;
import kd.hr.hbp.business.service.formula.entity.expression.DataGradeResultExpression;
import kd.hr.hbp.business.service.formula.entity.expression.DateExpression;
import kd.hr.hbp.business.service.formula.entity.expression.DateTimeExpression;
import kd.hr.hbp.business.service.formula.entity.expression.ExitExpression;
import kd.hr.hbp.business.service.formula.entity.expression.ExportExpression;
import kd.hr.hbp.business.service.formula.entity.expression.Expression;
import kd.hr.hbp.business.service.formula.entity.expression.FunExpression;
import kd.hr.hbp.business.service.formula.entity.expression.IntExpression;
import kd.hr.hbp.business.service.formula.entity.expression.InvokeMethodExpression;
import kd.hr.hbp.business.service.formula.entity.expression.ItemExpression;
import kd.hr.hbp.business.service.formula.entity.expression.NullExpression;
import kd.hr.hbp.business.service.formula.entity.expression.NumExpression;
import kd.hr.hbp.business.service.formula.entity.expression.OperatorExpression;
import kd.hr.hbp.business.service.formula.entity.expression.ResultExpression;
import kd.hr.hbp.business.service.formula.entity.expression.SelectItemExpression;
import kd.hr.hbp.business.service.formula.entity.expression.SpecialExpression;
import kd.hr.hbp.business.service.formula.entity.expression.StrExpression;
import kd.hr.hbp.business.service.formula.entity.floatcontrol.SelectItem;
import kd.hr.hbp.business.service.formula.entity.item.CalItem;
import kd.hr.hbp.business.service.formula.entity.item.DataGradeItem;
import kd.hr.hbp.business.service.formula.entity.item.FunctionItem;
import kd.hr.hbp.business.service.formula.entity.item.ParamItem;
import kd.hr.hbp.business.service.formula.entity.item.ResultItem;
import kd.hr.hbp.business.service.formula.entity.item.ReturnItem;
import kd.hr.hbp.business.service.formula.entity.node.OriginalNode;
import kd.hr.hbp.business.service.formula.enums.CalItemTypeEnum;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.business.service.formula.enums.ExpressionNodeTypeEnum;
import kd.hr.hbp.business.service.formula.enums.OperatorEnum;
import kd.hr.hbp.business.service.formula.utils.FormulaUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ExpressionParseHelper {
    private final FormulaInfo formula;
    private final Expression expression;
    private final OriginalNode conditionNode;

    public ExpressionParseHelper(FormulaInfo formula, Expression expression, OriginalNode conditionNode) {
        this.formula = formula;
        this.expression = expression;
        this.conditionNode = conditionNode;
    }

    public ResultExpression compile() throws KDBizException {
        return this.compile(this.expression);
    }

    public ResultExpression compile(Expression expression) throws KDBizException {
        if (expression instanceof CalExpression) {
            return this.compile((CalExpression)expression);
        }
        if (expression instanceof FunExpression) {
            return this.compile((FunExpression)expression);
        }
        if (expression instanceof ItemExpression) {
            return this.compile((ItemExpression)expression);
        }
        if (expression instanceof StrExpression) {
            return this.compile((StrExpression)expression);
        }
        if (expression instanceof IntExpression) {
            return this.compile((IntExpression)expression);
        }
        if (expression instanceof NumExpression) {
            return this.compile((NumExpression)expression);
        }
        if (expression instanceof BooleanExpression) {
            return this.compile((BooleanExpression)expression);
        }
        if (expression instanceof AssExpression) {
            return this.compile((AssExpression)expression);
        }
        if (expression instanceof DataGradeExpression) {
            return this.compile((DataGradeExpression)expression);
        }
        if (expression instanceof DateTimeExpression) {
            return this.compile((DateTimeExpression)expression);
        }
        if (expression instanceof SelectItemExpression) {
            return this.compile((SelectItemExpression)expression);
        }
        if (expression instanceof NullExpression) {
            return this.compile((NullExpression)expression);
        }
        if (expression instanceof ExitExpression) {
            return this.compile((ExitExpression)expression);
        }
        if (expression instanceof ExportExpression) {
            return this.compile((ExportExpression)expression);
        }
        if (expression instanceof ResultExpression) {
            return (ResultExpression)expression;
        }
        return null;
    }

    private ResultExpression compile(DateTimeExpression dateTimeExpression) {
        String value = dateTimeExpression.getNode().getNodeText();
        String code = String.format("HRDateTimeUtils.parseDate(%s)", value);
        return new ResultExpression(ExpressionNodeTypeEnum.RESULT, value, code, dateTimeExpression.getNode().getDataType(), dateTimeExpression, dateTimeExpression.getNode());
    }

    private ResultExpression compile(StrExpression strExpression) {
        String value = strExpression.getNode().getNodeText();
        return new ResultExpression(ExpressionNodeTypeEnum.RESULT, value, value, DataTypeEnum.TEXT, strExpression, strExpression.getNode());
    }

    private ResultExpression compile(NumExpression numExpression) {
        String value = numExpression.getNode().getNodeText();
        String code = FormulaUtils.isNumber(value) ? String.format("new BigDecimal(\"%s\")", value) : String.format("new BigDecimal(%s)", value);
        return new ResultExpression(ExpressionNodeTypeEnum.RESULT, value, code, DataTypeEnum.NUM, numExpression, numExpression.getNode());
    }

    private ResultExpression compile(BooleanExpression booleanExpression) {
        String value = booleanExpression.getNode().getNodeText();
        String code = String.format("Boolean.valueOf(\"%s\")", value);
        return new ResultExpression(ExpressionNodeTypeEnum.RESULT, value, code, DataTypeEnum.BOOLEAN, booleanExpression, booleanExpression.getNode());
    }

    private ResultExpression compile(IntExpression intExpression) {
        String value = intExpression.getNode().getNodeText();
        String code = String.format("Integer.valueOf(\"%s\")", value);
        return new ResultExpression(ExpressionNodeTypeEnum.RESULT, value, code, DataTypeEnum.INT, intExpression, intExpression.getNode());
    }

    private ResultExpression compile(AssExpression assExpression) {
        DataTypeEnum dataType;
        String code;
        CalItem calItem = assExpression.getCalItem();
        OriginalNode itemNode = assExpression.getNode();
        if (Objects.nonNull(calItem)) {
            code = calItem.getUniqueCode();
            dataType = calItem.getDataType();
            itemNode.setKeyType(assExpression.getType());
            itemNode.setUniqueKey(code);
            this.formula.addOriginalKey(itemNode);
        } else {
            dataType = assExpression.getDataType();
            code = itemNode.getUniqueKey();
        }
        return new ResultExpression(assExpression.getType(), null, code, dataType, assExpression, assExpression.getNode());
    }

    public ResultExpression compile(ItemExpression itemExpression) {
        ResultExpression itemResultExpression = this.getCalItemResultExpression(itemExpression);
        CalItem calItem = itemExpression.getCalItem();
        String uniqueCode = calItem.getUniqueCode();
        OriginalNode itemNode = itemExpression.getNode();
        itemNode.setKeyType(ExpressionNodeTypeEnum.ITEM);
        itemNode.setUniqueKey(uniqueCode);
        this.formula.addOriginalKey(itemNode);
        return itemResultExpression;
    }

    private ResultExpression compile(NullExpression nullExpression) {
        String value = nullExpression.getNode().getNodeText();
        return new ResultExpression(ExpressionNodeTypeEnum.RESULT, value, "null", DataTypeEnum.NULL, nullExpression, nullExpression.getNode());
    }

    private ResultExpression compile(ExitExpression exitExpression) {
        String value = exitExpression.getNode().getNodeText();
        ResultItem item = this.formula.getResultItem();
        String itemUniqueCode = item.getUniqueCode();
        String resultItemName = itemUniqueCode.replace('.', '_').replace('-', '_');
        if (this.formula.isProrateItemFormula()) {
            itemUniqueCode = this.formula.getId();
        }
        String code = String.format("isExit = true;\n    addResultValue(\"%s\",%s,sectionKey);\n    break", itemUniqueCode, resultItemName);
        return new ResultExpression(ExpressionNodeTypeEnum.EXIT, value, code, DataTypeEnum.NULL, exitExpression, exitExpression.getNode());
    }

    private ResultExpression getCalItemResultExpression(ItemExpression itemExpression) {
        CalItem calItem = itemExpression.getCalItem();
        DataTypeEnum itemType = calItem.getDataType();
        String uniqueCode = calItem.getUniqueCode();
        return new ResultExpression(ExpressionNodeTypeEnum.RESULT, null, uniqueCode, itemType, itemExpression, itemExpression.getNode());
    }

    /*
     * Enabled aggressive block sorting
     */
    public ResultExpression compile(FunExpression funExpression) throws KDBizException {
        OriginalNode funNode = funExpression.getNode();
        FunctionItem functionItem = funExpression.getFunctionItem();
        List<ParamItem> paramList = functionItem.getParams();
        int index = 0;
        StringBuilder funcCode = new StringBuilder();
        funcCode.append(functionItem.getDefine());
        funcCode.append('(');
        Iterator<Expression> iterator = funExpression.getParameter().iterator();
        while (true) {
            DataTypeEnum paramDataType;
            ResultExpression paramResult;
            block11: {
                block9: {
                    OriginalNode node;
                    Expression paramExp;
                    block10: {
                        if (!iterator.hasNext()) {
                            funcCode.append(')');
                            funNode.setKeyType(ExpressionNodeTypeEnum.FUN);
                            funNode.setUniqueKey(functionItem.getUniqueCode());
                            this.formula.addOriginalKey(funNode);
                            return new ResultExpression(ExpressionNodeTypeEnum.RESULT, funcCode.toString(), funcCode.toString(), DataTypeEnum.getDataType(functionItem.getFuncDataType()), funExpression, funNode);
                        }
                        paramExp = iterator.next();
                        paramResult = this.compile(paramExp);
                        ParamItem paramItem = paramList.get(index);
                        paramDataType = paramItem.getParamDataType();
                        if (!this.isNotSameType(paramDataType, paramResult.getDataType())) break block9;
                        if (DataTypeEnum.OBJECT == paramDataType) break block10;
                        if (DataTypeEnum.TEXT == paramDataType && (DataTypeEnum.DATE == paramResult.getDataType() || DataTypeEnum.DATETIME == paramResult.getDataType())) {
                            node = paramExp.getNode();
                            if (FormulaUtils.isString(node.getNodeText())) {
                                paramResult = this.compile(new StrExpression(node));
                            }
                            break block11;
                        } else {
                            String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u51fd\u6570\u201c{2}\u201d\u7684\u7b2c{3}\u4e2a\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u51fd\u6570\u201c{4}\u201d\u7684\u7b2c{5}\u4e2a\u53c2\u6570\u7684\u6570\u636e\u7c7b\u578b\u5fc5\u987b\u662f{6}\uff0c\u800c\u7ef4\u62a4\u7684\u53c2\u6570\u6570\u636e\u7c7b\u578b\u4e3a{7}\u3002", (String)"ExpressionParseHelper_1", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                            throw new KDBizException(MessageFormat.format(msg, funNode.getLineIndex() + 1, funNode.getEndColumnIndex() + 1, funNode.getNodeText(), index + 1, funNode.getNodeText(), index + 1, paramDataType.getAlias(), paramResult.getDataType().getAlias()));
                        }
                    }
                    if ((DataTypeEnum.DATE == paramResult.getDataType() || DataTypeEnum.DATETIME == paramResult.getDataType()) && FormulaUtils.isString((node = paramExp.getNode()).getNodeText())) {
                        paramResult = this.compile(new StrExpression(node));
                    }
                    break block11;
                }
                if (DataTypeEnum.TEXT == paramDataType && DataTypeEnum.TEXT == paramResult.getDataType()) {
                    paramResult = this.checkAndConvertEnumSelectExpression(paramResult);
                }
            }
            String paramCode = this.getParamCode(paramResult, paramDataType);
            if (index == 0) {
                funcCode.append(paramCode);
            } else {
                funcCode.append(',').append(paramCode);
            }
            ++index;
        }
    }

    public ResultExpression compile(DataGradeExpression dataGradeExpression) throws KDBizException {
        OriginalNode dataGradeNode = dataGradeExpression.getNode();
        DataGradeItem dataGradeItem = dataGradeExpression.getDataGradeItem();
        List<ParamItem> paramList = dataGradeItem.getDataGradeParams();
        int index = 0;
        StringBuilder funcCode = new StringBuilder();
        ResultExpression resultExpression = this.compile(dataGradeExpression.getResultExpression());
        DataTypeEnum resultDataType = resultExpression.getDataType();
        String dataGradeMethodName = this.getDataGradeMethodName(resultDataType);
        funcCode.append(dataGradeMethodName);
        funcCode.append('(');
        funcCode.append('\"').append(dataGradeItem.getUniqueCode()).append('\"').append(", ");
        funcCode.append(resultExpression.getCode());
        ArrayList<String> paramCode = new ArrayList<String>(dataGradeExpression.getParameter().size());
        for (Expression paramExp : dataGradeExpression.getParameter()) {
            ResultExpression paramResult = this.compile(paramExp);
            ParamItem paramItem = paramList.get(index);
            DataTypeEnum paramDataType = paramItem.getParamDataType();
            if (this.isNotSameType(paramDataType, paramResult.getDataType())) {
                OriginalNode node;
                boolean isError = true;
                if (DataTypeEnum.BASE == paramDataType && (DataTypeEnum.TEXT == paramResult.getDataType() || DataTypeEnum.DATETIME == paramResult.getDataType() || DataTypeEnum.DATE == paramResult.getDataType()) && HRStringUtils.isNotEmpty((String)paramItem.getEntityNumber())) {
                    CalItem calItem;
                    Map<String, CalItem> entityNumberCalItemMap;
                    Expression originalExp = paramResult.getOriginalExp();
                    if ((originalExp instanceof StrExpression || originalExp instanceof DateExpression) && (entityNumberCalItemMap = this.formula.getEntityNumberBaseDataCalItemMap()) != null && (calItem = entityNumberCalItemMap.get(paramItem.getEntityNumber())) != null) {
                        OriginalNode originalNode = originalExp.getNode();
                        Expression selectOrStrExpression = null;
                        if (CalItemTypeEnum.BASE_DATA == calItem.getItemType() && HRStringUtils.isNotEmpty((String)calItem.getEntityNumber()) && HRStringUtils.isNotEmpty((String)calItem.getPropertyField())) {
                            selectOrStrExpression = FormulaParseService.getBaseDataOrStrExpression(originalNode, calItem);
                        }
                        if (selectOrStrExpression instanceof SelectItemExpression) {
                            paramResult = this.compile(selectOrStrExpression);
                            isError = false;
                        }
                    }
                } else if (DataTypeEnum.TEXT == paramDataType && (DataTypeEnum.DATETIME == paramResult.getDataType() || DataTypeEnum.DATE == paramResult.getDataType()) && FormulaUtils.isString((node = paramExp.getNode()).getNodeText())) {
                    paramResult = this.compile(new StrExpression(node));
                    isError = false;
                }
                if (isError) {
                    String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6570\u636e\u5206\u7ea7\u201c{2}\u201d\u7684\u7b2c{3}\u4e2a\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u6570\u636e\u5206\u7ea7\u201c{4}\u201d\u7684\u7b2c{5}\u4e2a\u53c2\u6570\u7684\u6570\u636e\u7c7b\u578b\u5fc5\u987b\u662f{6}\uff0c\u800c\u7ef4\u62a4\u7684\u53c2\u6570\u6570\u636e\u7c7b\u578b\u4e3a{7}\u3002", (String)"ExpressionParseHelper_3", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                    throw new KDBizException(MessageFormat.format(msg, dataGradeNode.getLineIndex() + 1, dataGradeNode.getEndColumnIndex() + 1, dataGradeNode.getNodeText(), index + 1, dataGradeNode.getNodeText(), index + 1, paramDataType.getAlias(), paramResult.getDataType().getAlias()));
                }
            } else if (DataTypeEnum.TEXT == paramDataType && DataTypeEnum.TEXT == paramResult.getDataType()) {
                paramResult = this.checkAndConvertEnumSelectExpression(paramResult);
            }
            paramCode.add(this.getParamCode(paramResult, paramDataType));
            ++index;
        }
        funcCode.append(',').append(String.format("new Object[] {%s}", StringUtils.join(paramCode, (String)",")));
        funcCode.append(')');
        dataGradeNode.setKeyType(ExpressionNodeTypeEnum.DATA_GRADE);
        dataGradeNode.setUniqueKey(dataGradeItem.getUniqueCode());
        this.formula.addOriginalKey(dataGradeNode);
        return new ResultExpression(ExpressionNodeTypeEnum.RESULT, funcCode.toString(), funcCode.toString(), resultDataType, dataGradeExpression, dataGradeNode);
    }

    private ResultExpression checkAndConvertEnumSelectExpression(ResultExpression paramResult) {
        Expression selectOrStrExpression;
        OriginalNode originalNode;
        List<CalItem> calItems;
        Map<String, List<CalItem>> enumValueToCalItemMap;
        Expression originalExp = paramResult.getOriginalExp();
        if (originalExp instanceof StrExpression && (enumValueToCalItemMap = this.formula.getEnumValueToCalItemMap()) != null && (calItems = enumValueToCalItemMap.get((originalNode = ((StrExpression)originalExp).getNode()).getNodeText())) != null && !calItems.isEmpty() && (selectOrStrExpression = FormulaParseService.getEnumOrStrExpression(originalNode, calItems.get(0))) instanceof SelectItemExpression) {
            paramResult = this.compile(selectOrStrExpression);
        }
        return paramResult;
    }

    public ResultExpression compile(SelectItemExpression selectItemExpression) {
        String code;
        SelectItem selectItem = selectItemExpression.getSelectItem();
        DataTypeEnum dataType = selectItem.getDataType();
        OriginalNode node = selectItemExpression.getNode();
        if (DataTypeEnum.BASE == dataType) {
            code = String.format("getDynamicObjectByEntityNumberAndId(\"%s\",\"%s\")", selectItem.getEntityNumber(), selectItem.getExecuteValue());
            this.formula.addBaseDataUniqueCodeSet(selectItem.getUniqueKey());
        } else {
            code = "\"" + selectItem.getExecuteValue() + "\"";
            if (HRStringUtils.isNotEmpty((String)selectItem.getUniqueKey())) {
                this.formula.addEnumUniqueCodeSet(selectItem.getUniqueKey());
            }
        }
        node.setKeyType(ExpressionNodeTypeEnum.SELECT_ITEM);
        node.setUniqueKey(selectItem.getUniqueKey());
        if (HRStringUtils.isNotEmpty((String)node.getUniqueKey())) {
            this.formula.addOriginalKey(node);
        }
        return new ResultExpression(ExpressionNodeTypeEnum.RESULT, node.getNodeText(), code, dataType, selectItemExpression, node);
    }

    public ResultExpression compile(ExportExpression exportExpression) {
        List<Expression> exportItems = exportExpression.getExportItems();
        OriginalNode expressionNode = exportExpression.getNode();
        this.formula.addOriginalKey(expressionNode);
        for (Expression exportItem : exportItems) {
            CalItem calItem;
            if (!(exportItem instanceof AssExpression) || (calItem = ((AssExpression)exportItem).getCalItem()) == null) continue;
            if (calItem.isCustomItem()) {
                this.formula.addOutputCustomCalItem(calItem);
            } else {
                this.formula.addOutputCalItem(calItem);
            }
            this.formula.addOriginalKey(exportItem.getNode());
        }
        return new ResultExpression(ExpressionNodeTypeEnum.EXPORT, "", "", null, expressionNode);
    }

    @NotNull
    private String getDataGradeMethodName(DataTypeEnum resultDataType) {
        switch (resultDataType) {
            case INT: {
                return "getDataGradeResultToInteger";
            }
            case NUM: 
            case MONEY: {
                return "getDataGradeResultToBigDecimal";
            }
            case BASE: {
                return "getDataGradeResultToDynamicObject";
            }
            case DATE: {
                return "getDataGradeResultToDate";
            }
        }
        return "getDataGradeResultToString";
    }

    private String getParamCode(ResultExpression paramResult, DataTypeEnum paramDataType) {
        String paramCode = paramDataType == DataTypeEnum.BOOLEAN && paramResult.getDataType() == DataTypeEnum.INT ? (HRStringUtils.equals((String)"0", (String)paramResult.getOriginalCode()) ? "Boolean.valueOf(false)" : "Boolean.valueOf(true)") : ((paramDataType == DataTypeEnum.NUM || paramDataType == DataTypeEnum.MONEY) && paramResult.getDataType() == DataTypeEnum.INT ? String.format("new BigDecimal(String.valueOf(%s))", paramResult.getCode()) : paramResult.getCode());
        return paramCode;
    }

    private ResultExpression compile(DataGradeResultExpression dataGradeResultExpression) {
        ReturnItem returnItem = dataGradeResultExpression.getReturnItem();
        String resultDataTypeStr = returnItem.getReturnDataType();
        String valueKey = returnItem.getReturnValueKey();
        DataTypeEnum dataType = DataTypeEnum.getDataType(resultDataTypeStr);
        if (Objects.isNull((Object)dataType)) {
            dataType = DataTypeEnum.TEXT;
        }
        String code = String.format("\"%s\"", valueKey);
        return new ResultExpression(ExpressionNodeTypeEnum.RESULT, dataGradeResultExpression.getNode().getNodeText(), code, dataType, dataGradeResultExpression, dataGradeResultExpression.getNode());
    }

    private boolean isNotSameType(DataTypeEnum dataType1, DataTypeEnum dataType2) {
        if (!(DataTypeEnum.NUM != dataType1 && DataTypeEnum.MONEY != dataType1 || DataTypeEnum.INT != dataType2 && DataTypeEnum.MONEY != dataType2 && DataTypeEnum.NUM != dataType2)) {
            return false;
        }
        if (dataType1 == DataTypeEnum.BOOLEAN && dataType2 == DataTypeEnum.INT) {
            return false;
        }
        if (dataType2 == DataTypeEnum.NULL) {
            return false;
        }
        if (!(DataTypeEnum.DATE != dataType1 && DataTypeEnum.DATETIME != dataType1 || DataTypeEnum.DATE != dataType2 && DataTypeEnum.DATETIME != dataType2)) {
            return false;
        }
        return dataType1 != dataType2;
    }

    public ResultExpression compile(CalExpression calExpression) throws KDBizException {
        Stack<Expression> calStack = this.getCalStack(calExpression.getParameter());
        Stack<Expression> resultStack = new Stack<Expression>();
        for (Expression exp : calStack) {
            ResultExpression resExp;
            Expression previousExp;
            ResultExpression resultExp;
            if (exp instanceof StrExpression || exp instanceof IntExpression || exp instanceof NumExpression || exp instanceof ResultExpression || exp instanceof BooleanExpression || exp instanceof DateTimeExpression || exp instanceof SelectItemExpression || exp instanceof NullExpression) {
                resultStack.push(exp);
                continue;
            }
            if (exp instanceof ItemExpression) {
                resultExp = this.compile((ItemExpression)exp);
                resultStack.push(resultExp);
                continue;
            }
            if (exp instanceof OperatorExpression) {
                this.pushResultExpressionToStack(resultStack, exp);
                continue;
            }
            if (exp instanceof AssExpression) {
                resultExp = this.compile((AssExpression)exp);
                resultStack.push(resultExp);
                continue;
            }
            if (exp instanceof SpecialExpression) {
                ResultExpression result = this.compile(resultStack.pop());
                if (result == null) continue;
                result.setCode(String.format("(%s)", result.getCode()));
                resultStack.push(result);
                continue;
            }
            if (exp instanceof ArrayIndexExpression) {
                ArrayIndexExpression arrayExp = (ArrayIndexExpression)exp;
                previousExp = resultStack.peek();
                if (!(previousExp instanceof ResultExpression)) continue;
                resExp = (ResultExpression)previousExp;
                resExp.setCode(resExp.getCode() + arrayExp.getCode());
                resExp.setOriginalCode(resExp.getOriginalCode() + arrayExp.getCode());
                resExp.setDataType(DataTypeEnum.changeArrayToSingleType(resExp.getDataType()));
                continue;
            }
            if (!(exp instanceof InvokeMethodExpression)) continue;
            InvokeMethodExpression invokeExp = (InvokeMethodExpression)exp;
            previousExp = resultStack.peek();
            if (!(previousExp instanceof ResultExpression)) continue;
            resExp = (ResultExpression)previousExp;
            resExp.setCode(invokeExp.boxCode(resExp.getCode() + invokeExp.getCode()));
            resExp.setOriginalCode(resExp.getOriginalCode() + invokeExp.getNode().getNodeText());
            resExp.setDataType(invokeExp.getReturnDataType());
        }
        Expression express = (Expression)resultStack.pop();
        if (!(express instanceof ResultExpression)) {
            if (this.conditionNode != null) {
                String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5173\u952e\u5b57[{2}]\u540e\u9762\u7684\u8868\u8fbe\u5f0f\u7ef4\u62a4\u4e0d\u6b63\u786e\u3002", (String)"ExpressionParseHelper_4", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, this.conditionNode.getLineIndex() + 1, this.conditionNode.getStartColumnIndex() + 1, this.conditionNode.getNodeText()));
            }
            String errorMsg = ResManager.loadKDString((String)"\u7ed3\u679c\u8868\u8fbe\u5f0f\u7ef4\u62a4\u4e0d\u6b63\u786e\u3002", (String)"ExpressionParseHelper_5", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        return (ResultExpression)express;
    }

    private void pushResultExpressionToStack(Stack<Expression> resultStack, Expression exp) throws KDBizException {
        OperatorEnum operatorEnum = FormulaUtils.getOperatorEnum((OperatorExpression)exp);
        OriginalNode operatorNode = ((OperatorExpression)exp).getNode();
        if (resultStack.size() < 2) {
            if (operatorEnum == OperatorEnum.LPARENTHESES) {
                String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u7f3a\u5c11\u4e0e\u5de6\u62ec\u53f7\u201c{2}\u201d\u5339\u914d\u7684\u53f3\u62ec\u53f7\u201c{3}\u201d\u3002", (String)"ExpressionParseHelper_6", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, operatorNode.getLineIndex() + 1, operatorNode.getStartColumnIndex() + 1, OperatorEnum.LPARENTHESES.getAlias(), OperatorEnum.RPARENTHESES.getAlias()));
            }
            if (operatorEnum != OperatorEnum.ASSIGNMENT) {
                String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8fd0\u7b97\u7b26\u201c{2}\u201d\u6240\u5728\u7684\u8868\u8fbe\u5f0f\u4e0d\u5b8c\u6574\u3002", (String)"ExpressionParseHelper_7", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, operatorNode.getLineIndex() + 1, operatorNode.getStartColumnIndex() + 1, operatorNode.getNodeText()));
            }
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8fd0\u7b97\u7b26\u201c{2}\u201d\u6240\u5728\u7684\u8d4b\u503c\u8868\u8fbe\u5f0f\u4e0d\u5b8c\u6574\u6216\u540e\u9762\u5b58\u5728\u5176\u4ed6\u8bed\u6cd5\u9519\u8bef\u7684\u8ba1\u7b97\u7b26\u53f7\u3002", (String)"ExpressionParseHelper_22", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, operatorNode.getLineIndex() + 1, operatorNode.getStartColumnIndex() + 1, OperatorEnum.EQUAL.getAlias()));
        }
        Expression calExp2 = resultStack.pop();
        Expression calExp1 = resultStack.pop();
        ResultExpression result1 = this.compile(calExp1);
        ResultExpression result2 = this.compile(calExp2);
        ResultExpression resultExp = null;
        if (operatorEnum == OperatorEnum.PLUS || operatorEnum == OperatorEnum.SUBTRACT || operatorEnum == OperatorEnum.MULTIPLY || operatorEnum == OperatorEnum.DIVIDE) {
            resultExp = this.getCalResultExpression(operatorEnum, operatorNode, result1, result2);
        } else if (operatorEnum == OperatorEnum.EQUAL || operatorEnum == OperatorEnum.UNEQUAL) {
            resultExp = this.getEqualOrUnEqualResultExpression(operatorEnum, operatorNode, result1, result2);
        } else if (operatorEnum == OperatorEnum.GT || operatorEnum == OperatorEnum.GTOREQUAL || operatorEnum == OperatorEnum.LT || operatorEnum == OperatorEnum.LTOREQUAL) {
            resultExp = this.getCompareResultExpression(operatorEnum, operatorNode, result1, result2);
        } else if (operatorEnum == OperatorEnum.AND || operatorEnum == OperatorEnum.OR) {
            resultExp = this.getConditionResultExpression(operatorEnum, operatorNode, result1, result2);
        } else if (operatorEnum == OperatorEnum.ASSIGNMENT) {
            resultExp = this.getAssResultExpression(operatorEnum, operatorNode, result1, result2);
        } else if (operatorEnum == OperatorEnum.CONTAIN) {
            resultExp = this.getContainsResultExpression(operatorEnum, operatorNode, result1, result2);
        }
        resultStack.push(resultExp);
    }

    @NotNull
    private ResultExpression getContainsResultExpression(OperatorEnum operatorEnum, OriginalNode operatorNode, ResultExpression result1, ResultExpression result2) {
        if (result1.getDataType() != DataTypeEnum.TEXT) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5173\u952e\u5b57\u201c{3}\u201d\u5de6\u8fb9\u8868\u8fbe\u5f0f\u7684\u8fd4\u56de\u503c\u6570\u636e\u7c7b\u578b\u4e3a{2}\uff0c\u800c\u201c{3}\u201d\u5de6\u53f3\u4e24\u8fb9\u7684\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u5fc5\u987b\u662f\u201c{4}\u201d\u3002", (String)"ExpressionParseHelper_8", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, operatorNode.getLineIndex() + 1, operatorNode.getStartColumnIndex() + 1, result1.getDataType().getAlias(), OperatorEnum.CONTAIN.getAlias(), DataTypeEnum.TEXT.getAlias()));
        }
        if (result2.getDataType() != DataTypeEnum.TEXT) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5173\u952e\u5b57\u201c{3}\u201d\u53f3\u8fb9\u8868\u8fbe\u5f0f\u7684\u8fd4\u56de\u503c\u6570\u636e\u7c7b\u578b\u4e3a{2}\uff0c\u800c\u201c{3}\u201d\u5de6\u53f3\u4e24\u8fb9\u7684\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u5fc5\u987b\u662f\u201c{4}\u201d\u3002", (String)"ExpressionParseHelper_9", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, operatorNode.getLineIndex() + 1, operatorNode.getStartColumnIndex() + 1, result2.getDataType().getAlias(), OperatorEnum.CONTAIN.getAlias(), DataTypeEnum.TEXT.getAlias()));
        }
        operatorNode.setUniqueKey(operatorEnum.getName());
        String code = String.format("%s.contains(%s)", result1.getCode(), result2.getCode());
        ResultExpression resultExp = new ResultExpression(ExpressionNodeTypeEnum.RESULT, code, code, DataTypeEnum.BOOLEAN, operatorNode);
        return resultExp;
    }

    private ResultExpression getAssResultExpression(OperatorEnum operatorEnum, OriginalNode operatorNode, ResultExpression result1, ResultExpression result2) {
        DataTypeEnum dataType = null;
        String tempCode = null;
        Expression originalExp = result1.getOriginalExp();
        if (result1.getDataType() != result2.getDataType()) {
            CalItem calItem;
            boolean isError = true;
            if (result1.getDataType() == DataTypeEnum.INT && (result2.getDataType() == DataTypeEnum.NUM || result2.getDataType() == DataTypeEnum.MONEY || result2.getDataType() == DataTypeEnum.OBJECT)) {
                tempCode = String.format(Locale.ROOT, "new Integer(new BigDecimal(String.valueOf(%s)).intValue())", result2.getCode());
                dataType = result1.getDataType();
                isError = false;
            } else if (!(result1.getDataType() != DataTypeEnum.NUM && result1.getDataType() != DataTypeEnum.MONEY || result2.getDataType() != DataTypeEnum.INT && result2.getDataType() != DataTypeEnum.MONEY && result2.getDataType() != DataTypeEnum.NUM && result2.getDataType() != DataTypeEnum.OBJECT)) {
                tempCode = String.format(Locale.ROOT, "new BigDecimal(String.valueOf(%s))", result2.getCode());
                dataType = result1.getDataType();
                isError = false;
            } else if (result2.getDataType() == DataTypeEnum.NULL) {
                tempCode = result2.getCode();
                dataType = result2.getDataType();
                isError = false;
            } else if (!(result1.getDataType() != DataTypeEnum.DATETIME && result1.getDataType() != DataTypeEnum.DATE || result2.getDataType() != DataTypeEnum.DATE && result2.getDataType() != DataTypeEnum.DATETIME && result2.getDataType() != DataTypeEnum.OBJECT)) {
                tempCode = String.format(Locale.ROOT, "new DateTime(%s).toDate()", result2.getCode());
                dataType = result1.getDataType();
                isError = false;
            } else if (result1.getDataType() == DataTypeEnum.OBJECT) {
                tempCode = result2.getCode();
                dataType = result1.getDataType();
                isError = false;
            } else if (result2.getDataType() == DataTypeEnum.OBJECT) {
                dataType = result1.getDataType();
                tempCode = result1.getDataType() == DataTypeEnum.TEXT ? String.format(Locale.ROOT, "String.valueOf(%s)", result2.getCode()) : (result1.getDataType() == DataTypeEnum.BOOLEAN ? String.format(Locale.ROOT, "Boolean.parseBoolean(String.valueOf(%s))", result2.getCode()) : (result1.getDataType() == DataTypeEnum.BASE ? String.format(Locale.ROOT, "((DynamicObject) %s)", result2.getCode()) : result2.getCode()));
                isError = false;
            } else if (result1.getDataType() == DataTypeEnum.BASE && result2.getDataType() == DataTypeEnum.TEXT && originalExp instanceof AssExpression && result2.getOriginalExp() instanceof StrExpression && HRStringUtils.isNotEmpty((String)(calItem = ((AssExpression)originalExp).getCalItem()).getEntityNumber())) {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)calItem.getEntityNumber());
                String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8ba1\u7b97\u9879\u76ee\u201c{2}\u201d\u7684\u201c=\u201d\u8d4b\u503c\u64cd\u4f5c\u5fc5\u987b\u8d4b\u503c\u201c{3}\u201d\u7c7b\u578b\u7684\u57fa\u7840\u8d44\u6599\u6570\u636e\u3002", (String)"ExpressionParseHelper_23", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, operatorNode.getLineIndex() + 1, operatorNode.getStartColumnIndex() + 1, calItem.getName(), entityType.getDisplayName().getLocaleValue()));
            }
            if (isError) {
                String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8fd0\u7b97\u7b26\u201c=\u201d\u4e24\u8fb9\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u5fc5\u987b\u4e00\u81f4\u3002", (String)"ExpressionParseHelper_10", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, operatorNode.getLineIndex() + 1, operatorNode.getStartColumnIndex() + 1));
            }
        } else if (result1.getDataType() == result2.getDataType() && result1.getDataType() == DataTypeEnum.TEXT) {
            tempCode = String.format("String.valueOf(%s)", result2.getCode());
            dataType = DataTypeEnum.TEXT;
        } else {
            tempCode = result2.getCode();
            dataType = result1.getDataType();
        }
        String code = String.format("%s%s%s", result1.getCode(), operatorEnum == OperatorEnum.ASSIGNMENT ? "=" : operatorEnum.getCode(), tempCode);
        if (originalExp instanceof ItemExpression) {
            this.formula.addCalItemValueChange(((ItemExpression)originalExp).getCalItem());
        }
        return new ResultExpression(ExpressionNodeTypeEnum.ASS, code, code, dataType, originalExp, originalExp.getNode());
    }

    private ResultExpression getCalResultExpression(OperatorEnum operatorEnum, OriginalNode operatorNode, ResultExpression result1, ResultExpression result2) throws KDBizException {
        DataTypeEnum dataType;
        if (result1.getDataType() == DataTypeEnum.INT && result2.getDataType() == DataTypeEnum.INT) {
            dataType = operatorEnum == OperatorEnum.PLUS || operatorEnum == OperatorEnum.SUBTRACT ? DataTypeEnum.INT : DataTypeEnum.NUM;
        } else {
            if (result1.getDataType() != DataTypeEnum.NUM && result1.getDataType() != DataTypeEnum.MONEY) {
                if (result1.getDataType() == DataTypeEnum.INT) {
                    result1.setCode(String.format("new BigDecimal(String.valueOf(%s))", result1.getCode()));
                } else {
                    String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8fd0\u7b97\u7b26\u201c{2}\u201d\u5de6\u8fb9\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u662f{3}\uff0c\u800c\u52a0\u3001\u51cf\u3001\u4e58\u3001\u9664\u7b49\u8fd0\u7b97\u7b26\u5de6\u53f3\u4e24\u8fb9\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u5fc5\u987b\u662f\u6570\u503c\u3002", (String)"ExpressionParseHelper_11", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                    throw new KDBizException(MessageFormat.format(errorMsg, operatorNode.getLineIndex() + 1, operatorNode.getStartColumnIndex() + 1, operatorNode.getNodeText(), result1.getDataType().getAlias()));
                }
            }
            if (result2.getDataType() != DataTypeEnum.NUM && result2.getDataType() != DataTypeEnum.MONEY) {
                if (result2.getDataType() == DataTypeEnum.INT) {
                    result2.setCode(String.format("new BigDecimal(String.valueOf(%s))", result2.getCode()));
                } else {
                    String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8fd0\u7b97\u7b26\u201c{2}\u201d\u53f3\u8fb9\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u662f{3}\uff0c\u800c\u52a0\u3001\u51cf\u3001\u4e58\u3001\u9664\u7b49\u8fd0\u7b97\u7b26\u5de6\u53f3\u4e24\u8fb9\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u5fc5\u987b\u662f\u6570\u503c\u3002", (String)"ExpressionParseHelper_12", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                    throw new KDBizException(MessageFormat.format(errorMsg, operatorNode.getLineIndex() + 1, operatorNode.getStartColumnIndex() + 1, operatorNode.getNodeText(), result2.getDataType().getAlias()));
                }
            }
            dataType = DataTypeEnum.NUM;
        }
        String code = String.format("%s(%s,%s)", operatorEnum.getCode(), result1.getCode(), result2.getCode());
        return new ResultExpression(ExpressionNodeTypeEnum.RESULT, code, code, dataType, operatorNode);
    }

    private ResultExpression getEqualOrUnEqualResultExpression(OperatorEnum operatorEnum, OriginalNode operatorNode, ResultExpression result1, ResultExpression result2) throws KDBizException {
        String code;
        if (result1.getDataType() == DataTypeEnum.NULL || result2.getDataType() == DataTypeEnum.NULL || result1.getDataType() == DataTypeEnum.TEXT && result2.getDataType() == DataTypeEnum.TEXT || result1.getDataType() == DataTypeEnum.INT && result2.getDataType() == DataTypeEnum.INT || result1.getDataType() == DataTypeEnum.BOOLEAN && result2.getDataType() == DataTypeEnum.BOOLEAN || this.isDateCompare(result1.getDataType(), result2.getDataType()) || result1.getDataType() == DataTypeEnum.BASE && result2.getDataType() == DataTypeEnum.BASE) {
            code = this.isDateCompare(result1.getDataType(), result2.getDataType()) && this.checkDateCompareNotIncludeHourMinSec(result1, result2) ? String.format("%s(%s,%s,false)", operatorEnum.getCode(), result1.getCode(), result2.getCode()) : String.format("%s(%s,%s)", operatorEnum.getCode(), result1.getCode(), result2.getCode());
        } else if (DataTypeEnum.checkAndChangeIsNumType(result1.getDataType(), result2.getDataType())) {
            this.changeResultExpressionCodeToBigDecimal(result1, result2);
            code = String.format("%s(%s,%s)", operatorEnum.getCode(), result1.getCode(), result2.getCode());
        } else {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8fd0\u7b97\u7b26\u201c{2}\u201d\u5de6\u53f3\u4e24\u8fb9\u7684\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u5de6\u8fb9\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e3a{3}\uff0c\u53f3\u8fb9\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e3a{4}\u3002", (String)"ExpressionParseHelper_13", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, operatorNode.getLineIndex() + 1, operatorNode.getStartColumnIndex() + 1, operatorNode.getNodeText(), result1.getDataType().getAlias(), result2.getDataType().getAlias()));
        }
        return new ResultExpression(ExpressionNodeTypeEnum.RESULT, code, code, DataTypeEnum.BOOLEAN, operatorNode);
    }

    private ResultExpression getCompareResultExpression(OperatorEnum operatorEnum, OriginalNode operatorNode, ResultExpression result1, ResultExpression result2) throws KDBizException {
        String code;
        if (result1.getDataType() == DataTypeEnum.INT && result2.getDataType() == DataTypeEnum.INT || this.isDateCompare(result1.getDataType(), result2.getDataType())) {
            code = this.isDateCompare(result1.getDataType(), result2.getDataType()) && this.checkDateCompareNotIncludeHourMinSec(result1, result2) ? String.format("%s(%s,%s,false)", operatorEnum.getCode(), result1.getCode(), result2.getCode()) : String.format("%s(%s,%s)", operatorEnum.getCode(), result1.getCode(), result2.getCode());
        } else if (DataTypeEnum.checkAndChangeIsNumType(result1.getDataType(), result2.getDataType())) {
            this.changeResultExpressionCodeToBigDecimal(result1, result2);
            code = String.format("%s(%s,%s)", operatorEnum.getCode(), result1.getCode(), result2.getCode());
        } else {
            if (result1.getDataType() != DataTypeEnum.INT && result1.getDataType() != DataTypeEnum.NUM && result1.getDataType() != DataTypeEnum.DATE && result1.getDataType() != DataTypeEnum.DATETIME && result1.getDataType() != DataTypeEnum.MONEY) {
                String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8fd0\u7b97\u7b26\u53f7\u201c{2}\u201d\u5de6\u8fb9\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e3a{3}\uff0c\u4e0d\u6b63\u786e\uff0c\u5927\u4e8e\u3001\u5c0f\u4e8e\u3001\u5927\u4e8e\u7b49\u4e8e\u548c\u5c0f\u4e8e\u7b49\u4e8e\u7b49\u8fd0\u7b97\u7b26\u53f7\u5de6\u53f3\u4e24\u8fb9\u7684\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u5fc5\u987b\u90fd\u662f\u6570\u503c\u6216\u65e5\u671f\u3002", (String)"ExpressionParseHelper_14", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, operatorNode.getLineIndex() + 1, operatorNode.getStartColumnIndex() + 1, operatorNode.getNodeText(), result1.getDataType().getAlias()));
            }
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u8fd0\u7b97\u7b26\u53f7\u201c{2}\u201d\u53f3\u8fb9\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e3a{3}\uff0c\u4e0d\u6b63\u786e\uff0c\u5927\u4e8e\u3001\u5c0f\u4e8e\u3001\u5927\u4e8e\u7b49\u4e8e\u548c\u5c0f\u4e8e\u7b49\u4e8e\u7b49\u8fd0\u7b97\u7b26\u53f7\u5de6\u53f3\u4e24\u8fb9\u7684\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u5fc5\u987b\u90fd\u662f\u6570\u503c\u6216\u65e5\u671f\u3002", (String)"ExpressionParseHelper_15", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, operatorNode.getLineIndex() + 1, operatorNode.getStartColumnIndex() + 1, operatorNode.getNodeText(), result2.getDataType().getAlias()));
        }
        return new ResultExpression(ExpressionNodeTypeEnum.RESULT, code, code, DataTypeEnum.BOOLEAN, operatorNode);
    }

    private ResultExpression getConditionResultExpression(OperatorEnum operatorEnum, OriginalNode operatorNode, ResultExpression result1, ResultExpression result2) throws KDBizException {
        if (result1.getDataType() != DataTypeEnum.BOOLEAN) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6761\u4ef6\u8bed\u53e5\u201c{2}\u201d\u5de6\u8fb9\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e0d\u662f\u903b\u8f91\u7c7b\u578b\u3002", (String)"ExpressionParseHelper_16", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, operatorNode.getLineIndex() + 1, operatorNode.getStartColumnIndex() + 1, operatorNode.getNodeText()));
        }
        if (result2.getDataType() != DataTypeEnum.BOOLEAN) {
            String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u6761\u4ef6\u8bed\u53e5\u201c{2}\u201d\u53f3\u8fb9\u8868\u8fbe\u5f0f\u8fd4\u56de\u503c\u7684\u6570\u636e\u7c7b\u578b\u4e0d\u662f\u903b\u8f91\u7c7b\u578b\u3002", (String)"ExpressionParseHelper_17", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(errorMsg, operatorNode.getLineIndex() + 1, operatorNode.getStartColumnIndex() + 1, operatorNode.getNodeText()));
        }
        String code = String.format("%s%s%s", result1.getCode(), operatorEnum.getCode(), result2.getCode());
        operatorNode.setKeyType(ExpressionNodeTypeEnum.OPERATOR);
        operatorNode.setUniqueKey(operatorEnum.getName());
        this.formula.addOriginalKey(operatorNode);
        return new ResultExpression(ExpressionNodeTypeEnum.RESULT, code, code, DataTypeEnum.BOOLEAN, operatorNode);
    }

    private Stack<Expression> getCalStack(List<Expression> list) throws KDBizException {
        Stack<Expression> calStack = new Stack<Expression>();
        Stack<Expression> operatorStack = new Stack<Expression>();
        Expression previousExp = null;
        int size = list.size();
        for (int index = 0; index < size; ++index) {
            ResultExpression resultExp;
            Expression expression = list.get(index);
            if (expression instanceof StrExpression || expression instanceof IntExpression || expression instanceof NumExpression || expression instanceof BooleanExpression || expression instanceof AssExpression || expression instanceof ArrayIndexExpression || expression instanceof InvokeMethodExpression || expression instanceof DateTimeExpression || expression instanceof SelectItemExpression || expression instanceof NullExpression) {
                previousExp = this.checkTwoParenthesesHaveOperator(previousExp, expression);
                calStack.push(expression);
                continue;
            }
            if (expression instanceof OperatorExpression) {
                previousExp = this.checkTwoParenthesesHaveOperator(previousExp, expression);
                this.setCalAndOperatorStack(list, calStack, operatorStack, index, expression);
                continue;
            }
            if (expression instanceof FunExpression) {
                previousExp = this.checkTwoParenthesesHaveOperator(previousExp, expression);
                FunExpression funExp = (FunExpression)expression;
                resultExp = this.compile(funExp);
                calStack.push(resultExp);
                continue;
            }
            if (expression instanceof DataGradeExpression) {
                previousExp = this.checkTwoParenthesesHaveOperator(previousExp, expression);
                DataGradeExpression dataGradeExp = (DataGradeExpression)expression;
                resultExp = this.compile(dataGradeExp);
                calStack.push(resultExp);
                continue;
            }
            if (!(expression instanceof ExportExpression)) continue;
            previousExp = this.checkTwoParenthesesHaveOperator(previousExp, expression);
            ExportExpression exportExpression = (ExportExpression)expression;
            resultExp = this.compile(exportExpression);
            calStack.push(resultExp);
        }
        while (!operatorStack.isEmpty()) {
            Expression pop = (Expression)operatorStack.pop();
            calStack.push(pop);
        }
        return calStack;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setCalAndOperatorStack(List<Expression> list, Stack<Expression> calStack, Stack<Expression> operatorStack, int index, Expression expression) {
        int priority;
        Expression op;
        Expression operator;
        Expression top;
        OperatorExpression operExpression = (OperatorExpression)expression;
        OriginalNode nodeTemp = operExpression.getNode();
        if (this.isLParentheses(expression)) {
            operatorStack.push(expression);
            return;
        }
        if (this.isRParentheses(expression)) {
            if (operatorStack.isEmpty()) {
                String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5b58\u5728\u591a\u4f59\u7684\u53f3\u62ec\u53f7\u201c{2}\u201d\u3002", (String)"ExpressionParseHelper_18", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, nodeTemp.getLineIndex() + 1, nodeTemp.getStartColumnIndex() + 1, nodeTemp.getNodeText()));
            }
            Expression pop = operatorStack.pop();
            while (!(operatorStack.isEmpty() || this.isLParentheses(pop) || this.isAssOperator(pop))) {
                calStack.push(pop);
                pop = operatorStack.pop();
            }
            if (!this.isLParentheses(pop) && !this.isAssOperator(pop)) {
                String errorMsg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5b58\u5728\u591a\u4f59\u7684\u53f3\u62ec\u53f7\u201c{2}\u201d\u3002", (String)"ExpressionParseHelper_18", (String)"hrmp-hbp-business", (Object[])new Object[0]);
                throw new KDBizException(MessageFormat.format(errorMsg, nodeTemp.getLineIndex() + 1, nodeTemp.getStartColumnIndex() + 1, nodeTemp.getNodeText()));
            }
            calStack.push(new SpecialExpression());
            if (!this.isAssOperator(pop)) return;
            calStack.push(pop);
            return;
        }
        OperatorEnum operatorEnum = FormulaUtils.getOperatorEnum(operExpression);
        if ((operExpression.getNode().getNodeText().equals(OperatorEnum.SUBTRACT.getAlias()) || operExpression.getNode().getNodeText().equals(OperatorEnum.PLUS.getAlias())) && (index == 0 || list.get(index - 1) instanceof OperatorExpression && (this.isLParentheses(list.get(index - 1)) || this.isSpecialOperator((OperatorExpression)list.get(index - 1))))) {
            OriginalNode thisNode = operExpression.getNode();
            OriginalNode zeroNode = new OriginalNode();
            zeroNode.setLineIndex(thisNode.getLineIndex());
            zeroNode.setStartColumnIndex(thisNode.getStartColumnIndex());
            zeroNode.setStartColumnIndex(thisNode.getStartColumnIndex());
            zeroNode.setNodeText("0");
            zeroNode.setKeyType(ExpressionNodeTypeEnum.INT);
            calStack.push(new IntExpression(zeroNode));
        }
        if (this.isLParentheses(top = this.getTop(operatorStack)) || top == null) {
            operatorStack.push(expression);
            return;
        }
        if (this.isBooleanOperator(operatorEnum)) {
            if (!operatorStack.isEmpty()) {
                operator = operatorStack.pop();
                while (!(operatorStack.isEmpty() || this.isLParentheses(operator) || this.isAndOrOperator((OperatorExpression)operator))) {
                    calStack.push(operator);
                    operator = operatorStack.pop();
                }
                if (this.isLParentheses(operator) || this.isAndOrOperator((OperatorExpression)operator)) {
                    operatorStack.push(operator);
                } else {
                    calStack.push(operator);
                }
            }
            operatorStack.push(expression);
            return;
        }
        if (this.isAndOrOperator(operExpression)) {
            if (!operatorStack.isEmpty()) {
                operator = operatorStack.pop();
                while (!operatorStack.isEmpty() && !this.isLParentheses(operator)) {
                    calStack.push(operator);
                    operator = operatorStack.pop();
                }
                if (this.isLParentheses(operator)) {
                    operatorStack.push(operator);
                } else {
                    calStack.push(operator);
                }
            }
            operatorStack.push(expression);
            return;
        }
        int num = FormulaUtils.compareOperatorPriority((OperatorExpression)top, (OperatorExpression)expression);
        if (num < 0) {
            operatorStack.push(expression);
            return;
        }
        calStack.push(operatorStack.pop());
        while (!operatorStack.isEmpty() && !this.isLParentheses(op = operatorStack.peek()) && (priority = FormulaUtils.compareOperatorPriority((OperatorExpression)op, (OperatorExpression)expression)) >= 0) {
            calStack.push(operatorStack.pop());
        }
        operatorStack.push(expression);
    }

    private boolean isBooleanOperator(OperatorEnum operatorEnum) {
        return operatorEnum == OperatorEnum.EQUAL || operatorEnum == OperatorEnum.UNEQUAL || operatorEnum == OperatorEnum.GT || operatorEnum == OperatorEnum.LT || operatorEnum == OperatorEnum.GTOREQUAL || operatorEnum == OperatorEnum.LTOREQUAL;
    }

    private boolean isAndOrOperator(OperatorExpression operatorExpression) {
        boolean flag = false;
        OperatorEnum operatorEnum = FormulaUtils.getOperatorEnum(operatorExpression);
        if (operatorEnum == OperatorEnum.AND || operatorEnum == OperatorEnum.OR) {
            flag = true;
        }
        return flag;
    }

    private Expression checkTwoParenthesesHaveOperator(Expression previousExp, Expression currentExp) throws KDBizException {
        if (previousExp == null) {
            return currentExp;
        }
        if (this.isRParentheses(previousExp) && this.isLParentheses(currentExp)) {
            OperatorExpression previous = (OperatorExpression)previousExp;
            OperatorExpression current = (OperatorExpression)currentExp;
            OriginalNode previousNode = previous.getNode();
            OriginalNode currentNode = current.getNode();
            String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u53f3\u62ec\u53f7\u201c{2}\u201d\u4e0e\u7b2c{3}\u884c\u7b2c{4}\u5217\u7684\u5de6\u62ec\u53f7\u201c{5}\u201d\u4e4b\u95f4\u6ca1\u6709\u64cd\u4f5c\u7b26\uff0c\u9700\u8981\u901a\u8fc7\u8fd0\u7b97\u7b26\u8fde\u63a5\u3002", (String)"ExpressionParseHelper_19", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(msg, previousNode.getLineIndex() + 1, previousNode.getStartColumnIndex() + 1, previousNode.getNodeText(), currentNode.getLineIndex() + 1, currentNode.getStartColumnIndex() + 1, currentNode.getNodeText()));
        }
        if (this.isRParentheses(previousExp) && !(currentExp instanceof OperatorExpression)) {
            String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u201c{2}\u201d\u4e0e\u7b2c{3}\u884c\u7b2c{4}\u5217\u7684\u201c{5}\u201d\u4e4b\u95f4\u6ca1\u6709\u64cd\u4f5c\u7b26\uff0c\u9700\u8981\u901a\u8fc7\u8fd0\u7b97\u7b26\u8fde\u63a5\u3002", (String)"ExpressionParseHelper_20", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            OriginalNode currentNode = this.getExpressionNode(currentExp);
            OperatorExpression opExp = (OperatorExpression)previousExp;
            OriginalNode previousNode = opExp.getNode();
            throw new KDBizException(MessageFormat.format(msg, previousNode.getLineIndex() + 1, previousNode.getStartColumnIndex() + 1, previousNode.getNodeText(), currentNode.getLineIndex() + 1, currentNode.getStartColumnIndex() + 1, currentNode.getNodeText()));
        }
        if (this.isLParentheses(currentExp) && !(previousExp instanceof OperatorExpression)) {
            String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u201c{2}\u201d\u4e0e\u7b2c{3}\u884c\u7b2c{4}\u5217\u7684\u201c{5}\u201d\u4e4b\u95f4\u6ca1\u6709\u64cd\u4f5c\u7b26\uff0c\u9700\u8981\u901a\u8fc7\u8fd0\u7b97\u7b26\u8fde\u63a5\u3002", (String)"ExpressionParseHelper_20", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            OriginalNode previousNode = this.getExpressionNode(previousExp);
            OperatorExpression opExp = (OperatorExpression)currentExp;
            OriginalNode currentNode = opExp.getNode();
            throw new KDBizException(MessageFormat.format(msg, previousNode.getLineIndex() + 1, previousNode.getStartColumnIndex() + 1, previousNode.getNodeText(), currentNode.getLineIndex() + 1, currentNode.getStartColumnIndex() + 1, currentNode.getNodeText()));
        }
        if (this.isLParentheses(previousExp) && this.isRParentheses(currentExp)) {
            OperatorExpression opExp = (OperatorExpression)previousExp;
            OriginalNode node = opExp.getNode();
            String msg = ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u62ec\u53f7\u5185\u5fc5\u987b\u7ef4\u62a4\u503c\u3002", (String)"ExpressionParseHelper_21", (String)"hrmp-hbp-business", (Object[])new Object[0]);
            throw new KDBizException(MessageFormat.format(msg, node.getLineIndex() + 1, node.getStartColumnIndex() + 1));
        }
        return currentExp;
    }

    private OriginalNode getExpressionNode(Expression exp) {
        if (exp instanceof StrExpression) {
            StrExpression str = (StrExpression)exp;
            return str.getNode();
        }
        if (exp instanceof IntExpression) {
            IntExpression intExp = (IntExpression)exp;
            return intExp.getNode();
        }
        if (exp instanceof NumExpression) {
            NumExpression numExp = (NumExpression)exp;
            return numExp.getNode();
        }
        if (exp instanceof ItemExpression) {
            ItemExpression itemExp = (ItemExpression)exp;
            return itemExp.getNode();
        }
        if (exp instanceof FunExpression) {
            FunExpression funcExp = (FunExpression)exp;
            return funcExp.getNode();
        }
        if (exp instanceof BooleanExpression) {
            BooleanExpression booleanExp = (BooleanExpression)exp;
            return booleanExp.getNode();
        }
        return new OriginalNode();
    }

    private boolean isLParentheses(Expression expression) {
        if (expression instanceof OperatorExpression) {
            return ((OperatorExpression)expression).getNode().getNodeText().equals(OperatorEnum.LPARENTHESES.getAlias());
        }
        return false;
    }

    private boolean isAssOperator(Expression expression) {
        if (expression instanceof OperatorExpression) {
            return expression.getNode().getNodeText().equals(OperatorEnum.ASSIGNMENT.getAlias());
        }
        return false;
    }

    private boolean isRParentheses(Expression expression) {
        if (expression instanceof OperatorExpression) {
            return ((OperatorExpression)expression).getNode().getNodeText().equals(OperatorEnum.RPARENTHESES.getAlias());
        }
        return false;
    }

    private boolean isSpecialOperator(OperatorExpression expression) {
        OriginalNode node = expression.getNode();
        return HRStringUtils.equals((String)node.getNodeText(), (String)OperatorEnum.EQUAL.getAlias()) || HRStringUtils.equals((String)node.getNodeText(), (String)OperatorEnum.ASSIGNMENT.getAlias()) || HRStringUtils.equals((String)node.getNodeText(), (String)OperatorEnum.UNEQUAL.getAlias()) || HRStringUtils.equals((String)node.getNodeText(), (String)OperatorEnum.GT.getAlias()) || HRStringUtils.equals((String)node.getNodeText(), (String)OperatorEnum.LT.getAlias()) || HRStringUtils.equals((String)node.getNodeText(), (String)OperatorEnum.GTOREQUAL.getAlias()) || HRStringUtils.equals((String)node.getNodeText(), (String)OperatorEnum.LTOREQUAL.getAlias());
    }

    private Expression getTop(Stack<Expression> stack) {
        if (stack.isEmpty()) {
            return null;
        }
        int top = stack.size() - 1;
        return (Expression)stack.get(top);
    }

    private void changeResultExpressionCodeToBigDecimal(ResultExpression ... resultExpressions) {
        if (Objects.nonNull(resultExpressions)) {
            for (ResultExpression resultExpression : resultExpressions) {
                if (DataTypeEnum.INT != resultExpression.getDataType() && DataTypeEnum.MONEY != resultExpression.getDataType() && DataTypeEnum.NUM != resultExpression.getDataType()) continue;
                resultExpression.setCode(String.format("new BigDecimal(String.valueOf(%s))", resultExpression.getCode()));
            }
        }
    }

    private boolean checkDateCompareNotIncludeHourMinSec(ResultExpression ... results) {
        for (ResultExpression result : results) {
            if (!this.checkDateHourMinSec(result)) continue;
            return false;
        }
        return true;
    }

    private boolean checkDateHourMinSec(ResultExpression result) {
        Expression originalExp = result.getOriginalExp();
        if (originalExp instanceof DateExpression) {
            return false;
        }
        if (originalExp instanceof DateTimeExpression) {
            return true;
        }
        if (originalExp instanceof ItemExpression) {
            CalItem calItem = ((ItemExpression)originalExp).getCalItem();
            return calItem.isCheckHourMinSec() || calItem.getDataType() == DataTypeEnum.DATETIME;
        }
        return false;
    }

    private boolean isDateCompare(DataTypeEnum ... dataTypes) {
        for (DataTypeEnum dataType : dataTypes) {
            if (dataType == DataTypeEnum.DATETIME || dataType == DataTypeEnum.DATE) continue;
            return false;
        }
        return true;
    }
}

