/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.hr.hbp.business.service.formula.entity.item.ParamItem;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.business.service.formula.enums.FormulaKeyEnum;
import kd.hr.hbp.business.service.formula.enums.InvokeMethodEnum;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;

public class FormulaDataServiceHelper {
    public static Optional<List<TreeNodeItem>> getFuncList(String bizAppNumber, Set<String> extFuncTypeNumbers, Set<String> extFuncTypeNames) {
        return Optional.of(HRMServiceHelper.invokeHRMPService("hrcs", "IHRCSFunctionService", "getFunctionTreeItemByAppNumber", bizAppNumber, extFuncTypeNumbers, extFuncTypeNames));
    }

    public static List<ParamItem> getParamItems(DynamicObjectCollection entryList) {
        ArrayList<ParamItem> result = new ArrayList<ParamItem>();
        if (entryList == null || entryList.size() == 0) {
            return result;
        }
        for (DynamicObject entry : entryList) {
            result.add(new ParamItem(entry.getString("paramdatatype"), entry.getString("paramname"), entry.getString("paramdesc"), null));
        }
        return result;
    }

    public static Map<String, Object> getEditorKey(IFormView view, Map<String, Object> dataMap) {
        if (dataMap == null || dataMap.size() == 0) {
            HRPageCache pageCache = new HRPageCache(view);
            dataMap = (Map)pageCache.get("hbp_formula_cache_key", Map.class);
        }
        HashMap<String, Object> json = new HashMap<String, Object>(16);
        HashSet<String> keyList = new HashSet<String>(16);
        keyList.add(FormulaKeyEnum.IF.getAlias());
        keyList.add(FormulaKeyEnum.WHILE.getAlias());
        keyList.add(FormulaKeyEnum.ELSEIF.getAlias());
        keyList.add(FormulaKeyEnum.ELSE.getAlias());
        keyList.add(FormulaKeyEnum.THEN.getAlias());
        keyList.add(FormulaKeyEnum.LIKE.getAlias());
        keyList.add(FormulaKeyEnum.ENDIF.getAlias());
        keyList.add(FormulaKeyEnum.ENDWHILE.getAlias());
        keyList.add(DataTypeEnum.TEXT.getAlias());
        keyList.add(DataTypeEnum.NUM.getAlias());
        keyList.add(DataTypeEnum.INT.getAlias());
        keyList.add(DataTypeEnum.DATE.getAlias());
        keyList.add(DataTypeEnum.DATETIME.getAlias());
        keyList.add(DataTypeEnum.OBJECT.getAlias());
        keyList.add(DataTypeEnum.ARRAY_OBJECT.getAlias());
        keyList.add(FormulaKeyEnum.AND.getAlias());
        keyList.add(FormulaKeyEnum.OR.getAlias());
        keyList.add(FormulaKeyEnum.RESULT.getAlias());
        keyList.add(FormulaKeyEnum.NULL.getAlias());
        keyList.add(FormulaKeyEnum.EXIT.getAlias());
        keyList.add(InvokeMethodEnum.LENGTH.getAlias());
        keyList.add(FormulaKeyEnum.EXPORT.getAlias());
        json.put("conditionKey", keyList);
        keyList = new HashSet(16);
        keyList.addAll(FormulaDataServiceHelper.getItemTextFromMap("formula_cal_item_map_cache_key", dataMap));
        json.put("calItemKey", keyList);
        keyList = new HashSet(16);
        keyList.addAll(FormulaDataServiceHelper.getItemTextFromMap("formula_fuc_map_cache_key", dataMap));
        keyList.addAll(FormulaDataServiceHelper.getItemTextFromMap("formula_data_grade_map_cache_key", dataMap));
        json.put("funcKey", keyList);
        return json;
    }

    public static Set<String> getItemTextFromMap(String itemName, Map<String, Object> dataMap) {
        Object result = dataMap.get(itemName);
        if (result instanceof Map) {
            Map map = (Map)result;
            if (map.size() == 0) {
                return new HashSet<String>();
            }
            return map.keySet().stream().map(key -> {
                String str = String.valueOf(key);
                if (str.contains("[") && str.contains("]")) {
                    return str.substring(str.indexOf(91) + 1, str.indexOf(93));
                }
                return str;
            }).collect(Collectors.toSet());
        }
        return new HashSet<String>();
    }
}

