/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.helper;

import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.business.service.formula.entity.node.OriginalNode;
import kd.hr.hbp.business.service.formula.enums.InvokeMethodEnum;
import kd.hr.hbp.business.service.formula.enums.OperatorEnum;
import kd.hr.hbp.common.util.HRStringUtils;

public class FormulaSplitHelper {
    private boolean isBlockAnnotation = false;
    private static final String SPECIAL_EMPTY = "\u00a0";
    private static final String NOT = "!";
    private static final Set<String> MATH_SYMBOL = Sets.newHashSet((Object[])new String[]{OperatorEnum.LPARENTHESES.getAlias(), OperatorEnum.RPARENTHESES.getAlias(), OperatorEnum.PLUS.getAlias(), OperatorEnum.SUBTRACT.getAlias(), OperatorEnum.MULTIPLY.getAlias(), OperatorEnum.DIVIDE.getAlias(), OperatorEnum.EQUAL.getAlias()});

    public List<OriginalNode> getOriginalNodes(String formulaText, Set<String> itemCategorySet) throws KDBizException {
        formulaText = formulaText.replace("\t", "    ");
        String[] lines = formulaText.split("\\r?\\n");
        ArrayList<OriginalNode> nodes = new ArrayList<OriginalNode>();
        int len = lines.length;
        for (int index = 0; index < len; ++index) {
            String lineText = lines[index];
            List<OriginalNode> lineNodes = this.getOriginalNodeByLine(lineText, index, itemCategorySet);
            nodes.addAll(lineNodes);
        }
        return nodes;
    }

    private List<OriginalNode> getOriginalNodeByLine(String formulaText, int lineIndex, Set<String> itemCategorySet) throws KDBizException {
        ArrayList<OriginalNode> nodes = new ArrayList<OriginalNode>();
        SplitLoopIndex loopIndex = new SplitLoopIndex(formulaText.length());
        while (loopIndex.allIndex < loopIndex.len) {
            if (this.isBlockAnnotation) {
                this.matchBlockAnnotationNode(nodes, formulaText, lineIndex, loopIndex);
                continue;
            }
            String ch = String.valueOf(formulaText.charAt(loopIndex.allIndex));
            if (OperatorEnum.QUOT.getAlias().equals(ch)) {
                this.matchQuotNode(formulaText, lineIndex, nodes, loopIndex);
                continue;
            }
            if (OperatorEnum.LBRACKET.getAlias().equals(ch)) {
                this.matchLeftBracketNode(formulaText, lineIndex, itemCategorySet, nodes, loopIndex);
                continue;
            }
            if (OperatorEnum.RBRACKET.getAlias().equals(ch)) {
                this.matchRightBracket(lineIndex, loopIndex);
                continue;
            }
            if (MATH_SYMBOL.contains(ch) || OperatorEnum.COMMA.getAlias().equals(ch)) {
                this.matchMathOrSimpleKeyNode(formulaText, lineIndex, nodes, loopIndex, ch);
                continue;
            }
            if (OperatorEnum.GT.getAlias().equals(ch) || OperatorEnum.LT.getAlias().equals(ch)) {
                this.matchSameFrontKeyNodeAndAddNode(formulaText, lineIndex, nodes, loopIndex, () -> OperatorEnum.GTOREQUAL.getAlias().equals(loopIndex.tempStr) || OperatorEnum.LTOREQUAL.getAlias().equals(loopIndex.tempStr) || OperatorEnum.UNEQUAL.getAlias().equals(loopIndex.tempStr));
                continue;
            }
            if (NOT.equals(ch)) {
                this.matchSameFrontKeyNodeAndAddNode(formulaText, lineIndex, nodes, loopIndex, () -> OperatorEnum.UNEQUAL.getAlias().equals(loopIndex.tempStr));
                continue;
            }
            if (OperatorEnum.SPOT.getAlias().equals(ch)) {
                this.matchNodeBySplitDot(formulaText, lineIndex, nodes, loopIndex);
                continue;
            }
            if (OperatorEnum.EMPTY.getAlias().equals(ch) || SPECIAL_EMPTY.equals(ch)) {
                this.matchNodeBySplitEmpty(formulaText, lineIndex, nodes, loopIndex);
                continue;
            }
            loopIndex.setAllIndex(loopIndex.allIndex + 1);
        }
        if (loopIndex.fromIndex < loopIndex.len + 1) {
            loopIndex.updateNodeText(formulaText, loopIndex.len);
            loopIndex.updateCurrIndex(loopIndex.fromIndex, loopIndex.reduceLen);
            if (HRStringUtils.isNotEmpty((String)loopIndex.nodeText)) {
                this.addOriginalNode(nodes, loopIndex, lineIndex, false);
            }
        }
        return nodes;
    }

    private void matchBlockAnnotationNode(List<OriginalNode> nodes, String formulaText, int lineIndex, SplitLoopIndex loopIndex) {
        OriginalNode blockAnnotationNode = this.getBlockAnnotation(loopIndex.allIndex, formulaText, lineIndex);
        loopIndex.setNodeText(blockAnnotationNode.getNodeText());
        loopIndex.updateCurrIndex(blockAnnotationNode.getStartColumnIndex(), blockAnnotationNode.getEndColumnIndex());
        loopIndex.setAllIndex(blockAnnotationNode.getEndColumnIndex() + 1);
        loopIndex.updateIndex(loopIndex.allIndex, loopIndex.allIndex, null, null, null);
        nodes.add(blockAnnotationNode);
    }

    private void matchRightBracket(int lineIndex, SplitLoopIndex loopIndex) {
        throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5b58\u5728\u591a\u4f59\u7684\u53f3\u4e2d\u62ec\u53f7\u201c{2}\u201d\u3002", (String)"FormulaSplitHelper_0", (String)"hrmp-hbp-business", (Object[])new Object[0]), lineIndex + 1, loopIndex.allIndex + 1, OperatorEnum.RBRACKET.getAlias()));
    }

    private void matchLeftBracketNode(String formulaText, int lineIndex, Set<String> itemCategorySet, List<OriginalNode> nodes, SplitLoopIndex loopIndex) {
        if (loopIndex.fromIndex < loopIndex.allIndex) {
            loopIndex.updateNodeText(formulaText, loopIndex.allIndex);
            if (!itemCategorySet.contains(loopIndex.nodeText)) {
                loopIndex.updateIndex(loopIndex.toIndex, null, loopIndex.fromIndex, loopIndex.toIndex, null);
                this.addOriginalNode(nodes, loopIndex, lineIndex, false);
            }
        }
        OriginalNode node = this.getBracketNode(loopIndex.allIndex, formulaText, lineIndex);
        loopIndex.updateIndex(null, null, loopIndex.fromIndex, node.getEndColumnIndex(), node.getEndColumnIndex() + 1);
        loopIndex.updateNodeTextNotUpdateIndex(formulaText, node.getEndColumnIndex() + 1);
        this.addOriginalNode(nodes, loopIndex, lineIndex, false);
        loopIndex.setFromIndex(loopIndex.allIndex);
    }

    private void matchQuotNode(String formulaText, int lineIndex, List<OriginalNode> nodes, SplitLoopIndex loopIndex) {
        if (loopIndex.fromIndex < loopIndex.allIndex) {
            loopIndex.updateNodeText(formulaText, loopIndex.allIndex);
            loopIndex.updateIndex(loopIndex.toIndex, null, loopIndex.fromIndex, loopIndex.toIndex, null);
            this.addOriginalNode(nodes, loopIndex, lineIndex, false);
        }
        OriginalNode node = this.getQuotNode(loopIndex.allIndex, formulaText, lineIndex);
        loopIndex.setNodeText(node.getNodeText());
        loopIndex.updateIndex(null, null, node.getStartColumnIndex(), node.getEndColumnIndex(), null);
        this.addOriginalNode(nodes, loopIndex, lineIndex, false);
        loopIndex.updateIndex(node.getEndColumnIndex() + 1, null, null, null, node.getEndColumnIndex() + 1);
    }

    private void matchNodeBySplitEmpty(String formulaText, int lineIndex, List<OriginalNode> nodes, SplitLoopIndex loopIndex) {
        if (loopIndex.fromIndex < loopIndex.allIndex) {
            loopIndex.updateNodeText(formulaText, loopIndex.allIndex);
            loopIndex.updateIndex(loopIndex.toIndex + 1, null, loopIndex.fromIndex, loopIndex.toIndex - 1, null);
            this.addOriginalNode(nodes, loopIndex, lineIndex, false);
        } else {
            loopIndex.setFromIndex(loopIndex.allIndex + 1);
        }
        loopIndex.setAllIndex(loopIndex.allIndex + 1);
    }

    private void matchNodeBySplitDot(String formulaText, int lineIndex, List<OriginalNode> nodes, SplitLoopIndex loopIndex) {
        if (formulaText.length() > loopIndex.allIndex + 1 && InvokeMethodEnum.isStartWithInvokeMethod(formulaText.substring(loopIndex.allIndex))) {
            if (loopIndex.fromIndex < loopIndex.allIndex) {
                loopIndex.updateNodeText(formulaText, loopIndex.allIndex);
                loopIndex.updateIndex(loopIndex.toIndex, null, loopIndex.fromIndex, loopIndex.toIndex - 1, null);
                this.addOriginalNode(nodes, loopIndex, lineIndex, false);
            } else {
                loopIndex.setFromIndex(loopIndex.allIndex);
            }
        }
        loopIndex.setAllIndex(loopIndex.allIndex + 1);
    }

    private void matchMathOrSimpleKeyNode(String formulaText, int lineIndex, List<OriginalNode> nodes, SplitLoopIndex loopIndex, String ch) {
        if (loopIndex.fromIndex < loopIndex.allIndex) {
            loopIndex.updateNodeText(formulaText, loopIndex.allIndex);
            loopIndex.updateCurrIndex(loopIndex.fromIndex, loopIndex.toIndex - 1);
            this.addOriginalNode(nodes, loopIndex, lineIndex, false);
        }
        boolean isRowAnnotation = false;
        if (loopIndex.allIndex < loopIndex.reduceLen && OperatorEnum.DIVIDE.getAlias().equals(ch)) {
            String nextCh = String.valueOf(formulaText.charAt(loopIndex.allIndex + 1));
            if (OperatorEnum.DIVIDE.getAlias().equals(nextCh)) {
                isRowAnnotation = true;
                loopIndex.setFromIndex(loopIndex.allIndex);
            } else if (OperatorEnum.MULTIPLY.getAlias().equals(nextCh)) {
                this.isBlockAnnotation = true;
            }
        }
        if (isRowAnnotation) {
            loopIndex.updateNodeText(formulaText, loopIndex.len);
            loopIndex.updateIndex(loopIndex.len, null, loopIndex.fromIndex, loopIndex.reduceLen, loopIndex.len);
            this.addOriginalNode(nodes, loopIndex, lineIndex, true);
        } else if (this.isBlockAnnotation) {
            OriginalNode blockAnnotationNode = this.getBlockAnnotation(loopIndex.allIndex, formulaText, lineIndex);
            loopIndex.updateIndex(blockAnnotationNode.getEndColumnIndex() + 1, null, blockAnnotationNode.getStartColumnIndex(), blockAnnotationNode.getEndColumnIndex(), blockAnnotationNode.getEndColumnIndex() + 1);
            loopIndex.setNodeText(blockAnnotationNode.getNodeText());
            nodes.add(blockAnnotationNode);
        } else {
            loopIndex.setFromIndex(loopIndex.allIndex);
            loopIndex.updateNodeText(formulaText, loopIndex.allIndex + 1);
            loopIndex.updateIndex(loopIndex.toIndex, null, loopIndex.fromIndex, loopIndex.allIndex, loopIndex.toIndex);
            this.addOriginalNode(nodes, loopIndex, lineIndex, false);
        }
    }

    private void matchSameFrontKeyNodeAndAddNode(String formulaText, int lineIndex, List<OriginalNode> nodes, SplitLoopIndex loopIndex, Callable<Boolean> checkIsAnotherKey) {
        if (loopIndex.fromIndex < loopIndex.allIndex) {
            loopIndex.updateNodeText(formulaText, loopIndex.allIndex);
            loopIndex.updateIndex(loopIndex.toIndex, null, loopIndex.fromIndex, loopIndex.toIndex, null);
            this.addOriginalNode(nodes, loopIndex, lineIndex, false);
        }
        if (loopIndex.len >= loopIndex.allIndex + 2) {
            loopIndex.setTempStr(formulaText.substring(loopIndex.fromIndex, loopIndex.allIndex + 2));
        } else {
            loopIndex.setTempStr(formulaText.substring(loopIndex.fromIndex, loopIndex.len));
        }
        try {
            Boolean isAnotherKey = checkIsAnotherKey.call();
            if (isAnotherKey.booleanValue()) {
                loopIndex.updateIndex(loopIndex.allIndex + 2, loopIndex.allIndex + 2, loopIndex.fromIndex, loopIndex.allIndex + 2, loopIndex.allIndex + 2);
                loopIndex.setNodeText(loopIndex.tempStr);
                this.addOriginalNode(nodes, loopIndex, lineIndex, false);
            } else {
                loopIndex.updateNodeText(formulaText, loopIndex.allIndex + 1);
                loopIndex.updateIndex(loopIndex.toIndex, null, loopIndex.fromIndex, loopIndex.toIndex, loopIndex.allIndex + 1);
                this.addOriginalNode(nodes, loopIndex, lineIndex, false);
            }
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    private OriginalNode getBlockAnnotation(int index, String formulaText, int lineIndex) {
        int fromIndex = index;
        int len = formulaText.length();
        String nodeText = "";
        while (index < len) {
            String ch = String.valueOf(formulaText.charAt(index));
            if (index >= 1 && OperatorEnum.DIVIDE.getAlias().equals(ch) && OperatorEnum.MULTIPLY.getAlias().equals(String.valueOf(formulaText.charAt(index - 1)))) {
                this.isBlockAnnotation = false;
                ++index;
                break;
            }
            ++index;
        }
        nodeText = formulaText.substring(fromIndex, index);
        OriginalNode node = new OriginalNode();
        node.setNodeText(nodeText);
        node.setLineIndex(lineIndex);
        node.setStartColumnIndex(fromIndex);
        node.setEndColumnIndex(index - 1);
        node.setAnnotation(true);
        return node;
    }

    private OriginalNode getQuotNode(int fromIndex, String formulaText, int lineIndex) throws KDBizException {
        int index;
        int len = formulaText.length();
        String nodeText = "";
        if (fromIndex + 1 == len) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5b58\u5728\u591a\u4f59\u7684\u5f15\u53f7\u201c{2}\u201d\u3002", (String)"FormulaSplitHelper_1", (String)"hrmp-hbp-business", (Object[])new Object[0]), lineIndex + 1, index + 1, OperatorEnum.QUOT.getAlias()));
        }
        for (index = fromIndex + 1; index < len; ++index) {
            String ch = String.valueOf(formulaText.charAt(index));
            if (!OperatorEnum.QUOT.getAlias().equals(ch)) continue;
            nodeText = formulaText.substring(fromIndex, index + 1);
            break;
        }
        if (HRStringUtils.isEmpty((String)nodeText)) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5b58\u5728\u591a\u4f59\u7684\u5f15\u53f7\u201c{2}\u201d\u3002", (String)"FormulaSplitHelper_1", (String)"hrmp-hbp-business", (Object[])new Object[0]), lineIndex + 1, fromIndex + 1, OperatorEnum.QUOT.getAlias()));
        }
        OriginalNode node = new OriginalNode();
        node.setNodeText(nodeText);
        node.setStartColumnIndex(fromIndex);
        node.setEndColumnIndex(index);
        return node;
    }

    private OriginalNode getBracketNode(int fromIndex, String formulaText, int lineIndex) throws KDBizException {
        int index;
        int len = formulaText.length();
        String nodeText = "";
        if (fromIndex + 1 == len) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5b58\u5728\u591a\u4f59\u7684\u5de6\u4e2d\u62ec\u53f7\u201c{2}\u201d\u3002", (String)"FormulaSplitHelper_2", (String)"hrmp-hbp-business", (Object[])new Object[0]), lineIndex + 1, index + 1, OperatorEnum.LBRACKET.getAlias()));
        }
        for (index = fromIndex + 1; index < len; ++index) {
            String ch = String.valueOf(formulaText.charAt(index));
            if (OperatorEnum.LBRACKET.getAlias().equals(ch)) {
                throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u4e2d\u62ec\u53f7\u5185\u4e0d\u80fd\u51fa\u73b0\u5de6\u4e2d\u62ec\u53f7\"{2}\"\u3002", (String)"FormulaSplitHelper_3", (String)"hrmp-hbp-business", (Object[])new Object[0]), lineIndex + 1, index + 1, OperatorEnum.LBRACKET.getAlias()));
            }
            if (!OperatorEnum.RBRACKET.getAlias().equals(ch)) continue;
            nodeText = formulaText.substring(fromIndex, index + 1);
            if (!HRStringUtils.isEmpty((String)nodeText)) break;
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u4e2d\u62ec\u53f7\u5185\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FormulaSplitHelper_4", (String)"hrmp-hbp-business", (Object[])new Object[0]), lineIndex + 1, fromIndex + 1));
        }
        if (HRStringUtils.isEmpty((String)nodeText)) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u5b58\u5728\u591a\u4f59\u7684\u5de6\u4e2d\u62ec\u53f7\u201c{2}\u201d\u3002", (String)"FormulaSplitHelper_2", (String)"hrmp-hbp-business", (Object[])new Object[0]), lineIndex + 1, fromIndex + 1, OperatorEnum.LBRACKET.getAlias()));
        }
        OriginalNode node = new OriginalNode();
        node.setNodeText(nodeText);
        node.setStartColumnIndex(fromIndex);
        node.setEndColumnIndex(index);
        return node;
    }

    private void addOriginalNode(List<OriginalNode> nodes, SplitLoopIndex loopIndex, int lineIndex, boolean isAnnotation) {
        String nodeText = loopIndex.nodeText;
        if (nodeText != null && nodeText.trim().length() > 0) {
            OriginalNode node = new OriginalNode();
            node.setNodeText(nodeText);
            node.setLineIndex(lineIndex);
            node.setStartColumnIndex(loopIndex.currFromIndex);
            node.setEndColumnIndex(loopIndex.currToIndex);
            if (isAnnotation) {
                node.setAnnotation(true);
            }
            nodes.add(node);
        }
    }

    private static class SplitLoopIndex {
        int len = 0;
        int fromIndex = 0;
        int toIndex = 0;
        int currFromIndex = 0;
        int currToIndex = 0;
        String nodeText = "";
        int allIndex = 0;
        int reduceLen = 0;
        String tempStr = "";

        private SplitLoopIndex(int len) {
            this.len = len;
            this.reduceLen = len - 1;
        }

        private void updateIndex(Integer fromIndex, Integer toIndex, Integer currFromIndex, Integer currToIndex, Integer allIndex) {
            if (Objects.nonNull(fromIndex)) {
                this.fromIndex = fromIndex;
            }
            if (Objects.nonNull(toIndex)) {
                this.toIndex = toIndex;
            }
            if (Objects.nonNull(currFromIndex)) {
                this.currFromIndex = currFromIndex;
            }
            if (Objects.nonNull(currToIndex)) {
                this.currToIndex = currToIndex;
            }
            if (Objects.nonNull(allIndex)) {
                this.allIndex = allIndex;
            }
        }

        private void updateCurrIndex(Integer currFromIndex, Integer currToIndex) {
            this.updateIndex(null, null, currFromIndex, currToIndex, null);
        }

        private void updateNodeText(String lineText, int toIndex) {
            this.toIndex = toIndex;
            this.nodeText = lineText.substring(this.fromIndex, this.toIndex);
        }

        private void updateNodeTextNotUpdateIndex(String lineText, int toIndex) {
            this.nodeText = lineText.substring(this.fromIndex, toIndex);
        }

        public void setFromIndex(int fromIndex) {
            this.fromIndex = fromIndex;
        }

        public void setNodeText(String nodeText) {
            this.nodeText = nodeText;
        }

        public void setAllIndex(int allIndex) {
            this.allIndex = allIndex;
        }

        public void setTempStr(String tempStr) {
            this.tempStr = tempStr;
        }
    }
}

