/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.formula.entity.item.DataGradeResultItem;
import kd.hr.hbp.business.service.formula.entity.item.FunctionItem;
import kd.hr.hbp.business.service.formula.entity.item.ResultItem;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.business.service.formula.utils.FormulaUtils;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;

public class FormulaCacheUtils {
    private static final Log LOGGER = LogFactory.getLog(FormulaCacheUtils.class);

    public static void putValueIntoPageCache(IFormView view, String key, Object value) {
        HRPageCache pageCache = new HRPageCache(view);
        if (Objects.isNull(value)) {
            LOGGER.warn(MessageFormat.format("putValueIntoPageCache_value_is_null_key_is_[{0}]", key));
            return;
        }
        pageCache.put(key, value);
    }

    public static <T> T getValueFromPageCache(IFormView view, String key, Class<T> clazz) {
        IPageCache thisPageCache = (IPageCache)view.getService(IPageCache.class);
        if (String.class.equals(clazz)) {
            return (T)thisPageCache.get(key);
        }
        if (Boolean.class.equals(clazz)) {
            return (T)Boolean.valueOf(thisPageCache.get(key));
        }
        if (Integer.class.equals(clazz)) {
            return (T)Integer.valueOf(thisPageCache.get(key));
        }
        if (Long.class.equals(clazz)) {
            return (T)Long.valueOf(thisPageCache.get(key));
        }
        if (Float.class.equals(clazz)) {
            return (T)Float.valueOf(thisPageCache.get(key));
        }
        if (Double.class.equals(clazz)) {
            return (T)Double.valueOf(thisPageCache.get(key));
        }
        if (Short.class.equals(clazz)) {
            return (T)Short.valueOf(thisPageCache.get(key));
        }
        if (Byte.class.equals(clazz)) {
            return (T)Byte.valueOf(thisPageCache.get(key));
        }
        HRPageCache pageCache = new HRPageCache(view);
        return (T)pageCache.get(key, clazz);
    }

    public static <T> List<T> getListBaseValueFromFormulaPageCache(IFormView view, String keyName, Class<T> clazz) {
        List list;
        HRPageCache pageCache = new HRPageCache(view);
        Map totalMap = (Map)pageCache.get("hbp_formula_cache_key", Map.class);
        if (Objects.nonNull(totalMap) && !CollectionUtils.isEmpty((Collection)(list = (List)totalMap.get(keyName)))) {
            ArrayList<Object> returnList = new ArrayList<Object>(list.size());
            for (Object obj : list) {
                String str = String.valueOf(obj);
                if (String.class.equals(clazz)) {
                    returnList.add(str);
                    continue;
                }
                if (Boolean.class.equals(clazz)) {
                    returnList.add(Boolean.valueOf(str));
                    continue;
                }
                if (Integer.class.equals(clazz)) {
                    returnList.add(Integer.valueOf(str));
                    continue;
                }
                if (Long.class.equals(clazz)) {
                    returnList.add(Long.valueOf(str));
                    continue;
                }
                if (Float.class.equals(clazz)) {
                    returnList.add(Float.valueOf(str));
                    continue;
                }
                if (Double.class.equals(clazz)) {
                    returnList.add(Double.valueOf(str));
                    continue;
                }
                if (Short.class.equals(clazz)) {
                    returnList.add(Short.valueOf(str));
                    continue;
                }
                if (Byte.class.equals(clazz)) {
                    returnList.add(Byte.valueOf(str));
                    continue;
                }
                if (!Character.class.equals(clazz)) continue;
                returnList.add(obj);
            }
            return returnList;
        }
        return new ArrayList();
    }

    public static <T> List<T> getListCustValueFromFormulaPageCache(IFormView view, String keyName, Class<T> clazz) {
        List list;
        HRPageCache pageCache = new HRPageCache(view);
        Map totalMap = (Map)pageCache.get("hbp_formula_cache_key", Map.class);
        if (Objects.nonNull(totalMap) && !CollectionUtils.isEmpty((Collection)(list = (List)totalMap.get(keyName)))) {
            ArrayList<Object> returnList = new ArrayList<Object>(list.size());
            for (Object obj : list) {
                if (!(obj instanceof Map)) continue;
                returnList.add(JSONObject.parseObject((String)SerializationUtils.toJsonString(obj), clazz));
            }
            return returnList;
        }
        return new ArrayList();
    }

    public static <T> Map<String, T> getMapCustValueFromFormulaPageCache(IFormView view, String keyName, Class<T> clazz) {
        Map map;
        HRPageCache pageCache = new HRPageCache(view);
        Map totalMap = (Map)pageCache.get("hbp_formula_cache_key", Map.class);
        if (Objects.nonNull(totalMap) && !CollectionUtils.isEmpty((Map)(map = (Map)totalMap.get(keyName)))) {
            HashMap<String, Object> returnMap = new HashMap<String, Object>(map.size());
            Set entries = map.entrySet();
            for (Map.Entry entry : entries) {
                if (!(entry.getValue() instanceof Map)) continue;
                returnMap.put(String.valueOf(entry.getKey()), SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(entry.getValue()), clazz));
            }
            return returnMap;
        }
        return new HashMap();
    }

    public static void putValueIntoFormulaPageCache(IFormView view, String key, Object value) {
        HRPageCache pageCache = new HRPageCache(view);
        if (Objects.isNull(value)) {
            LOGGER.warn(MessageFormat.format("putValueIntoFormulaPageCache_value_is_null_key_is_[{0}]", key));
            return;
        }
        try (DLock lock = DLock.create((String)("HRMP_HBP_FORMULA_" + view.getPageId()));){
            lock.lock();
            Map totalMap = (Map)pageCache.get("hbp_formula_cache_key", Map.class);
            if (Objects.nonNull(totalMap)) {
                totalMap.put(key, value);
                pageCache.put("hbp_formula_cache_key", (Object)totalMap);
            }
        }
    }

    public static ResultItem findResultItemById(String id, IFormView view) {
        if (id == null || view == null) {
            return null;
        }
        List<ResultItem> result = FormulaCacheUtils.getListCustValueFromFormulaPageCache(view, "formula_result_item_list_cache_key", ResultItem.class);
        Optional<ResultItem> filterResultItem = result.stream().filter(Objects::nonNull).filter(func -> id.equals(String.valueOf(func.getId()))).findFirst();
        return filterResultItem.orElse(null);
    }

    public static FunctionItem findFuncById(String id, IFormView view) {
        if (id == null || view == null) {
            return null;
        }
        List<FunctionItem> result = FormulaCacheUtils.getListCustValueFromFormulaPageCache(view, "formula_fuc_tree_node_cache_key", FunctionItem.class);
        Optional<FunctionItem> functionItem = result.stream().filter(Objects::nonNull).filter(func -> id.equals(String.valueOf(func.getId()))).findFirst();
        return functionItem.orElse(null);
    }

    public static DataGradeResultItem findDataGradeById(String id, IFormView view) {
        if (id == null || view == null) {
            return null;
        }
        List<DataGradeResultItem> result = FormulaCacheUtils.getListCustValueFromFormulaPageCache(view, "formula_data_grade_tree_node_cache_key", DataGradeResultItem.class);
        List<TreeNodeItem> dataGradeTreeItemList = FormulaUtils.getDataGradeTreeItemList(result);
        Optional<DataGradeResultItem> gradeResultItem = dataGradeTreeItemList.stream().filter(Objects::nonNull).filter(func -> id.equals(String.valueOf(func.getId()))).map(item -> (DataGradeResultItem)item).findFirst();
        return gradeResultItem.orElse(null);
    }

    public static List<DynamicObject> getResultItemBySearch(IFormView view, int start, int limit, List<QFilter> paramFilters, boolean isFuzzy, boolean isAllMatch, DynamicObjectType objectType, List<QFilter> baseFilter) {
        List<ResultItem> resultItems = FormulaCacheUtils.getListCustValueFromFormulaPageCache(view, "formula_result_item_list_cache_key", ResultItem.class);
        return resultItems.stream().map(item -> ResultItem.getDyByResultItem(item, objectType)).filter(item -> {
            if (CollectionUtils.isEmpty((Collection)baseFilter)) {
                return true;
            }
            for (QFilter filter : baseFilter) {
                if (FormulaCacheUtils.checkByQFilter(item, filter)) continue;
                return false;
            }
            return true;
        }).filter(item -> {
            if (CollectionUtils.isEmpty((Collection)paramFilters)) {
                return true;
            }
            boolean isMatch = false;
            for (QFilter filter : paramFilters) {
                boolean filterMatch = false;
                String filterValue = String.valueOf(filter.getValue());
                String[] fieldAndValueArray = filterValue.split("#");
                String[] fields = fieldAndValueArray[0].split(",");
                String[] values = fieldAndValueArray[1].split("\b");
                block1: for (String field : fields) {
                    String fieldValue = item.getString(field);
                    if (!HRStringUtils.isNotEmpty((String)fieldValue)) continue;
                    for (String value : values) {
                        if (isFuzzy) {
                            if (!fieldValue.toLowerCase().contains(value.toLowerCase())) continue;
                            filterMatch = true;
                            break block1;
                        }
                        if (!fieldValue.toLowerCase().equals(value.toLowerCase())) continue;
                        filterMatch = true;
                        break block1;
                    }
                }
                if (isAllMatch && !filterMatch) {
                    isMatch = false;
                    break;
                }
                if (!isAllMatch && filterMatch) {
                    isMatch = true;
                    break;
                }
                if (!filterMatch) continue;
                isMatch = true;
            }
            return isMatch;
        }).skip(start).limit(limit).collect(Collectors.toList());
    }

    private static boolean checkByQFilter(DynamicObject dy, QFilter filter) {
        if (Objects.isNull(filter) || Objects.isNull(dy)) {
            return false;
        }
        Object data = dy.get(filter.getProperty());
        if (Objects.isNull(data)) {
            return "is null".equals(filter.getCP());
        }
        switch (filter.getCP()) {
            case "=": {
                return data.equals(filter.getValue());
            }
            case ">": 
            case "<": 
            case ">=": 
            case "<=": {
                return FormulaCacheUtils.compareNumAndDate(data, filter.getValue(), filter.getCP());
            }
            case "!=": 
            case "<>": {
                return !data.equals(filter.getValue());
            }
            case "like": {
                return String.valueOf(data).contains(String.valueOf(filter.getValue()).replace("%", ""));
            }
            case "not like": {
                return !String.valueOf(data).contains(String.valueOf(filter.getValue()).replace("%", ""));
            }
            case "in": 
            case "not in": {
                return FormulaCacheUtils.filterIn(data, filter.getValue(), filter.getCP());
            }
            case "is not null": {
                return true;
            }
        }
        return true;
    }

    private static boolean compareNumAndDate(Object data1, Object data2, String compareSymbol) {
        int compareResult = 0;
        if (data1 instanceof Date && data2 instanceof Date) {
            compareResult = ((Date)data1).compareTo((Date)data2);
        } else {
            if (Objects.isNull(data1) || Objects.isNull(data2)) {
                return false;
            }
            compareResult = new BigDecimal(String.valueOf(data1)).compareTo(new BigDecimal(String.valueOf(data2)));
        }
        switch (compareSymbol) {
            case ">": {
                return compareResult > 0;
            }
            case "<": {
                return compareResult < 0;
            }
            case ">=": {
                return compareResult >= 0;
            }
            case "<=": {
                return compareResult <= 0;
            }
        }
        return true;
    }

    private static boolean filterIn(Object data1, Object data2, String compareSymbol) {
        if (data2 instanceof Collection) {
            for (Object val : (Collection)data2) {
                if (!data1.equals(val)) continue;
                return "in".equals(compareSymbol);
            }
        }
        return !"in".equals(compareSymbol);
    }

    public static <T> List<T> getFunctionItemsFromPageCache(IFormView view, String keyName, Class<T> clazz) {
        HRPageCache pageCache = new HRPageCache(view);
        List functionItems = (List)pageCache.get(keyName, List.class);
        ArrayList functionItemList = Lists.newArrayListWithCapacity((int)functionItems.size());
        if (!CollectionUtils.isEmpty((Collection)functionItems)) {
            for (Object obj : functionItems) {
                if (obj instanceof Map) {
                    functionItemList.add(JSONObject.parseObject((String)SerializationUtils.toJsonString(obj), clazz));
                    continue;
                }
                functionItemList.add(obj);
            }
        }
        return functionItemList;
    }
}

