/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.utils;

import java.util.HashMap;
import java.util.Map;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.business.service.formula.enums.FormulaKeyEnum;
import kd.hr.hbp.business.service.formula.enums.InvokeMethodEnum;

public class FormulaOperatorUtils {
    private static Map<String, String> getOperatorMap() {
        HashMap<String, String> operatorMap = new HashMap<String, String>(35);
        operatorMap.put("oper_//", "// ");
        operatorMap.put("oper_point", ".");
        operatorMap.put("oper_quot", "\"\"");
        operatorMap.put("oper_divide", " / ");
        operatorMap.put("oper_multiply", " * ");
        operatorMap.put("oper_subtract", " - ");
        operatorMap.put("oper_plus", " + ");
        operatorMap.put("oper_equal", " = ");
        operatorMap.put("oper_unequal", " != ");
        operatorMap.put("oper_lt", " < ");
        operatorMap.put("oper_gt", " > ");
        operatorMap.put("oper_ltorequal", " <= ");
        operatorMap.put("oper_gtorequal", " >= ");
        operatorMap.put("oper_parentheses", "()");
        operatorMap.put("oper_long_annotation", "/*  */");
        operatorMap.put("condition_if", FormulaKeyEnum.IF.getAlias());
        operatorMap.put("condition_then", FormulaKeyEnum.THEN.getAlias());
        operatorMap.put("condition_elseif", FormulaKeyEnum.ELSEIF.getAlias());
        operatorMap.put("condition_else", FormulaKeyEnum.ELSE.getAlias());
        operatorMap.put("condition_and", FormulaKeyEnum.AND.getAlias());
        operatorMap.put("condition_or", FormulaKeyEnum.OR.getAlias());
        operatorMap.put("condition_like", FormulaKeyEnum.LIKE.getAlias());
        operatorMap.put("condition_null", FormulaKeyEnum.NULL.getAlias());
        operatorMap.put("condition_exit", FormulaKeyEnum.EXIT.getAlias());
        operatorMap.put("condition_result", FormulaKeyEnum.RESULT.getAlias());
        operatorMap.put("condition_endif", FormulaKeyEnum.ENDIF.getAlias());
        operatorMap.put("complex_while", FormulaKeyEnum.WHILE.getAlias());
        operatorMap.put("complex_while_end", FormulaKeyEnum.ENDWHILE.getAlias());
        operatorMap.put("type_text", DataTypeEnum.TEXT.getAlias());
        operatorMap.put("type_int", DataTypeEnum.INT.getAlias());
        operatorMap.put("type_boolean", DataTypeEnum.BOOLEAN.getAlias());
        operatorMap.put("type_num", DataTypeEnum.NUM.getAlias());
        operatorMap.put("type_date", DataTypeEnum.DATE.getAlias());
        operatorMap.put("type_datetime", DataTypeEnum.DATETIME.getAlias());
        operatorMap.put("type_object", DataTypeEnum.OBJECT.getAlias());
        operatorMap.put("type_arr_obj", DataTypeEnum.ARRAY_OBJECT.getAlias());
        operatorMap.put("type_arr_number", DataTypeEnum.ARRAY_NUM.getAlias());
        operatorMap.put("type_arr_text", DataTypeEnum.ARRAY_STRING.getAlias());
        operatorMap.put("type_arr_boolean", DataTypeEnum.ARRAY_BOOLEAN.getAlias());
        operatorMap.put("type_arr_int", DataTypeEnum.ARRAY_INT.getAlias());
        operatorMap.put("type_arr_date", DataTypeEnum.ARRAY_DATE.getAlias());
        operatorMap.put("invoke_length", InvokeMethodEnum.LENGTH.getAlias());
        operatorMap.put("op_export", FormulaKeyEnum.EXPORT.getAlias());
        return operatorMap;
    }

    public static String getOperatorValue(String key) {
        if (key == null || key.length() == 0) {
            return "";
        }
        Map<String, String> operatorMap = FormulaOperatorUtils.getOperatorMap();
        return operatorMap.get(key);
    }
}

