/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.formula.utils;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.service.formula.entity.FormulaInfo;
import kd.hr.hbp.business.service.formula.entity.expression.OperatorExpression;
import kd.hr.hbp.business.service.formula.entity.item.CalItem;
import kd.hr.hbp.business.service.formula.entity.item.DataGradeItem;
import kd.hr.hbp.business.service.formula.entity.item.DataGradeResultItem;
import kd.hr.hbp.business.service.formula.entity.item.Item;
import kd.hr.hbp.business.service.formula.entity.item.ReturnItem;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.business.service.formula.entity.node.OriginalNode;
import kd.hr.hbp.business.service.formula.enums.ConditionEnum;
import kd.hr.hbp.business.service.formula.enums.DataTypeEnum;
import kd.hr.hbp.business.service.formula.enums.FormulaKeyEnum;
import kd.hr.hbp.business.service.formula.enums.InvokeMethodEnum;
import kd.hr.hbp.business.service.formula.enums.OperatorEnum;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.StringUtils;

public class FormulaUtils {
    private static final String IS_INTEGER = "^[-+]?[\\d]+$";
    private static final Pattern IS_INTEGER_PATTERN = Pattern.compile("^[-+]?[\\d]+$");
    private static final String IS_DATE = "^[0-9/\\-:\\s]+$";
    private static final Pattern IS_DATE_STR_PATTERN = Pattern.compile("^[0-9/\\-:\\s]+$");

    public static String getItemMapKey(String itemCategory, String name) {
        return itemCategory + "[" + name + "]";
    }

    public static Map<String, TreeNodeItem> itemListToMap(List<TreeNodeItem> items) {
        if (!CollectionUtils.isEmpty(items)) {
            HashMap<String, TreeNodeItem> itemMap = new HashMap<String, TreeNodeItem>(items.size());
            for (TreeNodeItem treeNodeItem : items) {
                if (!HRStringUtils.isNotEmpty((String)treeNodeItem.getUniqueCode())) continue;
                itemMap.putIfAbsent(FormulaUtils.getItemMapKey(treeNodeItem.getItemCategory(), treeNodeItem.getName()), treeNodeItem);
                itemMap.computeIfPresent(FormulaUtils.getItemMapKey(treeNodeItem.getItemCategory(), treeNodeItem.getName()), (key, oldValue) -> {
                    if (!treeNodeItem.isHasChild()) {
                        return treeNodeItem;
                    }
                    if (oldValue.isHasChild()) {
                        return treeNodeItem;
                    }
                    return oldValue;
                });
            }
            return itemMap;
        }
        return new HashMap<String, TreeNodeItem>(16);
    }

    public static Set<String> getItemCategorySet(List<? extends TreeNodeItem> items) {
        if (!CollectionUtils.isEmpty(items)) {
            HashSet<String> itemCategorySet = new HashSet<String>(16);
            for (Item item : items) {
                itemCategorySet.add(item.getItemCategory());
            }
            return itemCategorySet;
        }
        return new HashSet<String>(16);
    }

    public static Map<String, ConditionEnum> getConditionMap() {
        HashMap<String, ConditionEnum> conditionKeyMap = new HashMap<String, ConditionEnum>(16);
        for (ConditionEnum conditionKeyEnum : ConditionEnum.values()) {
            conditionKeyMap.put(FormulaKeyEnum.getByAlias(conditionKeyEnum.getName()).getAlias(), conditionKeyEnum);
        }
        return conditionKeyMap;
    }

    public static Map<String, OperatorEnum> getOperatorMap() {
        return OperatorEnum.getAliasCacheMap();
    }

    public static Map<String, DataTypeEnum> getDataTypeMap() {
        return DataTypeEnum.getAliasCacheMap();
    }

    public static int getOperatorPriority(OperatorEnum operatorEnum) {
        switch (operatorEnum) {
            case LPARENTHESES: 
            case RPARENTHESES: {
                return 9;
            }
            case MULTIPLY: 
            case DIVIDE: {
                return 6;
            }
            case PLUS: 
            case SUBTRACT: {
                return 5;
            }
            case EQUAL: 
            case UNEQUAL: 
            case GT: 
            case LT: 
            case GTOREQUAL: 
            case LTOREQUAL: 
            case CONTAIN: {
                return 2;
            }
            case AND: 
            case OR: {
                return 1;
            }
        }
        return 0;
    }

    public static int compareOperatorPriority(OperatorEnum operatorEnum1, OperatorEnum operatorEnum2) {
        return FormulaUtils.getOperatorPriority(operatorEnum1) - FormulaUtils.getOperatorPriority(operatorEnum2);
    }

    public static int compareOperatorPriority(OperatorExpression operatorExpression1, OperatorExpression operatorExpression2) {
        Map<String, OperatorEnum> operationMap = FormulaUtils.getOperatorMap();
        OperatorEnum operatorEnum1 = operationMap.get(operatorExpression1.getNode().getNodeText());
        OperatorEnum operatorEnum2 = operationMap.get(operatorExpression2.getNode().getNodeText());
        return FormulaUtils.compareOperatorPriority(operatorEnum1, operatorEnum2);
    }

    public static OperatorEnum getOperatorEnum(OperatorExpression operatorExpression) {
        return OperatorEnum.getAliasCacheMap().get(operatorExpression.getNode().getNodeText());
    }

    public static String subStringNodeText(String nodeText) {
        if (null == nodeText) {
            return null;
        }
        return nodeText.substring(3, nodeText.length() - 1);
    }

    public static boolean isFormulaKey(String nodeText) {
        return FormulaKeyEnum.getAliasCacheMap().containsKey(nodeText);
    }

    public static boolean isOperation(String nodeText) {
        return FormulaUtils.getOperatorMap().containsKey(nodeText);
    }

    public static boolean isDataType(String nodeText) {
        return FormulaUtils.getDataTypeMap().containsKey(nodeText);
    }

    public static boolean isNullType(String nodeText) {
        DataTypeEnum dataTypeEnum = FormulaUtils.getDataTypeMap().get(nodeText);
        return DataTypeEnum.NULL == dataTypeEnum;
    }

    public static boolean isNotNullDataType(String nodeText) {
        boolean isDataType = FormulaUtils.isDataType(nodeText);
        if (isDataType) {
            return DataTypeEnum.NULL != FormulaUtils.getDataTypeMap().get(nodeText);
        }
        return false;
    }

    public static boolean isArrayIndex(OriginalNode node, FormulaInfo formula) {
        String nodeText = node.getNodeText();
        if (HRStringUtils.isNotEmpty((String)nodeText) && nodeText.startsWith("[") && nodeText.endsWith("]")) {
            String index = nodeText.substring(1, nodeText.length() - 1);
            if (FormulaUtils.isInteger(index)) {
                return true;
            }
            OriginalNode tempVariable = formula.getTempVariableMap().get(FormulaUtils.getTempVariableCode(index));
            if (Objects.nonNull(tempVariable)) {
                if (DataTypeEnum.INT == tempVariable.getDataType()) {
                    return true;
                }
                throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff0c\u7b2c{1}\u5217\uff0c\u201c{2}\u201d\u4f5c\u4e3a\u6570\u7ec4\u7d22\u5f15\uff0c\u5fc5\u987b\u5b9a\u4e49\u4e3a\u6574\u6570\u3002", (String)"FormulaUtils_0", (String)"hrmp-hbp-business", (Object[])new Object[0]), node.getLineIndex() + 1, node.getStartColumnIndex() + 1, node.getNodeText()));
            }
        }
        return false;
    }

    public static boolean isFunction(FormulaInfo formulaInfo, String nodeText) {
        if (null == nodeText || Objects.isNull(formulaInfo) || Objects.isNull(formulaInfo.getFcMap())) {
            return false;
        }
        return Objects.nonNull(formulaInfo.getFcMap().get(nodeText));
    }

    public static boolean isDataGrade(FormulaInfo formulaInfo, String nodeText) {
        if (null == nodeText || Objects.isNull(formulaInfo) || Objects.isNull(formulaInfo.getDataGradeMap())) {
            return false;
        }
        return Objects.nonNull(formulaInfo.getDataGradeMap().get(nodeText));
    }

    public static boolean isDataGradeResult(FormulaInfo formulaInfo, String dataGradeText, String nodeText, int index, List<OriginalNode> nodes) {
        if (null == dataGradeText || null == nodeText || Objects.isNull(formulaInfo) || Objects.isNull(formulaInfo.getDataGradeMap()) || nodes == null) {
            return false;
        }
        if (index >= nodes.size()) {
            return false;
        }
        DataGradeItem dataGradeItem = formulaInfo.getDataGradeMap().get(dataGradeText);
        if (Objects.isNull(dataGradeItem) || Objects.isNull(dataGradeItem.getReturnDataMap())) {
            return false;
        }
        OriginalNode nextNode = nodes.get(index + 1);
        if (!OperatorEnum.RPARENTHESES.getAlias().equals(nextNode.getNodeText())) {
            return false;
        }
        return Objects.nonNull(dataGradeItem.getReturnDataMap().get(nodeText));
    }

    public static boolean isItem(FormulaInfo formulaInfo, String nodeText) {
        if (null == nodeText || Objects.isNull(formulaInfo) || Objects.isNull(formulaInfo.getCalItemMap())) {
            return false;
        }
        CalItem calItem = formulaInfo.getCalItemMap().get(nodeText);
        return Objects.nonNull(calItem);
    }

    public static boolean isCalItem(FormulaInfo formulaInfo, String nodeText) {
        if (null == nodeText || Objects.isNull(formulaInfo) || Objects.isNull(formulaInfo.getCalItemMap())) {
            return false;
        }
        CalItem calItem = formulaInfo.getCalItemMap().get(nodeText);
        if (Objects.nonNull(calItem)) {
            return !calItem.isCustomItem();
        }
        return false;
    }

    public static boolean isCalCustomItem(FormulaInfo formulaInfo, String nodeText) {
        if (null == nodeText || Objects.isNull(formulaInfo) || Objects.isNull(formulaInfo.getCalItemMap())) {
            return false;
        }
        CalItem calItem = formulaInfo.getCalItemMap().get(nodeText);
        if (Objects.nonNull(calItem)) {
            return calItem.isCustomItem();
        }
        return false;
    }

    public static boolean isCanAssignmentItem(FormulaInfo formulaInfo, String nodeText) {
        if (null == nodeText || Objects.isNull(formulaInfo) || Objects.isNull(formulaInfo.getCalItemMap())) {
            return false;
        }
        CalItem calItem = formulaInfo.getCalItemMap().get(nodeText);
        if (Objects.nonNull(calItem)) {
            return calItem.isCanAssignment();
        }
        return false;
    }

    public static boolean isTempVariable(FormulaInfo formulaInfo, String nodeText) {
        if (null == nodeText || Objects.isNull(formulaInfo) || Objects.isNull(formulaInfo.getTempVariableMap())) {
            return false;
        }
        return Objects.nonNull(formulaInfo.getTempVariableMap().get(FormulaUtils.getTempVariableCode(nodeText)));
    }

    public static boolean isExit(String nodeText) {
        return FormulaKeyEnum.EXIT == FormulaKeyEnum.getByAlias(nodeText);
    }

    public static String getTempVariableCode(String nodeText) {
        if (Objects.isNull(nodeText)) {
            return "_";
        }
        return "_" + nodeText;
    }

    public static boolean isNumber(String str) {
        try {
            new BigDecimal(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isInteger(String str) {
        return IS_INTEGER_PATTERN.matcher(str).matches();
    }

    public static boolean isString(String str) {
        return str.startsWith(OperatorEnum.QUOT.getAlias());
    }

    public static boolean isInvokeMethod(String str) {
        return str.startsWith(OperatorEnum.SPOT.getAlias()) && Objects.nonNull((Object)InvokeMethodEnum.getInvokeMethodEnum(str));
    }

    public static boolean isDate(String str) {
        try {
            String dateStr;
            if (HRStringUtils.isNotEmpty((String)str) && str.startsWith(OperatorEnum.QUOT.getAlias()) && IS_DATE_STR_PATTERN.matcher(dateStr = str.replace("\"", "")).matches()) {
                HRDateTimeUtils.parseDate((String)dateStr);
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isGtMaxInteger(String value) {
        BigDecimal compareValue;
        if (value == null) {
            return false;
        }
        BigDecimal maxValue = new BigDecimal(String.valueOf(Integer.MAX_VALUE));
        return maxValue.compareTo(compareValue = new BigDecimal(value)) < 0;
    }

    public static boolean isLtMinInteger(String value) {
        BigDecimal compareValue;
        if (value == null) {
            return false;
        }
        BigDecimal minValue = new BigDecimal(String.valueOf(Integer.MIN_VALUE));
        return minValue.compareTo(compareValue = new BigDecimal(value)) > 0;
    }

    public static <T> T convertMapToObject(Map map, Class<T> clazz) {
        if (Objects.nonNull(map)) {
            return (T)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)map), clazz);
        }
        return null;
    }

    public static boolean isBoolean(String str) {
        return "true".equalsIgnoreCase(str) || "false".equalsIgnoreCase(str);
    }

    public static boolean isAssignmentMeaning(FormulaInfo formula, List<OriginalNode> nodes, int index) {
        if (index < 0) {
            return false;
        }
        OriginalNode originalNode = nodes.get(index);
        boolean isCustomItem = FormulaUtils.isCalCustomItem(formula, originalNode.getNodeText());
        boolean isCalItem = FormulaUtils.isCalItem(formula, originalNode.getNodeText());
        boolean isTempVariable = FormulaUtils.isTempVariable(formula, originalNode.getNodeText());
        if (!(isCustomItem || isCalItem || isTempVariable)) {
            return false;
        }
        if (index > 0) {
            OperatorEnum preOpEnum = OperatorEnum.getAliasCacheMap().get(nodes.get(index - 1).getNodeText());
            boolean preNodeIsDataType = FormulaUtils.isNotNullDataType(nodes.get(index - 1).getNodeText());
            if (Objects.nonNull((Object)preOpEnum)) {
                return preOpEnum == OperatorEnum.QUOT || preOpEnum == OperatorEnum.EMPTY || preOpEnum == OperatorEnum.RPARENTHESES;
            }
            return !preNodeIsDataType;
        }
        return true;
    }

    public static boolean checkIsCanAssignment(FormulaInfo formula, List<OriginalNode> nodes, int index) {
        if (index < 0) {
            return false;
        }
        OriginalNode originalNode = nodes.get(index);
        boolean isAssignmentItem = FormulaUtils.isCanAssignmentItem(formula, originalNode.getNodeText());
        boolean isTempVariable = FormulaUtils.isTempVariable(formula, originalNode.getNodeText());
        if (!isAssignmentItem && !isTempVariable) {
            return false;
        }
        if (index > 0) {
            OperatorEnum preOpEnum = OperatorEnum.getAliasCacheMap().get(nodes.get(index - 1).getNodeText());
            boolean preNodeIsDataType = FormulaUtils.isNotNullDataType(nodes.get(index - 1).getNodeText());
            if (Objects.nonNull((Object)preOpEnum)) {
                return preOpEnum == OperatorEnum.QUOT || preOpEnum == OperatorEnum.EMPTY || preOpEnum == OperatorEnum.RPARENTHESES;
            }
            return !preNodeIsDataType;
        }
        return true;
    }

    public static List<TreeNodeItem> getDataGradeTreeItemList(List<? extends TreeNodeItem> dataGradeItemList) {
        if (Objects.nonNull(dataGradeItemList)) {
            ArrayList returnList = Lists.newArrayListWithExpectedSize((int)(3 * dataGradeItemList.size()));
            for (TreeNodeItem treeNodeItem : dataGradeItemList) {
                if (treeNodeItem instanceof DataGradeItem) {
                    Map<String, ReturnItem> resultDataMap = ((DataGradeItem)treeNodeItem).getReturnDataMap();
                    for (String resultName : resultDataMap.keySet()) {
                        returnList.add(new DataGradeResultItem((DataGradeItem)treeNodeItem, resultName));
                    }
                }
                returnList.add(treeNodeItem);
            }
            return returnList;
        }
        return Lists.newArrayListWithExpectedSize((int)16);
    }

    public static List<HRBaseServiceHelper> getFormulaTplAllChildMetaServiceHelper() {
        HRBaseServiceHelper metaHelper = new HRBaseServiceHelper("bos_formmeta");
        QFilter numberFilter = new QFilter("number", "=", (Object)"hbp_formulatpl");
        DynamicObject parentMeta = metaHelper.queryOne(new QFilter[]{numberFilter});
        String parentId = parentMeta.getString("id");
        QFilter sonFilter = new QFilter("inheritPath", "like", (Object)("%" + parentId + "%"));
        DynamicObject[] sonMetas = metaHelper.queryOriginalArray("number", new QFilter[]{sonFilter});
        ArrayList numberList = Lists.newArrayListWithCapacity((int)sonMetas.length);
        for (DynamicObject son : sonMetas) {
            String number = son.getString("number");
            try {
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
                if (StringUtils.isEmpty((CharSequence)dataEntityType.getAlias())) continue;
                numberList.add(number);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return numberList.stream().map(HRBaseServiceHelper::new).collect(Collectors.toList());
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }
}

