/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.funcentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.PermissionControlType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.service.funcentity.MergeMasterAppIdMapFunction;
import kd.hr.hbp.business.service.funcentity.constants.FunctionEntityConstants;
import kd.hr.hbp.business.service.funcentity.model.ControlPermNotAuthorize;
import kd.hr.hbp.business.service.funcentity.model.FunctionEntityRowMeta;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRCloudServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class FunctionEntityService
implements FunctionEntityConstants {
    private static final Log LOGGER = LogFactory.getLog(FunctionEntityService.class);

    public static ControlPermNotAuthorize getControlPermNotAuthorize() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_entityforbid");
        DynamicObject[] dys = serviceHelper.queryOriginalArray("id,entitytypeid,app,permitem,forbidtype", new QFilter[0]);
        HashSet notAuthEntityNumbers = Sets.newHashSetWithExpectedSize((int)dys.length);
        HashSet notAuthAppIds = Sets.newHashSetWithExpectedSize((int)dys.length);
        HashMap notAuthAppEntities = Maps.newHashMapWithExpectedSize((int)dys.length);
        HashMap notAuthEntityPerms = Maps.newHashMapWithExpectedSize((int)dys.length);
        HashMap notAuthAppEntityPerms = Maps.newHashMapWithExpectedSize((int)dys.length);
        block14: for (DynamicObject dy : dys) {
            String forBidType = dy.getString("forbidtype");
            String entityNum = dy.getString("entitytypeid");
            String appId = dy.getString("app");
            String permItemId = dy.getString("permitem");
            switch (forBidType) {
                case "1": {
                    if (!HRStringUtils.isNotEmpty((String)entityNum)) continue block14;
                    notAuthEntityNumbers.add(entityNum);
                    continue block14;
                }
                case "2": {
                    if (!HRStringUtils.isNotEmpty((String)appId)) continue block14;
                    notAuthAppIds.add(appId);
                    continue block14;
                }
                case "3": {
                    if (!HRStringUtils.isNotEmpty((String)appId) || !HRStringUtils.isNotEmpty((String)entityNum)) continue block14;
                    Set entityList = notAuthAppEntities.computeIfAbsent(appId, key -> Sets.newHashSetWithExpectedSize((int)dys.length));
                    entityList.add(entityNum);
                    continue block14;
                }
                case "4": {
                    if (!HRStringUtils.isNotEmpty((String)entityNum) || !HRStringUtils.isNotEmpty((String)permItemId)) continue block14;
                    Set permItemList = notAuthEntityPerms.computeIfAbsent(entityNum, key -> Sets.newHashSetWithExpectedSize((int)dys.length));
                    permItemList.add(permItemId);
                    continue block14;
                }
                case "5": {
                    if (!HRStringUtils.isNotEmpty((String)appId) || !HRStringUtils.isNotEmpty((String)entityNum) || !HRStringUtils.isNotEmpty((String)permItemId)) continue block14;
                    Map entityPermMap = notAuthAppEntityPerms.computeIfAbsent(appId, key -> Maps.newHashMapWithExpectedSize((int)dys.length));
                    Set permItemList = entityPermMap.computeIfAbsent(entityNum, key -> Sets.newHashSetWithExpectedSize((int)dys.length));
                    permItemList.add(permItemId);
                    continue block14;
                }
            }
        }
        return new ControlPermNotAuthorize(notAuthEntityNumbers, notAuthAppIds, notAuthAppEntities, notAuthEntityPerms, notAuthAppEntityPerms);
    }

    public static Map<String, Map<String, Set<String>>> queryAllIndependentPerm() {
        HRBaseServiceHelper configHelper = new HRBaseServiceHelper("hrcs_permrelatcfg");
        QFilter filter = new QFilter("isassign", "=", (Object)"1");
        DynamicObject[] configs = configHelper.query("app,entitytype,permitem", new QFilter[]{filter});
        HashMap result = Maps.newHashMapWithExpectedSize((int)configs.length);
        for (DynamicObject config : configs) {
            String app = config.getString("app.id");
            String entityType = config.getString("entitytype.id");
            if (app == null || null == entityType) continue;
            Map map = result.computeIfAbsent(app, key -> Maps.newHashMapWithExpectedSize((int)16));
            String permItemNum = config.getString("permitem.number");
            Set perms = (Set)map.get(entityType);
            if (null == perms) {
                perms = Sets.newHashSet((Object[])new String[]{permItemNum});
                map.put(entityType, perms);
                continue;
            }
            perms.add(permItemNum);
        }
        return result;
    }

    public static Map<String, Map<String, Set<String>>> getAllRelatedPerms() {
        Map<String, Map<String, Set<String>>> allIndependentPerm = FunctionEntityService.queryAllIndependentPerm();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_permrelat");
        DynamicObject[] permRelates = serviceHelper.query("entryentity.entitytypeid,entryentity.app,entryentity.permitemid", new QFilter[0]);
        HashMap entityPermMap = Maps.newHashMapWithExpectedSize((int)16);
        if (permRelates.length > 0) {
            for (DynamicObject permRelate : permRelates) {
                DynamicObjectCollection entry = permRelate.getDynamicObjectCollection("entryentity");
                for (DynamicObject dy : entry) {
                    String entityTypeId = dy.getString("entitytypeid.id");
                    String appId = dy.getString("app.id");
                    if (HRStringUtils.isEmpty((String)entityTypeId) || HRStringUtils.isEmpty((String)appId)) continue;
                    Map appMap = entityPermMap.computeIfAbsent(appId, key -> Maps.newHashMapWithExpectedSize((int)16));
                    Set permItems = appMap.computeIfAbsent(entityTypeId, key -> Sets.newHashSetWithExpectedSize((int)16));
                    Set idSet = Arrays.stream(dy.getString("permitemid").split(",")).collect(Collectors.toSet());
                    if (allIndependentPerm.get(appId) != null && allIndependentPerm.get(appId).get(entityTypeId) != null) {
                        allIndependentPerm.get(appId).get(entityTypeId).forEach(idSet::remove);
                    }
                    permItems.addAll(idSet);
                }
            }
        }
        return entityPermMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSet getFunctionEntityDS(FunctionEntityRowMeta rowMeta) {
        DataSet dataSet;
        DataSet mainEntityDS = null;
        DataSet deployAppEntityDS = null;
        DataSet deployAppToEntityIdDs = null;
        DataSet allAppEntityIdDS = null;
        DataSet funcPermDS = null;
        DataSet cloudSeqDS = null;
        DataSet cloudNameDS = null;
        DataSet industryDS = null;
        try {
            Set<String> allHRCloudIds = HRCloudServiceHelper.getAllHRCloudId();
            mainEntityDS = new HRBaseServiceHelper("bos_entityobject").queryDataSet("FunctionEntityService_mainEntity", String.join((CharSequence)",", "bizappid", "bizappid.masterid", "dentityid,id,name"), new QFilter[]{new QFilter("istemplate", "=", (Object)"0"), new QFilter("bizappid.bizcloud", "in", allHRCloudIds)});
            mainEntityDS = mainEntityDS.map((MapFunction)new MergeMasterAppIdMapFunction(mainEntityDS.getRowMeta()));
            deployAppEntityDS = new HRBaseServiceHelper("perm_bizobjapp").queryDataSet("FunctionEntityService_deployEntity", "bizapp,bizobj");
            deployAppToEntityIdDs = deployAppEntityDS.join(mainEntityDS).on("bizobj", "id").select(new String[]{"bizapp"}, new String[]{"dentityid", "id", "name"}).finish();
            allAppEntityIdDS = mainEntityDS.union(deployAppToEntityIdDs);
            final ControlPermNotAuthorize controlPermNotAuthorize = FunctionEntityService.getControlPermNotAuthorize();
            Set<String> bosNotAuthEntities = FunctionEntityService.queryNoCtrlPermEntitiesHr(allHRCloudIds);
            if (!bosNotAuthEntities.isEmpty()) {
                HashMap filterData = Maps.newHashMapWithExpectedSize((int)1);
                filterData.put("bos_not_auth_entities", bosNotAuthEntities);
                allAppEntityIdDS = allAppEntityIdDS.filter("id not in (bos_not_auth_entities)", (Map)filterData);
            }
            allAppEntityIdDS = allAppEntityIdDS.filter(new FilterFunction(){
                private static final long serialVersionUID = 3922963415921785316L;

                public boolean test(Row row) {
                    Set<String> notAuthAppIds = controlPermNotAuthorize.getNotAuthAppIds();
                    Set<String> notAuthEntityNumbers = controlPermNotAuthorize.getNotAuthEntityNumbers();
                    String appId = row.getString("bizappid");
                    String entityNumber = row.getString("id");
                    return !notAuthAppIds.contains(appId) && !notAuthEntityNumbers.contains(entityNumber);
                }
            });
            String appBlacklist = RunModeServiceHelper.getAppIdFromBlacklist();
            if (HRStringUtils.isNotEmpty((String)appBlacklist)) {
                allAppEntityIdDS = allAppEntityIdDS.filter("bizappid not in (" + appBlacklist + ")");
            }
            funcPermDS = DB.queryDataSet((String)"FunctionEntityService_functionPermItem", (DBRoute)DBRoute.permission, (String)"select distinct funcperm.FDENTITYTYPEID funcperm_entid, funcperm.fpermitemid funcperm_permitemid ,permitem.fnumber perm_item_num from t_perm_functionperm funcperm INNER JOIN t_perm_permitem permitem ON permitem.FID = funcperm.FPERMITEMID ");
            DataSet finalDS = allAppEntityIdDS.join(funcPermDS).on("dentityid", "funcperm_entid").select(new String[]{"bizappid as biz_app_id", "dentityid as entity_id", "id as entity_number", "name as entity_name"}, new String[]{"funcperm_permitemid as perm_item_id", "perm_item_num"}).finish();
            final Map<String, Map<String, Set<String>>> allRelatedPerms = FunctionEntityService.getAllRelatedPerms();
            finalDS = finalDS.filter(new FilterFunction(){
                private static final long serialVersionUID = -5366576814941645232L;

                public boolean test(Row row) {
                    Set<String> permItems;
                    Set relPerms;
                    String appId = row.getString("biz_app_id");
                    String entityNumber = row.getString("entity_number");
                    String permItemId = row.getString("perm_item_id");
                    String permItemNum = row.getString("perm_item_num");
                    if (allRelatedPerms.get(appId) != null && (relPerms = (Set)((Map)allRelatedPerms.get(appId)).get(entityNumber)) != null && HRStringUtils.isNotEmpty((String)permItemNum) && relPerms.contains(permItemNum)) {
                        return false;
                    }
                    Map<String, Set<String>> notAuthAppEntities = controlPermNotAuthorize.getNotAuthAppEntities();
                    Set<String> appEntityNumbers = notAuthAppEntities.get(appId);
                    if (appEntityNumbers != null && appEntityNumbers.contains(entityNumber)) {
                        return false;
                    }
                    Map<String, Set<String>> notAuthEntityPerms = controlPermNotAuthorize.getNotAuthEntityPerms();
                    Set<String> entityPermItems = notAuthEntityPerms.get(entityNumber);
                    if (entityPermItems != null && entityPermItems.contains(permItemId)) {
                        return false;
                    }
                    Map<String, Map<String, Set<String>>> notAuthAppEntityPerm = controlPermNotAuthorize.getNotAuthAppEntityPerms();
                    Map<String, Set<String>> appEntityPerms = notAuthAppEntityPerm.get(appId);
                    if (appEntityPerms != null && (permItems = appEntityPerms.get(entityNumber)) != null) {
                        return !permItems.contains(permItemId);
                    }
                    return true;
                }
            });
            cloudSeqDS = new HRBaseServiceHelper("hrcs_hrcloud").queryDataSet("FunctionEntityService_cloudSeq", "id,index cloud_index");
            cloudNameDS = FunctionEntityService.getCloudDS().join(cloudSeqDS).on("cloud_id", "id").select(new String[]{"cloud_id", "cloud_name", "app_id", "app_name", "app_industry"}, new String[]{"cloud_index"}).finish();
            finalDS = cloudNameDS.join(finalDS).on("app_id", "biz_app_id").select(new String[]{"cloud_id", "cloud_name", "cloud_index", "app_id", "app_name", "app_industry"}, new String[]{"entity_id", "entity_number", "entity_name"}).finish().distinct();
            industryDS = FunctionEntityService.getIndustryDS();
            dataSet = finalDS = finalDS.leftJoin(industryDS).on("app_industry", "industry_id").select(new String[]{"cloud_id", "cloud_name", "cloud_index", "app_id", "app_name", "entity_id", "entity_number", "entity_name"}, new String[]{"app_industry_name"}).finish().orderBy(new String[]{"cloud_index asc", "app_id asc"}).select(FunctionEntityService.getReturnFieldAlias(rowMeta));
        }
        catch (Throwable throwable) {
            FunctionEntityService.closeDataSets(mainEntityDS, deployAppEntityDS, deployAppToEntityIdDs, allAppEntityIdDS, funcPermDS, cloudSeqDS, cloudNameDS, industryDS);
            throw throwable;
        }
        FunctionEntityService.closeDataSets(mainEntityDS, deployAppEntityDS, deployAppToEntityIdDs, allAppEntityIdDS, funcPermDS, cloudSeqDS, cloudNameDS, industryDS);
        return dataSet;
    }

    private static DataSet getCloudDS() {
        String cloudNumBlackList;
        StringBuilder sb = new StringBuilder().append("select cloudl.fid cloud_id, cloudl.fname cloud_name, cloud.fseq cloud_seq, ").append(" appr.FID app_id, appl.fname app_name, app.findustry app_industry").append(" from  t_meta_appruntime appr ").append(" INNER JOIN  t_meta_appruntime_l appl ON (appr.fappid = appl.fappid AND appl.flocaleid = ?) ").append(" INNER JOIN  t_meta_bizapp app ON (appr.FID = app.FID) ").append(" INNER JOIN  t_meta_bizcloud cloud ON (cloud.FID = appr.fcloudid) ").append(" INNER JOIN t_meta_bizcloud_l cloudl ON (cloudl.FID = cloud.FID AND cloudl.FLOCALEID = ?)").append(" AND appr.falluserapp <> '1'").append(" AND appr.fdeploystatus  = '2' ");
        Set<String> cloudIds = HRCloudServiceHelper.getAllHRCloudId();
        if (!CollectionUtils.isEmpty(cloudIds)) {
            sb.append(" and cloudl.fid in ( '").append(String.join((CharSequence)"','", cloudIds)).append("')");
        }
        if (StringUtils.isNotEmpty((String)(cloudNumBlackList = RunModeServiceHelper.getCloudIdsFromBlackList()))) {
            sb.append(" and cloudl.fid not in (").append(cloudNumBlackList).append(')');
        }
        return DB.queryDataSet((String)"FunctionEntityService_cloudApps", (DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])new Object[]{RequestContext.get().getLang().name(), RequestContext.get().getLang().name()});
    }

    private static DataSet getIndustryDS() {
        return new HRBaseServiceHelper("bos_devp_industry").queryDataSet("FunctionEntityService_industry", "id as industry_id, name as app_industry_name");
    }

    private static String[] getReturnFieldAlias(FunctionEntityRowMeta rowMeta) {
        ArrayList returnFieldAlias = Lists.newArrayList();
        returnFieldAlias.add("cloud_id as " + rowMeta.getCloudIdAlias());
        returnFieldAlias.add("cloud_name as " + rowMeta.getCloudNameAlias());
        returnFieldAlias.add("cloud_index as " + rowMeta.getCloudIndexAlias());
        returnFieldAlias.add("app_id as " + rowMeta.getAppIdAlias());
        returnFieldAlias.add("app_name as " + rowMeta.getAppNameAlias());
        returnFieldAlias.add("app_industry_name as " + rowMeta.getAppIndustryNameAlias());
        returnFieldAlias.add("entity_id as " + rowMeta.getEntityIdAlias());
        returnFieldAlias.add("entity_number as " + rowMeta.getEntityNumberAlias());
        returnFieldAlias.add("entity_name as " + rowMeta.getEntityNameAlias());
        return returnFieldAlias.toArray(new String[0]);
    }

    private static void closeDataSets(DataSet ... dataSets) {
        for (DataSet dataSet : dataSets) {
            if (dataSet == null) continue;
            dataSet.close();
        }
    }

    public static Set<String> queryNoCtrlPermEntitiesHr(Set<String> cloudIds) {
        HashSet noCtrlPermEntities = Sets.newHashSetWithExpectedSize((int)16);
        long startTime = System.currentTimeMillis();
        String sql = "select en.FNUMBER, en.FDATA from T_META_ENTITY en left join t_meta_mainentityinfo e on en.fnumber = e.fid left join t_meta_bizapp a on e.fbizappid = a.fid where en.FKEY = 'CtrlType' AND en.FTYPE = '24' and en.FKEY = 'CtrlType' AND en.FTYPE = '24' ";
        if (cloudIds != null && !cloudIds.isEmpty()) {
            sql = sql + "and a.fbizcloudid in (" + cloudIds.stream().map(cloudId -> "'" + cloudId + "'").collect(Collectors.joining(",")) + ") ";
        }
        String algoKey = "FunctionEntityService.queryEntityIsCtrlPermBatch";
        try (DataSet dataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.meta, (String)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String data = row.getString("FDATA");
                PermissionControlType pct = (PermissionControlType)SerializationUtils.fromJsonString((String)data, PermissionControlType.class);
                if (pct.isControlFunction()) continue;
                noCtrlPermEntities.add(row.getString("FNUMBER"));
            }
        }
        LOGGER.info("FunctionEntityService_queryNoCtrlPermEntities end,cost_mills:{} ms", (Object)(System.currentTimeMillis() - startTime));
        return noCtrlPermEntities;
    }
}

