/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.labelandreport;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.complexobj.ReportQueryService;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.HRComplexObjContext;
import kd.hr.hbp.common.model.complexobj.labelandreport.FieldTreeNode;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinEntityCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.labelandreport.ComplexObjTransferUtil;

public class DataPreviewService {
    private static final Log LOGGER = LogFactory.getLog(DataPreviewService.class);

    public static FormShowParameter getDataPreviewShowParameter(HRComplexObjContext hrComplexObjContext, List<Map<String, String>> fieldMap) {
        List<Object> dataPreviewData = CollectionUtils.isEmpty(fieldMap) ? Lists.newArrayList() : DataPreviewService.getDataPreviewData(hrComplexObjContext);
        DataPreviewService.formatData(dataPreviewData, fieldMap);
        LOGGER.info("fieldMap:{}", (Object)SerializationUtils.toJsonString(fieldMap));
        LOGGER.info("dataPreviewData:{}", (Object)SerializationUtils.toJsonString((Object)dataPreviewData));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hbp_datapreview");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("fieldList", fieldMap);
        showParameter.setCustomParam("values", (Object)dataPreviewData);
        return showParameter;
    }

    @ExcludeFromJacocoGeneratedReport
    public static List<Map<String, String>> getDataPreviewField(String queryFieldListStr) {
        List treeNodeList = JSON.parseArray((String)queryFieldListStr, FieldTreeNode.class);
        ArrayList fieldList = Lists.newArrayListWithExpectedSize((int)treeNodeList.size());
        for (FieldTreeNode treeNode : treeNodeList) {
            if (HRStringUtils.isEmpty((String)treeNode.getFieldAlias())) continue;
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("id", treeNode.getFieldAlias());
            map.put("name", treeNode.getName().getLocaleValue());
            map.put("type", treeNode.getValueType());
            fieldList.add(map);
        }
        return fieldList;
    }

    @ExcludeFromJacocoGeneratedReport
    public static HRComplexObjContext getContext(String entityNodesStr, String queryFieldListStr, List<QFilter> qFilterList) {
        List joinEntityCommonBoList = JSON.parseArray((String)entityNodesStr, JoinEntityCommonBo.class);
        List treeNodeList = JSON.parseArray((String)queryFieldListStr, FieldTreeNode.class);
        List entityRelationCommonBoList = joinEntityCommonBoList.stream().filter(joinEntityCommonBo -> joinEntityCommonBo.getEntityRelation() != null).map(JoinEntityCommonBo::getEntityRelation).collect(Collectors.toList());
        List queryFieldCommonBoList = treeNodeList.stream().filter(treeNode -> !HRStringUtils.isEmpty((String)treeNode.getFieldAlias())).map(treeNode -> {
            QueryFieldCommonBo queryFieldCommonBo = new QueryFieldCommonBo();
            queryFieldCommonBo.setValueType(treeNode.getValueType());
            queryFieldCommonBo.setFieldName(treeNode.getName());
            queryFieldCommonBo.setFieldPath(treeNode.getFieldPath());
            queryFieldCommonBo.setEntityNumber(treeNode.getEntityNumber());
            queryFieldCommonBo.setComplexType(treeNode.getComplexType());
            queryFieldCommonBo.setFieldAlias(treeNode.getFieldAlias());
            return queryFieldCommonBo;
        }).collect(Collectors.toList());
        HRComplexObjContext hrComplexObjContext = ComplexObjTransferUtil.transferToComplexObjContext((List)joinEntityCommonBoList, queryFieldCommonBoList, entityRelationCommonBoList, qFilterList);
        if (hrComplexObjContext != null) {
            hrComplexObjContext.setTransferField(false);
        }
        return hrComplexObjContext;
    }

    public static List<Map<String, String>> getDataPreviewData(HRComplexObjContext hrComplexObjContext) {
        ReportQueryService reportQueryService = new ReportQueryService(hrComplexObjContext);
        List<Map<String, Object>> dataList = reportQueryService.queryMap(0, 500);
        ArrayList previewDataList = Lists.newArrayListWithExpectedSize((int)dataList.size());
        InteServiceImpl service = new InteServiceImpl();
        String dateFormat = service.getDateFormat(Long.valueOf(RequestContext.get().getCurrUserId()));
        dataList.forEach(data -> {
            HashMap previewDataMap = Maps.newHashMapWithExpectedSize((int)data.size());
            for (Map.Entry entry : data.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if ("id".equals(key) || key.endsWith(".id")) continue;
                String valueStr = DataPreviewService.formatData(value, dateFormat);
                previewDataMap.put(key, valueStr);
            }
            previewDataList.add(previewDataMap);
        });
        return previewDataList;
    }

    @ExcludeFromJacocoGeneratedReport
    private static String formatData(Object value, String dateFormat) {
        String valueStr = value instanceof Date ? HRDateTimeUtils.format((Date)((Date)value), (String)dateFormat) : (value instanceof BigDecimal ? ((BigDecimal)value).toPlainString() : (value == null ? "" : value.toString()));
        return valueStr;
    }

    private static void formatData(List<Map<String, String>> dataPreviewData, List<Map<String, String>> fieldMapList) {
        DataPreviewService.removeId(fieldMapList);
        DataPreviewService.replaceDot(dataPreviewData, fieldMapList);
    }

    private static void removeId(List<Map<String, String>> fieldMapList) {
        ArrayList removeList = Lists.newArrayListWithExpectedSize((int)fieldMapList.size());
        fieldMapList.forEach(fieldMap -> {
            String id = (String)fieldMap.get("id");
            if ("id".equals(id) || id.endsWith(".id")) {
                removeList.add(fieldMap);
            }
        });
        fieldMapList.removeAll(removeList);
    }

    private static void replaceDot(List<Map<String, String>> dataPreviewData, List<Map<String, String>> fieldMapList) {
        dataPreviewData.forEach(dataMap -> {
            HashMap newDataMap = Maps.newHashMapWithExpectedSize((int)dataMap.size());
            dataMap.forEach((key, value) -> {
                String newKey = key.contains(".") ? key.replaceAll("\\.", "#") : key;
                newDataMap.put(newKey, value);
            });
            dataMap.clear();
            dataMap.putAll(newDataMap);
        });
        fieldMapList.forEach(fieldMap -> {
            String newKey = ((String)fieldMap.get("id")).contains(".") ? ((String)fieldMap.get("id")).replaceAll("\\.", "#") : (String)fieldMap.get("id");
            fieldMap.put("id", newKey);
        });
    }
}

