/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.labelandreport;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.ext.hr.metadata.prop.QueryProp;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.common.model.complexobj.SelectFieldTreeNode;
import kd.hr.hbp.common.util.HRStringUtils;

public class SelectEntityFieldUtil {
    public static void findNode(String fieldAlias, SelectFieldTreeNode node, List<SelectFieldTreeNode> result) {
        if (HRStringUtils.equals((String)node.getFieldAlias(), (String)fieldAlias)) {
            result.add(node);
        } else {
            List children = node.getChildren();
            if (children != null) {
                for (SelectFieldTreeNode child : children) {
                    SelectEntityFieldUtil.findNode(fieldAlias, child, result);
                }
            }
        }
    }

    public static SelectFieldTreeNode getEntityFieldsShowHR(boolean showHRPersonQuery, String entityNum, String entityAlias, boolean isMainEntity) {
        return SelectEntityFieldUtil.getEntityFields(showHRPersonQuery, entityNum, entityAlias, isMainEntity, false);
    }

    public static SelectFieldTreeNode getEntityFields(String entityNum, String entityAlias, boolean isMainEntity) {
        return SelectEntityFieldUtil.getEntityFields(false, entityNum, entityAlias, isMainEntity, false);
    }

    public static SelectFieldTreeNode getEntityFields(boolean showHRPersonQuery, String entityNum, String entityAlias, boolean isMainEntity, boolean isHideEntryField) {
        SelectFieldTreeNode fieldTreeNode = new SelectFieldTreeNode();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        String entityName = dataEntityType.getDisplayName().getLocaleValue();
        if (entityAlias.contains("\u03b4")) {
            String numStr = entityAlias.substring(entityAlias.indexOf("\u03b4") + 1);
            entityName = entityName + numStr;
        }
        fieldTreeNode.setName(entityName);
        fieldTreeNode.setNumber(entityNum);
        fieldTreeNode.setField(Boolean.valueOf(false));
        ArrayList children = Lists.newArrayListWithCapacity((int)10);
        fieldTreeNode.setChildren((List)children);
        Map allEntities = dataEntityType.getAllEntities();
        EntityType entityType = (EntityType)allEntities.get(entityNum);
        HashMap baseDataMap = Maps.newHashMapWithExpectedSize((int)16);
        SelectEntityFieldUtil.collectPropBo(entityName, entityType, fieldTreeNode.getChildren(), entityAlias, isMainEntity, "", false, baseDataMap, showHRPersonQuery);
        if (isHideEntryField) {
            return fieldTreeNode;
        }
        String finalEntityName = entityName;
        allEntities.forEach((entryEntityNum, entryEntityType) -> {
            if (HRStringUtils.equals((String)entityNum, (String)entryEntityNum)) {
                return;
            }
            if (HRStringUtils.isEmpty((String)entryEntityType.getAlias())) {
                return;
            }
            SelectFieldTreeNode entryEntityNode = new SelectFieldTreeNode();
            entryEntityNode.setName(entryEntityType.getDisplayName().getLocaleValue());
            entryEntityNode.setLongName(finalEntityName + "." + entryEntityNode.getName());
            entryEntityNode.setNumber(entryEntityNum);
            entryEntityNode.setFieldAlias(entityAlias + "." + entryEntityNum);
            entryEntityNode.setField(Boolean.valueOf(false));
            ArrayList entryChildren = Lists.newArrayListWithCapacity((int)10);
            String entrySuffix = null;
            if (entryEntityType instanceof SubEntryType) {
                entrySuffix = entryEntityType.getParent().getName() + "." + entryEntityNum;
            } else if (entryEntityType instanceof EntryType) {
                entrySuffix = entryEntityNum;
            }
            SelectEntityFieldUtil.collectPropBo(entryEntityNode.getLongName(), entryEntityType, entryChildren, entityAlias, isMainEntity, entrySuffix, true, baseDataMap, showHRPersonQuery);
            entryEntityNode.setChildren((List)entryChildren);
            fieldTreeNode.getChildren().add(entryEntityNode);
        });
        return fieldTreeNode;
    }

    private static void collectPropBo(String parentNodeLongName, EntityType entityType, List<SelectFieldTreeNode> children, String entityAlias, boolean isMainEntity, String entrySuffix, boolean isEntry, Map<String, String> baseDataMap, boolean showHRPersonQuery) {
        if (!isEntry) {
            IDataEntityProperty idProp = (IDataEntityProperty)entityType.getProperties().get((Object)"id");
            String idAlias = idProp.getName();
            if (!isMainEntity) {
                idAlias = entityAlias + "." + idAlias;
            }
            SelectFieldTreeNode idPropNode = new SelectFieldTreeNode("id", parentNodeLongName + "." + "id", "id", entityAlias, idAlias, Boolean.valueOf(true), null);
            idPropNode.setValueType(AnalyseObjectUtil.getFieldValueType(idProp));
            idPropNode.setComplexType(AnalyseObjectUtil.getFieldComplexType(idProp, baseDataMap));
            children.add(idPropNode);
        }
        for (Map.Entry propertyEntry : entityType.getFields().entrySet()) {
            IDataEntityProperty property = (IDataEntityProperty)propertyEntry.getValue();
            if (property instanceof MulBasedataProp || HRStringUtils.isEmpty((String)property.getAlias()) || property instanceof QueryProp && !showHRPersonQuery) continue;
            String filedAlias = SelectEntityFieldUtil.getFiledPath(entityAlias, isMainEntity, property, entrySuffix);
            SelectFieldTreeNode propNode = SelectEntityFieldUtil.getPropBo(parentNodeLongName, filedAlias, property, entityAlias, baseDataMap);
            children.add(propNode);
        }
    }

    private static SelectFieldTreeNode getPropBo(String parentNodeLongName, String fieldAlias, IDataEntityProperty property, String entityAlias, Map<String, String> baseDataMap) {
        SelectFieldTreeNode propBo;
        if (property instanceof BasedataProp) {
            propBo = SelectEntityFieldUtil.getBaseDataPropBo(parentNodeLongName, fieldAlias, (BasedataProp)property, entityAlias, baseDataMap);
        } else {
            String displayName = property.getDisplayName() == null ? property.getName() : property.getDisplayName().getLocaleValue();
            propBo = new SelectFieldTreeNode(displayName, parentNodeLongName + "." + displayName, property.getName(), entityAlias, fieldAlias, Boolean.valueOf(true), null);
            propBo.setValueType(AnalyseObjectUtil.getFieldValueType(property));
            propBo.setComplexType(AnalyseObjectUtil.getFieldComplexType(property, baseDataMap));
        }
        return propBo;
    }

    private static SelectFieldTreeNode getBaseDataPropBo(String parentNodeLongName, String fieldAlias, BasedataProp property, String entityAlias, Map<String, String> baseDataMap) {
        SelectFieldTreeNode propBo = new SelectFieldTreeNode();
        String fieldNum = property.getName() + ".id";
        String fieldName = property.getDisplayName().getLocaleValue();
        String fieldLongName = parentNodeLongName + "." + fieldName;
        propBo.setName(fieldName);
        propBo.setLongName(fieldLongName);
        propBo.setNumber(fieldNum);
        propBo.setEntityAlias(entityAlias);
        propBo.setFieldAlias(fieldAlias + ".id");
        propBo.setValueType(AnalyseObjectUtil.getFieldValueType((IDataEntityProperty)property));
        propBo.setComplexType(AnalyseObjectUtil.getFieldComplexType((IDataEntityProperty)property, baseDataMap));
        propBo.setField(Boolean.valueOf(true));
        DataEntityPropertyCollection relProps = property.getComplexType().getProperties();
        ArrayList childrenProps = Lists.newArrayListWithCapacity((int)relProps.size());
        for (IDataEntityProperty relProp : relProps) {
            String propNum = relProp.getName();
            if (HRStringUtils.isEmpty((String)propNum) || HRStringUtils.equals((String)"id", (String)propNum) || HRStringUtils.equals((String)"masterid", (String)propNum) || HRStringUtils.equals((String)"multilanguagetext", (String)propNum) || propNum.endsWith("_id") || relProp instanceof EntryProp || relProp instanceof MulBasedataProp || HRStringUtils.isEmpty((String)relProp.getAlias())) continue;
            SelectFieldTreeNode subProp = SelectEntityFieldUtil.getPropBo(fieldLongName, fieldAlias + "." + propNum, relProp, entityAlias, baseDataMap);
            childrenProps.add(subProp);
        }
        propBo.setChildren((List)childrenProps);
        return propBo;
    }

    private static String getFiledPath(String entityAlias, boolean isMainEntity, IDataEntityProperty property, String entrySuffix) {
        String fieldNum = property.getName();
        String fieldPath = "";
        if (!isMainEntity) {
            fieldPath = entityAlias + '.';
        }
        if (HRStringUtils.isNotEmpty((String)entrySuffix)) {
            fieldPath = fieldPath + entrySuffix + ".";
        }
        fieldPath = fieldPath + fieldNum;
        return fieldPath;
    }
}

