/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.message;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;

public class HRMessageConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(HRMessageConsumer.class);

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        logger.info("In HRMessageConsumer. Params: message:{}, messageId:{}  , resend: {}", new Object[]{message, messageId, resend});
        try {
            this.beforeConsumeMessage(message, messageId, resend, acker);
            this.consumeMessage(message, messageId, resend, acker);
            this.afterConsumeMessage(message, messageId, resend, acker);
            acker.ack(messageId);
        }
        catch (Exception ex) {
            logger.error("HRMessageConsumer. errior messageId:{} ", (Object)messageId, (Object)ex);
            acker.discard(messageId);
        }
    }

    protected void beforeConsumeMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
    }

    protected void consumeMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
    }

    protected void afterConsumeMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
    }
}

