/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.query.es;

import java.util.ArrayList;
import java.util.List;
import kd.bos.lang.Lang;
import kd.hr.hbp.business.service.query.es.EsContext;
import kd.hr.hbp.business.service.query.es.EsDataType;
import kd.hr.hbp.business.service.query.es.EsTokenizerType;

public class EsMappingProperty {
    String propertyName;
    EsDataType dataType;
    EsTokenizerType tokenizerType = EsTokenizerType.STANDARD;
    EsTokenizerType searchTokenizerType = EsTokenizerType.STANDARD;
    Lang lang;
    boolean withPinyin;
    long propertySize = 1024L;
    public List<EsMappingProperty> nests = new ArrayList<EsMappingProperty>();
    public List<EsContext> esContextList;

    public EsMappingProperty(String propertyName, Lang lang, boolean withPinyin) {
        this.propertyName = propertyName;
        this.dataType = EsDataType.STRING;
        this.lang = lang;
        this.withPinyin = withPinyin;
    }

    public EsMappingProperty(String propertyName, boolean withPinyin) {
        this.propertyName = propertyName;
        this.dataType = EsDataType.STRING;
        this.lang = null;
        this.withPinyin = withPinyin;
    }

    public EsMappingProperty(String propertyName, EsDataType dataType) {
        this.propertyName = propertyName;
        this.dataType = dataType;
        this.lang = null;
        this.withPinyin = false;
    }

    public EsMappingProperty(String propertyName, EsDataType dataType, EsTokenizerType tokenizerType) {
        this.propertyName = propertyName;
        this.dataType = dataType;
        this.lang = null;
        this.withPinyin = false;
        this.tokenizerType = tokenizerType;
    }

    public EsMappingProperty setTokenizerType(EsTokenizerType tokenizerType) {
        this.tokenizerType = tokenizerType;
        return this;
    }

    public EsMappingProperty setSize(long propertySize) {
        this.propertySize = propertySize > 32766L ? 32766L : propertySize;
        return this;
    }

    public long getPropertySize() {
        return this.propertySize;
    }

    public EsDataType getDataType() {
        return this.dataType;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Lang getLang() {
        return this.lang;
    }

    public boolean isWithPinyin() {
        return this.withPinyin;
    }

    public EsTokenizerType getSearchTokenizerType() {
        return this.searchTokenizerType;
    }

    public void setSearchTokenizerType(EsTokenizerType searchTokenizerType) {
        this.searchTokenizerType = searchTokenizerType;
    }

    public List<EsContext> getEsContextList() {
        return this.esContextList;
    }

    public void setEsContextList(List<EsContext> esContextList) {
        this.esContextList = esContextList;
    }

    public EsTokenizerType getTokenizerType() {
        return this.tokenizerType;
    }

    public String toString() {
        return "EsMappingProperty [propertyName=" + this.propertyName + ", dataType=" + (Object)((Object)this.dataType) + ", tokenizerType=" + (Object)((Object)this.tokenizerType) + ", lang=" + this.lang + ", withPinyin=" + this.withPinyin + ", propertySize=" + this.propertySize + "]";
    }
}

