/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.query.ksql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.query.ksql.IKsqlConfig;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.QueryEntityUtil;

public class CustomConditionFilterBuilder {
    private static final Log LOGGER = LogFactory.getLog(CustomConditionFilterBuilder.class);
    public static final String MULTI_ENTITY_QUERY_TRANSFORM_EXPRESS_CODE = "MultiEntityQueryTransformExpressCode";

    public String parseFilterString(QueryEntityType queryEntity, IKsqlConfig kSqlConfig, String expressString) {
        if (HRStringUtils.isEmpty((String)expressString)) {
            return null;
        }
        if (this.checkBadExpressString(expressString)) {
            LOGGER.info("bad expressString : {} ", (Object)expressString);
            return null;
        }
        LOGGER.info("expressStrBuilder input : {} ", (Object)expressString);
        List<String> propList = this.getSplitPropList(expressString);
        HashMap<String, String> expressMap = new HashMap<String, String>(16);
        for (String prop : propList) {
            String tableFieldStr = this.getFieldAliasByProp(queryEntity, kSqlConfig, prop);
            expressMap.put(prop, tableFieldStr);
        }
        StringBuilder expressStrBuilder = new StringBuilder(expressString);
        for (String prop : propList) {
            String replaceProp = (String)expressMap.get(prop);
            this.replaceFilterProp(expressStrBuilder, prop, replaceProp);
        }
        LOGGER.info("expressStrBuilder output : {} ", (Object)expressStrBuilder);
        return expressStrBuilder.toString();
    }

    private void replaceFilterProp(StringBuilder stringBuilder, String srcProp, String replaceProp) {
        String expressString = stringBuilder.toString();
        List positionList = this.getPositionList(srcProp, expressString);
        if (positionList.size() > 0) {
            int[] positionArray = (int[])positionList.get(0);
            expressString = expressString.substring(0, positionArray[0]) + replaceProp + expressString.substring(positionArray[1]);
            stringBuilder.setLength(0);
            stringBuilder = stringBuilder.append(expressString);
            this.replaceFilterProp(stringBuilder, srcProp, replaceProp);
        }
    }

    private List getPositionList(String targetStr, String expressString) {
        ArrayList<int[]> positionList = new ArrayList<int[]>();
        char[] targetChars = targetStr.toCharArray();
        char[] expressChars = expressString.toCharArray();
        StringBuilder currentVal = new StringBuilder();
        for (int i = 0; i < expressChars.length; ++i) {
            if (targetChars[0] != expressChars[i]) continue;
            int curPos = i;
            boolean isMatched = true;
            for (int j = 0; j < targetChars.length; ++j) {
                currentVal.append(expressChars[curPos]);
                if (targetChars[j] != expressChars[curPos]) {
                    isMatched = false;
                    break;
                }
                ++curPos;
            }
            if (!isMatched) continue;
            if (this.isFullMatched(expressChars, i, curPos)) {
                int[] matchedPosition = new int[]{i, i + targetStr.length()};
                positionList.add(matchedPosition);
                currentVal = new StringBuilder();
                break;
            }
            currentVal = new StringBuilder();
        }
        return positionList;
    }

    private boolean isFullMatched(char[] expressChars, int i, int curPos) {
        return (i == 0 || this.isSplitString(String.valueOf(expressChars[i - 1]))) && (curPos == expressChars.length || curPos < expressChars.length && this.isSplitString(String.valueOf(expressChars[curPos])));
    }

    private boolean isSplitString(String charStr) {
        if (this.isOperateChar(charStr)) {
            return true;
        }
        if (this.isBracketChar(charStr)) {
            return true;
        }
        return this.isBlankSpace(charStr);
    }

    private String getFieldAliasByProp(QueryEntityType queryEntity, IKsqlConfig ksqlConfig, String queryFieldAlias) {
        Map<String, String> joinEntityAliasMap = queryEntity.getJoinEntitys().stream().collect(Collectors.toMap(JoinEntity::getAlias, JoinEntity::getEntityName));
        String[] queryFields = queryFieldAlias.split("\\.");
        String entityAlias = QueryEntityUtil.getFieldEntityAlias((String)queryFieldAlias, (QueryEntityType)queryEntity);
        String entityName = queryFields.length == 2 ? joinEntityAliasMap.get(entityAlias) : queryEntity.getEntityName();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        String tableName = entityType.getAlias();
        String queryField = queryFieldAlias;
        if (queryFields.length == 2) {
            queryField = queryFields[1];
        }
        DynamicProperty property = entityType.getProperty(queryField);
        String tableGroup = property.getTableGroup();
        String fieldAlias = property.getAlias();
        String tableAlias = HRStringUtils.isEmpty((String)tableGroup) ? ksqlConfig.getTableAliasMap(queryEntity.getName()).get(entityAlias).get(tableName) : ksqlConfig.getTableAliasMap(queryEntity.getName()).get(entityAlias).get(tableName + "_" + tableGroup);
        return tableAlias + "." + fieldAlias;
    }

    private List<String> getSplitPropList(String expressString) {
        String[] codeStrings = expressString.split(" ");
        ArrayList<String> allPropList = new ArrayList<String>();
        for (String codeString : codeStrings) {
            String propStr = this.replaceDiscardString(codeString = codeString.trim());
            if (this.isAndOrString(propStr) || this.isOperateChar(propStr)) continue;
            List<String> propList = this.getSplitProp(propStr);
            allPropList.addAll(propList);
        }
        return allPropList;
    }

    private String replaceDiscardString(String charStr) {
        charStr = charStr.replace("(", "");
        charStr = charStr.replace(")", "");
        charStr = charStr.replace(" ", "");
        charStr = charStr.replace(" ", "");
        return charStr;
    }

    private boolean isAndOrString(String charStr) {
        return charStr.equalsIgnoreCase("and") || charStr.equalsIgnoreCase("or");
    }

    private List<String> getSplitProp(String propStr) {
        List<String> operateList = this.getOperateList();
        ArrayList<String> propList = new ArrayList<String>();
        for (String operate : operateList) {
            String[] propStars;
            if (!propStr.contains(operate) && propStr.length() <= 2 || (propStars = propStr.split(operate)).length != 2) continue;
            if (!operateList.contains(propStars[0]) && !HRStringUtils.isEmpty((String)propStr)) {
                propList.add(propStars[0]);
            }
            if (!operateList.contains(propStars[1]) && !HRStringUtils.isEmpty((String)propStr)) {
                propList.add(propStars[1]);
            }
            return propList;
        }
        boolean isOperateStr = false;
        for (String operate : operateList) {
            if (!propStr.contains(operate)) continue;
            isOperateStr = true;
        }
        if (!isOperateStr && !HRStringUtils.isEmpty((String)propStr)) {
            propList.add(propStr);
        }
        return propList;
    }

    private List<String> getOperateList() {
        ArrayList<String> operateList = new ArrayList<String>();
        operateList.add(">=");
        operateList.add("<=");
        operateList.add("!=");
        operateList.add("<>");
        operateList.add(">");
        operateList.add("<");
        operateList.add("=");
        return operateList;
    }

    private boolean isOperateChar(String charStr) {
        List<String> operateList = this.getOperateList();
        return operateList.contains(charStr.trim());
    }

    private boolean isBracketChar(String charStr) {
        HashSet<String> bracketSet = new HashSet<String>();
        bracketSet.add("(");
        bracketSet.add(")");
        return bracketSet.contains(charStr.trim());
    }

    private boolean isBlankSpace(String charStr) {
        return charStr.equals(" ");
    }

    private boolean checkBadExpressString(String expressString) {
        String checkString = expressString.toLowerCase();
        return checkString.contains(" delete ") || checkString.contains(" truncate ") || checkString.contains(" update ") || checkString.contains(";");
    }
}

