/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.query.ksql;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.query.ksql.IKsqlConfig;
import kd.hr.hbp.business.service.query.ksql.QueryEntityInfo;
import kd.hr.hbp.business.service.query.ksql.QueryKSqlFromParser;
import kd.hr.hbp.business.service.query.ksql.QueryKSqlSelectFieldParse;
import kd.hr.hbp.business.service.query.ksql.QueryKSqlSelectListParse;
import kd.hr.hbp.business.service.query.ksql.QueryKSqlTableParse;

public class KsqlConfig
implements IKsqlConfig {
    private final Set<String> unIgnoreTable = new HashSet<String>(16);
    private Map<String, Map<String, String>> entityTableAliasMap;
    private Map<String, List<QFilter>> joinOnRelationMap = null;
    private String customSelectedFields = null;
    private QueryEntityInfo queryEntityInfo;

    @Override
    public QueryEntityInfo getQueryEntityInfo(String entityName) {
        if (this.queryEntityInfo == null || !entityName.equals(this.queryEntityInfo.getQueryEntityNum())) {
            this.queryEntityInfo = new QueryEntityInfo(entityName);
        }
        return this.queryEntityInfo;
    }

    @Override
    public DBRoute getDBRoute(String entityName) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        return new DBRoute(dataEntityType.getDBRouteKey());
    }

    @Override
    public Map<String, String> getWhiteSQLFilter(String entityName) {
        return null;
    }

    @Override
    public Map<String, Object> getPKPropMap(String entityName) {
        Map<String, Object> pkPropMap = QueryKSqlSelectFieldParse.getPkFields(this.getQueryEntityInfo(entityName));
        return pkPropMap;
    }

    @Override
    public Map<String, Object> getPropMap(String entityName) {
        Map<String, Object> fieldMap = QueryKSqlSelectFieldParse.getAllFields(this.getQueryEntityInfo(entityName));
        return fieldMap;
    }

    @Override
    public Map<String, Map<String, String>> getTableAliasMap(String entityName) {
        if (this.entityTableAliasMap == null) {
            this.entityTableAliasMap = QueryKSqlTableParse.getTableAlias(this.getQueryEntityInfo(entityName));
        }
        return this.entityTableAliasMap;
    }

    @Override
    public void clearJoinConfig() {
        this.entityTableAliasMap = null;
        this.joinOnRelationMap = null;
        this.customSelectedFields = null;
    }

    @Override
    public String getSqlStr(int limit, int start, String entityName) {
        QueryKSqlSelectListParse selectListParse = new QueryKSqlSelectListParse(this);
        return "select top " + limit + ',' + start + ' ' + selectListParse.getSelectListSql(this.getQueryEntityInfo(entityName)) + this.getTableFromSql(entityName, false, this.parseUnIgnoreTable());
    }

    @Override
    public String getSqlStr(String entityName) {
        QueryKSqlSelectListParse selectListParse = new QueryKSqlSelectListParse(this);
        return "select " + selectListParse.getSelectListSql(this.getQueryEntityInfo(entityName)) + this.getTableFromSql(entityName, false, this.parseUnIgnoreTable());
    }

    @Override
    public String getSqlStr(int limit, int start) {
        QueryKSqlSelectListParse selectListParse = new QueryKSqlSelectListParse(this);
        return "select top " + limit + ',' + start + ' ' + selectListParse.getSelectListSql(this.queryEntityInfo) + this.getTableFromSql(this.queryEntityInfo, this.parseUnIgnoreTable());
    }

    @Override
    public String getSqlStr() {
        QueryKSqlSelectListParse selectListParse = new QueryKSqlSelectListParse(this);
        return "select " + selectListParse.getSelectListSql(this.queryEntityInfo) + this.getTableFromSql(this.queryEntityInfo, this.parseUnIgnoreTable());
    }

    @Override
    public String getPKSqlStr(int limit, int start, String entityName) {
        QueryKSqlSelectListParse selectListParse = new QueryKSqlSelectListParse(this);
        return "select top " + limit + ',' + start + ' ' + selectListParse.getPkSelectList(this.getQueryEntityInfo(entityName)) + this.getTableFromSql(entityName, true, this.parseUnIgnoreTable());
    }

    @Override
    public String getPKSqlStr(String entityName) {
        QueryKSqlSelectListParse selectListParse = new QueryKSqlSelectListParse(this);
        return "select " + selectListParse.getPkSelectList(this.getQueryEntityInfo(entityName)) + this.getTableFromSql(entityName, true, this.parseUnIgnoreTable());
    }

    @Override
    public String getOnlyMainPKSqlStr(String entityName) {
        QueryKSqlSelectListParse selectListParse = new QueryKSqlSelectListParse(this);
        return "select " + selectListParse.getMainEntityPkSelectList("", this.getQueryEntityInfo(entityName), this.getTableAliasMap(entityName)) + this.getTableFromSql(entityName, true, this.parseUnIgnoreTable());
    }

    @Override
    public String getOnlyMainPKSqlStr(String entityName, int limit, int start, String orderBy) {
        QueryKSqlSelectListParse selectListParse = new QueryKSqlSelectListParse(this);
        return "select top " + limit + ',' + start + ' ' + selectListParse.getMainEntityPkSelectList(orderBy, this.getQueryEntityInfo(entityName), this.getTableAliasMap(entityName)) + this.getTableFromSql(entityName, true, this.parseUnIgnoreTable());
    }

    @Override
    public String getSqlCount(String entityName) {
        return "select count(1) " + this.getTableFromSql(entityName, true, this.parseUnIgnoreTable());
    }

    @Override
    public void addUnIgnoreTable(String tableName) {
        this.unIgnoreTable.add(tableName);
    }

    @Override
    public Set<String> getUnIgnoreTable() {
        return this.unIgnoreTable;
    }

    private Set<String> parseUnIgnoreTable() {
        return this.unIgnoreTable;
    }

    private String getTableFromSql(String entityName, boolean ignoreMlSplitTb, Set<String> mustLoadTb) {
        QueryKSqlFromParser fromParser = new QueryKSqlFromParser(this.getQueryEntityInfo(entityName), this);
        return fromParser.getTableFromSql(ignoreMlSplitTb, true, mustLoadTb);
    }

    private String getTableFromSql(QueryEntityInfo queryEntityInfo, Set<String> mustLoadTb) {
        QueryKSqlFromParser fromParser = new QueryKSqlFromParser(queryEntityInfo, this);
        return fromParser.getTableFromSql(false, true, mustLoadTb);
    }

    @Override
    public Map<String, List<QFilter>> getJoinOnRelationMap() {
        return this.joinOnRelationMap;
    }

    public void setJoinOnRelationMap(Map<String, List<QFilter>> joinOnRelationMap) {
        this.joinOnRelationMap = joinOnRelationMap;
    }

    @Override
    public String getCustomSelectedFields() {
        return this.customSelectedFields;
    }

    public void setCustomSelectedFields(String customSelectedFields) {
        this.customSelectedFields = customSelectedFields;
    }

    public Map<String, Map<String, String>> getEntityTableAliasMap() {
        return this.entityTableAliasMap;
    }

    public void setEntityTableAliasMap(Map<String, Map<String, String>> entityTableAliasMap) {
        this.entityTableAliasMap = entityTableAliasMap;
    }

    public QueryEntityInfo getQueryEntityInfo() {
        return this.queryEntityInfo;
    }

    public void setQueryEntityInfo(QueryEntityInfo queryEntityInfo) {
        this.queryEntityInfo = queryEntityInfo;
    }
}

