/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.query.ksql;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ILocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.pktemptable.PKTempTable;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.mulentities.QSConditionRow;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.mulentities.QuerySourceJoinRelation;
import kd.bos.entity.mulentities.expr.QSExpr;
import kd.bos.entity.mulentities.expr.QSIdentifierExpr;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.ksql.KSqlUtil;
import kd.bos.ksql.exception.SqlTranslateException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.QueryBuilderFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.business.service.query.ksql.CriteriaBuilder;
import kd.hr.hbp.business.service.query.ksql.CustomConditionFilterBuilder;
import kd.hr.hbp.business.service.query.ksql.IKsqlConfig;
import kd.hr.hbp.business.service.query.ksql.KsqlConfig;
import kd.hr.hbp.business.service.query.ksql.KsqlMultiLangUtil;
import kd.hr.hbp.business.service.query.ksql.QueryEntityInfo;
import kd.hr.hbp.business.service.query.ksql.QueryField;
import kd.hr.hbp.business.service.query.util.ListProviderDynamicObjCollectionUtil;
import kd.hr.hbp.business.service.query.util.QFilterKSQLTransFunction;
import kd.hr.hbp.business.service.query.util.QFilterUtilHR;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.business.util.OrgServiceUtil;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.QueryEntityTypeUtil;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class KsqlListDataProvider
extends ListDataProvider {
    public static final String FULL_SQL = "FULLSQL";
    public static final String PKSQL = "PKSQL";
    private static final Log LOGGER = LogFactory.getLog(KsqlListDataProvider.class);
    IHRAppCache appCache;
    Map<Integer, List<QFilter>> unionFiltersMap = new HashMap<Integer, List<QFilter>>();
    Map<String, PKTempTable> tmpTableSQLOfSyncMap = new HashMap<String, PKTempTable>();
    private QueryEntityType queryEntity;
    private String querySQLType = "FULLSQL";
    private Boolean isUnionSQL = true;
    private Boolean isFullUnion = false;
    private int tmpTableThresh;
    private final int tmpTableThreshDefVal = 10000;
    private String searchType = "1";
    private final String searchTypeDefVal = "1";
    private final IKsqlConfig ksqlConfig;
    private final String cacheKey;
    private final int separateThreshold = 7;
    private final int separateNum = 5;
    private final int maxJoinEntitySplitNum = 4;
    private final String OPTIMIZE_LOCAL_RP_VAL = "'_XXXflocalidXXX_'";
    private final String OPTIMIZE_LOCAL_REG_STR = "#\\{flocalid}";
    String customExpressFilterString = null;

    public KsqlListDataProvider(KsqlConfig ksqlConfig, String appId, String cacheKey, String queryType, Boolean isUnionSQL) {
        this.cacheKey = cacheKey;
        this.appCache = HRAppCache.get((String)appId);
        this.ksqlConfig = ksqlConfig;
        this.querySQLType = queryType;
        this.isUnionSQL = isUnionSQL;
        this.initTmpTableThresh();
    }

    public KsqlListDataProvider(IFormView formView, IKsqlConfig ksqlConfig) {
        this.cacheKey = formView.getPageId();
        this.appCache = HRAppCache.get((String)this.cacheKey);
        this.ksqlConfig = ksqlConfig;
        this.initTmpTableThresh();
    }

    public KsqlListDataProvider(IFormView formView, IKsqlConfig ksqlConfig, String queryType, Boolean isUnionSQL, Boolean isFullUnion) {
        this.cacheKey = formView.getPageId();
        this.appCache = HRAppCache.get((String)this.cacheKey);
        this.querySQLType = queryType;
        this.isUnionSQL = isUnionSQL;
        this.isFullUnion = isFullUnion;
        this.ksqlConfig = ksqlConfig;
        this.initTmpTableThresh();
    }

    public DynamicObjectCollection getData(int start, int limit) {
        QueryBuilder thisQueryBuilder = QueryBuilderFactory.createQueryBuilder((IListDataProvider)this, (int)start, (int)limit, (boolean)false);
        long startTime = System.currentTimeMillis();
        DynamicObjectCollection result = this.queryCollection(thisQueryBuilder, start);
        this.optEndLog("queryCollection", startTime);
        return result;
    }

    protected void optEndLog(String opt, long startTime) {
        long ms = System.currentTimeMillis() - startTime;
        String msg = "----optEndLog----" + opt + "------" + ms + "ms----\r\n";
        LOGGER.info(msg);
    }

    private IDataEntityProperty findProperty(MainEntityType relationEntityType, String propertyName) {
        String nameKey;
        String[] nameKeys;
        IDataEntityProperty dataEntityProperty = null;
        String[] stringArray = nameKeys = propertyName.split("\\.");
        int n = stringArray.length;
        for (int i = 0; i < n && null == (dataEntityProperty = relationEntityType.findProperty(nameKey = stringArray[i])); ++i) {
        }
        return dataEntityProperty;
    }

    @ExcludeFromJacocoGeneratedReport
    public int getBillDataCount() {
        long startTime = System.currentTimeMillis();
        int billDataCount = this.countByRoute();
        long ms = System.currentTimeMillis() - startTime;
        LOGGER.info("----optEndLog----getBillDataCount:{}------{} ms----", (Object)billDataCount, (Object)ms);
        return billDataCount;
    }

    @ExcludeFromJacocoGeneratedReport
    public int getRealCount() {
        long startTime = System.currentTimeMillis();
        int realDataCount = this.countByRoute();
        long ms = System.currentTimeMillis() - startTime;
        LOGGER.info("----optEndLog----getRealCount:{}------{} ms----", (Object)realDataCount, (Object)ms);
        return realDataCount;
    }

    @ExcludeFromJacocoGeneratedReport
    private int queryDataCount() {
        long startTime = System.currentTimeMillis();
        int realDataCount = this.countByRoute();
        long ms = System.currentTimeMillis() - startTime;
        LOGGER.info("----optEndLog----queryDataCount:{}------{} ms----", (Object)realDataCount, (Object)ms);
        return realDataCount;
    }

    private int countByRoute() {
        return this.count4SqlQuery(PKSQL.equalsIgnoreCase(this.querySQLType));
    }

    private int count4IdQuery() {
        QueryBuilder thisQueryBuilder = QueryBuilderFactory.createQueryBuilder((IListDataProvider)this, (int)0, (int)10, (boolean)false);
        this.queryEntity = (QueryEntityType)thisQueryBuilder.getEntityType();
        QFilter[] filters = thisQueryBuilder.getFilters();
        return this.countByIDInc(this.queryEntity, filters, "", 0, -1, this.ksqlConfig.getJoinOnRelationMap());
    }

    private int count4SqlQuery(boolean optimize) {
        QueryBuilder thisQueryBuilder = QueryBuilderFactory.createQueryBuilder((IListDataProvider)this, (int)0, (int)10, (boolean)false);
        this.queryEntity = (QueryEntityType)thisQueryBuilder.getEntityType();
        QFilter[] filters = thisQueryBuilder.getFilters();
        filters = this.adaptiveQFilter(filters);
        Object[] qFiltersCopy = this.copyQFilters(filters);
        Object[] flikeQFilters = QFilterUtilHR.rebuidFlikeQFilterEx(this.unionFiltersMap, (QFilter[])qFiltersCopy, this.isFullUnion, this.queryEntity, this.searchType);
        QFilter[] newOriginFilters = (QFilter[])Arrays.stream(ArrayUtils.addAll((Object[])flikeQFilters, (Object[])qFiltersCopy)).filter(Objects::nonNull).toArray(QFilter[]::new);
        try {
            QFilter[] transQFilters = this.transQFilter(newOriginFilters);
            String countSql = this.genCountSql(this.queryEntity, this.ksqlConfig.getJoinOnRelationMap());
            CriteriaBuilder criteriaBuilder = new CriteriaBuilder(transQFilters, this.ksqlConfig.getDBRoute(this.queryEntity.getName()));
            criteriaBuilder.setTmpTableThresh(this.tmpTableThresh);
            return this.countByKsql(criteriaBuilder, countSql, optimize);
        }
        catch (Exception e) {
            LOGGER.error("queryDataCount error ", (Throwable)e);
            return 0;
        }
    }

    private String genCountSql(QueryEntityType queryEntityType, Map<String, List<QFilter>> relationMap) throws IllegalAccessException, InvocationTargetException {
        KsqlConfig ksqlConfigCopy = new KsqlConfig();
        BeanUtils.copyProperties((Object)ksqlConfigCopy, (Object)this.ksqlConfig);
        Set<String> unIgnoreTableSet = this.ksqlConfig.getUnIgnoreTable();
        for (String unIgnoreTable : unIgnoreTableSet) {
            ksqlConfigCopy.addUnIgnoreTable(unIgnoreTable);
        }
        QueryEntityInfo queryEntityInfo = ksqlConfigCopy.getQueryEntityInfo(queryEntityType.getName());
        ArrayList joinEntities = new ArrayList(queryEntityInfo.getQueryEntityType().getJoinEntitys());
        ArrayList<QuerySourceJoinRelation> joinRelations = new ArrayList<QuerySourceJoinRelation>(10);
        for (JoinEntity joinEntity : joinEntities) {
            this.handleJoinRelations(queryEntityInfo, joinEntity, joinRelations, relationMap);
        }
        queryEntityInfo.setJoinRelations(joinRelations);
        return ksqlConfigCopy.getSqlCount(this.queryEntity.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countByKsql(CriteriaBuilder criteriaBuilder, String countByPkSql, boolean optimize) {
        DataSet dataSet = null;
        Map<String, PKTempTable> tmpTableMap = null;
        try {
            criteriaBuilder.setbTmpTable(true);
            criteriaBuilder.setTmpTableMap(new HashMap<String, PKTempTable>(16));
            String whereSql = criteriaBuilder.qFilterToString();
            tmpTableMap = criteriaBuilder.getTmpTableMap();
            String orignSql = countByPkSql + " where 1 = 1 " + whereSql;
            String filterConditionStr = this.parseExpressFilterString(this.queryEntity, this.ksqlConfig);
            if (!HRStringUtils.isEmpty((String)filterConditionStr)) {
                orignSql = orignSql + " and " + filterConditionStr;
            }
            if (optimize) {
                LOGGER.info("KSQL countByKsql optimize sql:{}", (Object)orignSql);
                orignSql = orignSql.replaceAll("#\\{flocalid}", "'_XXXflocalidXXX_'");
                LOGGER.info("KSQL countByKsql, orignSql:{}", (Object)orignSql);
                String optimizeSql = KSqlUtil.optimize((String)orignSql);
                orignSql = optimizeSql.replaceAll("'_XXXflocalidXXX_'", "#\\{flocalid}");
                LOGGER.info("KSQL countByKsql, optimizeSql:{}", (Object)orignSql);
            }
            Object[] params = KsqlMultiLangUtil.getSQLParams(orignSql);
            orignSql = KsqlMultiLangUtil.localTransPlaceholder(orignSql);
            LOGGER.info("KSQL countByKsql exec sql:{}, param:{}", (Object)orignSql, (Object)params);
            DBRoute dbRoute = this.ksqlConfig.getDBRoute(this.queryEntity.getName());
            dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)dbRoute, (String)orignSql, (Object[])params);
            if (!dataSet.isEmpty()) {
                int n = ((Row)dataSet.iterator().next()).getInteger(0);
                return n;
            }
        }
        catch (Exception e) {
            LOGGER.error("countByKsql Exception: ", (Throwable)e);
        }
        finally {
            this.closePKTempTable(tmpTableMap);
        }
        return 0;
    }

    private void transforOrderBy(String orderByQuery, StringBuilder orderBys, Boolean bUnion) {
        this.transforOrderBy(orderByQuery, orderBys, bUnion, null);
    }

    private void transforOrderBy(String orderByQuery, StringBuilder orderBys, Boolean bUnion, List<JoinEntity> sortJoinEntities) {
        if (StringUtils.isBlank((CharSequence)orderByQuery)) {
            return;
        }
        String[] orderByArr = orderByQuery.split(",");
        String entityNumber = this.queryEntity.getName();
        for (int i = 0; i < orderByArr.length; ++i) {
            MainEntityType mainEntityType;
            IDataEntityProperty iDataEntityProperty;
            String[] orderByArrSub = orderByArr[i].split(" ");
            String orderByKey = orderByArrSub[0];
            boolean nestProperty = Boolean.FALSE;
            List<Object> joinEntities = null != this.ksqlConfig.getQueryEntityInfo(entityNumber) ? this.ksqlConfig.getQueryEntityInfo(entityNumber).getQueryJoinEntitys() : new ArrayList(this.queryEntity.getJoinEntitys());
            for (JoinEntity joinEntity : joinEntities) {
                MainEntityType relationEntityType;
                IDataEntityProperty relationDataEntityProperty;
                if (!orderByKey.contains(joinEntity.getAlias() + ".")) continue;
                if (null != sortJoinEntities && !sortJoinEntities.contains(joinEntity)) {
                    sortJoinEntities.add(joinEntity);
                }
                if (null == (relationDataEntityProperty = this.findProperty(relationEntityType = EntityMetadataCache.getDataEntityType((String)joinEntity.getEntityName()), orderByKey))) {
                    nestProperty = Boolean.TRUE;
                    continue;
                }
                this.buildOrderByProperty(relationEntityType, relationDataEntityProperty, orderByArrSub, orderBys, bUnion, joinEntity.getAlias());
                if (i < orderByArr.length - 1) {
                    orderBys.append(",");
                }
                nestProperty = Boolean.TRUE;
                break;
            }
            if (nestProperty || null == (iDataEntityProperty = this.findProperty(mainEntityType = EntityMetadataCache.getDataEntityType((String)this.queryEntity.getEntityName()), orderByKey))) continue;
            this.buildOrderByProperty(mainEntityType, iDataEntityProperty, orderByArrSub, orderBys, bUnion, this.queryEntity.getEditEntityAliasName());
            if (i >= orderByArr.length - 1) continue;
            orderBys.append(",");
        }
    }

    private boolean buildOrderByProperty(MainEntityType mainEntityType, IDataEntityProperty dataEntityProperty, String[] orderByArrSub, StringBuilder orderBys, Boolean isUnion, String entityAlias) {
        if (StringUtils.isBlank((CharSequence)this.ksqlConfig.getTableAliasMap(this.queryEntity.getName()).get(entityAlias).get(mainEntityType.getAlias()))) {
            return Boolean.FALSE;
        }
        boolean mutileLang = false;
        if (dataEntityProperty instanceof ILocaleProperty) {
            mutileLang = true;
        }
        String tableName = mainEntityType.getAlias();
        if (mutileLang) {
            tableName = tableName + "_L";
        } else {
            String tableGroup = dataEntityProperty.getTableGroup();
            if (HRStringUtils.isNotEmpty((String)tableGroup)) {
                tableName = tableName + "_" + tableGroup;
            }
        }
        String aliasName = this.ksqlConfig.getTableAliasMap(this.queryEntity.getName()).get(entityAlias).get(tableName);
        this.ksqlConfig.addUnIgnoreTable(tableName);
        if (dataEntityProperty instanceof IComplexProperty) {
            if (isUnion.booleanValue()) {
                String fullPropertyName = orderByArrSub[0];
                String firstProp = fullPropertyName.substring(0, fullPropertyName.lastIndexOf(46));
                StringBuilder b1 = new StringBuilder();
                b1.append(firstProp).append(".id");
                orderBys.append(b1.toString().replace(".", "$"));
                orderBys.append("$");
            } else {
                orderBys.append(aliasName).append(".");
                orderBys.append(dataEntityProperty.getAlias());
            }
            if (orderByArrSub.length == 2) {
                orderBys.append(" ");
                orderBys.append(orderByArrSub[1]);
            }
        } else if (!(dataEntityProperty instanceof ICollectionProperty)) {
            if (isUnion.booleanValue()) {
                String fullPropertyName = orderByArrSub[0];
                orderBys.append(fullPropertyName.replace(".", "$"));
                orderBys.append("$");
            } else {
                orderBys.append(aliasName).append(".");
                orderBys.append(dataEntityProperty.getAlias());
            }
            if (orderByArrSub.length == 2) {
                orderBys.append(" ");
                orderBys.append(orderByArrSub[1]);
            }
        }
        return Boolean.TRUE;
    }

    Boolean isWhiteSQLFilter(QFilter[] flikeQFilters, QFilter[] qFiltersCopy) {
        boolean isHitWhite = false;
        if (flikeQFilters.length == 0) {
            HashSet<String> filterPropertyes = new HashSet<String>();
            for (QFilter qFilter : qFiltersCopy) {
                if (qFilter == null) continue;
                filterPropertyes.add(qFilter.getProperty());
            }
            Set<String> whiteFilterKeySet = null;
            if (this.ksqlConfig.getWhiteSQLFilter(this.queryEntity.getName()) != null) {
                whiteFilterKeySet = this.ksqlConfig.getWhiteSQLFilter(this.queryEntity.getName()).keySet();
            }
            if (whiteFilterKeySet != null && whiteFilterKeySet.size() > 0) {
                HashSet whiteFilterSet = Sets.newHashSetWithExpectedSize((int)16);
                for (String o : whiteFilterKeySet) {
                    whiteFilterSet.add(o);
                }
                isHitWhite = true;
                if (whiteFilterSet.size() != filterPropertyes.size()) {
                    isHitWhite = false;
                } else {
                    for (String filterPropertye : filterPropertyes) {
                        if (whiteFilterSet.contains(filterPropertye)) continue;
                        isHitWhite = false;
                        break;
                    }
                }
            }
        }
        return isHitWhite;
    }

    private StringBuilder buildSQL(String selectSQL, QFilter[] flikeQFilters, QFilter[] qFiltersCopy, String orderByStr) {
        Boolean isHitWhite = this.isWhiteSQLFilter(flikeQFilters, qFiltersCopy);
        QFilter[] newFilters = (QFilter[])ArrayUtils.addAll((Object[])flikeQFilters, (Object[])qFiltersCopy);
        ArrayList<QFilter[]> unionFiltersArray = new ArrayList<QFilter[]>();
        this.rebuildUnionFilters(unionFiltersArray, flikeQFilters, qFiltersCopy);
        StringBuilder orderBy = new StringBuilder();
        this.transforOrderBy(orderByStr, orderBy, unionFiltersArray.size() > 1 && this.isUnionSQL != false);
        int characterPos = QFilterUtilHR.getCharacterPosition(selectSQL, 3);
        String basicSQL = selectSQL.substring(characterPos);
        StringBuilder sql = new StringBuilder();
        if (unionFiltersArray.size() > 1 && this.isUnionSQL.booleanValue()) {
            StringBuilder subSqlBuilder = new StringBuilder();
            String sqlWithOutTop = "select " + basicSQL;
            for (int i = 0; i < unionFiltersArray.size(); ++i) {
                QFilter[] filterArray = (QFilter[])unionFiltersArray.get(i);
                subSqlBuilder.append("( ").append(this.constructSqlQuery(filterArray, sqlWithOutTop, null)).append(") ");
                if (i >= unionFiltersArray.size() - 1) continue;
                subSqlBuilder.append(" union ");
            }
            String selectAliasesSql = this.buildSelectAliasesSql(basicSQL);
            LOGGER.info("buildSelectAliasesSql:{}", (Object)selectAliasesSql);
            String selectTopSql = selectSQL.substring(0, characterPos);
            sql.append(selectTopSql).append(' ').append(selectAliasesSql).append(" from (").append((CharSequence)subSqlBuilder).append(") as uniTbAlias ");
            if (orderBy.toString().length() > 0) {
                sql.append(" order by ").append((CharSequence)orderBy);
            }
        } else {
            QFilter[] filterArray = (QFilter[])unionFiltersArray.get(unionFiltersArray.size() - 1);
            sql.append(this.constructSqlQuery(filterArray, selectSQL, orderBy));
        }
        if (isHitWhite.booleanValue()) {
            StringBuilder sql2 = new StringBuilder();
            sql2.append(selectSQL).append(" where 1 != 1 ");
            return sql2;
        }
        return sql;
    }

    private String buildSelectAliasesSql(String basicSQL) {
        String lowerCase = basicSQL.toLowerCase(Locale.ROOT);
        String[] selectListFrom = lowerCase.split(" from ");
        String[] allField = selectListFrom[0].split(",");
        StringBuilder aliasSqlBuilder = new StringBuilder();
        for (int i = 0; i < allField.length; ++i) {
            String field = allField[i];
            String[] split = field.split(" as ");
            if (split.length == 2) {
                aliasSqlBuilder.append(split[1]);
            } else {
                aliasSqlBuilder.append(field);
            }
            if (i >= allField.length - 1) continue;
            aliasSqlBuilder.append(",");
        }
        return aliasSqlBuilder.toString();
    }

    private String constructSqlQuery(QFilter[] filterArray, String selectSQL, StringBuilder orderBy) {
        StringBuilder sql = new StringBuilder();
        QFilter[] filterArrayCopy = this.copyQFilters(filterArray);
        String whereSql = this.transferQFilter(filterArrayCopy, true, this.tmpTableSQLOfSyncMap);
        sql.append(selectSQL).append(" where 1 = 1 ").append(whereSql);
        String filterConditionStr = this.parseExpressFilterString(this.queryEntity, this.ksqlConfig);
        if (!HRStringUtils.isEmpty((String)filterConditionStr)) {
            sql.append(" and ").append(filterConditionStr);
        }
        if (orderBy != null && orderBy.toString().length() > 0) {
            sql.append(" order by ").append((CharSequence)orderBy);
        }
        return sql.toString();
    }

    private QFilter[] copyQFilters(QFilter[] filterArray) {
        QFilter[] filterArrayCopy = new QFilter[filterArray.length];
        for (int j = 0; j < filterArray.length; ++j) {
            if (filterArray[j] == null) continue;
            filterArrayCopy[j] = filterArray[j].copy();
        }
        return filterArrayCopy;
    }

    private void rebuildUnionFilters(List<QFilter[]> unionFiltersArray, QFilter[] flikeQFilters, QFilter[] qFiltersCopy) {
        if (this.unionFiltersMap.size() == 1) {
            boolean bMatchLenShort = false;
            for (List<QFilter> listValue1 : this.unionFiltersMap.values()) {
                for (QFilter qfilter : listValue1) {
                    Object value = qfilter.getValue();
                    if (!(value instanceof String) || value.toString().length() > 3) continue;
                    bMatchLenShort = true;
                    break;
                }
                if (!bMatchLenShort) continue;
                break;
            }
            if (!bMatchLenShort && this.isUnionSQL.booleanValue()) {
                for (List<QFilter> listValue2 : this.unionFiltersMap.values()) {
                    for (QFilter qfilter : listValue2) {
                        Object[] temp = new QFilter[]{qfilter};
                        unionFiltersArray.add((QFilter[])ArrayUtils.addAll((Object[])temp, (Object[])qFiltersCopy));
                    }
                }
            } else {
                unionFiltersArray.add((QFilter[])ArrayUtils.addAll((Object[])flikeQFilters, (Object[])qFiltersCopy));
                this.isUnionSQL = false;
            }
        } else {
            unionFiltersArray.add((QFilter[])ArrayUtils.addAll((Object[])flikeQFilters, (Object[])qFiltersCopy));
            this.isUnionSQL = false;
        }
    }

    private void handleJoinRelations(QueryEntityInfo queryEntityInfo, JoinEntity joinEntity, List<QuerySourceJoinRelation> joinRelations, Map<String, List<QFilter>> relationMap) {
        queryEntityInfo.getQueryEntityType().getJoinRelations().forEach(joinRelation -> {
            if (joinEntity.getAlias().equals(joinRelation.getRelEntityNumber())) {
                if (null != relationMap && relationMap.containsKey(joinEntity.getAlias())) {
                    QuerySourceJoinRelation relation = this.copyJoinRelation((QuerySourceJoinRelation)joinRelation);
                    List qFilterList = (List)relationMap.get(joinEntity.getAlias());
                    this.qFilter2QSConditionRow(qFilterList).forEach(arg_0 -> ((QuerySourceJoinRelation)relation).addCondition(arg_0));
                    joinRelations.add(relation);
                } else {
                    joinRelations.add((QuerySourceJoinRelation)joinRelation);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countByIDInc(QueryEntityType queryEntityType, QFilter[] qFilters, String orderBys, int start, int limit, Map<String, List<QFilter>> relationMap) {
        this.queryEntity = queryEntityType;
        int count = 0;
        try {
            String optimizeSql = this.genQueryAllPkSql(queryEntityType, qFilters, orderBys, start, limit, relationMap);
            Object[] params = KsqlMultiLangUtil.getSQLParams(optimizeSql);
            optimizeSql = KsqlMultiLangUtil.localTransPlaceholder(optimizeSql);
            LOGGER.info("KSQL countByIDInc exec sql:{}, param:{}", (Object)optimizeSql, (Object)params);
            int n = count = ((Integer)HRDBUtil.query((DBRoute)this.ksqlConfig.getDBRoute(queryEntityType.getName()), (String)optimizeSql, (Object[])params, rs -> {
                int rsRowCount = 0;
                while (rs.next()) {
                    ++rsRowCount;
                }
                return rsRowCount;
            })).intValue();
            return n;
        }
        catch (Exception exception) {
            LOGGER.error("KSQL countByIDInc error ", (Throwable)exception);
            int n = 0;
            return n;
        }
        finally {
            this.closePKTempTable(this.tmpTableSQLOfSyncMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> queryAllPk(QueryEntityType queryEntityType, QFilter[] qFilters, String orderBys, int start, int limit, Map<String, List<QFilter>> relationMap) {
        this.queryEntity = queryEntityType;
        try {
            String optimizeSql = this.genQueryAllPkSql(queryEntityType, qFilters, orderBys, start, limit, relationMap);
            Object[] params = KsqlMultiLangUtil.getSQLParams(optimizeSql);
            optimizeSql = KsqlMultiLangUtil.localTransPlaceholder(optimizeSql);
            LOGGER.info("KSQL queryAllPk exec sql:{}, param:{}", (Object)optimizeSql, (Object)params);
            LinkedHashSet allPkSet = Sets.newLinkedHashSetWithExpectedSize((int)16);
            boolean isVarchar = queryEntityType.getPrimaryKey().getPropertyType() == String.class;
            HRDBUtil.query((DBRoute)this.ksqlConfig.getDBRoute(queryEntityType.getName()), (String)optimizeSql, (Object[])params, rs -> {
                while (rs.next()) {
                    if (isVarchar) {
                        allPkSet.add(rs.getString("id$"));
                        continue;
                    }
                    allPkSet.add(rs.getLong("id$"));
                }
                return null;
            });
            ArrayList<Object> arrayList = new ArrayList<Object>(allPkSet);
            return arrayList;
        }
        catch (Exception exception) {
            LOGGER.error("KSQL queryAllPk error ", (Throwable)exception);
            List<Object> list = null;
            return list;
        }
        finally {
            this.closePKTempTable(this.tmpTableSQLOfSyncMap);
        }
    }

    public String genQueryAllPkSql(QueryEntityType queryEntityType, QFilter[] qFilters, String orderBys, int start, int limit, Map<String, List<QFilter>> relationMap) throws SqlTranslateException {
        QueryEntityInfo queryEntityInfo = this.ksqlConfig.getQueryEntityInfo(queryEntityType.getName());
        ArrayList joinEntities = new ArrayList(queryEntityInfo.getQueryEntityType().getJoinEntitys());
        ArrayList<QuerySourceJoinRelation> joinRelations = new ArrayList<QuerySourceJoinRelation>(10);
        for (JoinEntity joinEntity : joinEntities) {
            this.handleJoinRelations(queryEntityInfo, joinEntity, joinRelations, relationMap);
        }
        queryEntityInfo.setJoinRelations(joinRelations);
        qFilters = this.adaptiveQFilter(qFilters);
        Object[] qFiltersCopy = this.copyQFilters(qFilters);
        Object[] flikeQFilters = QFilterUtilHR.rebuidFlikeQFilterEx(this.unionFiltersMap, (QFilter[])qFiltersCopy, this.isFullUnion, queryEntityType, this.searchType);
        QFilter[] newOriginFilters = (QFilter[])ArrayUtils.addAll((Object[])flikeQFilters, (Object[])qFiltersCopy);
        newOriginFilters = (QFilter[])Arrays.stream(newOriginFilters).filter(Objects::nonNull).toArray(QFilter[]::new);
        StringBuilder orderBy = new StringBuilder();
        this.transforOrderBy(orderBys, orderBy, this.isUnionSQL);
        String queryEntityName = queryEntityType.getName();
        QFilter[] ignoreTableFilter = this.copyQFilters(newOriginFilters);
        this.transferQFilter(ignoreTableFilter, false, null);
        String selectSQL = this.ksqlConfig.getOnlyMainPKSqlStr(queryEntityName);
        StringBuilder sql = this.buildSQL(selectSQL, (QFilter[])flikeQFilters, (QFilter[])qFiltersCopy, orderBys);
        String orignSql = sql.toString();
        orignSql = orignSql.replaceAll("#\\{flocalid}", "'_XXXflocalidXXX_'");
        LOGGER.info("KSQL queryAllPk, orignSql:{}", (Object)orignSql);
        String optimizeSql = KSqlUtil.optimize((String)orignSql);
        if (start >= 0 && limit > 0) {
            String regex = "(?i)select";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(sql);
            optimizeSql = matcher.replaceFirst("SELECT TOP " + limit + ',' + start + ' ');
        }
        optimizeSql = optimizeSql.replaceAll("'_XXXflocalidXXX_'", "#\\{flocalid}");
        LOGGER.info("KSQL queryAllPk, optimizeSql:{}", (Object)optimizeSql);
        return optimizeSql;
    }

    public List<Object> queryAllPk(QueryEntityType queryEntityType, QFilter[] qFilters, String orderBys, int start, int limit) {
        return this.queryAllPk(queryEntityType, qFilters, orderBys, start, limit, null);
    }

    public DynamicObjectCollection queryDynamicObjectCollection(QueryEntityType queryEntityType, DynamicObjectType returnEntityType, String queryFields, QFilter[] qFilters, String orderBys, boolean isLimitCount, int start, int limit) {
        return this.queryDynamicObjectCollection(queryEntityType, returnEntityType, queryFields, qFilters, orderBys, isLimitCount, start, limit, this.ksqlConfig.getJoinOnRelationMap());
    }

    private void sortJoinEntity(List<JoinEntity> temp, List<JoinEntity> sortJoinEntities) {
        temp.removeAll(sortJoinEntities);
        temp.addAll(0, sortJoinEntities);
    }

    private List<List<Map<String, Object>>> getSplitResult(QueryEntityType queryEntityType, QueryEntityInfo queryEntityInfo, List<JoinEntity> sortJoinEntities, Map<String, List<QFilter>> relationMap, String orderBys, boolean isLimitCount, boolean limitRst, int start, int tmpLimit, String queryEntityName, QFilter[] newOriginFilters, QFilter[] flikeQFilters, QFilter[] qFiltersCopy) {
        int joinEntitySplitNumber = this.getJoinEntitySplitNumber(queryEntityType.getJoinEntitys().size());
        int startIdx = -1;
        List editEntitySelectField = queryEntityInfo.getEditEntitySelectField().getQueryFields().stream().map(QueryField::getAlias).collect(Collectors.toList());
        List mainEntitySelectField = queryEntityInfo.getQueryEntityType().getSelectFields().stream().filter(selectField -> editEntitySelectField.contains(selectField.getAlias())).collect(Collectors.toList());
        ArrayList<List<Map<String, Object>>> resultList = new ArrayList<List<Map<String, Object>>>(8);
        ArrayList<JoinEntity> temp = new ArrayList<JoinEntity>(queryEntityInfo.getQueryEntityType().getJoinEntitys());
        this.sortJoinEntity(temp, sortJoinEntities);
        if (CollectionUtils.isNotEmpty(sortJoinEntities) && joinEntitySplitNumber < sortJoinEntities.size()) {
            joinEntitySplitNumber = sortJoinEntities.size();
        }
        int joinEntitySize = temp.size();
        for (int i = 0; i < joinEntitySize; ++i) {
            if ((i + 1) % joinEntitySplitNumber != 0 && i != joinEntitySize - 1) continue;
            ArrayList<JoinEntity> joinEntitys = new ArrayList<JoinEntity>(temp.subList(startIdx + 1, i + 1));
            ArrayList<QuerySourceJoinRelation> joinRelations = new ArrayList<QuerySourceJoinRelation>();
            ArrayList<QuerySelectField> selectFields = new ArrayList<QuerySelectField>();
            if (i + 1 == joinEntitySplitNumber) {
                selectFields.addAll(mainEntitySelectField);
            } else {
                orderBys = "";
            }
            for (JoinEntity joinEntity : joinEntitys) {
                this.handleJoinRelations(queryEntityInfo, joinEntity, joinRelations, relationMap);
                boolean hasSelectFields = false;
                for (QuerySelectField selectField2 : queryEntityInfo.getQueryEntityType().getSelectFields()) {
                    if (!selectField2.getAlias().startsWith(joinEntity.getAlias() + ".")) continue;
                    selectFields.add(selectField2);
                    hasSelectFields = true;
                }
                if (hasSelectFields) continue;
                QuerySelectField selectField3 = new QuerySelectField();
                selectField3.setAlias(joinEntity.getAlias() + ".id");
                selectField3.setDisplayName(joinEntity.getDisplayName());
                selectFields.add(selectField3);
            }
            queryEntityInfo.setJoinEntitys(joinEntitys);
            queryEntityInfo.setJoinRelations(joinRelations);
            queryEntityInfo.setSelectFields(selectFields);
            resultList.add(this.getResult(orderBys, isLimitCount, limitRst, start, tmpLimit, queryEntityName, newOriginFilters, flikeQFilters, qFiltersCopy));
            queryEntityInfo.getJoinEntitys().clear();
            queryEntityInfo.getJoinRelations().clear();
            queryEntityInfo.getSelectFields().clear();
            queryEntityInfo.setJoinEntitySelectField(null);
            queryEntityInfo.setEditEntitySelectField(null);
            this.ksqlConfig.clearJoinConfig();
            startIdx = i;
        }
        int resultSize = ((List)resultList.get(0)).size();
        HashMap<Integer, Map<String, Map>> allMap = new HashMap<Integer, Map<String, Map>>();
        for (int j = 0; j < resultSize; ++j) {
            Map tempMap = (Map)((List)resultList.get(0)).get(j);
            for (int i = 1; i < resultList.size(); ++i) {
                Map<String, Map> resultMap;
                if (allMap.containsKey(i)) {
                    resultMap = (Map<String, Map>)allMap.get(i);
                } else {
                    resultMap = ((List)resultList.get(i)).stream().collect(Collectors.toMap(map -> String.valueOf(map.get("id")), map -> map, (x, y) -> x));
                    allMap.put(i, resultMap);
                }
                if (!resultMap.containsKey(String.valueOf(tempMap.get("id")))) continue;
                tempMap.putAll(resultMap.get(String.valueOf(tempMap.get("id"))));
            }
        }
        return resultList;
    }

    private QFilter[] adaptiveQFilter(QFilter[] qFilters) {
        if (qFilters == null) {
            return new QFilter[0];
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(qFilters.length);
        for (QFilter qFilter : qFilters) {
            if (qFilter == null) continue;
            if ("MultiEntityQueryTransformExpressCode".equals(qFilter.getProperty())) {
                this.customExpressFilterString = (String)qFilter.getValue();
                continue;
            }
            qFilterList.add(qFilter);
        }
        return qFilterList.toArray(new QFilter[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicObjectCollection queryDynamicObjectCollection(QueryEntityType queryEntityType, DynamicObjectType returnEntityType, String queryFields, QFilter[] qFilters, String orderBys, boolean isLimitCount, int start, int limit, Map<String, List<QFilter>> relationMap) {
        this.queryEntity = queryEntityType;
        qFilters = this.adaptiveQFilter(qFilters);
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection(returnEntityType, null);
        try {
            List<Map<String, Object>> result;
            boolean limitRst = true;
            if (this.querySQLType.equalsIgnoreCase(PKSQL) && (qFilters.length == 0 || !Arrays.stream(qFilters).allMatch(this::qFilterOnlyID))) {
                List<Object> pkIds = this.queryAllPk(queryEntityType, qFilters, orderBys, start, limit, relationMap);
                qFilters = CollectionUtils.isEmpty(pkIds) ? new QFilter[]{QFilter.of((String)"1!=1", (Object[])new Object[0])} : new QFilter[]{new QFilter(queryEntityType.getPrimaryKey().getName(), "in", pkIds)};
                limitRst = false;
            }
            Object[] qFiltersCopy = this.copyQFilters(qFilters);
            Object[] flikeQFilters = QFilterUtilHR.rebuidFlikeQFilterEx(this.unionFiltersMap, (QFilter[])qFiltersCopy, this.isFullUnion, queryEntityType, this.searchType);
            QFilter[] newOriginFilters = (QFilter[])Arrays.stream(ArrayUtils.addAll((Object[])flikeQFilters, (Object[])qFiltersCopy)).filter(Objects::nonNull).toArray(QFilter[]::new);
            ArrayList<JoinEntity> sortJoinEntities = new ArrayList<JoinEntity>(5);
            this.transforOrderBy(orderBys, new StringBuilder(), this.isUnionSQL, sortJoinEntities);
            String queryEntityName = queryEntityType.getName();
            QueryEntityInfo queryEntityInfo = this.ksqlConfig.getQueryEntityInfo(queryEntityName);
            if (this.needSeparate(queryEntityType, (QFilter[])qFiltersCopy, sortJoinEntities)) {
                List<List<Map<String, Object>>> resultList = this.getSplitResult(queryEntityType, queryEntityInfo, sortJoinEntities, relationMap, orderBys, isLimitCount, limitRst, start, limit, queryEntityName, newOriginFilters, (QFilter[])flikeQFilters, (QFilter[])qFiltersCopy);
                result = resultList.get(0);
            } else {
                ArrayList<QuerySourceJoinRelation> joinRelations = new ArrayList<QuerySourceJoinRelation>();
                List joinEntityList = queryEntityInfo.getQueryEntityType().getJoinEntitys();
                for (JoinEntity joinEntity : joinEntityList) {
                    this.handleJoinRelations(queryEntityInfo, joinEntity, joinRelations, relationMap);
                }
                queryEntityInfo.setJoinRelations(joinRelations);
                result = this.getResult(orderBys, isLimitCount, start, limit, queryEntityName, newOriginFilters, (QFilter[])flikeQFilters, (QFilter[])qFiltersCopy);
            }
            ListProviderDynamicObjCollectionUtil collectionUtil = new ListProviderDynamicObjCollectionUtil(queryFields, queryEntityType);
            collectionUtil.setReloadMultiLangField(true);
            DynamicObjectCollection dynamicObjectCollection2 = collectionUtil.createDynamicObjectCollection(result, start, dynamicObjectCollection, returnEntityType);
            return dynamicObjectCollection2;
        }
        catch (Exception exception) {
            LOGGER.error("KSQL queryDynamicObjectCollection error ", (Throwable)exception);
            DynamicObjectCollection dynamicObjectCollection3 = dynamicObjectCollection;
            return dynamicObjectCollection3;
        }
        finally {
            this.closePKTempTable(this.tmpTableSQLOfSyncMap);
        }
    }

    private QuerySourceJoinRelation copyJoinRelation(QuerySourceJoinRelation joinRelation) {
        QuerySourceJoinRelation relation = new QuerySourceJoinRelation();
        relation.setId(joinRelation.getId());
        relation.setJoinType(joinRelation.getJoinType());
        relation.setEntityNumber(joinRelation.getEntityNumber());
        relation.setRelEntityNumber(joinRelation.getRelEntityNumber());
        joinRelation.getCondition().forEach(arg_0 -> ((QuerySourceJoinRelation)relation).addCondition(arg_0));
        return relation;
    }

    private List<QSConditionRow> qFilter2QSConditionRow(List<QFilter> qFilterList) {
        ArrayList<QSConditionRow> rowList = new ArrayList<QSConditionRow>(qFilterList.size());
        for (QFilter qFilter : qFilterList) {
            QSConditionRow row = new QSConditionRow();
            QSIdentifierExpr left = new QSIdentifierExpr();
            left.setExpr(qFilter.getProperty());
            row.setLeftItem((QSExpr)left);
            row.setCompareOp(qFilter.getCP());
            QSIdentifierExpr right = new QSIdentifierExpr();
            right.setExpr(QFilterUtilHR.parametertoString(qFilter.getValue()));
            row.setRightItem((QSExpr)right);
            row.setLogicOp("AND");
            rowList.add(row);
            List nests = qFilter.getNests(false);
            if (!CollectionUtils.isNotEmpty((Collection)nests)) continue;
            for (QFilter.QFilterNest QFilterNest2 : nests) {
                rowList.addAll(this.qFilter2QSConditionRow(Collections.singletonList(QFilterNest2.getFilter())));
            }
        }
        return rowList;
    }

    private int getJoinEntitySplitNumber(int size) {
        if (size <= 4) {
            return size;
        }
        if (size <= 8) {
            return this.ceil(size, 2);
        }
        return this.ceil(size, 4) == this.ceil(size, 3) ? 3 : 4;
    }

    private int ceil(int a, int b) {
        return (int)Math.ceil((double)a * 1.0 / (double)b);
    }

    private List<Map<String, Object>> getResult(String orderBys, boolean isLimitCount, int start, int tmpLimit, String queryEntityName, QFilter[] newOriginFilters, QFilter[] flikeQFilters, QFilter[] qFiltersCopy) {
        return this.getResult(orderBys, isLimitCount, true, start, tmpLimit, queryEntityName, newOriginFilters, flikeQFilters, qFiltersCopy);
    }

    private List<Map<String, Object>> getResult(String orderBys, boolean isLimitCount, boolean limitRst, int start, int tmpLimit, String queryEntityName, QFilter[] newOriginFilters, QFilter[] flikeQFilters, QFilter[] qFiltersCopy) {
        this.transferQFilter(newOriginFilters, false, null);
        String selectSQL = limitRst && isLimitCount ? this.ksqlConfig.getSqlStr(tmpLimit, start) : this.ksqlConfig.getSqlStr();
        StringBuilder sql = this.buildSQL(selectSQL, flikeQFilters, qFiltersCopy, orderBys);
        Object[] params = KsqlMultiLangUtil.getSQLParams(sql.toString());
        sql = new StringBuilder(KsqlMultiLangUtil.localTransPlaceholder(sql.toString()));
        return this.queryDB(queryEntityName, sql, params);
    }

    private DynamicObjectCollection queryCollection(QueryBuilder queryBuilder, int start) {
        this.queryEntity = (QueryEntityType)queryBuilder.getEntityType();
        QFilter[] qFilters = queryBuilder.getFilters();
        String listSelectFields = this.getListSelectFields();
        DynamicObjectType returnEntityType = queryBuilder.getReturnEntityType();
        String customSelectedFields = this.getSubCustomFieldsString(listSelectFields, this.ksqlConfig.getCustomSelectedFields());
        listSelectFields = this.appendCustomSelectedFields(listSelectFields, customSelectedFields);
        QueryEntityTypeUtil queryEntityUtil = new QueryEntityTypeUtil(this.queryEntity, listSelectFields);
        queryEntityUtil.tryRegisterJoinPk(returnEntityType);
        this.registerCustomSelectedProperty(returnEntityType, queryEntityUtil, customSelectedFields);
        DynamicObjectCollection collection = this.queryDynamicObjectCollection(this.queryEntity, returnEntityType, listSelectFields, qFilters, queryBuilder.getOrderBys(), true, start, queryBuilder.getLimit());
        this.getQueryResult().setCollection(collection);
        return collection;
    }

    private String getListSelectFields() {
        List listFields = this.getListFields();
        return listFields.stream().map(ListField::getFieldName).collect(Collectors.joining(","));
    }

    private void closePKTempTable(Map<String, PKTempTable> tmpTableMap) {
        if (tmpTableMap != null) {
            for (Map.Entry<String, PKTempTable> entry : tmpTableMap.entrySet()) {
                LOGGER.info("HR queryentity query close tmptable:{}", (Object)entry.getKey());
                entry.getValue().close();
            }
            tmpTableMap.clear();
        }
    }

    private List<Map<String, Object>> queryDB(final String entityName, StringBuilder sql, Object[] params) {
        final ArrayList listDB = Lists.newArrayListWithCapacity((int)16);
        HRDBUtil.query((DBRoute)this.ksqlConfig.getDBRoute(entityName), (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                HashMap<String, Integer> columnDataTypeMap = new HashMap<String, Integer>(16);
                int columnCount = rs.getMetaData().getColumnCount();
                for (int i = 1; i <= columnCount; ++i) {
                    int columnType = rs.getMetaData().getColumnType(i);
                    String string = rs.getMetaData().getColumnLabel(i);
                    if (!HRStringUtils.equals((String)rs.getMetaData().getColumnLabel(i), (String)rs.getMetaData().getColumnName(i))) {
                        // empty if block
                    }
                    columnDataTypeMap.put(string.toLowerCase(), columnType);
                }
                StringBuilder stringBuilder = new StringBuilder(System.lineSeparator());
                for (Map.Entry entry : columnDataTypeMap.entrySet()) {
                    stringBuilder.append("key = ").append(entry.getKey() == null ? "'null'" : (String)entry.getKey()).append(", value = ").append(entry.getValue() == null ? "'null'" : ((Integer)entry.getValue()).toString()).append(System.lineSeparator());
                }
                HashMap<String, String> columnNameMappingMap = new HashMap<String, String>(16);
                for (Map.Entry<String, Object> entry : KsqlListDataProvider.this.ksqlConfig.getPropMap(entityName).entrySet()) {
                    columnNameMappingMap.put((String)entry.getValue(), entry.getKey().replace('.', '$') + "$");
                }
                stringBuilder = new StringBuilder(System.lineSeparator());
                for (Map.Entry entry : columnNameMappingMap.entrySet()) {
                    stringBuilder.append("key = ").append(entry.getKey() == null ? "'null'" : (String)entry.getKey()).append(", value = ").append(entry.getValue() == null ? "'null'" : (String)entry.getValue()).append(System.lineSeparator());
                }
                while (rs.next()) {
                    HashMap hashMap = Maps.newHashMapWithExpectedSize((int)16);
                    for (Map.Entry baseMap : columnNameMappingMap.entrySet()) {
                        String string = ((String)baseMap.getValue()).toLowerCase();
                        if (columnDataTypeMap.get(string) != null) {
                            if ((Integer)columnDataTypeMap.get(string) == 93) {
                                hashMap.put(baseMap.getKey(), rs.getTimestamp(string));
                                continue;
                            }
                            hashMap.put(baseMap.getKey(), rs.getString(string));
                            continue;
                        }
                        hashMap.put(baseMap.getKey(), rs.getString(string));
                    }
                    listDB.add(hashMap);
                }
                return null;
            }
        });
        return listDB;
    }

    protected String transferQFilter(QFilter[] oriFilters, boolean bTmpTable, Map<String, PKTempTable> tmpTableMap) {
        QFilter[] filters = this.transQFilter(oriFilters);
        return this.qFilterToString(filters, bTmpTable, tmpTableMap);
    }

    private String qFilterToString(QFilter[] filters, boolean bTmpTable, Map<String, PKTempTable> tmpTableMap) {
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(filters, this.ksqlConfig.getDBRoute(this.queryEntity.getName()), bTmpTable, tmpTableMap);
        criteriaBuilder.setTmpTableThresh(this.tmpTableThresh);
        return criteriaBuilder.qFilterToString();
    }

    private QFilter[] transQFilter(QFilter[] oriFilters) {
        QFilter[] filters = this.copyQFilters(oriFilters);
        QFilterKSQLTransFunction sqltf = new QFilterKSQLTransFunction(this.queryEntity, this.ksqlConfig);
        int n = filters.length;
        for (int i = 0; i < n; ++i) {
            if (filters[i] == null) continue;
            filters[i] = filters[i].trans((Function)sqltf);
        }
        return filters;
    }

    private boolean qFilterOnlyID(QFilter qFilter) {
        if (qFilter == null || HRStringUtils.isEmpty((String)qFilter.toString())) {
            LOGGER.info("query exists null");
            return false;
        }
        if (qFilter.toString().equals("1 = 1")) {
            List nests = qFilter.getNests(true);
            if (CollectionUtils.isEmpty((Collection)nests)) {
                LOGGER.info("query separate qFilterOnlyID false only 1 = 1");
                return false;
            }
            return nests.stream().allMatch(nest -> this.qFilterOnlyID(nest.getFilter()));
        }
        if (qFilter.getProperty().equalsIgnoreCase("id")) {
            Collection qFilterColl;
            Object qFilterValue = qFilter.getValue();
            if (qFilterValue instanceof Collection && (qFilterColl = (Collection)qFilterValue).size() >= this.tmpTableThresh * 5) {
                LOGGER.info("query separate qFilterOnlyID false id too big");
                return false;
            }
            List nests = qFilter.getNests(true);
            if (CollectionUtils.isEmpty((Collection)nests)) {
                return true;
            }
            return nests.stream().allMatch(nest -> this.qFilterOnlyID(nest.getFilter()));
        }
        LOGGER.info("query separate qFilterOnlyID false");
        return false;
    }

    private boolean needSeparate(QueryEntityType queryEntityType, QFilter[] qFilters, List<JoinEntity> sortJoinEntities) {
        if (!HRStringUtils.isEmpty((String)this.customExpressFilterString)) {
            return false;
        }
        boolean separate = queryEntityType.getJoinEntitys().size() >= 7;
        return separate && qFilters.length > 0 && Arrays.stream(qFilters).allMatch(this::qFilterOnlyID) && sortJoinEntities.size() < 5;
    }

    private String appendCustomSelectedFields(String listSelectFields, String customSelectedFields) {
        if (!HRStringUtils.isEmpty((String)customSelectedFields)) {
            listSelectFields = listSelectFields + "," + customSelectedFields;
        }
        return listSelectFields;
    }

    @ExcludeFromJacocoGeneratedReport
    private String getSubCustomFieldsString(String listSelectFields, String customSelectedFields) {
        if (HRStringUtils.isEmpty((String)customSelectedFields)) {
            return null;
        }
        HashSet<String> fieldSet = new HashSet<String>(16);
        List<String> queryFieldList = Arrays.asList(listSelectFields.split(","));
        fieldSet.addAll(queryFieldList);
        List customFieldList = Arrays.stream(customSelectedFields.split(",")).filter(field -> !fieldSet.contains(field)).collect(Collectors.toList());
        return String.join((CharSequence)",", customFieldList);
    }

    @ExcludeFromJacocoGeneratedReport
    private void registerCustomSelectedProperty(DynamicObjectType dynamicOjbType, QueryEntityTypeUtil queryEntityUtil, String customSelectedFields) {
        if (customSelectedFields != null && customSelectedFields.trim().length() > 0) {
            String[] fields;
            for (String field : fields = customSelectedFields.split(",")) {
                queryEntityUtil.registerProperty(dynamicOjbType, field);
            }
        }
    }

    private void initTmpTableThresh() {
        try {
            AppParam appParam;
            long orgId = RequestContext.get().getOrgId();
            Map sysConfigMap = null;
            if (orgId > 0L) {
                LOGGER.info("loadAppParameterFromCache from org:{}", (Object)orgId);
                appParam = new AppParam("15NPDX/GJFOO", Long.valueOf(orgId));
                sysConfigMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
            }
            if ((sysConfigMap == null || sysConfigMap.isEmpty()) && orgId != OrgServiceUtil.getHRRootOrgId()) {
                LOGGER.info("loadAppParameterFromCache from root org");
                appParam = new AppParam("15NPDX/GJFOO", Long.valueOf(OrgServiceUtil.getHRRootOrgId()));
                sysConfigMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
            }
            if (sysConfigMap == null || sysConfigMap.isEmpty()) {
                throw new KDBizException("sysConfig is Empty");
            }
            Object tmpTbThreshObj = sysConfigMap.get("tmptablethresh");
            this.tmpTableThresh = Objects.isNull(tmpTbThreshObj) ? 10000 : (Integer)tmpTbThreshObj;
            Object searchTypeObj = sysConfigMap.get("searchtype");
            this.searchType = Objects.isNull(searchTypeObj) ? "1" : (String)searchTypeObj;
            LOGGER.info("initTmpTableThresh: tmpTableThresh:{}, searchType:{}", (Object)this.tmpTableThresh, (Object)this.searchType);
            if (this.tmpTableThresh == 0) {
                this.tmpTableThresh = 10000;
            }
            if (HRStringUtils.isEmpty((String)this.searchType)) {
                this.searchType = "1";
            }
        }
        catch (Exception exception) {
            this.tmpTableThresh = 10000;
            this.searchType = "1";
            LOGGER.info("initTmpTableThresh: tmpTableThresh:{}, searchType:{}", (Object)this.tmpTableThresh, (Object)this.searchType);
            LOGGER.warn("loadAppParameterFromCache exception:", (Throwable)exception);
        }
    }

    private String parseExpressFilterString(QueryEntityType queryEntity, IKsqlConfig ksqlConfig) {
        String filterConditionParseResult = null;
        if (HRStringUtils.isEmpty((String)this.customExpressFilterString)) {
            return null;
        }
        CustomConditionFilterBuilder queryConditionFilterBuilder = new CustomConditionFilterBuilder();
        filterConditionParseResult = queryConditionFilterBuilder.parseFilterString(queryEntity, ksqlConfig, this.customExpressFilterString);
        return filterConditionParseResult;
    }
}

