/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.query.ksql;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QuerySourceJoinRelation;
import kd.hr.hbp.business.service.complexobj.util.MapCacheUtil;
import kd.hr.hbp.business.service.query.ksql.EntitySelectField;
import kd.hr.hbp.business.service.query.ksql.KsqlConfig;
import kd.hr.hbp.business.service.query.ksql.QueryEntityInfo;
import kd.hr.hbp.business.service.query.ksql.QueryField;
import kd.hr.hbp.business.service.query.ksql.QueryKSqlTableParse;
import kd.hr.hbp.business.service.query.model.QueryJoinConditionRowDetail;
import kd.hr.hbp.business.service.query.model.QueryJoinEntityRelation;
import kd.hr.hbp.business.service.query.model.QueryJoinFieldDetail;
import kd.hr.hbp.business.service.query.util.QueryJoinExprUtil;
import kd.hr.hbp.business.servicehelper.HREntityHelper;
import kd.hr.hbp.common.enums.query.KsqlJoinHint;
import kd.hr.hbp.common.util.HRStringUtils;

public class QueryKSqlFromParser {
    private final QueryEntityInfo queryEntityInfo;
    private final KsqlConfig ksqlConfig;
    private final Map<String, String> splitTbJoinCondMap;

    public QueryKSqlFromParser(QueryEntityInfo queryEntityInfo, KsqlConfig ksqlConfig) {
        this.queryEntityInfo = queryEntityInfo;
        this.ksqlConfig = ksqlConfig;
        this.splitTbJoinCondMap = new HashMap<String, String>(10);
    }

    public String getTableFromSql(boolean ignoreSplitTb, boolean ignoreMultiLanguageTb, Set<String> mustLoadTb) {
        HashMap<String, Set<String>> loadRecordAliasMap = new HashMap<String, Set<String>>();
        return this.getMustTableFromSql(loadRecordAliasMap) + this.genMuliLangTableSql(loadRecordAliasMap, ignoreSplitTb, mustLoadTb) + this.genTableGroupSql(loadRecordAliasMap, ignoreMultiLanguageTb, mustLoadTb);
    }

    private String getMustTableFromSql(Map<String, Set<String>> loadRecordAliasMap) {
        StringBuilder fromSqlSb = new StringBuilder(" FROM ");
        String editEntityTable = this.queryEntityInfo.getEditEntityTable();
        String editEntityNum = this.queryEntityInfo.getEditEntityNum();
        Map<String, Map<String, String>> tableAliasMap = this.ksqlConfig.getTableAliasMap(this.queryEntityInfo.getQueryEntityNum());
        String editEntityTableAlias = tableAliasMap.get(editEntityNum).get(editEntityTable);
        fromSqlSb.append(this.composeSimpleFromSql(editEntityTable, "", editEntityTableAlias, ""));
        HashSet<String> mainTbSet = new HashSet<String>(5);
        mainTbSet.add(editEntityTable);
        loadRecordAliasMap.put(editEntityNum, mainTbSet);
        fromSqlSb.append(this.genJoinRelationSql(loadRecordAliasMap));
        return fromSqlSb.toString();
    }

    private String genJoinRelationSql(Map<String, Set<String>> loadRecordAliasMap) {
        List<QuerySourceJoinRelation> joinRelations = this.queryEntityInfo.getQueryJoinRelations();
        Map<String, Map<String, String>> entityTableAlias = this.ksqlConfig.getTableAliasMap(this.queryEntityInfo.getQueryEntityNum());
        StringBuilder joinSql = new StringBuilder(" ");
        for (QuerySourceJoinRelation joinRelation : joinRelations) {
            joinSql.append(this.genJoinSql(joinRelation, loadRecordAliasMap, entityTableAlias));
        }
        return joinSql.toString();
    }

    private String genJoinSql(QuerySourceJoinRelation joinRelation, Map<String, Set<String>> loadRecordAliasMap, Map<String, Map<String, String>> entityTableAlias) {
        Map<String, String> relEntityMap = this.queryEntityInfo.getQueryJoinEntitys().stream().collect(Collectors.toMap(JoinEntity::getAlias, JoinEntity::getEntityName));
        List<Object> queryFields = new ArrayList<QueryField>(0);
        for (EntitySelectField entitySelectField : this.queryEntityInfo.getJoinEntitySelectField()) {
            if (!entitySelectField.getEntityAlias().equals(joinRelation.getRelEntityNumber())) continue;
            queryFields = entitySelectField.getQueryFields();
            for (QueryField queryField : queryFields) {
                queryField.setFieldEntityAlias(entitySelectField.getEntityAlias());
            }
        }
        List<QueryField> enitEntityFields = this.queryEntityInfo.getEditEntitySelectField().getQueryFields();
        for (QueryField enitEntityField : enitEntityFields) {
            enitEntityField.setFieldEntityAlias(this.queryEntityInfo.getEditEntityNum());
        }
        queryFields.addAll(enitEntityFields);
        QueryJoinEntityRelation queryJoinEntityRelation = QueryJoinExprUtil.conditionTrans(this.queryEntityInfo.getQueryEntityType(), joinRelation, relEntityMap, queryFields);
        LinkedHashMap<String, String> joinSqlMap = new LinkedHashMap<String, String>(16);
        Set<String> set = loadRecordAliasMap.get(joinRelation.getEntityNumber());
        StringBuilder rstSql = new StringBuilder(" ");
        List<QueryJoinConditionRowDetail> joinRowList = queryJoinEntityRelation.getJoinRowList();
        if (queryJoinEntityRelation.isJoinAble()) {
            joinRowList.sort(Comparator.comparingInt(QueryJoinConditionRowDetail::getJoinNum));
        } else {
            joinRowList.sort(Comparator.comparingInt(QueryJoinConditionRowDetail::getJoinNum).reversed());
        }
        String firstJoinTb = null;
        for (QueryJoinConditionRowDetail joinConditionRowDetail : joinRowList) {
            String mainJoinSqlStr = this.tryJoinMainTableSpliTb(joinRelation, entityTableAlias, set, joinConditionRowDetail);
            rstSql.append(mainJoinSqlStr);
            firstJoinTb = this.genJoinFieldItemSql(loadRecordAliasMap, entityTableAlias, queryJoinEntityRelation, joinSqlMap, firstJoinTb, joinConditionRowDetail);
        }
        for (QueryJoinConditionRowDetail joinConditionRowDetail : joinRowList) {
            this.genJoinFieldFilterSql(loadRecordAliasMap, entityTableAlias, joinSqlMap, firstJoinTb, joinConditionRowDetail);
        }
        loadRecordAliasMap.put(joinRelation.getEntityNumber(), set);
        for (String value : joinSqlMap.values()) {
            rstSql.append(value);
        }
        return rstSql.toString();
    }

    private void genJoinFieldFilterSql(Map<String, Set<String>> loadRecordAliasMap, Map<String, Map<String, String>> entityTableAlias, LinkedHashMap<String, String> joinSqlMap, String firstJoinTb, QueryJoinConditionRowDetail joinConditionRowDetail) {
        if (QueryJoinExprUtil.itemIsField(this.queryEntityInfo.getQueryEntityType(), joinConditionRowDetail.getConditionRow().getRightItem().toString())) {
            return;
        }
        QueryJoinFieldDetail leftField = joinConditionRowDetail.getLeftField();
        StringBuilder conditionAndSql = new StringBuilder(" AND ");
        Map<String, String> tableAliasMap = entityTableAlias.get(leftField.getFieldInfo().getFieldEntityAlias());
        Set<String> leftFieldCache = MapCacheUtil.getMapSetVal(loadRecordAliasMap, leftField.getFieldInfo().getFieldEntityAlias());
        String fieldTbAlias = tableAliasMap.get(leftField.getFieldRealTable());
        conditionAndSql.append(fieldTbAlias).append(".").append(leftField.getFieldInfo().getDbField()).append(" ");
        String compareOp = joinConditionRowDetail.getConditionRow().getCompareOp();
        conditionAndSql.append(compareOp);
        conditionAndSql.append(" ");
        String rightItemStr = joinConditionRowDetail.getConditionRow().getRightItem().toString();
        if ("like".equals(compareOp) || "not like".equals(compareOp)) {
            if (rightItemStr.endsWith("'")) {
                rightItemStr = rightItemStr.substring(0, rightItemStr.lastIndexOf("'"));
                rightItemStr = rightItemStr + "%'";
            }
            conditionAndSql.append(rightItemStr);
        } else if ("in".equals(compareOp) || "not in".equals(compareOp)) {
            conditionAndSql.append("(");
            conditionAndSql.append(rightItemStr);
            conditionAndSql.append(")");
        } else {
            conditionAndSql.append(rightItemStr);
        }
        conditionAndSql.append(" ");
        leftFieldCache.add(leftField.getFieldRealTable());
        loadRecordAliasMap.put(leftField.getFieldInfo().getFieldEntityAlias(), leftFieldCache);
        String joinTb = leftField.getFieldRealTable();
        if (leftField.isMainEntityField()) {
            joinTb = firstJoinTb;
        }
        String condiTionStr = conditionAndSql.toString();
        String joinSql = joinSqlMap.get(joinTb);
        if (joinSql == null) {
            String joinCondSql = this.splitTbJoinCondMap.get(joinTb);
            joinCondSql = joinCondSql == null ? " " : joinCondSql;
            this.splitTbJoinCondMap.put(joinTb, joinCondSql + condiTionStr);
        } else {
            joinSqlMap.put(joinTb, joinSql + condiTionStr);
        }
    }

    private String genJoinFieldItemSql(Map<String, Set<String>> loadRecordAliasMap, Map<String, Map<String, String>> entityTableAlias, QueryJoinEntityRelation joinEntityRelation, LinkedHashMap<String, String> joinSqlMap, String firstJoinTb, QueryJoinConditionRowDetail joinConditionRowDetail) {
        if (!QueryJoinExprUtil.itemIsField(this.queryEntityInfo.getQueryEntityType(), joinConditionRowDetail.getConditionRow().getRightItem().toString())) {
            return firstJoinTb;
        }
        QueryJoinFieldDetail leftField = joinConditionRowDetail.getLeftField();
        QueryJoinFieldDetail rightField = joinConditionRowDetail.getRightField();
        if (!leftField.isMainEntityField() && rightField.isMainEntityField()) {
            QueryJoinFieldDetail temp = rightField;
            rightField = leftField;
            leftField = temp;
        }
        if (firstJoinTb == null) {
            firstJoinTb = rightField.getFieldRealTable();
        }
        StringBuilder conditionSql = new StringBuilder(" ON ");
        Map<String, String> tableAliasMap = entityTableAlias.get(leftField.getFieldInfo().getFieldEntityAlias());
        String fieldTbAlias = tableAliasMap.get(leftField.getFieldRealTable());
        conditionSql.append(fieldTbAlias).append(".").append(leftField.getFieldInfo().getDbField()).append(" ");
        conditionSql.append(joinConditionRowDetail.getConditionRow().getCompareOp());
        conditionSql.append(" ");
        tableAliasMap = entityTableAlias.get(rightField.getFieldInfo().getFieldEntityAlias());
        String rightJoinTb = rightField.getFieldRealTable();
        fieldTbAlias = tableAliasMap.get(rightJoinTb);
        conditionSql.append(fieldTbAlias).append(".").append(rightField.getFieldInfo().getDbField()).append(" ");
        if (rightField.isMulangField()) {
            conditionSql.append(" AND ").append(fieldTbAlias).append(".").append("FLOCALEID = ").append("#{flocalid}").append(' ');
        }
        Set<String> rightFieldCache = MapCacheUtil.getMapSetVal(loadRecordAliasMap, rightField.getFieldInfo().getFieldEntityAlias());
        String mainTbJoinSql = null;
        if (HRStringUtils.isNotEmpty((String)rightField.getSplitTable())) {
            if (rightFieldCache.contains(rightField.getMainTable())) {
                conditionSql.append(" AND ").append(fieldTbAlias).append(".").append(rightField.getFieldInfo().getPkDbField()).append(" = ").append(tableAliasMap.get(rightField.getMainTable())).append(".").append(rightField.getFieldInfo().getPkDbField());
            } else {
                String mainTbJoinCondition = " ON " + fieldTbAlias + "." + rightField.getFieldInfo().getPkDbField() + " = " + tableAliasMap.get(rightField.getMainTable()) + "." + rightField.getFieldInfo().getPkDbField();
                mainTbJoinSql = this.composeSimpleFromSql(rightField.getMainTable(), joinEntityRelation.getJoinRelation().getJoinType(), entityTableAlias.get(rightField.getFieldInfo().getFieldEntityAlias()).get(rightField.getMainTable()), mainTbJoinCondition);
            }
        }
        String composeSimpleFromSql = this.composeSimpleFromSql(rightJoinTb, joinEntityRelation.getJoinRelation().getJoinType(), entityTableAlias.get(rightField.getFieldInfo().getFieldEntityAlias()).get(rightJoinTb), conditionSql.toString());
        joinSqlMap.put(rightJoinTb, composeSimpleFromSql);
        rightFieldCache.add(rightJoinTb);
        if (mainTbJoinSql != null) {
            joinSqlMap.put(rightField.getMainTable(), mainTbJoinSql);
            rightFieldCache.add(rightField.getMainTable());
        }
        loadRecordAliasMap.put(rightField.getFieldInfo().getFieldEntityAlias(), rightFieldCache);
        return firstJoinTb;
    }

    private String tryJoinMainTableSpliTb(QuerySourceJoinRelation joinRelation, Map<String, Map<String, String>> entityTableAlias, Set<String> mainEntityLoadCache, QueryJoinConditionRowDetail joinConditionRowDetail) {
        String splitTable;
        QueryJoinFieldDetail mainJoinDetail = null;
        String joinSqlStr = "";
        if (joinConditionRowDetail.getLeftField().isMainEntityField()) {
            mainJoinDetail = joinConditionRowDetail.getLeftField();
        } else if (QueryJoinExprUtil.itemIsField(this.queryEntityInfo.getQueryEntityType(), joinConditionRowDetail.getConditionRow().getRightItem().toString()) && joinConditionRowDetail.getRightField().isMainEntityField()) {
            mainJoinDetail = joinConditionRowDetail.getRightField();
        }
        if (mainJoinDetail != null && HRStringUtils.isNotEmpty((String)mainJoinDetail.getSplitTable()) && !mainEntityLoadCache.contains(splitTable = mainJoinDetail.getSplitTable())) {
            joinSqlStr = mainJoinDetail.isMulangField() ? this.composeMuliLangFromSql(splitTable, mainJoinDetail.getMainTable(), mainJoinDetail.getMainTablePk(), entityTableAlias.get(joinRelation.getEntityNumber())) : this.composeSplitTableFromSql(splitTable, mainJoinDetail.getMainTable(), mainJoinDetail.getMainTablePk(), mainJoinDetail.getMainTablePk(), entityTableAlias.get(joinRelation.getEntityNumber()));
            mainEntityLoadCache.add(splitTable);
        }
        return joinSqlStr;
    }

    private String genMuliLangTableSql(Map<String, Set<String>> loadRecordAliasMap, boolean ignore, Set<String> mustLoadTb) {
        StringBuilder mulTableSql = new StringBuilder();
        Map<String, Set<String>> mlTableMap = QueryKSqlTableParse.getMLTables(this.queryEntityInfo);
        Map<String, Map<String, String>> entityTableAlias = this.ksqlConfig.getTableAliasMap(this.queryEntityInfo.getEditEntityNum());
        Set<String> unIgnoreTable = this.ksqlConfig.getUnIgnoreTable();
        for (Map.Entry<String, Set<String>> entry : mlTableMap.entrySet()) {
            String entityAlias = entry.getKey();
            Set<String> multiLangTbSet = entry.getValue();
            Map<String, String> tableAlias = entityTableAlias.get(entityAlias);
            Iterator<String> iterator = multiLangTbSet.iterator();
            while (iterator.hasNext()) {
                String mulLangTable = iterator.next();
                String mainTable = mulLangTable.substring(0, mulLangTable.length() - 2);
                if (!tableAlias.containsKey(mainTable)) {
                    iterator.remove();
                    continue;
                }
                if (unIgnoreTable.contains(mulLangTable)) continue;
                iterator.remove();
            }
        }
        Map<String, String> tablePkMap = QueryKSqlFromParser.getTablePk(this.queryEntityInfo);
        for (Map.Entry<String, Set<String>> entry : mlTableMap.entrySet()) {
            String entityAlias = entry.getKey();
            Set<String> loadRecordTable = MapCacheUtil.getMapSetVal(loadRecordAliasMap, entityAlias);
            Set<String> tableSet = entry.getValue();
            for (String mulTb : tableSet) {
                if (loadRecordTable.contains(mulTb)) continue;
                String mainTable = mulTb.substring(0, mulTb.length() - 2);
                String pkField = tablePkMap.get(mainTable);
                mulTableSql.append(this.composeMuliLangFromSql(mulTb, mainTable, pkField, entityTableAlias.get(entityAlias)));
                loadRecordTable.add(mulTb);
            }
            loadRecordAliasMap.put(entityAlias, loadRecordTable);
        }
        return mulTableSql.toString();
    }

    private String composeMuliLangFromSql(String muliLangTable, String mainTable, String pkField, Map<String, String> entityTableAlias) {
        String muliLangTbAlias = entityTableAlias.get(muliLangTable);
        String mainTbAlias = entityTableAlias.get(mainTable);
        return KsqlJoinHint.LEFTJOIN.getJoin() + " " + muliLangTable + " " + muliLangTbAlias + " ON (" + mainTbAlias + "." + pkField + " = " + muliLangTbAlias + "." + pkField + " AND " + muliLangTbAlias + "." + "FLOCALEID = " + "#{flocalid}" + ") ";
    }

    private static void genIgnoreTableRecord(Map<String, Set<String>> specialTableMap, Set<String> mustLoadTb, Map<String, Set<String>> loadRecordAliasMap) {
        specialTableMap.forEach((entityAlias, specialTables) -> {
            if (mustLoadTb != null) {
                specialTables.removeAll(mustLoadTb);
            }
            Set loadTables = MapCacheUtil.getMapSetVal(loadRecordAliasMap, entityAlias);
            loadTables.addAll(specialTables);
            loadRecordAliasMap.put((String)entityAlias, loadTables);
        });
    }

    private String genTableGroupSql(Map<String, Set<String>> loadRecordAliasMap, boolean ignore, Set<String> mustLoadTb) {
        StringBuilder splitTbSql = new StringBuilder();
        Map<String, Set<String>> splitTableMap = QueryKSqlTableParse.getSplitTables(this.queryEntityInfo);
        Map<String, Map<String, String>> entityTableAlias = this.ksqlConfig.getTableAliasMap(this.queryEntityInfo.getQueryEntityNum());
        Map<String, String> tablePkMap = QueryKSqlFromParser.getTablePk(this.queryEntityInfo);
        for (Map.Entry<String, Set<String>> entry : splitTableMap.entrySet()) {
            String entityAlias = entry.getKey();
            Set<String> loadRecordTable = MapCacheUtil.getMapSetVal(loadRecordAliasMap, entityAlias);
            Set<String> tableSet = entry.getValue();
            Map<String, String> tableAlias = entityTableAlias.get(entityAlias);
            for (String splitTb : tableSet) {
                if (loadRecordTable.contains(splitTb)) continue;
                String mainTb = splitTb.substring(0, splitTb.lastIndexOf("_"));
                String pkField = tablePkMap.get(mainTb);
                if (!tableAlias.containsKey(mainTb)) continue;
                splitTbSql.append(this.composeSplitTableFromSql(splitTb, mainTb, pkField, pkField, entityTableAlias.get(entityAlias)));
                String joinCondSql = this.splitTbJoinCondMap.get(splitTb);
                joinCondSql = joinCondSql == null ? " " : joinCondSql;
                splitTbSql.append(joinCondSql);
                loadRecordTable.add(splitTb);
            }
            loadRecordAliasMap.put(entityAlias, loadRecordTable);
        }
        return splitTbSql.toString();
    }

    private static Map<String, String> getTablePk(QueryEntityInfo queryEntityInfo) {
        HashMap tablePkMap = Maps.newHashMapWithExpectedSize((int)16);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)queryEntityInfo.getEditEntityNum());
        tablePkMap.put(HREntityHelper.getTableName(queryEntityInfo.getEditEntityNum()), entityType.getPrimaryKey().getAlias());
        List<JoinEntity> joinEntitys = queryEntityInfo.getQueryJoinEntitys();
        for (JoinEntity joinEntity : joinEntitys) {
            MainEntityType joinEntityType = EntityMetadataCache.getDataEntityType((String)joinEntity.getEntityName());
            tablePkMap.put(HREntityHelper.getTableName(joinEntity.getEntityName()), joinEntityType.getPrimaryKey().getAlias());
        }
        return tablePkMap;
    }

    private String composeSplitTableFromSql(String splittable, String mainTable, String pkField, String fkField, Map<String, String> entityTableAlias) {
        String splitTbAlias = entityTableAlias.get(splittable);
        String mainTbAlias = entityTableAlias.get(mainTable);
        return KsqlJoinHint.LEFTJOIN.getJoin() + " " + splittable + " " + splitTbAlias + " ON " + mainTbAlias + "." + pkField + " = " + splitTbAlias + "." + fkField + " ";
    }

    private String composeSimpleFromSql(String tableName, String joinType, String tableAlias, String conditionSql) {
        String join = KsqlJoinHint.of((String)joinType).getJoin();
        return join + " " + tableName + " " + tableAlias + " " + conditionSql + " ";
    }
}

