/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.query.ksql;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.query.ksql.KsqlConfig;
import kd.hr.hbp.business.service.query.ksql.QueryEntityInfo;
import kd.hr.hbp.business.servicehelper.HREntityHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.QueryKSqlUtil;
import org.apache.commons.lang.StringUtils;

public class QueryKSqlSelectListParse {
    private static final Log LOGGER = LogFactory.getLog(QueryKSqlSelectListParse.class);
    private KsqlConfig ksqlConfig;

    public QueryKSqlSelectListParse(KsqlConfig ksqlConfig) {
        this.ksqlConfig = ksqlConfig;
    }

    public String getPkSelectList(QueryEntityInfo queryEntityInfo) {
        return this.getPkSelectList(queryEntityInfo, null);
    }

    public String getPkSelectList(QueryEntityInfo queryEntityInfo, Set<String> recordFieldAlias) {
        StringBuilder selectList = new StringBuilder();
        Map<String, Map<String, String>> entityTableAliasMap = this.ksqlConfig.getTableAliasMap(queryEntityInfo.getQueryEntityNum());
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)queryEntityInfo.getEditEntityNum());
        ISimpleProperty primaryKey = entityType.getPrimaryKey();
        selectList.append(this.composeSimpleSelectList(entityTableAliasMap.get(queryEntityInfo.getEditEntityNum()).get(queryEntityInfo.getEditEntityTable()), primaryKey.getAlias(), primaryKey.getName()));
        if (recordFieldAlias != null) {
            recordFieldAlias.add(primaryKey.getName());
        }
        List<JoinEntity> joinEntitys = queryEntityInfo.getQueryJoinEntitys();
        for (JoinEntity joinEntity : joinEntitys) {
            String joinEntityName = joinEntity.getEntityName();
            MainEntityType joinEntityType = EntityMetadataCache.getDataEntityType((String)joinEntityName);
            String joinEntityTable = HREntityHelper.getTableName(joinEntityName);
            String joinEntityPkFieldAlias = joinEntity.getAlias() + "." + joinEntityType.getPrimaryKey().getName();
            selectList.append(this.composeSimpleSelectList(entityTableAliasMap.get(joinEntity.getAlias()).get(joinEntityTable), joinEntityType.getPrimaryKey().getAlias(), joinEntityPkFieldAlias));
            if (recordFieldAlias == null) continue;
            recordFieldAlias.add(joinEntityPkFieldAlias);
        }
        String selectSql = selectList.toString();
        if (HRStringUtils.isNotEmpty((String)selectSql)) {
            selectSql = selectSql.substring(0, selectSql.lastIndexOf(","));
        }
        return selectSql;
    }

    public String getMainEntityPkSelectList(String orderBy, QueryEntityInfo queryEntityInfo, Map<String, Map<String, String>> entityTableAliasMap) {
        String selectSql;
        StringBuilder selectList = new StringBuilder();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)queryEntityInfo.getEditEntityNum());
        ISimpleProperty primaryKey = entityType.getPrimaryKey();
        HashSet<String> recordFieldAlias = new HashSet<String>();
        recordFieldAlias.add(primaryKey.getName());
        selectList.append(this.composeSimpleSelectList(entityTableAliasMap.get(queryEntityInfo.getEditEntityNum()).get(queryEntityInfo.getEditEntityTable()), primaryKey.getAlias(), primaryKey.getName()));
        if (StringUtils.isNotEmpty((String)orderBy)) {
            orderBy = orderBy.toLowerCase().replaceAll(" desc", "").replaceAll(" asc", "").trim();
            String[] orderBys = orderBy.split(",");
            List<JoinEntity> joinEntitys = queryEntityInfo.getQueryJoinEntitys();
            Map joinEntityMap = joinEntitys.stream().collect(Collectors.toMap(JoinEntity::getAlias, Function.identity()));
            for (String queryFieldAlias : orderBys) {
                String[] fieldAliasArr = queryFieldAlias.split("\\.");
                String firstField = fieldAliasArr[0];
                JoinEntity joinEntity = (JoinEntity)joinEntityMap.get(firstField);
                String curEntityNum = null;
                String curEntityAlias = null;
                String curFieldAlias = null;
                String fieldPrefix = null;
                if (joinEntity != null) {
                    curEntityNum = joinEntity.getEntityName();
                    curEntityAlias = joinEntity.getAlias();
                    fieldPrefix = firstField;
                    String realFieldAlias = queryFieldAlias.replaceFirst(firstField + ".", "");
                    curFieldAlias = QueryKSqlUtil.convertFieldAlias((String)joinEntity.getEntityName(), (String)firstField, (String)realFieldAlias);
                } else {
                    curEntityNum = queryEntityInfo.getEditEntityNum();
                    curEntityAlias = queryEntityInfo.getEditEntityNum();
                    curFieldAlias = QueryKSqlUtil.convertFieldAlias((String)queryEntityInfo.getEditEntityNum(), (String)"", (String)queryFieldAlias);
                    fieldPrefix = "";
                }
                selectList.append(this.genSimpleSelectList(curEntityNum, entityTableAliasMap.get(curEntityAlias), fieldPrefix, curFieldAlias, recordFieldAlias));
            }
        }
        if (HRStringUtils.isNotEmpty((String)(selectSql = selectList.toString()))) {
            selectSql = selectSql.substring(0, selectSql.lastIndexOf(","));
        }
        return selectSql;
    }

    public String getSelectListSql(QueryEntityInfo queryEntityInfo) {
        HashSet<String> recordFieldAlias = new HashSet<String>();
        StringBuilder selectList = new StringBuilder(this.getPkSelectList(queryEntityInfo, recordFieldAlias));
        selectList.append(",");
        Map<String, Map<String, String>> entityTableAliasMap = this.ksqlConfig.getTableAliasMap(queryEntityInfo.getQueryEntityNum());
        List<JoinEntity> joinEntitys = queryEntityInfo.getQueryJoinEntitys();
        Map joinEntityMap = joinEntitys.stream().collect(Collectors.toMap(JoinEntity::getAlias, Function.identity()));
        List<QuerySelectField> selectFields = queryEntityInfo.getQuerySelectFields();
        for (QuerySelectField selectField : selectFields) {
            String queryFieldAlias = selectField.getAlias();
            String[] fieldAliasArr = queryFieldAlias.split("\\.");
            String firstField = fieldAliasArr[0];
            JoinEntity joinEntity = (JoinEntity)joinEntityMap.get(firstField);
            String curEntityNum = null;
            String curEntityAlias = null;
            String curFieldAlias = null;
            String fieldPrefix = null;
            if (joinEntity != null) {
                curEntityNum = joinEntity.getEntityName();
                curEntityAlias = joinEntity.getAlias();
                fieldPrefix = firstField;
                String realFieldAlias = queryFieldAlias.replaceFirst(firstField + ".", "");
                curFieldAlias = QueryKSqlUtil.convertFieldAlias((String)joinEntity.getEntityName(), (String)firstField, (String)realFieldAlias);
            } else {
                curEntityNum = queryEntityInfo.getEditEntityNum();
                curEntityAlias = queryEntityInfo.getEditEntityNum();
                curFieldAlias = QueryKSqlUtil.convertFieldAlias((String)queryEntityInfo.getEditEntityNum(), (String)"", (String)queryFieldAlias);
                fieldPrefix = "";
            }
            try {
                selectList.append(this.genSimpleSelectList(curEntityNum, entityTableAliasMap.get(curEntityAlias), fieldPrefix, curFieldAlias, recordFieldAlias));
            }
            catch (Exception exception) {
                LOGGER.error("parse prex:{}, field :{}", (Object)fieldPrefix, (Object)curFieldAlias);
                throw exception;
            }
        }
        String selectSql = selectList.toString();
        if (HRStringUtils.isNotEmpty((String)selectSql)) {
            selectSql = selectSql.substring(0, selectSql.lastIndexOf(","));
        }
        return selectSql;
    }

    private String genSimpleSelectList(String entityName, Map<String, String> entityTableAlias, String prefix, String fieldAlias, Set<String> recordFieldAlias) {
        if (fieldAlias == null || recordFieldAlias.contains(fieldAlias)) {
            return "";
        }
        if (HRStringUtils.isNotEmpty((String)prefix)) {
            prefix = prefix + ".";
        }
        String realFieldAlias = fieldAlias.replace(prefix, "");
        String[] fieldAliasArr = realFieldAlias.split("\\.");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicProperty property = entityType.getProperty(fieldAliasArr[0]);
        recordFieldAlias.add(fieldAlias);
        String entityTableName = HREntityHelper.getTableName(entityName);
        return this.getSelectFieldSql(property, entityTableAlias, entityTableName, fieldAlias);
    }

    private String getSelectFieldSql(DynamicProperty property, Map<String, String> entityTableAlias, String entityTableName, String fieldAlias) {
        String selectFieldSql;
        if (property instanceof EntryProp) {
            return "";
        }
        String tableGroup = property.getTableGroup();
        String tableAlias = entityTableAlias.get(entityTableName);
        if (HRStringUtils.isNotEmpty((String)tableGroup)) {
            tableAlias = entityTableAlias.get(entityTableName + "_" + tableGroup);
        }
        if (property instanceof ISimpleProperty && ((ISimpleProperty)property).isEncrypt()) {
            selectFieldSql = this.composeSimpleSelectList(tableAlias, property.getAlias() + "_enp", fieldAlias);
        } else if (property instanceof MulBasedataProp) {
            String propEntityName = property.getParent().getName();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)propEntityName);
            String primaryKey = entityType.getPrimaryKey().getName();
            String selectField = entityType.getProperty(primaryKey).getAlias();
            selectFieldSql = this.composeSimpleSelectList(tableAlias, selectField, fieldAlias);
        } else {
            selectFieldSql = this.composeSimpleSelectList(tableAlias, property.getAlias(), fieldAlias);
        }
        return selectFieldSql;
    }

    private String composeMuliLangSelectList(String mainTabelAlias, String muliLangTableAlias, String selectField, String fieldAlias) {
        return " CASE WHEN " + muliLangTableAlias + "." + selectField + " IS NULL THEN " + mainTabelAlias + "." + selectField + " WHEN " + muliLangTableAlias + "." + selectField + " = '' THEN " + mainTabelAlias + "." + selectField + " WHEN " + muliLangTableAlias + "." + selectField + " = ' ' THEN " + mainTabelAlias + "." + selectField + " ELSE " + muliLangTableAlias + "." + selectField + " END " + fieldAlias.replace(".", "$") + "$" + ",";
    }

    private String composeSimpleSelectList(String tableAlias, String selectField, String fieldAlias) {
        if (HRStringUtils.isEmpty((String)selectField)) {
            return " ''  as " + fieldAlias.replace(".", "$") + "$" + ",";
        }
        return tableAlias + "." + selectField + " as " + fieldAlias.replace(".", "$") + "$" + ",";
    }
}

