/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.query.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ILocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.config.ORMConfig;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.hbp.business.service.query.util.QFilterUtilHR;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.query.vo.NestedBasicDataPropertyVO;

@ExcludeFromJacocoGeneratedReport
public class QFilterESTransFunction
implements Function<QFilter, QFilter> {
    private static Log logger = LogFactory.getLog(QFilterESTransFunction.class);
    private QueryEntityType queryEntity;

    public QFilterESTransFunction(QueryEntityType queryEntity) {
        this.queryEntity = queryEntity;
    }

    @Override
    public QFilter apply(QFilter filter) {
        NestedBasicDataPropertyVO vo;
        if ("ftlike".equals(filter.getCP())) {
            filter.__setCP("like");
        }
        if (filter.toString().equalsIgnoreCase("1 != 1")) {
            return filter;
        }
        filter = QFilterUtilHR.changeBasicDataToSubEntityFilterEx(QFilterUtilHR.convertPermQFilterEx(filter, this.queryEntity), this.queryEntity);
        String entityName = null;
        Boolean isMainEntity = false;
        entityName = QFilterUtilHR.getSubEntityName(filter.getProperty(), this.queryEntity);
        if (entityName == null) {
            entityName = this.queryEntity.getEntityName();
            isMainEntity = true;
        }
        if ((vo = QFilterUtilHR.changeSecondLvBDToFirstLvBDByFilterEx(filter.getProperty(), filter, this.queryEntity)) == null) {
            vo = this.getNestedBasicDataPropertyVO(filter, entityName, isMainEntity);
        }
        try {
            this.processSpecialFilter(vo.filter, vo.dataEntityProperty);
        }
        catch (Exception er) {
            logger.error((Throwable)er);
        }
        return vo.filter;
    }

    private NestedBasicDataPropertyVO getNestedBasicDataPropertyVO(QFilter filter, String entityName, Boolean isMainEntity) {
        MainEntityType dataEntityType;
        NestedBasicDataPropertyVO vo = new NestedBasicDataPropertyVO();
        vo.mainEntityType = dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        String propertyname = null;
        String[] nameKeys = filter.getProperty().split("\\.");
        if (isMainEntity.booleanValue()) {
            String mainEntityName = this.queryEntity.getEntityName();
            propertyname = nameKeys[0].equalsIgnoreCase(mainEntityName) ? nameKeys[1] : nameKeys[0];
        } else if (nameKeys.length < 2 && filter.getCP().equals("=") && filter.getValue() instanceof QEmptyValue) {
            propertyname = "id";
            filter.__setProperty(filter.getProperty() + ".id");
        } else {
            propertyname = nameKeys[1];
        }
        DynamicProperty dynamicProperty = dataEntityType.getProperty(propertyname);
        if (dynamicProperty == null) {
            throw new KDBizException(this.queryEntity.getName() + " not exists property:" + propertyname);
        }
        if (dynamicProperty instanceof ILocaleProperty) {
            String langStr = RequestContext.get().getLang().name();
            filter.__setProperty(filter.getProperty() + "_l." + langStr);
        } else if (dynamicProperty instanceof BooleanProp) {
            List values = (List)filter.getValue();
            ArrayList<Boolean> bolVals = new ArrayList<Boolean>(values.size());
            for (String val : values) {
                bolVals.add(val.equals("1"));
            }
            filter.__setValue(bolVals);
        }
        vo.setFilter(filter);
        if (ORMConfig.PRIVACY_ENABLE.getBoolean() && PrivacyCenterServiceHelper.isEncryptField((IDataEntityProperty)dynamicProperty)) {
            QFilterUtilHR.handlePrivacyProperty(dynamicProperty, filter, this.queryEntity, propertyname);
            return this.getNestedBasicDataPropertyVO(filter, entityName, isMainEntity);
        }
        vo.dataEntityProperty = dynamicProperty;
        vo.filter = filter;
        return vo;
    }

    private void processSpecialFilter(QFilter filter, IDataEntityProperty property) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Collection cl;
        if (filter.getCP().equalsIgnoreCase("not exists") && filter.getValue().toString().equalsIgnoreCase("1 = 1")) {
            filter.__setCP("=");
            filter.__setValue((Object)0L);
            return;
        }
        String[] nameKeys = filter.getProperty().split("\\.");
        if (nameKeys[nameKeys.length - 1].equalsIgnoreCase("id")) {
            if (null != filter.getValue() && filter.getValue() instanceof QEmptyValue) {
                if (property instanceof BasedataProp) {
                    IDataEntityProperty refIdProp = ((BasedataProp)property).getRefIdProp();
                    if (refIdProp instanceof LongProp) {
                        QFilterESTransFunction.resetFilter(filter, QFilterUtilHR.hrEmptyDecimal);
                    } else if (refIdProp instanceof VarcharProp) {
                        QFilterESTransFunction.resetFilter(filter, QFilterUtilHR.hrEmptyText);
                    } else {
                        filter.__setCP("is null");
                    }
                } else {
                    filter.__setCP("is null");
                }
            }
        } else if (filter.getCP().equals("=") && filter.getValue() instanceof QEmptyValue) {
            if (property instanceof DecimalProp) {
                QFilterESTransFunction.resetFilter(filter, QFilterUtilHR.hrEmptyDecimal);
            } else if (property instanceof TextProp) {
                QFilterESTransFunction.resetFilter(filter, QFilterUtilHR.hrEmptyFieldText);
            } else {
                filter.__setCP("is null");
            }
        }
        if (filter.getCP().equalsIgnoreCase("in") && filter.getValue() == null) {
            filter.__setCP("is null");
        }
        if (filter.getValue() != null && filter.getValue() instanceof Collection && (cl = (Collection)filter.getValue()).isEmpty()) {
            filter.__setCP("is null");
        }
    }

    public static void resetFilter(QFilter filter, String cp) throws NoSuchFieldException, IllegalAccessException {
        Field field = filter.getClass().getDeclaredField("cp");
        field.setAccessible(true);
        field.set(filter, cp);
    }
}

