/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.query.util;

import com.google.common.collect.Sets;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DBRoute;
import kd.bos.db.pktemptable.PKTempTable;
import kd.bos.db.pktemptable.PKTempTables;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QParameter;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.orm.sequence.DBType;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.xdb.XDBConfig;
import kd.hr.hbp.business.service.complexobj.util.DBConfigUtil;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.query.model.mulbasedata.HRMulBaseDataQueryInfo;
import kd.hr.hbp.business.service.query.util.HRMulBaseDataQuery;
import kd.hr.hbp.business.service.query.util.HRMulBaseDataQueryFilterInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.query.vo.NestedBasicDataPropertyVO;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.QueryEntityUtil;

public class QFilterUtilHR {
    private static final Log LOGGER = LogFactory.getLog(QFilterUtilHR.class);
    private static final Set<Class<?>> numberClsSet = new HashSet();
    public static String hrEmptyDecimal = "hrEmptyDecimal";
    public static String hrEmptyText = "hrEmptyText";
    public static String hrEmptyFieldText = "hrEmptyFieldText";
    public static String hrEmptyOther = "hrEmptyOther";

    private static boolean isNumber(Class<?> cls) {
        return numberClsSet.contains(cls);
    }

    private static String toSqlValueString(Object value) {
        String v = String.valueOf(value);
        return v.replaceAll("'", "''");
    }

    public static String parametertoString(Object value) {
        QParameter p = QFilterUtilHR.getInQParameter(value);
        if (p == null) {
            return "";
        }
        Object[] params = p.getParameters();
        StringBuilder s = new StringBuilder(params.length * 10);
        for (Object param : params) {
            if (s.length() > 0) {
                s.append(',');
            }
            if (param == null) {
                if (XDBConfig.get().isSpaceAsEmptyString()) {
                    s.append("' '");
                    continue;
                }
                s.append("''");
                continue;
            }
            Class<?> cls = param.getClass();
            if (QFilterUtilHR.isNumber(cls) || cls == Boolean.class) {
                s.append(param);
                continue;
            }
            if (Date.class.isAssignableFrom(cls)) {
                Date date = (Date)param;
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String dateString = format.format(date);
                s.append("{ts").append('\'').append(dateString).append('\'').append("}");
                continue;
            }
            if (cls.isArray()) {
                int n = Array.getLength(param);
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        s.append(',');
                    }
                    s.append(QFilterUtilHR.parametertoString(Array.get(param, i)));
                }
                continue;
            }
            if (XDBConfig.get().isSpaceAsEmptyString() && HRStringUtils.isEmpty((String)String.valueOf(value))) {
                s.append("' '");
                continue;
            }
            s.append('\'').append(QFilterUtilHR.toSqlValueString(param)).append('\'');
        }
        return s.toString();
    }

    static QParameter getInQParameter(Object value) {
        if (value == null) {
            return null;
        }
        Object[] params = QFilterUtilHR.getWithoutDuplicateInValues(value);
        int c = params.length;
        if (c > 0) {
            String sql = QFilterUtilHR.multiParamsSQL(c);
            return new QParameter(sql, params);
        }
        return null;
    }

    static String multiParamsSQL(int c) {
        StringBuilder s = new StringBuilder(c * 2);
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                s.append(',');
            }
            s.append('?');
        }
        return s.toString();
    }

    public static Object[] getWithoutDuplicateInValues(Object values) {
        if (values == null) {
            return null;
        }
        Object[] params = null;
        if (values.getClass().isArray()) {
            int c = Array.getLength(values);
            HashSet<Object> set = new HashSet<Object>(c);
            for (int i = 0; i < c; ++i) {
                set.add(Array.get(values, i));
            }
            c = set.size();
            HugeInConfig.limitInSize((int)c);
            params = set.toArray(new Object[c]);
        } else if (values instanceof Set) {
            params = ((Set)values).toArray(new Object[((Set)values).size()]);
        } else if (values instanceof Collection) {
            HashSet set = new HashSet((Collection)values);
            int c = set.size();
            HugeInConfig.limitInSize((int)c);
            params = set.toArray(new Object[c]);
        } else if (values instanceof Iterable) {
            HashSet set = new HashSet(16);
            for (Object item : (Iterable)values) {
                set.add(item);
            }
            int c = set.size();
            HugeInConfig.limitInSize((int)c);
            params = set.toArray(new Object[c]);
        } else {
            params = new Object[]{values};
        }
        return params;
    }

    public static int getCharacterPosition(String string, int times) {
        Matcher slashMatcher = Pattern.compile(" ").matcher(string);
        int mIdx = 0;
        while (slashMatcher.find() && ++mIdx != times) {
        }
        return slashMatcher.start();
    }

    public static String createTmpTableAndSQL(DBRoute dbRoute, Object[] params, Map<String, PKTempTable> tmpTableMap) {
        return QFilterUtilHR.createTmpTableAndSQL(dbRoute, params, tmpTableMap, false);
    }

    @ExcludeFromJacocoGeneratedReport
    public static String createTmpTableAndSQL(DBRoute dbRoute, Object[] params, Map<String, PKTempTable> tmpTableMap, boolean transDate) {
        PKTempTable tempTable;
        if (params[0] instanceof String) {
            tempTable = PKTempTables.createPKBigString((DBRoute)dbRoute);
            tempTable.insert(Arrays.asList(params));
        } else {
            tempTable = PKTempTables.createPKLong((DBRoute)dbRoute);
            tempTable.insert(Arrays.asList(params));
        }
        String inSQL = " (SELECT FID FROM " + tempTable.getName() + ") ";
        if (transDate) {
            inSQL = " (SELECT CONVERT(DATETIME, FID) FROM " + tempTable.getName() + ") ";
        }
        tmpTableMap.put(tempTable.getName(), tempTable);
        return inSQL;
    }

    @ExcludeFromJacocoGeneratedReport
    public static QFilter changeBasicDataToSubEntityFilterEx(QFilter qFilter, QueryEntityType queryEntity) {
        String fullPropertyName = qFilter.getProperty();
        String subEntityName = QFilterUtilHR.getSubEntityNameByBasicData(fullPropertyName, queryEntity);
        if (subEntityName != null) {
            String[] nameKeys = fullPropertyName.split("\\.");
            if (QFilterUtilHR.isMainEntityPropery(fullPropertyName, queryEntity).booleanValue()) {
                if (nameKeys.length == 2) {
                    String basicDataName = nameKeys[0];
                    String newPropertyName = fullPropertyName.replace(basicDataName, subEntityName);
                    qFilter.__setProperty(newPropertyName);
                }
            } else if (nameKeys.length == 3) {
                String attributeString = fullPropertyName.substring(fullPropertyName.lastIndexOf(46) + 1);
                StringBuilder newPropertyNameBuilder = new StringBuilder();
                newPropertyNameBuilder.append(subEntityName).append('.').append(attributeString);
                String newPropertyName = newPropertyNameBuilder.toString();
                qFilter.__setProperty(newPropertyName);
            }
        }
        return qFilter;
    }

    @ExcludeFromJacocoGeneratedReport
    public static String getSubEntityNameBySameBasicData(String entityName, String basicDataName, QueryEntityType queryEntity) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicProperty dynamicProperty = dataEntityType.getProperty(basicDataName);
        if (dynamicProperty instanceof DynamicComplexProperty) {
            DynamicComplexProperty dynamicComplexProperty = (DynamicComplexProperty)dynamicProperty;
            MainEntityType subEntityType = (MainEntityType)((DynamicComplexProperty)dynamicProperty).getComplexType();
            BasedataProp firstdataProp1 = (BasedataProp)dynamicComplexProperty;
            String basicDataEntityName = firstdataProp1.getBaseEntityId();
            for (JoinEntity joinEntity : queryEntity.getJoinEntitys()) {
                if (!basicDataEntityName.equalsIgnoreCase(joinEntity.getEntityName())) continue;
                return basicDataEntityName;
            }
        }
        return null;
    }

    public static String getSubEntityNameByBasicData(String fullPropertyName, QueryEntityType queryEntity) {
        if (QFilterUtilHR.getSubEntityName(fullPropertyName, queryEntity) != null) {
            String[] nameKeys = fullPropertyName.split("\\.");
            if (nameKeys.length != 3) {
                return null;
            }
            String entityAlias = nameKeys[0];
            String relEntityNumber = QueryEntityUtil.getEntityNameByAlias((String)entityAlias, (QueryEntityType)queryEntity);
            return QFilterUtilHR.getSubEntityNameBySameBasicData(relEntityNumber, nameKeys[1], queryEntity);
        }
        String[] nameKeys = fullPropertyName.split("\\.");
        if (nameKeys.length != 2) {
            return null;
        }
        return QFilterUtilHR.getSubEntityNameBySameBasicData(queryEntity.getEntityName(), nameKeys[0], queryEntity);
    }

    public static String getSubEntityName(String fullPropertyName, QueryEntity queryEntity) {
        String[] nameKeys = fullPropertyName.split("\\.");
        String subEntityName = fullPropertyName;
        if (nameKeys.length > 0) {
            subEntityName = nameKeys[0];
        }
        for (JoinEntity joinEntity : queryEntity.getJoinEntitys()) {
            if (!subEntityName.equalsIgnoreCase(joinEntity.getAlias())) continue;
            return joinEntity.getEntityName();
        }
        return null;
    }

    public static String getSubEntityName(String fullPropertyName, QueryEntityType queryEntityType) {
        String[] nameKeys = fullPropertyName.split("\\.");
        String subEntityName = fullPropertyName;
        if (nameKeys.length > 0) {
            subEntityName = nameKeys[0];
        }
        for (JoinEntity joinEntity : queryEntityType.getJoinEntitys()) {
            if (!subEntityName.equalsIgnoreCase(joinEntity.getAlias())) continue;
            return joinEntity.getEntityName();
        }
        return null;
    }

    public static Boolean isMainEntityPropery(String fullPropertyName, QueryEntityType queryEntity) {
        String subEntityName = QFilterUtilHR.getSubEntityName(fullPropertyName, queryEntity);
        if (subEntityName != null) {
            return false;
        }
        return true;
    }

    public static NestedBasicDataPropertyVO changeSecondLvBDToFirstLvBDByFilterEx(String fullPropertyName, QFilter filter, QueryEntityType queryEntity) {
        if (QFilterUtilHR.isNestedBasicData(fullPropertyName, queryEntity).booleanValue()) {
            if (QFilterUtilHR.getSubEntityName(fullPropertyName, queryEntity) != null) {
                String[] nameKeys = fullPropertyName.split("\\.");
                if (QFilterUtilHR.isMultiSelectBaseDataMoreThanTwoLevelOfRelatedEntity(nameKeys)) {
                    NestedBasicDataPropertyVO nestedBasicDataPropertyVO = QFilterUtilHR.changeRelateEntityFirstLvBDFromThirdLvBDEx(filter, queryEntity);
                    return nestedBasicDataPropertyVO;
                }
                String relEntityNumber = QueryEntityUtil.getEntityNameByAlias((String)nameKeys[0], (QueryEntityType)queryEntity);
                return QFilterUtilHR.changeFirstLvBDFromSecondLvBDEx(nameKeys[1], nameKeys[2], relEntityNumber, nameKeys[0], filter, queryEntity);
            }
            String[] nameKeys = fullPropertyName.split("\\.");
            if (QFilterUtilHR.isMultiSelectBaseDataMoreThanTwoLevelOfMainEntity(fullPropertyName, nameKeys)) {
                NestedBasicDataPropertyVO nestedBasicDataPropertyVO = QFilterUtilHR.changeMainFirstLvBDFromThirdLvBDEx(filter, queryEntity);
                return nestedBasicDataPropertyVO;
            }
            String firstBDName = null;
            String secondBDName = null;
            String mainEntityName = queryEntity.getEntityName();
            if (nameKeys[0].equalsIgnoreCase(mainEntityName)) {
                firstBDName = nameKeys[1];
                secondBDName = nameKeys[2];
            } else {
                firstBDName = nameKeys[0];
                secondBDName = nameKeys[1];
            }
            return QFilterUtilHR.changeFirstLvBDFromSecondLvBDEx(firstBDName, secondBDName, queryEntity.getEntityName(), queryEntity.getEntityName(), filter, queryEntity);
        }
        if (QFilterUtilHR.isNormaldBasicData(fullPropertyName, queryEntity).booleanValue()) {
            if (QFilterUtilHR.getSubEntityName(fullPropertyName, queryEntity) != null) {
                String[] nameKeys = fullPropertyName.split("\\.");
                String relEntityNumber = QueryEntityUtil.getEntityNameByAlias((String)nameKeys[0], (QueryEntityType)queryEntity);
                return QFilterUtilHR.changeNoramlBDEx(nameKeys[1], relEntityNumber, nameKeys[0], filter, queryEntity);
            }
            String[] nameKeys = fullPropertyName.split("\\.");
            String basicDataName = null;
            String mainEntityName = queryEntity.getEntityName();
            basicDataName = nameKeys[0].equalsIgnoreCase(mainEntityName) ? nameKeys[1] : nameKeys[0];
            return QFilterUtilHR.changeNoramlBDEx(basicDataName, queryEntity.getEntityName(), queryEntity.getEntityName(), filter, queryEntity);
        }
        return null;
    }

    public static Boolean isNormaldBasicData(String fullPropertyName, QueryEntityType queryEntity) {
        if (QFilterUtilHR.isMainEntityPropery(fullPropertyName, queryEntity).booleanValue()) {
            String[] nameKeys = fullPropertyName.split("\\.");
            String mainEntityName = queryEntity.getEntityName();
            int nLevel = 2;
            if (nameKeys[0].equalsIgnoreCase(mainEntityName)) {
                nLevel = 3;
            }
            if (nameKeys.length == nLevel) {
                return true;
            }
            return false;
        }
        if (QFilterUtilHR.getSubEntityName(fullPropertyName, queryEntity) != null) {
            String[] nameKeys = fullPropertyName.split("\\.");
            if (nameKeys.length == 3) {
                return true;
            }
            return false;
        }
        return false;
    }

    public static Boolean isNestedBasicData(String fullPropertyName, QueryEntityType queryEntity) {
        if (QFilterUtilHR.isMainEntityPropery(fullPropertyName, queryEntity).booleanValue()) {
            String[] nameKeys = fullPropertyName.split("\\.");
            String mainEntityName = queryEntity.getEntityName();
            int nLevel = 3;
            if (nameKeys[0].equalsIgnoreCase(mainEntityName)) {
                nLevel = 4;
            }
            if (nameKeys.length == nLevel || nameKeys.length > nLevel && QFilterUtilHR.isMultiBaseDataPropName(fullPropertyName)) {
                return true;
            }
            return false;
        }
        if (QFilterUtilHR.getSubEntityName(fullPropertyName, queryEntity) != null) {
            String[] nameKeys = fullPropertyName.split("\\.");
            if (nameKeys.length == 4 || nameKeys.length == 5) {
                return true;
            }
            return false;
        }
        return false;
    }

    public static NestedBasicDataPropertyVO changeFirstLvBDFromSecondLvBDEx(String firstBDName, String secondBDName, String entityName, String entityAlias, QFilter filter, QueryEntityType queryEntity) {
        String fullPropertyName = filter.getProperty();
        NestedBasicDataPropertyVO netstedBDVo = QFilterUtilHR.convertNestedBasicDataName(firstBDName, secondBDName, entityName);
        String attributeName = fullPropertyName.substring(fullPropertyName.lastIndexOf(46) + 1);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(netstedBDVo.secondBDEntityName);
        QFilter qFilter = new QFilter(attributeName, filter.getCP(), filter.getValue());
        HashSet secondIDSets = Sets.newHashSetWithExpectedSize((int)16);
        QFilter filterNew = null;
        if ("fbasedataid".equals(secondBDName)) {
            if ("not in".equals(qFilter.getCP())) {
                QFilter inQFilter = new QFilter(qFilter.getProperty(), "in", qFilter.getValue());
                Iterator dataSet = serviceHelper.queryDataSet("HRMultiQuery_queryMulData", "id", new QFilter[]{inQFilter});
                Iterator iterator = dataSet.iterator();
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    secondIDSets.add(row.getLong("id"));
                }
                filterNew = QFilterUtilHR.getMulBaseDataIdFilter(firstBDName, entityAlias, qFilter, queryEntity, secondIDSets);
                dataSet.close();
            } else {
                DataSet dataSet = serviceHelper.queryDataSet("HRMultiQuery_queryMulData", "id", new QFilter[]{qFilter});
                for (Row row : dataSet) {
                    secondIDSets.add(row.getLong("id"));
                }
                filterNew = QFilterUtilHR.getMulBaseDataIdFilter(firstBDName, entityAlias, qFilter, queryEntity, secondIDSets);
                dataSet.close();
            }
        } else {
            DynamicObjectCollection baseDataList = serviceHelper.queryOriginalCollection("id", new QFilter[]{qFilter});
            for (DynamicObject row : baseDataList) {
                secondIDSets.add(row.getLong("id"));
            }
            filterNew = QFilterUtilHR.changeFirstLvBDFromSecondLvBDSub(firstBDName, secondBDName, entityAlias, secondIDSets, netstedBDVo.firstBDEntityName, netstedBDVo.secondBDEntityName, queryEntity);
        }
        netstedBDVo.filter = filterNew;
        if (filterNew != null) {
            MainEntityType dataEntityType;
            netstedBDVo.mainEntityType = dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            DynamicProperty dynamicProperty = dataEntityType.getProperty(firstBDName);
            netstedBDVo.dataEntityProperty = dynamicProperty;
        }
        return netstedBDVo;
    }

    public static NestedBasicDataPropertyVO convertNestedBasicDataName(String firstBDName, String secondBDName, String entityName) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicProperty dynamicProperty = dataEntityType.getProperty(firstBDName);
        NestedBasicDataPropertyVO vo = new NestedBasicDataPropertyVO();
        if (dynamicProperty instanceof DynamicComplexProperty) {
            String firstBDEntityName;
            DynamicComplexProperty dynamicComplexProperty = (DynamicComplexProperty)dynamicProperty;
            MainEntityType subEntityType = (MainEntityType)((DynamicComplexProperty)dynamicProperty).getComplexType();
            BasedataProp firstdataProp1 = (BasedataProp)dynamicComplexProperty;
            vo.firstBDEntityName = firstBDEntityName = firstdataProp1.getBaseEntityId();
            DynamicProperty dynamicProperty2 = subEntityType.getProperty(secondBDName);
            if (dynamicProperty2 instanceof DynamicComplexProperty) {
                String secondBDEntityName;
                DynamicComplexProperty dynamicComplexProperty2 = (DynamicComplexProperty)dynamicProperty2;
                BasedataProp basedataProp2 = (BasedataProp)dynamicComplexProperty2;
                vo.secondBDEntityName = secondBDEntityName = basedataProp2.getBaseEntityId();
            } else if (dynamicProperty2 instanceof MulBasedataProp) {
                MulBasedataProp mulBasedataProp = (MulBasedataProp)dynamicProperty2;
                DynamicObjectType entityType = mulBasedataProp.getDynamicCollectionItemPropertyType();
                vo.firstBDEntityName = entityType.getName();
                vo.secondBDEntityName = mulBasedataProp.getBaseEntityId();
            }
        } else if (dynamicProperty instanceof MulBasedataProp) {
            MulBasedataProp mulBasedataProp = (MulBasedataProp)dynamicProperty;
            DynamicObjectType entityType = mulBasedataProp.getDynamicCollectionItemPropertyType();
            vo.firstBDEntityName = entityType.getName();
            vo.secondBDEntityName = mulBasedataProp.getBaseEntityId();
        }
        vo.entityName = entityName;
        vo.firstBDName = firstBDName;
        vo.secondBDName = secondBDName;
        return vo;
    }

    @ExcludeFromJacocoGeneratedReport
    public static QFilter changeFirstLvBDFromSecondLvBDSub(String firstBDName, String secondBDName, String entityAlias, Set<Long> secondIDSets, String firstBDEntityName, String secondBDEntityName, QueryEntityType queryEntity) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(firstBDEntityName);
        QFilter qFilter = new QFilter(secondBDName, "in", secondIDSets);
        HashSet firstIDSets = Sets.newHashSetWithExpectedSize((int)16);
        DynamicObjectCollection baseDataList = serviceHelper.queryOriginalCollection("id", new QFilter[]{qFilter});
        for (DynamicObject row : baseDataList) {
            firstIDSets.add(row.getLong("id"));
        }
        StringBuilder fullFilterName = new StringBuilder();
        if (QFilterUtilHR.getSubEntityName(entityAlias, queryEntity) != null) {
            fullFilterName.append(entityAlias).append(".");
        }
        fullFilterName.append(firstBDName).append(".id");
        QFilter firstBDFilter = null;
        firstBDFilter = firstIDSets.size() > 0 ? new QFilter(fullFilterName.toString(), "in", (Object)firstIDSets) : new QFilter(fullFilterName.toString(), "=", (Object)-9999L);
        return firstBDFilter;
    }

    public static NestedBasicDataPropertyVO changeNoramlBDEx(String BasicDataName, String entityName, String entityAlias, QFilter filter, QueryEntityType queryEntity) {
        String fullPropertyName = filter.getProperty();
        NestedBasicDataPropertyVO vo = null;
        String attributeName = fullPropertyName.substring(fullPropertyName.lastIndexOf(46) + 1);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicProperty dynamicProperty = dataEntityType.getProperty(BasicDataName);
        if (dynamicProperty instanceof DynamicComplexProperty) {
            vo = new NestedBasicDataPropertyVO();
            if (attributeName.equalsIgnoreCase("id")) {
                vo.filter = filter;
                vo.mainEntityType = dataEntityType;
                vo.dataEntityProperty = dynamicProperty;
                return vo;
            }
            BasedataProp firstdataProp = (BasedataProp)dynamicProperty;
            String BasicDataEntityName = firstdataProp.getBaseEntityId();
            QFilter qFilter = new QFilter(attributeName, filter.getCP(), filter.getValue());
            HashSet basicDataIDSets = Sets.newHashSetWithExpectedSize((int)16);
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(BasicDataEntityName);
            DynamicObjectCollection baseDataList = serviceHelper.queryOriginalCollection("id", new QFilter[]{qFilter});
            for (DynamicObject row : baseDataList) {
                basicDataIDSets.add(row.getLong("id"));
            }
            if (filter.getCP().equalsIgnoreCase("<>")) {
                basicDataIDSets.add(0L);
            }
            StringBuilder fullFilterName = new StringBuilder();
            if (QFilterUtilHR.getSubEntityName(entityAlias, queryEntity) != null) {
                fullFilterName.append(entityAlias).append(".");
            }
            fullFilterName.append(BasicDataName).append(".id");
            QFilter firstBDFilter = null;
            if (basicDataIDSets.size() > 0) {
                firstBDFilter = new QFilter(fullFilterName.toString(), "in", (Object)basicDataIDSets);
            } else {
                Long value = -1L;
                if (filter.getCP().equalsIgnoreCase("is null")) {
                    value = 0L;
                }
                firstBDFilter = new QFilter(fullFilterName.toString(), "=", (Object)value);
            }
            vo.filter = firstBDFilter;
            vo.mainEntityType = dataEntityType;
            vo.dataEntityProperty = dynamicProperty;
        }
        return vo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QFilter convertPermQFilterEx(QFilter filter, QueryEntityType queryEntity) {
        Boolean bSubEntity = true;
        String entityName = QFilterUtilHR.getSubEntityName(filter.getProperty(), queryEntity);
        if (entityName == null) {
            entityName = queryEntity.getEntityName();
            bSubEntity = false;
        }
        String propertyName = filter.getProperty();
        String[] nameKeys = propertyName.split("\\.");
        String attributeName = null;
        if (bSubEntity.booleanValue()) {
            if (nameKeys.length == 1) {
                filter.__setProperty(propertyName + ".id");
            } else {
                if (nameKeys.length != 2) return filter;
                attributeName = nameKeys[1];
            }
        } else {
            if (nameKeys.length != 1) return filter;
            attributeName = nameKeys[0];
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicProperty dynamicProperty = dataEntityType.getProperty(attributeName);
        if (!(dynamicProperty instanceof DynamicComplexProperty)) return filter;
        StringBuilder builder = new StringBuilder();
        builder.append(propertyName).append(".id");
        filter.__setProperty(builder.toString());
        return filter;
    }

    public static QFilter[] rebuidFlikeQFilterEx(Map<Integer, List<QFilter>> unionFiltersMap, QFilter[] qFilters, Boolean isFullUnion, QueryEntityType queryEntity, String searchType) {
        unionFiltersMap.clear();
        ArrayList<QFilter> flikeFilters = new ArrayList<QFilter>();
        for (int i = 0; i < qFilters.length; ++i) {
            QFilter filter = qFilters[i];
            if (filter == null || !"ftlike".equals(filter.getCP())) continue;
            if (!filter.getProperty().equals("1") && !filter.getProperty().equals("2")) {
                QFilter qf = new QFilter(filter.getProperty(), "like", filter.getValue());
                flikeFilters.add(qf);
                qFilters[i] = null;
                List nests = filter.getNests(false);
                for (QFilter.QFilterNest nest : nests) {
                    QFilter nestFilter = nest.getFilter();
                    QFilter[] filterEx = QFilterUtilHR.rebuidFlikeQFilterEx(unionFiltersMap, nestFilter.toArray(), isFullUnion, queryEntity);
                    flikeFilters.addAll(Arrays.asList(filterEx));
                }
                continue;
            }
            String values = filter.getOriginValue().toString();
            int valSplitIdx = values.indexOf("#");
            if (valSplitIdx < 0) continue;
            String properties = values.substring(0, valSplitIdx);
            String[] propertyArray = properties.split(",");
            values = values.substring(valSplitIdx + 1);
            String[] valueArray = values.split("\b");
            QFilter parentFilter = null;
            for (String property : propertyArray) {
                QFilter subFilter = null;
                for (String value : valueArray) {
                    QFilter qf = QFilterUtilHR.getLikeQFilter(queryEntity, searchType, property, value);
                    subFilter = subFilter == null ? qf.copy() : subFilter.or(qf);
                    List<QFilter> filterList = unionFiltersMap.get(i);
                    if (filterList == null) {
                        filterList = new ArrayList<QFilter>();
                        unionFiltersMap.put(i, filterList);
                    }
                    Boolean bMerge = false;
                    bMerge = isFullUnion != false ? Boolean.valueOf(false) : QFilterUtilHR.mergeQFilter(filterList, qf, queryEntity);
                    if (bMerge.booleanValue()) continue;
                    filterList.add(qf);
                }
                if (subFilter == null) continue;
                parentFilter = parentFilter == null ? subFilter.copy() : parentFilter.or(subFilter);
            }
            flikeFilters.add(parentFilter);
            qFilters[i] = null;
        }
        return flikeFilters.toArray(new QFilter[flikeFilters.size()]);
    }

    public static QFilter[] rebuidFlikeQFilterEx(Map<Integer, List<QFilter>> unionFiltersMap, QFilter[] qFilters, Boolean isFullUnion, QueryEntityType queryEntity) {
        return QFilterUtilHR.rebuidFlikeQFilterEx(unionFiltersMap, qFilters, isFullUnion, queryEntity, "1");
    }

    @ExcludeFromJacocoGeneratedReport
    public static Boolean mergeQFilter(List<QFilter> filterList, QFilter qf, QueryEntityType queryEntity) {
        Boolean bMerge = false;
        for (QFilter unionFilter : filterList) {
            String[] nameKeys2;
            if (QFilterUtilHR.isMainEntityPropery(unionFilter.getProperty(), queryEntity).booleanValue() && QFilterUtilHR.isMainEntityPropery(qf.getProperty(), queryEntity).booleanValue()) {
                unionFilter.or(qf);
                bMerge = true;
                break;
            }
            String[] nameKeys1 = unionFilter.getProperty().split("\\.");
            if (!nameKeys1[0].equalsIgnoreCase((nameKeys2 = qf.getProperty().split("\\."))[0])) continue;
            unionFilter.or(qf);
            bMerge = true;
            break;
        }
        return bMerge;
    }

    public static String toQFilterString(QFilter filter, boolean recursive, boolean bTmpTable, Map<String, PKTempTable> tmpTableMap, DBRoute route, int tmpTableThresh) {
        StringBuilder s = new StringBuilder(128);
        String property = filter.getProperty();
        Object value = filter.getValue();
        String cp = filter.getCP();
        List nests = filter.getNests(false);
        if (cp.equalsIgnoreCase(hrEmptyDecimal)) {
            s.append("(");
            s.append(property).append(' ').append("is null").append(" or ").append(property).append(' ').append("= 0");
            s.append(")");
        } else if (cp.equalsIgnoreCase(hrEmptyText)) {
            s.append("(");
            s.append(property).append(' ').append("is null").append(" or ").append(property).append(' ').append("=' '");
            if (!XDBConfig.get().isSpaceAsEmptyString()) {
                s.append(" or ").append(property).append(' ').append("=''");
            }
            s.append(")");
        } else if (cp.equalsIgnoreCase("is null") || cp.equalsIgnoreCase("is not null")) {
            s.append(property).append(' ').append(cp);
        } else if (cp.equalsIgnoreCase("in") || cp.equalsIgnoreCase("not in")) {
            s.append(property).append(' ').append(cp);
            if (value instanceof HRMulBaseDataQueryFilterInfo) {
                HRMulBaseDataQueryFilterInfo hrMulBaseDataQueryFilterInfo = (HRMulBaseDataQueryFilterInfo)value;
                Object[] params = QFilterUtilHR.getWithoutDuplicateInValues(hrMulBaseDataQueryFilterInfo.getIdList());
                String multiBaseDataFilterInSql = QFilterUtilHR.getMultiBaseDataInFilterSql(tmpTableMap, route, tmpTableThresh, hrMulBaseDataQueryFilterInfo, params);
                s.append(multiBaseDataFilterInSql);
            } else {
                Object[] params = QFilterUtilHR.getWithoutDuplicateInValues(value);
                if (params != null && bTmpTable && params.length >= tmpTableThresh && (params[0] instanceof String || params[0] instanceof Integer || params[0] instanceof Long)) {
                    String tmpTableName = QFilterUtilHR.createTmpTableAndSQL(route, params, tmpTableMap);
                    LOGGER.info("HR queryentity gen tmptable:{}", (Object)tmpTableName);
                    s.append(tmpTableName);
                } else {
                    s.append(" (").append(QFilterUtilHR.parametertoString(value)).append(')');
                }
            }
        } else {
            s.append(property).append(' ').append(cp);
            s.append(' ').append(QFilterUtilHR.parametertoString(value));
        }
        if (recursive) {
            for (QFilter.QFilterNest nest : nests) {
                s.insert(0, '(');
                if (nest.isAnd()) {
                    s.append(' ').append("and").append(' ');
                } else {
                    s.append(' ').append("or").append(' ');
                }
                s.append(QFilterUtilHR.toQFilterString(nest.getFilter(), true, bTmpTable, tmpTableMap, route, tmpTableThresh));
                s.append(')');
            }
        }
        return s.toString();
    }

    public static Boolean isIngoreCountData(int limit, QFilter[] qFilters) {
        if (limit >= 100000) {
            for (int i = 0; i < qFilters.length; ++i) {
                if (qFilters[i] == null || !qFilters[i].getProperty().equalsIgnoreCase("id") || !qFilters[i].getCP().equalsIgnoreCase("in")) continue;
                return true;
            }
        }
        return false;
    }

    @ExcludeFromJacocoGeneratedReport
    public static void handlePrivacyProperty(DynamicProperty prop, QFilter filter, QueryEntityType queryEntityType, String propertyname) {
        String property;
        int dotIndex;
        BasedataEntityType parent = (BasedataEntityType)prop.getParent();
        if (parent == null) {
            return;
        }
        String privacyEntityName = parent.getName();
        QFilter privacyQfilter = new QFilter(propertyname, filter.getCP(), filter.getValue());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(privacyEntityName);
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray("id", privacyQfilter.toArray());
        Set ids = Arrays.stream(dynamicObjects).map(dyo -> dyo.get("id")).collect(Collectors.toSet());
        boolean isMainEntity = false;
        String entityName = QFilterUtilHR.getSubEntityName(filter.getProperty(), queryEntityType);
        if (entityName == null) {
            isMainEntity = true;
        }
        String idProperty = (dotIndex = (property = filter.getProperty()).lastIndexOf(".")) == -1 ? "id" : property.substring(0, dotIndex);
        if (dotIndex >= 0 && !isMainEntity) {
            idProperty = idProperty + ".id";
        }
        filter.__setProperty(idProperty);
        if (filter.getCP().equalsIgnoreCase("=") || filter.getCP().equalsIgnoreCase("in")) {
            filter.__setCP("in");
        } else if (filter.getCP().equalsIgnoreCase("!=") || filter.getCP().equalsIgnoreCase("not in")) {
            filter.__setCP("not in");
        } else {
            filter.__setCP("in");
        }
        filter.__setValue(ids);
    }

    private static QFilter getLikeQFilter(QueryEntityType queryEntity, String searchType, String property, String value) {
        QFilter qf = "1".equals(searchType) ? (QFilterUtilHR.isPgIgnoreCase(queryEntity) ? new QFilter(property, "ilike", (Object)("%" + value + "%")) : new QFilter(property, "like", (Object)("%" + value + "%"))) : ("2".equals(searchType) ? (QFilterUtilHR.isPgIgnoreCase(queryEntity) ? new QFilter(property, "ilike", (Object)(value + "%")) : new QFilter(property, "like", (Object)(value + "%"))) : (QFilterUtilHR.isPgIgnoreCase(queryEntity) ? new QFilter(property, "ilike", (Object)("%" + value + "%")) : new QFilter(property, "like", (Object)("%" + value + "%"))));
        return qf;
    }

    private static boolean isPgIgnoreCase(QueryEntityType queryEntityType) {
        String pgIgnoreCase = SystemPropertyUtils.getProptyByTenant((String)"orm.opt.pg.ignorecase", (String)RequestContext.get().getTenantId());
        return ORMUtil.getDBType((String)queryEntityType.getDBRouteKey()) == DBType.Postgres && "true".equalsIgnoreCase(pgIgnoreCase);
    }

    private static QFilter getMulBaseDataIdFilter(String firstBDName, String entityAlias, QFilter filter, QueryEntityType queryEntity, Set<Long> secondIDSets) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityAlias);
        MulBasedataProp mulBasedataProp = (MulBasedataProp)dataEntityType.getProperty(firstBDName);
        IDataEntityType complexType = mulBasedataProp.getComplexType();
        boolean isBaseDataPkLongType = complexType.getPrimaryKey() instanceof LongProp;
        boolean isPkLongType = complexType.getPrimaryKey() instanceof LongProp;
        FilterField filterField = FilterField.create((MainEntityType)dataEntityType, (String)mulBasedataProp.getName());
        String entryPKAlias = filterField.getFieldProp().getParent().getPrimaryKey().getAlias();
        DynamicObjectType entityType = mulBasedataProp.getDynamicCollectionItemPropertyType();
        HRMulBaseDataQueryFilterInfo hrMulBaseDataQueryFilterInfo = new HRMulBaseDataQueryFilterInfo();
        if (!secondIDSets.isEmpty()) {
            ArrayList<Object> secondIdList = new ArrayList<Object>(secondIDSets);
            HRMulBaseDataQueryInfo mulBaseDataQueryInfo = new HRMulBaseDataQueryInfo(entityType.getDBRouteKey(), entityType.getAlias(), entryPKAlias, isPkLongType, secondIdList, isBaseDataPkLongType);
            hrMulBaseDataQueryFilterInfo = HRMulBaseDataQuery.getHRMulBaseBaseDataFilterInfo(mulBaseDataQueryInfo, filter);
        }
        StringBuilder fullFilterName = new StringBuilder();
        if (QFilterUtilHR.getSubEntityName(entityAlias, queryEntity) != null) {
            fullFilterName.append(entityAlias).append(".");
        }
        fullFilterName.append(dataEntityType.getPrimaryKey().getName());
        QFilter firstBDFilter = !secondIDSets.isEmpty() ? new QFilter(fullFilterName.toString(), "in", (Object)hrMulBaseDataQueryFilterInfo) : new QFilter(fullFilterName.toString(), "=", (Object)-9999L);
        return firstBDFilter;
    }

    private static String getMultiBaseDataInFilterSql(Map<String, PKTempTable> tmpTableMap, DBRoute route, int tmpTableThresh, HRMulBaseDataQueryFilterInfo hrMulBaseDataQueryFilterInfo, Object[] params) {
        StringBuilder stringBuilder = new StringBuilder();
        List<Object> idList = hrMulBaseDataQueryFilterInfo.getIdList();
        if (tmpTableMap == null) {
            tmpTableMap = new HashMap<String, PKTempTable>();
        }
        if (idList != null && idList.size() >= tmpTableThresh) {
            String tmpTableName = QFilterUtilHR.createTmpTableAndSQL(route, params, tmpTableMap);
            LOGGER.info("HR queryentity gen tmptable:{}", (Object)tmpTableName);
            String multiDataFilterSql = hrMulBaseDataQueryFilterInfo.getSelectFieldFilterSql();
            multiDataFilterSql = multiDataFilterSql.replace("$hrMultiBaseDataInTag$", tmpTableName);
            stringBuilder.append(" (").append(multiDataFilterSql).append(")");
        } else {
            String multiDataFilterSql = hrMulBaseDataQueryFilterInfo.getSelectFieldFilterSql();
            multiDataFilterSql = multiDataFilterSql.replace("$hrMultiBaseDataInTag$", QFilterUtilHR.parametertoString(idList));
            stringBuilder.append(" (").append(multiDataFilterSql).append(")");
        }
        return stringBuilder.toString();
    }

    private static NestedBasicDataPropertyVO changeRelateEntityFirstLvBDFromThirdLvBDEx(QFilter filter, QueryEntityType queryEntity) {
        String fullPropertyName = filter.getProperty();
        String[] nameKeys = fullPropertyName.split("\\.");
        String firstBDName = nameKeys[2];
        String secondBDName = nameKeys[3];
        String entityName = nameKeys[1];
        String entityAlias = nameKeys[1];
        NestedBasicDataPropertyVO nestedBDVo = QFilterUtilHR.convertNestedBasicDataName(firstBDName, secondBDName, entityName);
        String attributeName = null;
        attributeName = fullPropertyName.endsWith(".fbasedataid") ? "id" : fullPropertyName.substring(fullPropertyName.lastIndexOf(46) + 1);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(nestedBDVo.secondBDEntityName);
        QFilter qFilter = new QFilter(attributeName, filter.getCP(), filter.getValue());
        HashSet secondIDSets = Sets.newHashSetWithExpectedSize((int)16);
        QFilter filterNew = null;
        if ("not in".equals(qFilter.getCP())) {
            QFilter inQFilter = new QFilter(qFilter.getProperty(), "in", qFilter.getValue());
            Iterator dataSet = serviceHelper.queryDataSet("HRMultiQuery_queryMulData", "id", new QFilter[]{inQFilter});
            Iterator iterator = dataSet.iterator();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                secondIDSets.add(row.getLong("id"));
            }
            filterNew = QFilterUtilHR.getMulBaseDataIdFilter(firstBDName, entityAlias, qFilter, queryEntity, secondIDSets);
            dataSet.close();
        } else {
            DataSet dataSet = serviceHelper.queryDataSet("HRMultiQuery_queryMulData", "id", new QFilter[]{qFilter});
            for (Row row : dataSet) {
                secondIDSets.add(row.getLong("id"));
            }
            filterNew = QFilterUtilHR.getMulBaseDataIdFilter(firstBDName, entityAlias, qFilter, queryEntity, secondIDSets);
            dataSet.close();
        }
        if (!QFilterUtilHR.inOneLDB(nameKeys[0], nameKeys[1])) {
            HRMulBaseDataQuery.reAssembleMulBaseDataQFilter(nameKeys[1], filterNew);
        }
        nestedBDVo.filter = filterNew;
        if (filterNew != null) {
            MainEntityType dataEntityType;
            nameKeys = fullPropertyName.split("\\.");
            nestedBDVo.setEntityName(nameKeys[0]);
            nestedBDVo.setFirstBDEntityName(nameKeys[1]);
            nestedBDVo.setSecondBDEntityName(nameKeys[2]);
            nestedBDVo.mainEntityType = dataEntityType = EntityMetadataCache.getDataEntityType((String)nameKeys[0]);
            DynamicProperty dynamicProperty = dataEntityType.getProperty(nameKeys[1]);
            nestedBDVo.dataEntityProperty = dynamicProperty;
        }
        return nestedBDVo;
    }

    private static NestedBasicDataPropertyVO changeMainFirstLvBDFromThirdLvBDEx(QFilter filter, QueryEntityType queryEntity) {
        String fullPropertyName = filter.getProperty();
        String[] nameKeys = fullPropertyName.split("\\.");
        String mainEntityName = queryEntity.getEntityName();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)mainEntityName);
        DynamicProperty dynamicProperty = dataEntityType.getProperty(nameKeys[0]);
        String entityName = ((BasedataProp)dynamicProperty).getComplexType().getName();
        String firstBDName = nameKeys[1];
        String secondBDName = nameKeys[2];
        if (fullPropertyName.endsWith("fbasedataid")) {
            fullPropertyName = fullPropertyName + ".id";
            filter.__setProperty(fullPropertyName);
        }
        NestedBasicDataPropertyVO nestedBDVo = QFilterUtilHR.changeFirstLvBDFromSecondLvBDEx(firstBDName, secondBDName, entityName, entityName, filter, queryEntity);
        if (QFilterUtilHR.inOneLDB(entityName, mainEntityName)) {
            QFilter filterNew;
            nestedBDVo.filter = filterNew = HRMulBaseDataQuery.reAssembleMulBaseDataQFilter(mainEntityName, nestedBDVo.getFilter());
            if (filterNew != null) {
                nameKeys = fullPropertyName.split("\\.");
                nestedBDVo.setEntityName(mainEntityName);
                nestedBDVo.setFirstBDEntityName(nameKeys[0]);
                nestedBDVo.setSecondBDEntityName(nameKeys[1]);
                nestedBDVo.mainEntityType = dataEntityType;
                nestedBDVo.dataEntityProperty = dynamicProperty;
            }
        }
        return nestedBDVo;
    }

    public static boolean inOneLDB(String entityNumberA, String entityNumberB) {
        String dbRouteKeyB;
        DBConfigUtil dbConfigUtil = new DBConfigUtil();
        MainEntityTypeUtil mainEntityTypeUtil1 = new MainEntityTypeUtil();
        if (entityNumberA.equals(entityNumberB)) {
            return true;
        }
        String dbRouteKeyA = mainEntityTypeUtil1.getMainEntityType(entityNumberA).getDBRouteKey();
        if (dbRouteKeyA.equals(dbRouteKeyB = mainEntityTypeUtil1.getMainEntityType(entityNumberB).getDBRouteKey())) {
            return true;
        }
        String dbSchemaA = dbConfigUtil.getDBConfigSharingId(dbRouteKeyA);
        String dbSchemaB = dbConfigUtil.getDBConfigSharingId(dbRouteKeyB);
        return dbSchemaA.equals(dbSchemaB);
    }

    private static boolean isMultiSelectBaseDataMoreThanTwoLevelOfMainEntity(String fullPropertyName, String[] nameKeys) {
        return nameKeys.length >= 4 && fullPropertyName.indexOf("fbasedataid") > 0 || nameKeys.length >= 3 && fullPropertyName.endsWith("fbasedataid");
    }

    private static boolean isMultiSelectBaseDataMoreThanTwoLevelOfRelatedEntity(String[] nameKeys) {
        int multiBaseDataIndex = 0;
        for (int i = 0; i < nameKeys.length; ++i) {
            if (!"fbasedataid".equals(nameKeys[i])) continue;
            multiBaseDataIndex = i;
        }
        return multiBaseDataIndex >= 3;
    }

    private static boolean isMultiBaseDataPropName(String fullPropertyName) {
        return fullPropertyName.indexOf(".fbasedataid") > 0;
    }

    static {
        numberClsSet.add(Integer.TYPE);
        numberClsSet.add(Long.TYPE);
        numberClsSet.add(Short.TYPE);
        numberClsSet.add(Float.TYPE);
        numberClsSet.add(Double.TYPE);
        numberClsSet.add(Integer.class);
        numberClsSet.add(Long.class);
        numberClsSet.add(Short.class);
        numberClsSet.add(Float.class);
        numberClsSet.add(Double.class);
        numberClsSet.add(BigDecimal.class);
    }
}

