/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.query.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.privacy.PrivacyDataQuery;
import kd.hr.hbp.business.service.query.util.QuerySpecialFielder;
import kd.hr.hbp.business.service.query.util.QueryTableInfo;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

@ExcludeFromJacocoGeneratedReport
public class QueryPrivacyFiledLoader
extends QuerySpecialFielder {
    private static final Log LOGGER = LogFactory.getLog(QueryPrivacyFiledLoader.class);

    public QueryPrivacyFiledLoader(boolean needLoad) {
        super(needLoad);
    }

    @Override
    protected Map<String, Map<Object, Object>> getSpecialFileData(QueryTableInfo queryTableInfo) {
        String table = queryTableInfo.getTable();
        Set<String> specialFieldAliasSet = queryTableInfo.getDbDecFieldAliasSet();
        if (specialFieldAliasSet.isEmpty() || HRStringUtils.isEmpty((String)table)) {
            return Collections.emptyMap();
        }
        HashSet<String> fieldAliasSet = new HashSet<String>(specialFieldAliasSet);
        Set<String> mulFields = queryTableInfo.getMulFields();
        fieldAliasSet.removeAll(mulFields);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)queryTableInfo.getEntityName());
        ArrayList<Object> pkLists = new ArrayList<Object>(queryTableInfo.getPkList());
        HashMap<String, Map<Object, Object>> specialFileDataMap = new HashMap<String, Map<Object, Object>>(16);
        try {
            Map values = PrivacyDataQuery.getValues((DBRoute)DBRoute.of((String)entityType.getDBRouteKey()), (String)table, pkLists, fieldAliasSet, mulFields);
            for (Map.Entry idEntry : values.entrySet()) {
                String pkStr = (String)idEntry.getKey();
                Map entryFieldMap = (Map)idEntry.getValue();
                for (Map.Entry fieldEntry : entryFieldMap.entrySet()) {
                    Object primaryKey;
                    String fieldKey = (String)fieldEntry.getKey();
                    String[] fieldKeys = fieldKey.split("#\\$");
                    String filed = fieldKeys[0];
                    HashMap<Object, Object> fieldMap = (HashMap<Object, Object>)specialFileDataMap.get(filed);
                    if (fieldMap == null) {
                        fieldMap = new HashMap<Object, Object>();
                    }
                    Long pkLong = null;
                    try {
                        pkLong = Long.parseLong(pkStr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    Object object = primaryKey = pkLong != null ? pkLong : pkStr;
                    if (mulFields.contains(filed) && "GLang".equals(fieldKeys[1])) {
                        fieldMap.computeIfAbsent(primaryKey, ks -> fieldEntry.getValue());
                    } else {
                        fieldMap.put(primaryKey, fieldEntry.getValue());
                    }
                    specialFileDataMap.put(filed, fieldMap);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        return specialFileDataMap;
    }

    @Override
    public void setValue(DynamicObject dynamicObject, QueryTableInfo queryTableInfo, String fieldName, Object fieldVal) {
        if (HRObjectUtils.isEmpty((Object)fieldVal)) {
            return;
        }
        dynamicObject.set(fieldName, fieldVal);
    }

    @Override
    public String specialCondition() {
        return null;
    }
}

