/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.query.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.db.pktemptable.PKTempTable;
import kd.bos.db.pktemptable.PKTempTables;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.query.util.QueryFieldInfo;
import kd.hr.hbp.business.service.query.util.QueryTableInfo;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;

public abstract class QuerySpecialFielder {
    private static Log logger = LogFactory.getLog(QuerySpecialFielder.class);
    private boolean needLoad;

    public QuerySpecialFielder(boolean needLoad) {
        this.needLoad = needLoad;
    }

    public boolean isNeedLoad() {
        return this.needLoad;
    }

    public void reloadSpecialField(DynamicObjectCollection dynamicObjectCollection, List<QueryFieldInfo> queryFieldInfoList) {
        if (!this.isNeedLoad()) {
            return;
        }
        List<QueryTableInfo> queryTableInfoList = this.parseQuerySpecialField(queryFieldInfoList);
        this.setSpecialTbPkField(dynamicObjectCollection, queryTableInfoList);
        this.querySpecialFiledData(queryTableInfoList);
        this.fillDyoCollSpecialFielData(dynamicObjectCollection, queryTableInfoList);
    }

    private void fillDyoCollSpecialFielData(DynamicObjectCollection dynamicObjectCollection, List<QueryTableInfo> queryTableInfoList) {
        for (QueryTableInfo queryTableInfo : queryTableInfoList) {
            String pkField = queryTableInfo.isMainEntityField() ? queryTableInfo.getPkField() : queryTableInfo.getEntityAlias() + "." + queryTableInfo.getPkField();
            Map<String, Map<Object, Object>> dbDecFieldVal = queryTableInfo.getDbDecFieldVal();
            dbDecFieldVal.forEach((fieldAlias, idData) -> {
                String field = queryTableInfo.getDbDecFieldAliasMap().get(fieldAlias);
                String realField = queryTableInfo.isMainEntityField() ? field : queryTableInfo.getEntityAlias() + "." + field;
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    Object pkObj = dynamicObject.get(pkField);
                    Object fieldVal = idData.get(pkObj);
                    this.setValue(dynamicObject, queryTableInfo, realField, fieldVal);
                }
            });
        }
    }

    public abstract void setValue(DynamicObject var1, QueryTableInfo var2, String var3, Object var4);

    private List<QueryTableInfo> parseQuerySpecialField(List<QueryFieldInfo> queryFieldInfoList) {
        HashMap<String, QueryTableInfo> tableFieldMap = new HashMap<String, QueryTableInfo>(queryFieldInfoList.size());
        for (QueryFieldInfo queryDecryptFieldInfo : queryFieldInfoList) {
            String tableGroup = queryDecryptFieldInfo.getTableGroup();
            String tableSuffix = HRStringUtils.isEmpty((String)tableGroup) ? "" : "_" + tableGroup;
            String tableName = queryDecryptFieldInfo.getTable() + tableSuffix;
            String entityAlias = queryDecryptFieldInfo.getEntityAlias();
            String key = tableName + entityAlias;
            QueryTableInfo queryTableInfo = (QueryTableInfo)tableFieldMap.get(key);
            if (Objects.isNull(queryTableInfo)) {
                queryTableInfo = new QueryTableInfo(queryDecryptFieldInfo.getEntityName(), tableName, queryDecryptFieldInfo.getPkField(), queryDecryptFieldInfo.getPkFieldAlias(), queryDecryptFieldInfo.isMainEntityField());
                queryTableInfo.setDbDecFieldAliasSet(new HashSet<String>(16));
                queryTableInfo.setMulFields(new HashSet<String>(16));
                queryTableInfo.setDbDecFieldAliasMap(new HashMap<String, String>(16));
                queryTableInfo.setEntityAlias(entityAlias);
            }
            queryTableInfo.getDbDecFieldAliasSet().add(queryDecryptFieldInfo.getFieldAlias());
            queryTableInfo.getDbDecFieldAliasMap().put(queryDecryptFieldInfo.getFieldAlias(), queryDecryptFieldInfo.getField());
            if (queryDecryptFieldInfo.isMulField()) {
                queryTableInfo.getMulFields().add(queryDecryptFieldInfo.getFieldAlias());
            }
            tableFieldMap.put(key, queryTableInfo);
        }
        return new ArrayList<QueryTableInfo>(tableFieldMap.values());
    }

    private void setSpecialTbPkField(DynamicObjectCollection dynamicObjectCollection, List<QueryTableInfo> queryTableInfoList) {
        for (QueryTableInfo queryTableInfo : queryTableInfoList) {
            HashSet<Object> pkList = new HashSet<Object>(dynamicObjectCollection.size());
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                String field = queryTableInfo.isMainEntityField() ? queryTableInfo.getPkField() : queryTableInfo.getEntityAlias() + "." + queryTableInfo.getPkField();
                pkList.add(dynamicObject.get(field));
            }
            queryTableInfo.setPkList(pkList);
        }
    }

    private void querySpecialFiledData(List<QueryTableInfo> queryTableInfoList) {
        for (QueryTableInfo queryTableInfo : queryTableInfoList) {
            Map<String, Map<Object, Object>> dbDecFieldValMap = this.getSpecialFileData(queryTableInfo);
            queryTableInfo.setDbDecFieldVal(dbDecFieldValMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Map<Object, Object>> getSpecialFileData(QueryTableInfo queryTableInfo) {
        HashMap<String, Map<Object, Object>> dbDecFieldValMap = new HashMap<String, Map<Object, Object>>(16);
        if (!queryTableInfo.getDbDecFieldAliasSet().isEmpty() && !HRStringUtils.isEmpty((String)queryTableInfo.getTable())) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)queryTableInfo.getEntityName());
            String idString = this.stringJoin(queryTableInfo.getPkList(), ",");
            String selectField = String.join((CharSequence)",", queryTableInfo.getDbDecFieldAliasSet());
            StringBuilder selectSql = new StringBuilder();
            selectSql.append(" select ").append(queryTableInfo.getPkFieldAlias()).append(", ").append(selectField);
            selectSql.append(" from ").append(queryTableInfo.getTable());
            try (PKTempTable tempTable = null;){
                String inSQL = "";
                if (queryTableInfo.getPkList().size() >= 5000) {
                    tempTable = PKTempTables.createPKLong((DBRoute)DBRoute.of((String)entityType.getDBRouteKey()));
                    tempTable.insert(queryTableInfo.getPkList());
                    inSQL = " in (SELECT FID FROM " + tempTable.getName() + ") ";
                } else {
                    inSQL = " in ( " + idString + " ) ";
                }
                selectSql.append(" where ").append(queryTableInfo.getPkFieldAlias()).append(inSQL);
                selectSql.append(this.specialCondition());
                HRDBUtil.query((DBRoute)DBRoute.of((String)entityType.getDBRouteKey()), (String)selectSql.toString(), null, resultSet -> {
                    while (resultSet.next()) {
                        Object idVal = resultSet.getObject(queryTableInfo.getPkFieldAlias());
                        for (String decField : queryTableInfo.getDbDecFieldAliasSet()) {
                            HashMap<Object, Object> idDataMap = (HashMap<Object, Object>)dbDecFieldValMap.get(decField);
                            if (idDataMap == null) {
                                idDataMap = new HashMap<Object, Object>();
                            }
                            idDataMap.put(idVal, resultSet.getObject(decField));
                            dbDecFieldValMap.put(decField, idDataMap);
                        }
                    }
                    return null;
                });
            }
        }
        return dbDecFieldValMap;
    }

    public abstract String specialCondition();

    private String stringJoin(Set<Object> set, String spliter) {
        int index = 0;
        StringBuilder sb = new StringBuilder();
        boolean isString = false;
        for (Object object : set) {
            if (index == 0) {
                if (object instanceof String) {
                    isString = true;
                }
                if (isString) {
                    sb.append("'").append(object).append("'");
                } else {
                    sb.append(object);
                }
            } else if (isString) {
                sb.append(',').append("'").append(object).append("'");
            } else {
                sb.append(',').append(object);
            }
            ++index;
        }
        return sb.toString();
    }
}

