/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.smartsearch;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.enums.smartsearch.SearchRespCodeEnum;
import kd.hr.hbp.common.model.smartsearch.searchlog.SearchKeywordCountBo;
import kd.hr.hbp.common.util.HRStringUtils;

public class SearchLogQueryService {
    private static final Log LOGGER = LogFactory.getLog(SearchLogQueryService.class);

    public static HrApiResponse<List<SearchKeywordCountBo>> queryTopKeywords(Long sceneId, String searchPageNumber, Date startTime, Date endTime) {
        HrApiResponse response;
        block4: {
            LOGGER.info("queryTopKeywords param[sceneId:{},searchPageNumber:{},startTime:{},endTime:{}]", new Object[]{sceneId, searchPageNumber, startTime, endTime});
            response = null;
            try {
                List searchKeywordCountList = (List)HRMServiceHelper.invokeBizService("hrmp", "hrss", "IHRSSSearchLogService", "queryTopKeywords", sceneId, searchPageNumber, startTime, endTime);
                response = searchKeywordCountList == null ? HrApiResponse.fail((String)SearchRespCodeEnum.NOT_FOUND.getCode(), (String)SearchRespCodeEnum.NOT_FOUND.getLocalMsg()) : HrApiResponse.success((Object)searchKeywordCountList);
            }
            catch (Exception exp) {
                LOGGER.error((Throwable)exp);
                if (exp instanceof KDBizException) {
                    KDBizException kdBizException = (KDBizException)((Object)exp);
                    if (BosErrorCode.paramError.getCode().equals(kdBizException.getErrorCode().getCode())) {
                        response = HrApiResponse.fail((String)SearchRespCodeEnum.PARAM_ERROR.getCode(), (String)exp.getMessage());
                    }
                }
                if (response != null) break block4;
                response = HrApiResponse.fail((String)SearchRespCodeEnum.FAIL.getCode(), (String)exp.getMessage());
            }
        }
        LOGGER.info("queryTopKeywords result:{}", (Object)SerializationUtils.toJsonString(response));
        return response;
    }

    public static HrApiResponse<List<String>> queryUserTopKeywords(Long sceneId, String searchPageNumber, Long userId) {
        HrApiResponse response;
        block4: {
            LOGGER.info("queryUserTopKeywords param[sceneId:{},searchPageNumber:{},userId:{}]", new Object[]{sceneId, searchPageNumber, userId});
            response = null;
            try {
                List userSearchKeywordList = (List)HRMServiceHelper.invokeBizService("hrmp", "hrss", "IHRSSSearchLogService", "queryUserTopKeywords", sceneId, searchPageNumber, userId);
                response = userSearchKeywordList == null ? HrApiResponse.fail((String)SearchRespCodeEnum.NOT_FOUND.getCode(), (String)SearchRespCodeEnum.NOT_FOUND.getLocalMsg()) : HrApiResponse.success((Object)userSearchKeywordList);
            }
            catch (Exception exp) {
                LOGGER.error((Throwable)exp);
                if (exp instanceof KDBizException) {
                    KDBizException kdBizException = (KDBizException)((Object)exp);
                    if (BosErrorCode.paramError.getCode().equals(kdBizException.getErrorCode().getCode())) {
                        response = HrApiResponse.fail((String)SearchRespCodeEnum.PARAM_ERROR.getCode(), (String)exp.getMessage());
                    }
                }
                if (response != null) break block4;
                response = HrApiResponse.fail((String)SearchRespCodeEnum.FAIL.getCode(), (String)exp.getMessage());
            }
        }
        LOGGER.info("queryUserTopKeywords result:{}", (Object)SerializationUtils.toJsonString(response));
        return response;
    }

    public static void removeUserKeywords(Long sceneId, String searchPageNumber, Long userId) {
        LOGGER.info("removeUserKeywords param[sceneId:{},searchPageNumber:{},userId:{}]", new Object[]{sceneId, searchPageNumber, userId});
        HRMServiceHelper.invokeBizService("hrmp", "hrss", "IHRSSSearchLogService", "removeUserKeywords", sceneId, searchPageNumber, userId, null);
    }

    public static void removeUserKeywords(Long sceneId, String searchPageNumber, Long userId, String keyword) {
        LOGGER.info("removeUserKeywords param[sceneId:{},searchPageNumber:{},userId:{},keyword:{}]", new Object[]{sceneId, searchPageNumber, userId, keyword});
        if (HRStringUtils.isEmpty((String)keyword)) {
            return;
        }
        HRMServiceHelper.invokeBizService("hrmp", "hrss", "IHRSSSearchLogService", "removeUserKeywords", sceneId, searchPageNumber, userId, keyword);
    }
}

