/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.service.smartsearch;

import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.enums.smartsearch.SearchRespCodeEnum;
import kd.hr.hbp.common.model.smartsearch.scene.SearchFieldBo;
import kd.hr.hbp.common.model.smartsearch.scene.SearchSceneBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic(scriptName="HR\u667a\u80fd\u641c\u7d22\u641c\u7d22\u573a\u666f\u67e5\u8be2\u670d\u52a1\u7c7b")
public class SearchSceneService {
    private static final Log LOGGER = LogFactory.getLog(SearchSceneService.class);

    public static HrApiResponse<SearchSceneBo> querySearchScene(String searchEntityNumber, String appNumber) {
        LOGGER.info("querySearchScene param:{}, appid:{}", (Object)searchEntityNumber, (Object)appNumber);
        if (HRStringUtils.isEmpty((String)searchEntityNumber)) {
            return HrApiResponse.fail((String)SearchRespCodeEnum.PARAM_ERROR.getCode(), (String)(SearchRespCodeEnum.PARAM_ERROR.getLocalMsg() + "searchEntityNumber"));
        }
        SearchSceneBo searchScene = (SearchSceneBo)HRMServiceHelper.invokeBizService("hrmp", "hrss", "IHRSSService", "querySceneConfByPageNum", searchEntityNumber, appNumber);
        if (searchScene == null) {
            return HrApiResponse.fail((String)SearchRespCodeEnum.NOT_FOUND.getCode(), (String)SearchRespCodeEnum.NOT_FOUND.getLocalMsg());
        }
        HrApiResponse success = HrApiResponse.success((Object)searchScene);
        LOGGER.info("querySearchScene resp:{}", (Object)SerializationUtils.toJsonString((Object)success));
        return success;
    }

    public static HrApiResponse<SearchSceneBo> querySearchScene(String searchEntityNumber) {
        return SearchSceneService.querySearchScene(searchEntityNumber, null);
    }

    public static HrApiResponse<SearchSceneBo> querySearchScene(Long sceneId) {
        LOGGER.info("querySearchScene param:{}", (Object)sceneId);
        if (sceneId == null || sceneId == 0L) {
            return HrApiResponse.fail((String)SearchRespCodeEnum.PARAM_ERROR.getCode(), (String)(SearchRespCodeEnum.PARAM_ERROR.getLocalMsg() + "sceneId"));
        }
        SearchSceneBo searchScene = (SearchSceneBo)HRMServiceHelper.invokeBizService("hrmp", "hrss", "IHRSSService", "querySceneConfByPk", sceneId);
        if (searchScene == null) {
            return HrApiResponse.fail((String)SearchRespCodeEnum.NOT_FOUND.getCode(), (String)SearchRespCodeEnum.NOT_FOUND.getLocalMsg());
        }
        HrApiResponse success = HrApiResponse.success((Object)searchScene);
        LOGGER.info("querySearchScene resp:{}", (Object)SerializationUtils.toJsonString((Object)success));
        return success;
    }

    public static HrApiResponse<QFilter> getPermQFilters(Long sceneId, String fieldAlias, String searchEntityNumber) {
        return SearchSceneService.getPermQFilters(sceneId, fieldAlias, searchEntityNumber, null);
    }

    public static HrApiResponse<QFilter> getPermQFilters(Long sceneId, String fieldAlias, String searchEntityNumber, String appNumber) {
        if (sceneId == null || sceneId == 0L) {
            return HrApiResponse.fail((String)SearchRespCodeEnum.PARAM_ERROR.getCode(), (String)(SearchRespCodeEnum.PARAM_ERROR.getLocalMsg() + "sceneId"));
        }
        if (HRStringUtils.isEmpty((String)fieldAlias)) {
            return HrApiResponse.fail((String)SearchRespCodeEnum.PARAM_ERROR.getCode(), (String)(SearchRespCodeEnum.PARAM_ERROR.getLocalMsg() + "fieldAlias"));
        }
        if (HRStringUtils.isEmpty((String)searchEntityNumber)) {
            return HrApiResponse.fail((String)SearchRespCodeEnum.PARAM_ERROR.getCode(), (String)(SearchRespCodeEnum.PARAM_ERROR.getLocalMsg() + "searchEntityNumber"));
        }
        QFilter qFilter = (QFilter)HRMServiceHelper.invokeBizService("hrmp", "hrss", "IHRSSService", "getPermQFilters", sceneId, fieldAlias, searchEntityNumber, appNumber);
        return HrApiResponse.success((Object)qFilter);
    }

    public static HrApiResponse<List<SearchFieldBo>> queryAllLabelFields(Long searchObjId) {
        LOGGER.info("queryAllLabelFields param:{}", (Object)searchObjId);
        HrApiResponse response = null;
        try {
            List allLabelFieldList = (List)HRMServiceHelper.invokeBizService("hrmp", "hrss", "IHRSSService", "queryAllLabelFields", searchObjId);
            response = HrApiResponse.success((Object)allLabelFieldList);
        }
        catch (Exception exp) {
            LOGGER.error((Throwable)exp);
            response = HrApiResponse.fail((String)SearchRespCodeEnum.FAIL.getCode(), (String)exp.getMessage());
        }
        return response;
    }
}

