/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.servicehelper;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.activity.IHRCSActivityFieldPluginService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class ActivityServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(ActivityServiceHelper.class);
    private static final String PROPERTIES_INS = "applier,bizbillid,biznum,bizkey,bindbizbillid,bindbiznum,bindbizkey,bindinglayoutid,actthemestr,taskstatus,createtime,wfcurtaskid,wfprocessinsid,wfprocessdefinitionid,actscheme,schemenumber,schemeversion,activity,handletime,handlers,wfnode";
    private static final String ENTITYNAME_INS = "hrcs_activityins";

    public static void invokePlugin(String pluginPath, DynamicObject actBizObjDy, String pluginType) {
        IHRCSActivityFieldPluginService instance = null;
        try {
            Class<?> cl = Class.forName(pluginPath);
            instance = (IHRCSActivityFieldPluginService)cl.newInstance();
        }
        catch (Exception e) {
            LOGGER.error("instancePlugin error", (Throwable)e);
            return;
        }
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
        paramMap.put("businessObject", actBizObjDy);
        if ("0".equals(pluginType)) {
            instance.beforeBusiness(paramMap);
        } else {
            instance.afterBusiness(paramMap);
        }
    }

    public static DynamicObject getActivityInsById(String selectProperties, Long activityInsId) {
        String selector = PROPERTIES_INS;
        if (HRStringUtils.isNotEmpty((String)selectProperties)) {
            selector = selectProperties;
        }
        HRBaseServiceHelper insHelper = new HRBaseServiceHelper(ENTITYNAME_INS);
        return insHelper.queryOne(selector, new QFilter[]{new QFilter("id", "=", (Object)activityInsId)});
    }

    public static boolean checkProcessingStatus(DynamicObject activityInsItem) {
        return "20".equals(activityInsItem.get("taskstatus"));
    }

    public static boolean checkProcessingOrAssignStatus(DynamicObject activityInsItem) {
        Object status = activityInsItem.get("taskstatus");
        return "20".equals(status) || "10".equals(status);
    }

    public static void showErrorMessage(OperationResult operationResult, IFormView view, BeforeDoOperationEventArgs args) {
        if (!operationResult.isSuccess()) {
            List allErrorInfo = operationResult.getAllErrorInfo();
            view.showErrorNotification(((OperateErrorInfo)allErrorInfo.get(0)).getErrorCode());
            args.setCancel(true);
        }
    }

    public static void updateDealUser(Object billId, String billNumber) {
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper(billNumber);
        DynamicObject dynamicObject = baseServiceHelper.queryOne(billId);
        dynamicObject.set("dealuser", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("dealtime", (Object)new Date());
        baseServiceHelper.updateOne(dynamicObject);
    }
}

