/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.servicehelper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class HRAppServiceHelper {
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String BIZ_CLOUD_ID = "bizcloud.id";
    private static final String DEPLOY_STATUS = "deploystatus";
    private static final String TYPE = "type";
    private static final String VISIBLE = "visible";
    private static final String HBSS_CLOUD_APP = "hbss_cloud_app";
    private static final String HBSS_APP_ID = "app.id";
    private static final String HBSS_CLOUD_ID = "app.bizcloud.id";
    private static Boolean FALSE = Boolean.FALSE;

    public static Set<String> getAllHRAppIds() {
        return HRAppServiceHelper.getAllHRAppIds(FALSE);
    }

    public static Set<String> getAllHRAppIdsExceptExt() {
        return HRAppServiceHelper.getAllHRAppIdsExceptExt(FALSE);
    }

    public static Set<String> getAppIdsAndExcId(String appId) {
        return HRAppServiceHelper.getAppIdsAndExcId(appId, FALSE);
    }

    public static List<String> getAPPByCloudIds(List<String> cloudIdList) {
        return HRAppServiceHelper.getAPPByCloudIds(cloudIdList, FALSE);
    }

    public static List<String> getAppExceptExtByCloudIds(List<String> cloudIdList) {
        return HRAppServiceHelper.getAppExceptExtByCloudIds(cloudIdList, FALSE);
    }

    public static List<DynamicObject> getAPPDynByCloudIds(List<String> cloudIdList) {
        return HRAppServiceHelper.getAPPDynByCloudIds(cloudIdList, FALSE);
    }

    public static List<String> getSortedHRAppIds() {
        return HRAppServiceHelper.getSortedHRAppIds(FALSE);
    }

    public static Set<String> getAllHRAppIds(boolean onlyVisible) {
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)3);
        Set<String> allHRAppIds = HRAppServiceHelper.getAllHRAppIdsExceptExt(onlyVisible);
        qFilters.add(new QFilter("id", "in", allHRAppIds).or(new QFilter("masterid", "in", allHRAppIds)));
        qFilters.add(new QFilter(DEPLOY_STATUS, "=", (Object)"2"));
        if (onlyVisible) {
            qFilters.add(new QFilter(VISIBLE, "=", (Object)Boolean.TRUE));
        }
        HRBaseServiceHelper appHelper = new HRBaseServiceHelper(BOS_DEVPORTAL_BIZAPP);
        DynamicObject[] apps = appHelper.queryOriginalArray("id", qFilters.toArray(new QFilter[0]));
        return Stream.of(apps).map(dy -> dy.getString("id")).collect(Collectors.toSet());
    }

    public static Set<String> getAllHRAppIdsExceptExt(boolean onlyVisible) {
        HRBaseServiceHelper appHelper = new HRBaseServiceHelper(HBSS_CLOUD_APP);
        DynamicObject[] apps = appHelper.queryOriginalArray("app.id,app.visible", null);
        if (onlyVisible) {
            return Stream.of(apps).filter(dy -> dy.getBoolean("app.visible")).map(dy -> dy.getString(HBSS_APP_ID)).collect(Collectors.toSet());
        }
        return Stream.of(apps).map(dy -> dy.getString(HBSS_APP_ID)).collect(Collectors.toSet());
    }

    public static Set<String> getAppIdsAndExcId(String appId, boolean onlyVisible) {
        HRBaseServiceHelper appHelper = new HRBaseServiceHelper(BOS_DEVPORTAL_BIZAPP);
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)3);
        qFilters.add(new QFilter("id", "=", (Object)appId).or(new QFilter("masterid", "=", (Object)appId)));
        if (onlyVisible) {
            qFilters.add(new QFilter(VISIBLE, "=", (Object)Boolean.TRUE));
        }
        DynamicObject[] apps = appHelper.queryOriginalArray("id", qFilters.toArray(new QFilter[0]));
        return Stream.of(apps).map(dy -> dy.getString("id")).collect(Collectors.toSet());
    }

    public static List<String> getAPPByCloudIds(List<String> cloudIdList, boolean onlyVisible) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(BOS_DEVPORTAL_BIZAPP);
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)3);
        qFilters.add(new QFilter(DEPLOY_STATUS, "=", (Object)"2"));
        qFilters.add(new QFilter(BIZ_CLOUD_ID, "in", cloudIdList));
        if (onlyVisible) {
            qFilters.add(new QFilter(VISIBLE, "=", (Object)Boolean.TRUE));
        }
        DynamicObject[] results = serviceHelper.query("id,bizcloud.id", qFilters.toArray(new QFilter[0]));
        return Arrays.stream(results).sorted(Comparator.comparingInt(x -> cloudIdList.indexOf(x.getString(BIZ_CLOUD_ID)))).map(result -> result.getString("id")).distinct().collect(Collectors.toList());
    }

    public static List<String> getAppExceptExtByCloudIds(List<String> cloudIdList, boolean onlyVisible) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(BOS_DEVPORTAL_BIZAPP);
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)3);
        qFilters.add(new QFilter(DEPLOY_STATUS, "=", (Object)"2"));
        qFilters.add(new QFilter(BIZ_CLOUD_ID, "in", cloudIdList));
        qFilters.add(new QFilter(TYPE, "=", (Object)"0"));
        if (onlyVisible) {
            qFilters.add(new QFilter(VISIBLE, "=", (Object)Boolean.TRUE));
        }
        DynamicObject[] results = serviceHelper.query("id,bizcloud.id", qFilters.toArray(new QFilter[0]));
        return Arrays.stream(results).sorted(Comparator.comparingInt(x -> cloudIdList.indexOf(x.getString(BIZ_CLOUD_ID)))).map(result -> result.getString("id")).distinct().collect(Collectors.toList());
    }

    public static List<DynamicObject> getAPPDynByCloudIds(List<String> cloudIdList, boolean onlyVisible) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(BOS_DEVPORTAL_BIZAPP);
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)3);
        qFilters.add(new QFilter(DEPLOY_STATUS, "=", (Object)"2"));
        qFilters.add(new QFilter(BIZ_CLOUD_ID, "in", cloudIdList));
        if (onlyVisible) {
            qFilters.add(new QFilter(VISIBLE, "=", (Object)Boolean.TRUE));
        }
        DynamicObject[] results = serviceHelper.loadDynamicObjectArray(qFilters.toArray(new QFilter[0]));
        return Arrays.stream(results).sorted(Comparator.comparingInt(x -> cloudIdList.indexOf(x.getString(BIZ_CLOUD_ID)))).collect(Collectors.toList());
    }

    public static List<String> getSortedHRAppIds(boolean onlyVisible) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(HBSS_CLOUD_APP);
        DynamicObject[] results = serviceHelper.query("app.id,app.bizcloud.id,app.visible,index", null);
        if (onlyVisible) {
            return Arrays.stream(results).filter(dy -> dy.getBoolean("app.visible")).sorted(Comparator.comparingInt(x -> x.getInt("index"))).map(result -> result.getString(HBSS_APP_ID)).distinct().collect(Collectors.toList());
        }
        return Arrays.stream(results).sorted(Comparator.comparingInt(x -> x.getInt("index"))).map(result -> result.getString(HBSS_APP_ID)).distinct().collect(Collectors.toList());
    }
}

