/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.servicehelper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class HREntityTreeNodeServiceHelper {
    private static final String HAOS_ADMINSTRUCT = "haos_adminstruct";

    public static List<Long> queryAdminOrgChildrenNodes(Object adminOrgId) {
        return HREntityTreeNodeServiceHelper.queryEntityTreeNodes(adminOrgId, false, HAOS_ADMINSTRUCT, "adminorg");
    }

    public static List<Long> queryAdminOrgLeafNodes(Object adminOrgId) {
        return HREntityTreeNodeServiceHelper.queryEntityTreeNodes(adminOrgId, true, HAOS_ADMINSTRUCT, "adminorg");
    }

    public static List<Long> queryHrbuChildrenNodes(Object hrbuId) {
        return HREntityTreeNodeServiceHelper.queryEntityTreeNodes(hrbuId, false, "hbss_hrbustruct", "hrbu");
    }

    public static List<Long> queryHrbuLeafNodes(Object hrbuId) {
        return HREntityTreeNodeServiceHelper.queryEntityTreeNodes(hrbuId, true, "hbss_hrbustruct", "hrbu");
    }

    private static List<Long> queryEntityTreeNodes(Object baseEntityId, boolean onlyLeafs, String entityName, String baseEntityName) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        QFilter idFilter = new QFilter(baseEntityName, "=", baseEntityId);
        QFilter[] filters = new QFilter[]{idFilter};
        String select = "id," + baseEntityName + ",longnumber";
        DynamicObject baseEntityObj = serviceHelper.queryOne(select, filters);
        if (baseEntityObj == null) {
            return new ArrayList<Long>();
        }
        String longNumber = baseEntityObj.getString("longnumber");
        QFilter longNumFilter = new QFilter("longnumber", "like", (Object)(longNumber + "!%"));
        QFilter noSelfFilter = new QFilter(baseEntityName, "!=", baseEntityId);
        if (HAOS_ADMINSTRUCT.equals(entityName)) {
            QFilter enableFilter = new QFilter("adminorg.enable", "=", (Object)"1");
            longNumFilter.and(enableFilter);
        }
        if (onlyLeafs) {
            QFilter leafFilter = new QFilter("isleaf", "=", (Object)"1");
            filters = new QFilter[]{longNumFilter, noSelfFilter, leafFilter};
        } else {
            filters = new QFilter[]{longNumFilter, noSelfFilter};
        }
        DynamicObject[] baseEntityObjs = serviceHelper.query(select, filters);
        ArrayList<Long> baseEntityIds = new ArrayList<Long>();
        for (DynamicObject obj : baseEntityObjs) {
            long entityId = obj.getLong(baseEntityName + ".id");
            if (entityId == 0L) continue;
            baseEntityIds.add(entityId);
        }
        return baseEntityIds;
    }
}

