/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.business.servicehelper;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HREntityHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class HRExportDataHelper {
    private static final Log LOGGER = LogFactory.getLog(HREntityHelper.class);
    private static final String EXCEL_SUFFIX = ".xls";
    private boolean isCustomColumn = false;

    public boolean isCustomColumn() {
        return this.isCustomColumn;
    }

    public String getExcelDownLoadUrl(String fileName, List<Map<String, Object>> exportDataList, List<HRExportHeadObject> headDataList) throws IOException {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        wb.setSheetName(0, fileName);
        int maxWidth = 65280;
        HRExportDataHelper.createHeadColumn(wb, sheet, headDataList, 0);
        HRExportDataHelper.createContentColumn(wb, sheet, exportDataList, headDataList);
        if (this.isCustomColumn()) {
            this.setSheetColumn(sheet, headDataList);
        } else {
            HRExportDataHelper.setHeaderColumn(headDataList, sheet, maxWidth);
        }
        return HRExportDataHelper.writeFiel(wb, fileName);
    }

    public void setSheetColumn(HSSFSheet sheet, List<HRExportHeadObject> headDataList) {
    }

    public static String getExportExcelUrl(String fileName, List<Map<String, Object>> exportDataList, List<HRExportHeadObject> headDataList) throws IOException {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        wb.setSheetName(0, fileName);
        int maxWidth = 65280;
        HRExportDataHelper.createHeadColumn(wb, sheet, headDataList, 0);
        HRExportDataHelper.createContentColumn(wb, sheet, exportDataList, headDataList);
        HRExportDataHelper.setHeaderColumn(headDataList, sheet, maxWidth);
        return HRExportDataHelper.writeFiel(wb, fileName);
    }

    private static void setHeaderColumn(List<HRExportHeadObject> headDataList, HSSFSheet sheet, int maxWidth) {
        for (int rowI = 0; rowI < headDataList.size(); ++rowI) {
            sheet.autoSizeColumn((int)((short)rowI));
            int columnWidth = sheet.getColumnWidth(rowI);
            sheet.setColumnWidth(rowI, columnWidth * 2 > maxWidth ? maxWidth : columnWidth * 2);
        }
    }

    private static void createContentColumn(HSSFWorkbook wb, HSSFSheet sheet, List<Map<String, Object>> exportDataList, List<HRExportHeadObject> headData) {
        for (int rowIndex = 0; rowIndex < exportDataList.size(); ++rowIndex) {
            HSSFRow contentRow = sheet.createRow(rowIndex + 1);
            for (int columnIndex = 0; columnIndex < headData.size(); ++columnIndex) {
                HSSFCell columnCell = contentRow.createCell(columnIndex);
                columnCell.setCellValue(String.valueOf(exportDataList.get(rowIndex).get(headData.get(columnIndex).getColumnId()) == null ? "" : exportDataList.get(rowIndex).get(headData.get(columnIndex).getColumnId())));
            }
        }
    }

    private static void createHeadColumn(HSSFWorkbook wb, HSSFSheet sheet, List<HRExportHeadObject> headData, int rowIndex) {
        HSSFRow headRow = sheet.createRow(rowIndex);
        HSSFCellStyle style = HRExportDataHelper.getHeadColumnStyle(wb);
        for (int rowI = 0; rowI < headData.size(); ++rowI) {
            if (null == headData.get(rowI)) continue;
            HSSFCell cell = headRow.createCell(rowI);
            cell.setCellValue(headData.get(rowI).getColumnAlias());
            cell.setCellType(CellType.STRING);
            cell.setCellStyle(style);
        }
    }

    private static HSSFCellStyle getHeadColumnStyle(HSSFWorkbook wb) {
        HSSFCellStyle headColumnStyle = wb.createCellStyle();
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderTop(BorderStyle.THIN);
        headColumnStyle.setBorderLeft(BorderStyle.THIN);
        headColumnStyle.setBorderRight(BorderStyle.THIN);
        headColumnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_40_PERCENT.getIndex());
        headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headColumnStyle.setAlignment(HorizontalAlignment.CENTER);
        headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headColumnStyle.setHidden(false);
        return headColumnStyle;
    }

    /*
     * Exception decompiling
     */
    private static String writeFiel(HSSFWorkbook wb, String fileName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

